/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.popover;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.telefonica.mistica.R;
import com.telefonica.mistica.feedback.popover.PopOverData;
import com.telefonica.mistica.feedback.popover.PopOverTheme;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00029:B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0019H\u0016J\u001d\u0010\"\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010'\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010,\u001a\u00020 H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020 H\u0003J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u001bH\u0007J\u000e\u00104\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u00105\u001a\u00020 H\u0007J\u0006\u00106\u001a\u00020 J\u0010\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/telefonica/mistica/feedback/popover/PopOverView;", "Landroid/widget/RelativeLayout;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "popOverContent", "Landroid/view/ViewGroup;", "popOverTopTip", "Landroid/view/View;", "popOverTitle", "Landroid/widget/TextView;", "popOverImage", "Landroid/widget/ImageView;", "popOverDescription", "popOverBottomTip", "popOverCloseButton", "popOverPosition", "Lcom/telefonica/mistica/feedback/popover/PopOverView$Position;", "popOverData", "Lcom/telefonica/mistica/feedback/popover/PopOverData;", "targetView", "dimensionsKnown", "", "targetViewRelativeY", "", "targetViewRelativeX", "listener", "Lcom/telefonica/mistica/feedback/popover/PopOverView$PopOverClickListener;", "init", "", "onPreDraw", "setUpToolTip", "setUpToolTip$com_telefonica_mistica_release", "setTipMargin", "tipMargin", "setMargin", "setCloseButton", "setTitle", "setImage", "setDescription", "setMaxWidth", "setShadow", "setPosition", "applyTheme", "theme", "Lcom/telefonica/mistica/feedback/popover/PopOverTheme;", "applyPopOverTipPosition", "setPointerCenterX", "pointerCenterX", "setToolTipListener", "remove", "removeWithoutAnimation", "onClick", "view", "PopOverClickListener", "Position", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPopOverView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopOverView.kt\ncom/telefonica/mistica/feedback/popover/PopOverView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,335:1\n1#2:336\n*E\n"})
public class PopOverView
extends RelativeLayout
implements ViewTreeObserver.OnPreDrawListener,
View.OnClickListener {
    private ViewGroup popOverContent;
    private View popOverTopTip;
    private TextView popOverTitle;
    private ImageView popOverImage;
    private TextView popOverDescription;
    private View popOverBottomTip;
    private ImageView popOverCloseButton;
    @NotNull
    private Position popOverPosition;
    @Nullable
    private PopOverData popOverData;
    private View targetView;
    private boolean dimensionsKnown;
    private int targetViewRelativeY;
    private int targetViewRelativeX;
    @Nullable
    private PopOverClickListener listener;
    public static final int $stable = 8;

    public PopOverView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.popOverPosition = Position.AUTO;
        this.init();
    }

    private final void init() {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.popover_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.popover_content);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.popOverContent = (ViewGroup)view;
        View view2 = this.findViewById(R.id.popover_pointer_up);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.popOverTopTip = view2;
        View view3 = this.findViewById(R.id.popover_title);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.popOverTitle = (TextView)view3;
        View view4 = this.findViewById(R.id.popover_image);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.popOverImage = (ImageView)view4;
        View view5 = this.findViewById(R.id.popover_subtitle);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.popOverDescription = (TextView)view5;
        View view6 = this.findViewById(R.id.popover_pointer_down);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.popOverBottomTip = view6;
        View view7 = this.findViewById(R.id.close_button);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
        this.popOverCloseButton = (ImageView)view7;
        this.setOnClickListener(this);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public boolean onPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.dimensionsKnown = true;
        if (this.popOverData != null) {
            this.applyPopOverTipPosition();
        }
        return true;
    }

    public final void setUpToolTip$com_telefonica_mistica_release(@NotNull PopOverData popOverData, @NotNull View targetView) {
        Intrinsics.checkNotNullParameter((Object)popOverData, (String)"popOverData");
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        this.popOverData = popOverData;
        this.targetView = targetView;
        this.setTitle(popOverData);
        this.setImage(popOverData);
        this.setDescription(popOverData);
        this.setCloseButton();
        this.setMaxWidth(popOverData);
        this.applyTheme(popOverData.getTheme());
        this.setTipMargin(popOverData.getExtraMarginForTip());
        this.setMargin(popOverData);
        this.setPosition(popOverData);
        this.setContentDescription(popOverData.getDismissButtonContentDescription());
        this.setShadow();
        if (this.dimensionsKnown) {
            this.applyPopOverTipPosition();
        }
    }

    private final void setTipMargin(int tipMargin) {
        if (tipMargin != 0) {
            View view = this.popOverTopTip;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
                view = null;
            }
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            RelativeLayout.LayoutParams paramsTop = (RelativeLayout.LayoutParams)layoutParams;
            paramsTop.setMargins(MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), tipMargin, MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_vertical)));
            View view2 = this.popOverTopTip;
            if (view2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
                view2 = null;
            }
            view2.setLayoutParams((ViewGroup.LayoutParams)paramsTop);
            View view3 = this.popOverBottomTip;
            if (view3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
                view3 = null;
            }
            ViewGroup.LayoutParams layoutParams2 = view3.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams2, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            RelativeLayout.LayoutParams paramsBottom = (RelativeLayout.LayoutParams)layoutParams2;
            paramsBottom.setMargins(MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_vertical)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), tipMargin);
            View view4 = this.popOverBottomTip;
            if (view4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
                view4 = null;
            }
            view4.setLayoutParams((ViewGroup.LayoutParams)paramsBottom);
        }
    }

    private final void setMargin(PopOverData popOverData) {
        int margin = popOverData.getMargin();
        if (margin > 0) {
            this.setPadding(margin, 0, margin, 0);
        }
    }

    private final void setCloseButton() {
        ImageView imageView = this.popOverCloseButton;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            imageView = null;
        }
        imageView.setVisibility(0);
        ImageView imageView2 = this.popOverCloseButton;
        if (imageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            imageView2 = null;
        }
        imageView2.setOnClickListener(arg_0 -> PopOverView.setCloseButton$lambda$0(this, arg_0));
    }

    private final void setTitle(PopOverData popOverData) {
        CharSequence charSequence = popOverData.getTitle();
        if (!(charSequence == null || charSequence.length() == 0)) {
            TextView textView = this.popOverTitle;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                textView = null;
            }
            textView.setText((CharSequence)popOverData.getTitle());
            TextView textView2 = this.popOverTitle;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                textView2 = null;
            }
            textView2.setVisibility(0);
        } else {
            TextView textView = this.popOverTitle;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                textView = null;
            }
            textView.setVisibility(8);
        }
    }

    private final void setImage(PopOverData popOverData) {
        if (popOverData.getImageRes() != null) {
            ImageView imageView = this.popOverImage;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView = null;
            }
            imageView.setImageResource(popOverData.getImageRes().intValue());
            ImageView imageView2 = this.popOverImage;
            if (imageView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView2 = null;
            }
            imageView2.setVisibility(0);
        } else {
            ImageView imageView = this.popOverImage;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView = null;
            }
            imageView.setVisibility(8);
        }
    }

    private final void setDescription(PopOverData popOverData) {
        if (popOverData.getDescription() != null) {
            TextView textView = this.popOverDescription;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView = null;
            }
            textView.setText((CharSequence)popOverData.getDescription());
            TextView textView2 = this.popOverDescription;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView2 = null;
            }
            textView2.setVisibility(0);
        } else {
            TextView textView = this.popOverDescription;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView = null;
            }
            textView.setVisibility(8);
        }
    }

    private final void setMaxWidth(PopOverData popOverData) {
        if (popOverData.getMaxWidth() > 0) {
            TextView textView = this.popOverTitle;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                textView = null;
            }
            textView.setMaxWidth(popOverData.getMaxWidth());
        }
    }

    private final void setShadow() {
        ViewGroup viewGroup = this.popOverContent;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverContent");
            viewGroup = null;
        }
        viewGroup.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
        View view = this.popOverBottomTip;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view = null;
        }
        view.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
        View view2 = this.popOverTopTip;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view2 = null;
        }
        view2.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
    }

    private final void setPosition(PopOverData popOverData) {
        block0: {
            Position position = popOverData.getPosition();
            if (position == null) break block0;
            Position it = position;
            boolean bl = false;
            this.popOverPosition = it;
        }
    }

    private final void applyTheme(PopOverTheme theme) {
        View view = this.popOverTopTip;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view = null;
        }
        view.setBackgroundResource(theme.getTopTip());
        View view2 = this.popOverBottomTip;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view2 = null;
        }
        view2.setBackgroundResource(theme.getBottomTip());
        TextView textView = this.popOverTitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
            textView = null;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        textView.setTextColor(ColorUtilsKt.getThemeColor(context, theme.getTextColor()));
        ImageView imageView = this.popOverCloseButton;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            imageView = null;
        }
        imageView.setImageResource(theme.getCloseButton());
    }

    @SuppressLint(value={"NewApi"})
    private final void applyPopOverTipPosition() {
        float[] fArray;
        int[] targetViewScreenPosition = new int[2];
        int[] parentViewScreenPosition = new int[2];
        Rect availableVisibleArea = new Rect();
        View view = this.targetView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view = null;
        }
        view.getLocationOnScreen(targetViewScreenPosition);
        View view2 = this.targetView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view2 = null;
        }
        view2.getWindowVisibleDisplayFrame(availableVisibleArea);
        ViewParent viewParent = this.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        ((View)viewParent).getLocationOnScreen(parentViewScreenPosition);
        this.targetViewRelativeX = targetViewScreenPosition[0] - parentViewScreenPosition[0];
        this.targetViewRelativeY = targetViewScreenPosition[1] - parentViewScreenPosition[1];
        View view3 = this.targetView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view3 = null;
        }
        int targetViewRelativeCenterX = this.targetViewRelativeX + view3.getWidth() / 2;
        float popOverViewAboveY = this.targetViewRelativeY - this.getHeight();
        View view4 = this.targetView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view4 = null;
        }
        float popOverViewBelowY = this.targetViewRelativeY + view4.getHeight();
        float popOverViewY = 0.0f;
        float popOverViewX = Math.max(0, targetViewRelativeCenterX - this.getWidth() / 2);
        if (popOverViewX + (float)this.getWidth() > (float)availableVisibleArea.right) {
            popOverViewX = availableVisibleArea.right - this.getWidth();
        }
        this.setX(popOverViewX);
        this.setPointerCenterX(targetViewRelativeCenterX);
        boolean showBelow = switch (WhenMappings.$EnumSwitchMapping$0[this.popOverPosition.ordinal()]) {
            case 1 -> {
                if (popOverViewAboveY < 0.0f) {
                    yield true;
                }
                yield false;
            }
            case 2 -> false;
            case 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
        View view5 = this.popOverTopTip;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view5 = null;
        }
        view5.setVisibility(showBelow ? 0 : 8);
        View view6 = this.popOverBottomTip;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view6 = null;
        }
        view6.setVisibility(showBelow ? 8 : 0);
        popOverViewY = showBelow ? popOverViewBelowY : popOverViewAboveY;
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        PopOverData popOverData = this.popOverData;
        boolean bl = popOverData != null ? popOverData.getAnimationType() == 101 : false;
        if (bl) {
            fArray = new float[2];
            View view7 = this.targetView;
            if (view7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view7 = null;
            }
            fArray[0] = this.targetViewRelativeY + view7.getHeight() / 2 - this.getHeight() / 2;
            fArray[1] = popOverViewY;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])fArray));
            fArray = new float[2];
            View view8 = this.targetView;
            if (view8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view8 = null;
            }
            fArray[0] = this.targetViewRelativeX + view8.getWidth() / 2 - this.getWidth() / 2;
            fArray[1] = popOverViewX;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_X, (float[])fArray));
        } else {
            PopOverData popOverData2 = this.popOverData;
            boolean bl2 = popOverData2 != null ? popOverData2.getAnimationType() == 102 : false;
            if (bl2) {
                fArray = new float[]{0.0f, popOverViewY};
                animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])fArray));
            }
        }
        fArray = new float[]{0.0f, 1.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_X, (float[])fArray));
        fArray = new float[]{0.0f, 1.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_Y, (float[])fArray));
        fArray = new float[]{0.0f, 1.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.ALPHA, (float[])fArray));
        AnimatorSet animatorSet = new AnimatorSet();
        PopOverData popOverData3 = this.popOverData;
        animatorSet.setDuration(popOverData3 != null ? popOverData3.getAnimationDuration() : 0L);
        animatorSet.playTogether((Collection)animators);
        animatorSet.start();
    }

    @SuppressLint(value={"NewApi"})
    public final void setPointerCenterX(int pointerCenterX) {
        View view = this.popOverTopTip;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view = null;
        }
        int n = view.getMeasuredWidth();
        View view2 = this.popOverBottomTip;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view2 = null;
        }
        int n2 = view2.getMeasuredWidth();
        int pointerWidth = Math.max(n, n2);
        View view3 = this.popOverTopTip;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view3 = null;
        }
        view3.setX((float)pointerCenterX - (float)(pointerWidth / 2) - this.getX());
        View view4 = this.popOverBottomTip;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view4 = null;
        }
        view4.setX((float)pointerCenterX - (float)(pointerWidth / 2) - this.getX());
    }

    public final void setToolTipListener(@NotNull PopOverClickListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
    }

    @SuppressLint(value={"NewApi"})
    public final void remove() {
        float[] fArray;
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        PopOverData popOverData = this.popOverData;
        boolean bl = popOverData != null ? popOverData.getAnimationType() == 101 : false;
        if (bl) {
            fArray = new float[2];
            fArray[0] = this.getY();
            View view = this.targetView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view = null;
            }
            fArray[1] = this.targetViewRelativeY + view.getHeight() / 2 - this.getHeight() / 2;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])fArray));
            fArray = new float[2];
            fArray[0] = this.getX();
            View view2 = this.targetView;
            if (view2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view2 = null;
            }
            fArray[1] = this.targetViewRelativeX + view2.getWidth() / 2 - this.getWidth() / 2;
            v4 = animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_X, (float[])fArray));
        } else {
            fArray = new float[]{this.getY(), 0.0f};
            v4 = animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])fArray));
        }
        fArray = new float[]{1.0f, 0.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_X, (float[])fArray));
        fArray = new float[]{1.0f, 0.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_Y, (float[])fArray));
        fArray = new float[]{1.0f, 0.0f};
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.ALPHA, (float[])fArray));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether((Collection)animators);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ PopOverView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                this.this$0.removeWithoutAnimation();
            }
        });
        animatorSet.start();
    }

    public final void removeWithoutAnimation() {
        block0: {
            ViewGroup containerParent;
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
            View container = (View)viewParent;
            ViewParent viewParent2 = container.getParent();
            ViewGroup viewGroup = containerParent = viewParent2 instanceof ViewGroup ? (ViewGroup)viewParent2 : null;
            if (viewGroup == null) break block0;
            viewGroup.removeView(container);
        }
    }

    public void onClick(@NotNull View view) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            PopOverClickListener popOverClickListener = this.listener;
            if (popOverClickListener == null) break block0;
            popOverClickListener.onPopOverViewClicked(this);
        }
    }

    private static final void setCloseButton$lambda$0(PopOverView this$0, View it) {
        block0: {
            PopOverClickListener popOverClickListener = this$0.listener;
            if (popOverClickListener == null) break block0;
            popOverClickListener.onCloseClicked(this$0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/telefonica/mistica/feedback/popover/PopOverView$PopOverClickListener;", "", "onPopOverViewClicked", "", "popOverView", "Lcom/telefonica/mistica/feedback/popover/PopOverView;", "onCloseClicked", "com.telefonica.mistica_release"})
    public static interface PopOverClickListener {
        public void onPopOverViewClicked(@NotNull PopOverView var1);

        public void onCloseClicked(@NotNull PopOverView var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/feedback/popover/PopOverView$Position;", "", "<init>", "(Ljava/lang/String;I)V", "AUTO", "TOP", "BOTTOM", "com.telefonica.mistica_release"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position AUTO = new Position();
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.AUTO, Position.TOP, Position.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Position.values().length];
            try {
                nArray[Position.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

