/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.screen.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.PathInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.RawRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.telefonica.mistica.R;
import com.telefonica.mistica.button.ProgressButton;
import com.telefonica.mistica.compose.theme.values.ThemeVariant;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbackType;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbacksKt;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.DrawableUtilsKt;
import com.telefonica.mistica.util.ResUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 i2\u00020\u0001:\u0002hiB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u000e\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\nJ\u0006\u00102\u001a\u00020\nJ\u000e\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u000e\u00105\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u000e\u00106\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u0010\u00107\u001a\u0002012\b\b\u0001\u00108\u001a\u00020\nJ\u000e\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020 J\u000e\u0010;\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u000e\u0010<\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u000e\u0010=\u001a\u0002012\u0006\u00104\u001a\u00020\u001cJ\u000e\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020 J\u000e\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020,J\u000e\u0010B\u001a\u0002012\u0006\u0010A\u001a\u00020,J\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010F\u001a\u0002012\u0006\u0010/\u001a\u00020\nJ\u000e\u0010G\u001a\u0002012\u0006\u0010.\u001a\u00020\nJ&\u0010H\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\b\u0010I\u001a\u000201H\u0014J\b\u0010J\u001a\u000201H\u0002J\b\u0010K\u001a\u000201H\u0002J\b\u0010L\u001a\u000201H\u0002J\b\u0010M\u001a\u00020\nH\u0002J&\u0010L\u001a\u0002012\b\b\u0001\u0010N\u001a\u00020\n2\b\b\u0001\u0010O\u001a\u00020\n2\b\b\u0001\u0010P\u001a\u00020\nH\u0002J/\u0010Q\u001a\u0002012\n\b\u0001\u0010R\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010S\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010P\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u000201H\u0002J\b\u0010V\u001a\u000201H\u0002J\b\u0010W\u001a\u000201H\u0002J\b\u0010X\u001a\u000201H\u0002J\u0006\u0010Y\u001a\u000201J\b\u0010Z\u001a\u000201H\u0002J\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010_\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J\b\u0010`\u001a\u00020aH\u0002J\b\u0010b\u001a\u000201H\u0002J\b\u0010c\u001a\u00020 H\u0002J\u0012\u0010d\u001a\u00020 2\b\b\u0001\u0010e\u001a\u00020\nH\u0002J\b\u0010f\u001a\u00020 H\u0002J\u0010\u0010g\u001a\u0002012\u0006\u0010)\u001a\u00020 H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0016\u0010/\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u0006j"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "icon", "Lcom/airbnb/lottie/LottieAnimationView;", "title", "Landroid/widget/TextView;", "subtitle", "errorReference", "customContentContainer", "Landroid/widget/FrameLayout;", "buttonsContainer", "Landroid/widget/LinearLayout;", "firstButton", "Lcom/telefonica/mistica/button/ProgressButton;", "secondButton", "Landroid/widget/Button;", "type", "titleText", "", "subtitleText", "errorReferenceText", "isLoading", "", "customContentLayout", "Ljava/lang/Integer;", "firstButtonText", "firstButtonLoadingText", "secondButtonText", "secondButtonAsLink", "isIconAnimated", "shouldAnimateOnAttachedToWindow", "testMode", "isAnimatedOnce", "firstButtonClickListener", "Landroid/view/View$OnClickListener;", "secondButtonClickListener", "customAnimation", "customIcon", "setFeedbackType", "", "getFeedbackType", "setFeedbackTitle", "text", "setFeedbackSubtitle", "setFeedbackErrorReference", "setCustomContentLayout", "layout", "setShouldAnimateOnAttached", "animate", "setFeedbackFirstButtonText", "setFeedbackFirstButtonLoadingText", "setFeedbackSecondButtonText", "setFeedbackSecondButtonAsLink", "asLink", "setFirstButtonOnClick", "clickListener", "setSecondButtonOnClick", "getFirstButtonText", "", "setIsLoading", "setCustomIcon", "setCustomAnimation", "init", "onAttachedToWindow", "configureView", "configureBackground", "configureIcon", "getSuccessIconColor", "animationAttr", "imageAttr", "colorAttr", "configureIconAsResource", "animationResource", "imageResource", "(Ljava/lang/Integer;Ljava/lang/Integer;I)V", "configureTexts", "configureCustomContentView", "configureButtons", "animateViewsOnFirstLayout", "animateViews", "executeHapticFeedback", "getTranslationYAnim", "Landroid/animation/ObjectAnimator;", "view", "Landroid/view/View;", "getFadeInAnim", "getCubicBezierInterpolator", "Landroid/view/animation/PathInterpolator;", "performHapticFeedback", "isInversePresentation", "getBooleanThemeRes", "attributeRes", "isInverseThemeVariant", "setTestMode", "FeedbackType", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFeedbackScreenView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedbackScreenView.kt\ncom/telefonica/mistica/feedback/screen/view/FeedbackScreenView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ColorDrawable.kt\nandroidx/core/graphics/drawable/ColorDrawableKt\n*L\n1#1,505:1\n1#2:506\n28#3:507\n*S KotlinDebug\n*F\n+ 1 FeedbackScreenView.kt\ncom/telefonica/mistica/feedback/screen/view/FeedbackScreenView\n*L\n266#1:507\n*E\n"})
public final class FeedbackScreenView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private LottieAnimationView icon;
    private TextView title;
    private TextView subtitle;
    private TextView errorReference;
    private FrameLayout customContentContainer;
    private LinearLayout buttonsContainer;
    private ProgressButton firstButton;
    private Button secondButton;
    private int type;
    @NotNull
    private CharSequence titleText;
    @NotNull
    private CharSequence subtitleText;
    @NotNull
    private CharSequence errorReferenceText;
    private boolean isLoading;
    @LayoutRes
    @Nullable
    private Integer customContentLayout;
    @NotNull
    private CharSequence firstButtonText;
    @NotNull
    private CharSequence firstButtonLoadingText;
    @NotNull
    private CharSequence secondButtonText;
    private boolean secondButtonAsLink;
    private boolean isIconAnimated;
    private boolean shouldAnimateOnAttachedToWindow;
    private boolean testMode;
    private boolean isAnimatedOnce;
    @Nullable
    private View.OnClickListener firstButtonClickListener;
    @Nullable
    private View.OnClickListener secondButtonClickListener;
    @RawRes
    @Nullable
    private Integer customAnimation;
    @DrawableRes
    @Nullable
    private Integer customIcon;
    public static final int $stable = 8;
    public static final int TYPE_SUCCESS = 0;
    public static final int TYPE_ERROR = 1;
    public static final int TYPE_INFO = 2;
    public static final long TEXTS_ANIMATION_DURATION = 800L;
    public static final long TITLE_ANIMATION_DELAY = 600L;
    public static final long SUBTITLE_ANIMATION_DELAY = 900L;
    public static final long EXTRAS_ANIMATION_DELAY = 1200L;
    public static final long HAPTIC_FEEDBACK_DEFAULT_DELAY = 450L;
    public static final long HAPTIC_FEEDBACK_ERROR_DELAY = 500L;

    public FeedbackScreenView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        FeedbackScreenView.init$default(this, context, null, 0, 6, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        FeedbackScreenView.init$default(this, context, attrs, 0, 4, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        this.init(context, attrs, defStyleAttr);
    }

    public final void setFeedbackType(int type) {
        this.type = type;
        this.configureView();
    }

    public final int getFeedbackType() {
        return this.type;
    }

    public final void setFeedbackTitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.titleText = text;
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            textView = null;
        }
        textView.setText(text);
        TextView textView2 = this.title;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            textView2 = null;
        }
        ViewCompat.setAccessibilityHeading((View)((View)textView2), (boolean)true);
    }

    public final void setFeedbackSubtitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.subtitleText = text;
        TextView textView = this.subtitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
            textView = null;
        }
        textView.setText(text);
    }

    public final void setFeedbackErrorReference(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.errorReferenceText = text;
        TextView textView = this.errorReference;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
            textView = null;
        }
        textView.setText(text);
        TextView textView2 = this.errorReference;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
            textView2 = null;
        }
        textView2.setVisibility(!StringsKt.isBlank((CharSequence)text) && this.type == 1 ? 0 : 8);
    }

    public final void setCustomContentLayout(@LayoutRes int layout2) {
        this.customContentLayout = layout2;
        this.configureCustomContentView();
    }

    public final void setShouldAnimateOnAttached(boolean animate) {
        this.shouldAnimateOnAttachedToWindow = animate;
    }

    public final void setFeedbackFirstButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.firstButtonText = text;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setText(text);
        ProgressButton progressButton2 = this.firstButton;
        if (progressButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton2 = null;
        }
        progressButton2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackFirstButtonLoadingText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.firstButtonLoadingText = text;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setLoadingText(text);
    }

    public final void setFeedbackSecondButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.secondButtonText = text;
        Button button = this.secondButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
            button = null;
        }
        button.setText(text);
        Button button2 = this.secondButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
            button2 = null;
        }
        button2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackSecondButtonAsLink(boolean asLink) {
        this.secondButtonAsLink = asLink;
        this.configureButtons();
    }

    public final void setFirstButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.firstButtonClickListener = clickListener;
        if (this.firstButton != null) {
            ProgressButton progressButton = this.firstButton;
            if (progressButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
                progressButton = null;
            }
            progressButton.setOnClickListener(clickListener);
        }
    }

    public final void setSecondButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.secondButtonClickListener = clickListener;
        if (this.secondButton != null) {
            Button button = this.secondButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
                button = null;
            }
            button.setOnClickListener(clickListener);
        }
    }

    @NotNull
    public final String getFirstButtonText() {
        return ((Object)this.firstButtonText).toString();
    }

    public final void setIsLoading(boolean isLoading) {
        boolean wasLoading = this.isLoading;
        this.isLoading = isLoading;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setIsLoading(isLoading);
        if (wasLoading && !isLoading) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.playAnimation();
            this.executeHapticFeedback();
        }
    }

    public final void setCustomIcon(int customIcon) {
        this.customIcon = customIcon;
    }

    public final void setCustomAnimation(int customAnimation) {
        this.customAnimation = customAnimation;
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.screen_feedback, (ViewGroup)this, true);
        if (attrs != null) {
            int it;
            CharSequence it2;
            Resources.Theme theme = context.getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.FeedbackScreen, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            this.type = styledAttrs.getInteger(R.styleable.FeedbackScreen_feedbackType, 2);
            CharSequence charSequence = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackTitle);
            if (charSequence != null) {
                it2 = charSequence;
                boolean bl = false;
                this.titleText = it2;
            }
            Object object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSubtitle);
            if (object != null) {
                it2 = object;
                boolean bl = false;
                this.subtitleText = it2;
            }
            CharSequence charSequence2 = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackErrorReference);
            if (charSequence2 != null) {
                it2 = charSequence2;
                boolean bl = false;
                this.errorReferenceText = it2;
            }
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_feedbackCustomContentLayout, 0);
            int n = ((Number)object).intValue();
            FeedbackScreenView feedbackScreenView = this;
            boolean bl = false;
            boolean bl2 = it != 0;
            feedbackScreenView.customContentLayout = bl2 ? object : null;
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackFirstButtonText);
            if (object != null) {
                Object it3 = object;
                boolean bl3 = false;
                this.firstButtonText = it3;
            }
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackFirstButtonLoadingText);
            if (object != null) {
                Object it4 = object;
                boolean bl4 = false;
                this.firstButtonLoadingText = it4;
            }
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSecondButtonText);
            if (object != null) {
                Object it5 = object;
                boolean bl5 = false;
                this.secondButtonText = it5;
            }
            this.secondButtonAsLink = styledAttrs.getBoolean(R.styleable.FeedbackScreen_feedbackSecondButtonAsLink, false);
            this.shouldAnimateOnAttachedToWindow = styledAttrs.getBoolean(R.styleable.FeedbackScreen_shouldAnimateOnAttached, true);
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_customAnimation, 0);
            it = ((Number)object).intValue();
            boolean bl6 = false;
            Object it22 = it != 0 ? object : null;
            boolean bl7 = false;
            this.customAnimation = it22;
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_customIcon, 0);
            it = ((Number)object).intValue();
            boolean bl8 = false;
            Object it3 = it != 0 ? object : null;
            boolean bl9 = false;
            this.customIcon = it3;
            styledAttrs.recycle();
        }
        View view = this.findViewById(R.id.icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.icon = (LottieAnimationView)view;
        View view2 = this.findViewById(R.id.title);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.title = (TextView)view2;
        View view3 = this.findViewById(R.id.subtitle);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.subtitle = (TextView)view3;
        View view4 = this.findViewById(R.id.error_reference);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.errorReference = (TextView)view4;
        View view5 = this.findViewById(R.id.custom_content);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.customContentContainer = (FrameLayout)view5;
        View view6 = this.findViewById(R.id.buttons_container);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.buttonsContainer = (LinearLayout)view6;
        int buttonsLayout = this.isInversePresentation() ? R.layout.screen_feedback_buttons_inverse : R.layout.screen_feedback_buttons;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        LinearLayout linearLayout = this.buttonsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
            linearLayout = null;
        }
        View buttonsView = layoutInflater.inflate(buttonsLayout, (ViewGroup)linearLayout, true);
        View view7 = buttonsView.findViewById(R.id.first_button);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
        this.firstButton = (ProgressButton)view7;
        View view8 = buttonsView.findViewById(this.secondButtonAsLink ? R.id.link_button : R.id.second_button);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(...)");
        this.secondButton = (Button)view8;
    }

    static /* synthetic */ void init$default(FeedbackScreenView feedbackScreenView, Context context, AttributeSet attributeSet, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        feedbackScreenView.init(context, attributeSet, n);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.configureView();
        this.animateViewsOnFirstLayout();
    }

    private final void configureView() {
        this.configureBackground();
        this.configureIcon();
        this.configureTexts();
        this.configureCustomContentView();
        this.configureButtons();
    }

    private final void configureBackground() {
        Drawable drawable2;
        if (this.isInversePresentation()) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            drawable2 = (Drawable)DrawableUtilsKt.getMisticaThemeDrawable(context, R.attr.drawableBackgroundBrand);
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            int $this$toDrawable$iv = ColorUtilsKt.getThemeColor(context, R.attr.colorBackground);
            boolean $i$f$toDrawable = false;
            drawable2 = (Drawable)new ColorDrawable($this$toDrawable$iv);
        }
        Drawable it = drawable2;
        boolean bl = false;
        this.setBackground(it);
    }

    private final void configureIcon() {
        switch (this.type) {
            case 0: {
                this.configureIcon(R.attr.feedbackScreenSuccessAnimation, R.attr.feedbackScreenSuccessIcon, this.getSuccessIconColor());
                break;
            }
            case 1: {
                this.configureIcon(R.attr.feedbackScreenErrorAnimation, R.attr.feedbackScreenErrorIcon, R.attr.colorError);
                break;
            }
            case 2: {
                Integer n;
                Integer n2 = this.customAnimation;
                if (n2 == null) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    n2 = ResUtilsKt.getThemeRes(context, R.attr.feedbackScreenInfoAnimation, false);
                }
                if ((n = this.customIcon) == null) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    n = ResUtilsKt.getThemeRes(context, R.attr.feedbackScreenInfoIcon, false);
                }
                this.configureIconAsResource(n2, n, R.attr.colorBrand);
            }
        }
    }

    private final int getSuccessIconColor() {
        return this.isInversePresentation() ? R.attr.colorInverse : R.attr.colorBrand;
    }

    private final void configureIcon(@AttrRes int animationAttr, @AttrRes int imageAttr, @AttrRes int colorAttr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Integer animationResource = ResUtilsKt.getThemeRes(context, animationAttr, false);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        Integer imageResource = ResUtilsKt.getThemeRes(context2, imageAttr, false);
        this.configureIconAsResource(animationResource, imageResource, colorAttr);
    }

    private final void configureIconAsResource(@RawRes Integer animationResource, @DrawableRes Integer imageResource, @AttrRes int colorAttr) {
        if (animationResource != null) {
            LottieAnimationView lottieAnimationView;
            LottieAnimationView lottieAnimationView2 = this.icon;
            if (lottieAnimationView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView2 = null;
            }
            lottieAnimationView2.setAnimation(animationResource.intValue());
            LottieAnimationView lottieAnimationView3 = this.icon;
            if (lottieAnimationView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView3 = null;
            }
            String[] stringArray = new String[]{"**"};
            lottieAnimationView3.addValueCallback(new KeyPath(stringArray), (Object)LottieProperty.COLOR_FILTER, arg_0 -> FeedbackScreenView.configureIconAsResource$lambda$0(this, colorAttr, arg_0));
            if (this.testMode) {
                LottieAnimationView lottieAnimationView4 = this.icon;
                if (lottieAnimationView4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                    lottieAnimationView4 = null;
                }
                lottieAnimationView4.setProgress(1.0f);
            }
            if ((lottieAnimationView = this.icon) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setVisibility(0);
        } else if (imageResource != null) {
            Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageResource);
            Intrinsics.checkNotNull((Object)drawable2);
            Drawable unwrappedDrawable = drawable2;
            Drawable drawable3 = DrawableCompat.wrap((Drawable)unwrappedDrawable);
            Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"wrap(...)");
            Drawable drawable4 = drawable3;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            DrawableCompat.setTint((Drawable)drawable4, (int)ColorUtilsKt.getThemeColor(context, colorAttr));
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setImageDrawable(drawable4);
            LottieAnimationView lottieAnimationView5 = this.icon;
            if (lottieAnimationView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView5 = null;
            }
            lottieAnimationView5.setVisibility(0);
        } else {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setVisibility(8);
        }
        this.isIconAnimated = animationResource != null;
    }

    private final void configureTexts() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int titleTextColor = ColorUtilsKt.getThemeColor(context, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextPrimary);
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            textView = null;
        }
        textView.setTextColor(titleTextColor);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        int subtitleTextColor = ColorUtilsKt.getThemeColor(context2, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextSecondary);
        TextView textView2 = this.subtitle;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
            textView2 = null;
        }
        textView2.setTextColor(subtitleTextColor);
        this.setFeedbackTitle(this.titleText);
        this.setFeedbackSubtitle(this.subtitleText);
        this.setFeedbackErrorReference(this.errorReferenceText);
    }

    private final void configureCustomContentView() {
        block3: {
            FrameLayout frameLayout = this.customContentContainer;
            if (frameLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout = null;
            }
            frameLayout.removeAllViews();
            Integer n = this.customContentLayout;
            if (n == null) break block3;
            int it = ((Number)n).intValue();
            boolean bl = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            FrameLayout frameLayout2 = this.customContentContainer;
            if (frameLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout2 = null;
            }
            layoutInflater.inflate(it, (ViewGroup)frameLayout2, false);
            FrameLayout frameLayout3 = this.customContentContainer;
            if (frameLayout3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout3 = null;
            }
            frameLayout3.setVisibility(0);
        }
    }

    private final void configureButtons() {
        block4: {
            ProgressButton progressButton;
            View.OnClickListener it;
            LinearLayout linearLayout = this.buttonsContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
                linearLayout = null;
            }
            linearLayout.removeAllViews();
            int layout2 = this.isInversePresentation() ? R.layout.screen_feedback_buttons_inverse : R.layout.screen_feedback_buttons;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            LinearLayout linearLayout2 = this.buttonsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
                linearLayout2 = null;
            }
            layoutInflater.inflate(layout2, (ViewGroup)linearLayout2, true);
            View view = this.findViewById(R.id.first_button);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
            this.firstButton = (ProgressButton)view;
            this.setFeedbackFirstButtonText(this.firstButtonText);
            this.setFeedbackFirstButtonLoadingText(this.firstButtonLoadingText);
            View.OnClickListener onClickListener = this.firstButtonClickListener;
            if (onClickListener != null) {
                it = onClickListener;
                boolean bl = false;
                this.setFirstButtonOnClick(it);
            }
            if ((progressButton = this.firstButton) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
                progressButton = null;
            }
            progressButton.setIsLoading(this.isLoading);
            View view2 = this.findViewById(this.secondButtonAsLink ? R.id.link_button : R.id.second_button);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
            this.secondButton = (Button)view2;
            this.setFeedbackSecondButtonText(this.secondButtonText);
            View.OnClickListener onClickListener2 = this.secondButtonClickListener;
            if (onClickListener2 == null) break block4;
            it = onClickListener2;
            boolean bl = false;
            this.setSecondButtonOnClick(it);
        }
    }

    private final void animateViewsOnFirstLayout() {
        if (this.shouldAnimateOnAttachedToWindow) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
                final /* synthetic */ FeedbackScreenView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onGlobalLayout() {
                    this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    this.this$0.animateViews();
                }
            });
        }
    }

    public final void animateViews() {
        if (this.isIconAnimated && !this.testMode) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.resumeAnimation();
            if (!this.isAnimatedOnce) {
                AnimatorSet animatorSet;
                AnimatorSet animatorSet2;
                this.isAnimatedOnce = true;
                AnimatorSet $this$animateViews_u24lambda_u240 = animatorSet2 = new AnimatorSet();
                boolean bl = false;
                Animator[] animatorArray = new Animator[2];
                TextView textView = this.title;
                if (textView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                    textView = null;
                }
                animatorArray[0] = this.getFadeInAnim((View)textView);
                TextView textView2 = this.title;
                if (textView2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                    textView2 = null;
                }
                animatorArray[1] = this.getTranslationYAnim((View)textView2);
                $this$animateViews_u24lambda_u240.playTogether(animatorArray);
                $this$animateViews_u24lambda_u240.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
                $this$animateViews_u24lambda_u240.setDuration(800L);
                $this$animateViews_u24lambda_u240.setStartDelay(600L);
                AnimatorSet titleAnimation = animatorSet2;
                AnimatorSet $this$animateViews_u24lambda_u241 = $this$animateViews_u24lambda_u240 = new AnimatorSet();
                boolean bl2 = false;
                Animator[] animatorArray2 = new Animator[2];
                TextView textView3 = this.subtitle;
                if (textView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                    textView3 = null;
                }
                animatorArray2[0] = this.getFadeInAnim((View)textView3);
                TextView textView4 = this.subtitle;
                if (textView4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                    textView4 = null;
                }
                animatorArray2[1] = this.getTranslationYAnim((View)textView4);
                $this$animateViews_u24lambda_u241.playTogether(animatorArray2);
                $this$animateViews_u24lambda_u241.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
                $this$animateViews_u24lambda_u241.setDuration(800L);
                $this$animateViews_u24lambda_u241.setStartDelay(900L);
                AnimatorSet subtitleAnimation = $this$animateViews_u24lambda_u240;
                AnimatorSet $this$animateViews_u24lambda_u242 = animatorSet = new AnimatorSet();
                boolean bl3 = false;
                Animator[] animatorArray3 = new Animator[4];
                FrameLayout frameLayout = this.customContentContainer;
                if (frameLayout == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                    frameLayout = null;
                }
                animatorArray3[0] = this.getFadeInAnim((View)frameLayout);
                FrameLayout frameLayout2 = this.customContentContainer;
                if (frameLayout2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                    frameLayout2 = null;
                }
                animatorArray3[1] = this.getTranslationYAnim((View)frameLayout2);
                TextView textView5 = this.errorReference;
                if (textView5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                    textView5 = null;
                }
                animatorArray3[2] = this.getFadeInAnim((View)textView5);
                TextView textView6 = this.errorReference;
                if (textView6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                    textView6 = null;
                }
                animatorArray3[3] = this.getTranslationYAnim((View)textView6);
                $this$animateViews_u24lambda_u242.playTogether(animatorArray3);
                $this$animateViews_u24lambda_u242.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
                $this$animateViews_u24lambda_u242.setDuration(800L);
                $this$animateViews_u24lambda_u242.setStartDelay(this.subtitleText.length() == 0 ? 900L : 1200L);
                AnimatorSet extraAnimation = animatorSet;
                TextView textView7 = this.title;
                if (textView7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                    textView7 = null;
                }
                textView7.setAlpha(0.0f);
                TextView textView8 = this.subtitle;
                if (textView8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                    textView8 = null;
                }
                textView8.setAlpha(0.0f);
                TextView textView9 = this.errorReference;
                if (textView9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                    textView9 = null;
                }
                textView9.setAlpha(0.0f);
                FrameLayout frameLayout3 = this.customContentContainer;
                if (frameLayout3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                    frameLayout3 = null;
                }
                frameLayout3.setAlpha(0.0f);
                titleAnimation.start();
                subtitleAnimation.start();
                extraAnimation.start();
                this.executeHapticFeedback();
            }
        }
    }

    private final void executeHapticFeedback() {
        this.postDelayed(() -> FeedbackScreenView.executeHapticFeedback$lambda$0(this), this.type == 1 ? 500L : 450L);
    }

    private final ObjectAnimator getTranslationYAnim(View view) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        float pixels = ViewUtilsKt.convertDpToPx(context, 20);
        float[] fArray = new float[]{pixels, 0.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])fArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(...)");
        return objectAnimator;
    }

    private final ObjectAnimator getFadeInAnim(View view) {
        float[] fArray = new float[]{0.0f, 1.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])fArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(...)");
        return objectAnimator;
    }

    private final PathInterpolator getCubicBezierInterpolator() {
        return new PathInterpolator(0.215f, 0.61f, 0.355f, 1.0f);
    }

    private final void performHapticFeedback() {
        switch (this.type) {
            case 0: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.SUCCESS);
                break;
            }
            case 1: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.ERROR);
            }
        }
    }

    private final boolean isInversePresentation() {
        return this.type == 0 && (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessWithGradient) || this.isInverseThemeVariant());
    }

    private final boolean getBooleanThemeRes(@AttrRes int attributeRes) {
        boolean bl;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Integer n = ResUtilsKt.getThemeRes$default(context, attributeRes, false, 2, null);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInverseThemeVariant() {
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.successFeedbackThemeVariant, typedValue, true);
        return typedValue.data == ThemeVariant.INVERSE.ordinal();
    }

    @VisibleForTesting
    public final void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    private static final ColorFilter configureIconAsResource$lambda$0(FeedbackScreenView this$0, int $colorAttr, LottieFrameInfo it) {
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return (ColorFilter)new PorterDuffColorFilter(ColorUtilsKt.getThemeColor(context, $colorAttr), PorterDuff.Mode.SRC_ATOP);
    }

    private static final void executeHapticFeedback$lambda$0(FeedbackScreenView this$0) {
        this$0.performHapticFeedback();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$Companion;", "", "<init>", "()V", "TYPE_SUCCESS", "", "TYPE_ERROR", "TYPE_INFO", "TEXTS_ANIMATION_DURATION", "", "TITLE_ANIMATION_DELAY", "SUBTITLE_ANIMATION_DELAY", "EXTRAS_ANIMATION_DELAY", "HAPTIC_FEEDBACK_DEFAULT_DELAY", "HAPTIC_FEEDBACK_ERROR_DELAY", "com.telefonica.mistica_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$FeedbackType;", "", "com.telefonica.mistica_release"})
    public static @interface FeedbackType {
    }
}

