/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.snackbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import com.telefonica.mistica.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\u0007J\u0014\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/telefonica/mistica/feedback/snackbar/CustomSnackbarLayout;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "maxActionLengthPx", "setText", "", "text", "", "setAction", "actionText", "contentDescription", "", "listener", "Landroid/view/View$OnClickListener;", "setActionTextColor", "color", "setOnDismissClickListener", "onDismissed", "Lkotlin/Function0;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "actionIsTooLong", "", "rearrangeLayout", "getText", "Landroid/widget/TextView;", "getAction", "Landroid/widget/Button;", "getDismissButton", "Landroid/view/View;", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
public final class CustomSnackbarLayout
extends ConstraintLayout {
    private final int maxActionLengthPx;
    public static final int $stable = 8;

    @JvmOverloads
    public CustomSnackbarLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.snackbar_custom_layout_merge, (ViewGroup)this, true);
        this.maxActionLengthPx = context.getResources().getDimensionPixelSize(R.dimen.mistica_snackbar_maxActionInlineWidth);
    }

    public /* synthetic */ CustomSnackbarLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.getText().setText(text);
    }

    public final void setAction(@NotNull CharSequence actionText, @Nullable String contentDescription, @NotNull View.OnClickListener listener2) {
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Button $this$setAction_u24lambda_u240 = this.getAction();
        boolean bl = false;
        $this$setAction_u24lambda_u240.setVisibility(0);
        $this$setAction_u24lambda_u240.setText(actionText);
        String string2 = contentDescription;
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$setAction_u24lambda_u240.setContentDescription((CharSequence)contentDescription);
        }
        $this$setAction_u24lambda_u240.setOnClickListener(listener2);
    }

    public final void setActionTextColor(@ColorInt int color) {
        this.getAction().setTextColor(color);
    }

    public final void setOnDismissClickListener(@NotNull Function0<Unit> onDismissed) {
        Intrinsics.checkNotNullParameter(onDismissed, (String)"onDismissed");
        this.getDismissButton().setVisibility(0);
        this.getDismissButton().setOnClickListener(arg_0 -> CustomSnackbarLayout.setOnDismissClickListener$lambda$0(onDismissed, arg_0));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.actionIsTooLong()) {
            this.rearrangeLayout();
        }
    }

    private final boolean actionIsTooLong() {
        return this.getAction().getMeasuredWidth() > this.maxActionLengthPx;
    }

    private final void rearrangeLayout() {
        TextView text = this.getText();
        Button action = this.getAction();
        View dismissButton = this.getDismissButton();
        CustomSnackbarLayout parent = this;
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)parent);
        constraintSet.connect(text.getId(), 7, dismissButton.getId(), 6);
        constraintSet.connect(text.getId(), 4, action.getId(), 3);
        constraintSet.connect(dismissButton.getId(), 6, text.getId(), 7);
        constraintSet.connect(dismissButton.getId(), 7, parent.getId(), 7);
        constraintSet.setHorizontalBias(dismissButton.getId(), 1.0f);
        constraintSet.setVerticalBias(dismissButton.getId(), 0.0f);
        constraintSet.setMargin(dismissButton.getId(), 3, this.getContext().getResources().getDimensionPixelSize(R.dimen.mistica_snackbar_padding_vertical));
        constraintSet.connect(action.getId(), 6, parent.getId(), 6);
        constraintSet.connect(action.getId(), 4, parent.getId(), 4);
        constraintSet.connect(action.getId(), 3, text.getId(), 4);
        constraintSet.connect(action.getId(), 7, parent.getId(), 7);
        constraintSet.setHorizontalBias(action.getId(), 1.0f);
        constraintSet.setMargin(action.getId(), 7, this.getContext().getResources().getDimensionPixelSize(R.dimen.mistica_snackbar_action_horizontal_margin));
        constraintSet.setMargin(action.getId(), 4, this.getContext().getResources().getDimensionPixelSize(R.dimen.mistica_snackbar_action_vertical_margin));
        constraintSet.setMargin(action.getId(), 3, this.getContext().getResources().getDimensionPixelSize(R.dimen.mistica_snackbar_action_vertical_margin));
        constraintSet.applyTo((ConstraintLayout)this);
    }

    private final TextView getText() {
        View view = this.findViewById(R.id.custom_snackbar_text);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (TextView)view;
    }

    private final Button getAction() {
        View view = this.findViewById(R.id.custom_snackbar_action);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (Button)view;
    }

    private final View getDismissButton() {
        View view = this.findViewById(R.id.custom_snackbar_dismiss);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return view;
    }

    @JvmOverloads
    public CustomSnackbarLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CustomSnackbarLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setOnDismissClickListener$lambda$0(Function0 $onDismissed, View it) {
        $onDismissed.invoke();
    }
}

