/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.tag;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textview.MaterialTextView;
import com.telefonica.mistica.R;
import com.telefonica.mistica.tag.TagColors;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\b\b\u0001\u0010\u0016\u001a\u00020\u0007J\u001c\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001d*\u00020\u0007H\u0002R\u0014\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/telefonica/mistica/tag/TagView;", "Lcom/google/android/material/textview/MaterialTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentStyle", "getCurrentStyle$annotations", "()V", "setTagStyle", "", "style", "icon", "Landroid/graphics/drawable/Drawable;", "customColors", "Lcom/telefonica/mistica/tag/TagColors;", "setTagIcon", "drawable", "textColor", "setText", "text", "", "type", "Landroid/widget/TextView$BufferType;", "getStyle", "Lkotlin/Pair;", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTagView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagView.kt\ncom/telefonica/mistica/tag/TagView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class TagView
extends MaterialTextView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentStyle;
    public static final int $stable = 8;
    public static final int TYPE_PROMO = 0;
    public static final int TYPE_INFO = 1;
    public static final int TYPE_ACTIVE = 2;
    public static final int TYPE_INACTIVE = 3;
    public static final int TYPE_SUCCESS = 4;
    public static final int TYPE_WARNING = 5;
    public static final int TYPE_ERROR = 6;
    private static final int UNDEFINED_COLOR = Integer.MIN_VALUE;

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((Context)new ContextThemeWrapper(context, R.style.AppTheme_Widgets_Tag), attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TagView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            int style2 = styledAttrs.getInt(R.styleable.TagView_tagStyle, this.currentStyle);
            Drawable icon = styledAttrs.getDrawable(R.styleable.TagView_tagIcon);
            Integer n = styledAttrs.getColor(R.styleable.TagView_tagTextColor, Integer.MIN_VALUE);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer textColor = it != Integer.MIN_VALUE ? n : null;
            Integer n2 = styledAttrs.getColor(R.styleable.TagView_tagBackgroundColor, Integer.MIN_VALUE);
            int it2 = ((Number)n2).intValue();
            boolean bl2 = false;
            Integer backgroundColor = it2 != Integer.MIN_VALUE ? n2 : null;
            this.setTagStyle(style2, icon, new TagColors(textColor, backgroundColor));
            styledAttrs.recycle();
        }
    }

    public /* synthetic */ TagView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private static /* synthetic */ void getCurrentStyle$annotations() {
    }

    @JvmOverloads
    public final void setTagStyle(int style2, @Nullable Drawable icon, @Nullable TagColors customColors) {
        int n;
        Object object;
        int tagBackgroundColor;
        this.currentStyle = style2;
        Pair<Integer, Integer> styleColors = this.getStyle(style2);
        Object object2 = customColors;
        if (object2 != null && (object2 = ((TagColors)object2).getBackgroundColor()) != null) {
            v1 = (Integer)object2;
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            v1 = tagBackgroundColor = ColorUtilsKt.getThemeColor(context, ((Number)styleColors.getFirst()).intValue());
        }
        if ((object = customColors) != null && (object = ((TagColors)object).getTextColor()) != null) {
            n = (Integer)object;
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            n = ColorUtilsKt.getThemeColor(context, ((Number)styleColors.getSecond()).intValue());
        }
        int tagTextColor = n;
        this.getBackground().setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)tagBackgroundColor, (BlendModeCompat)BlendModeCompat.SRC_IN));
        this.setTextColor(tagTextColor);
        if (icon != null) {
            this.setTagIcon(icon, tagTextColor);
        }
    }

    public static /* synthetic */ void setTagStyle$default(TagView tagView, int n, Drawable drawable2, TagColors tagColors, int n2, Object object) {
        if ((n2 & 2) != 0) {
            drawable2 = null;
        }
        if ((n2 & 4) != 0) {
            tagColors = null;
        }
        tagView.setTagStyle(n, drawable2, tagColors);
    }

    public final void setTagIcon(@NotNull Drawable drawable2, @ColorInt int textColor) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable2), (int)textColor);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int iconSize = ViewUtilsKt.convertDpToPx(context, 16);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        int fixedMargin = ViewUtilsKt.convertDpToPx(context2, 1.5f);
        drawable2.setBounds(0, fixedMargin, iconSize, iconSize + fixedMargin);
        this.setCompoundDrawablesRelative(drawable2, null, null, null);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
        this.setCompoundDrawablePadding(ViewUtilsKt.convertDpToPx(context3, 4));
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
        this.setPadding(ViewUtilsKt.convertDpToPx(context4, 8), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    public void setText(@Nullable CharSequence text, @Nullable TextView.BufferType type) {
        CharSequence charSequence = text;
        super.setText((CharSequence)(charSequence != null ? ((Object)charSequence).toString() : null), type);
    }

    private final Pair<Integer, Integer> getStyle(int $this$getStyle) {
        return switch ($this$getStyle) {
            case 0 -> TuplesKt.to((Object)R.attr.colorTagBackgroundPromo, (Object)R.attr.colorTagTextPromo);
            case 1 -> TuplesKt.to((Object)R.attr.colorTagBackgroundInfo, (Object)R.attr.colorTagTextInfo);
            case 2 -> TuplesKt.to((Object)R.attr.colorTagBackgroundActive, (Object)R.attr.colorTagTextActive);
            case 3 -> TuplesKt.to((Object)R.attr.colorTagBackgroundInactive, (Object)R.attr.colorTagTextInactive);
            case 4 -> TuplesKt.to((Object)R.attr.colorTagBackgroundSuccess, (Object)R.attr.colorTagTextSuccess);
            case 5 -> TuplesKt.to((Object)R.attr.colorTagBackgroundWarning, (Object)R.attr.colorTagTextWarning);
            case 6 -> TuplesKt.to((Object)R.attr.colorTagBackgroundError, (Object)R.attr.colorTagTextError);
            default -> TuplesKt.to((Object)R.attr.colorTagBackgroundPromo, (Object)R.attr.colorTagTextPromo);
        };
    }

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TagView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @JvmOverloads
    public final void setTagStyle(int style2, @Nullable Drawable icon) {
        TagView.setTagStyle$default(this, style2, icon, null, 4, null);
    }

    @JvmOverloads
    public final void setTagStyle(int style2) {
        TagView.setTagStyle$default(this, style2, null, null, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/telefonica/mistica/tag/TagView$Companion;", "", "<init>", "()V", "TYPE_PROMO", "", "TYPE_INFO", "TYPE_ACTIVE", "TYPE_INACTIVE", "TYPE_SUCCESS", "TYPE_WARNING", "TYPE_ERROR", "UNDEFINED_COLOR", "com.telefonica.mistica_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

