/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.request.Options;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/telefonica/mistica/util/Base64DataUrlFetcher;", "Lcoil/fetch/Fetcher;", "base64Data", "", "resources", "Landroid/content/res/Resources;", "<init>", "(Ljava/lang/String;Landroid/content/res/Resources;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBase64DataUrlFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base64DataUrlFetcher.kt\ncom/telefonica/mistica/util/Base64DataUrlFetcher\n+ 2 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n*L\n1#1,72:1\n27#2:73\n*S KotlinDebug\n*F\n+ 1 Base64DataUrlFetcher.kt\ncom/telefonica/mistica/util/Base64DataUrlFetcher\n*L\n34#1:73\n*E\n"})
public final class Base64DataUrlFetcher
implements Fetcher {
    @NotNull
    private final String base64Data;
    @NotNull
    private final Resources resources;
    public static final int $stable = 8;

    public Base64DataUrlFetcher(@NotNull String base64Data, @NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)base64Data, (String)"base64Data");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.base64Data = base64Data;
        this.resources = resources;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        try {
            void $this$toDrawable$iv;
            byte[] bytes = Base64.decode((String)this.base64Data, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            Intrinsics.checkNotNull((Object)bitmap);
            Bitmap bitmap2 = bitmap;
            Resources resources$iv = this.resources;
            boolean $i$f$toDrawable = false;
            BitmapDrawable drawable2 = new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv);
            fetchResult = (FetchResult)new DrawableResult((Drawable)drawable2, false, DataSource.MEMORY);
        }
        catch (IllegalArgumentException e) {
            Log.i((String)"Base64Fetcher", (String)("Image data uri " + StringsKt.take((String)this.base64Data, (int)30) + "... could not be parsed"));
            fetchResult = null;
        }
        return fetchResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/telefonica/mistica/util/Base64DataUrlFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "resources", "Landroid/content/res/Resources;", "<init>", "(Landroid/content/res/Resources;)V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isDataUrl", "", "", "isBase64", "Companion", "com.telefonica.mistica_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final Resources resources;
        public static final int $stable = 8;
        @Deprecated
        public static final char ENCODED_DATA_DELIMITER = ',';

        public Factory(@NotNull Resources resources) {
            Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
            this.resources = resources;
        }

        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            Fetcher fetcher;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
            String string2 = data.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String url = string2;
            String dataPrefix = StringsKt.substringBefore$default((String)url, (char)',', null, (int)2, null);
            if (this.isDataUrl(dataPrefix) && this.isBase64(dataPrefix)) {
                String base64Data = StringsKt.substringAfter$default((String)url, (char)',', null, (int)2, null);
                fetcher = new Base64DataUrlFetcher(base64Data, this.resources);
            } else {
                fetcher = null;
            }
            return fetcher;
        }

        private final boolean isDataUrl(String $this$isDataUrl) {
            return StringsKt.startsWith$default((String)$this$isDataUrl, (String)"data:", (boolean)false, (int)2, null);
        }

        private final boolean isBase64(String $this$isBase64) {
            return StringsKt.endsWith$default((String)$this$isBase64, (String)";base64", (boolean)false, (int)2, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/telefonica/mistica/util/Base64DataUrlFetcher$Factory$Companion;", "", "<init>", "()V", "ENCODED_DATA_DELIMITER", "", "com.telefonica.mistica_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

