/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.res.ResourcesCompat;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.DimensionUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00002\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\r\u001a\u00020\u00002\n\b\u0003\u0010\u0012\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0015J#\u0010\u000e\u001a\u00020\u00002\n\b\u0003\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u0019*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/telefonica/mistica/util/DrawableBuilder;", "", "context", "Landroid/content/Context;", "baseDrawable", "Landroid/graphics/drawable/PaintDrawable;", "<init>", "(Landroid/content/Context;Landroid/graphics/drawable/PaintDrawable;)V", "withCornerRadius", "", "cornerRadius", "", "Ljava/lang/Float;", "withRipple", "withBorderStroke", "borderStrokeColor", "", "Ljava/lang/Integer;", "rippleColor", "borderStrokeWidth", "(Ljava/lang/Float;)Lcom/telefonica/mistica/util/DrawableBuilder;", "(Ljava/lang/Integer;)Lcom/telefonica/mistica/util/DrawableBuilder;", "borderStrikeWidth", "(Ljava/lang/Integer;Ljava/lang/Float;)Lcom/telefonica/mistica/util/DrawableBuilder;", "get", "Landroid/graphics/drawable/Drawable;", "applyCornerRadius", "applyRipple", "applyBorderStroke", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDrawableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawableBuilder.kt\ncom/telefonica/mistica/util/DrawableBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class DrawableBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final PaintDrawable baseDrawable;
    private boolean withCornerRadius;
    @Px
    @Nullable
    private Float cornerRadius;
    private boolean withRipple;
    private boolean withBorderStroke;
    @ColorInt
    @Nullable
    private Integer borderStrokeColor;
    @ColorInt
    @Nullable
    private Integer rippleColor;
    @Px
    @Nullable
    private Float borderStrokeWidth;
    public static final int $stable = 8;

    public DrawableBuilder(@NotNull Context context, @NotNull PaintDrawable baseDrawable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)baseDrawable, (String)"baseDrawable");
        this.context = context;
        this.baseDrawable = baseDrawable;
    }

    @NotNull
    public final DrawableBuilder withCornerRadius(@Px @Nullable Float cornerRadius) {
        DrawableBuilder drawableBuilder;
        DrawableBuilder $this$withCornerRadius_u24lambda_u240 = drawableBuilder = this;
        boolean bl = false;
        $this$withCornerRadius_u24lambda_u240.withCornerRadius = true;
        $this$withCornerRadius_u24lambda_u240.cornerRadius = cornerRadius;
        return drawableBuilder;
    }

    public static /* synthetic */ DrawableBuilder withCornerRadius$default(DrawableBuilder drawableBuilder, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        return drawableBuilder.withCornerRadius(f);
    }

    @NotNull
    public final DrawableBuilder withRipple(@ColorInt @Nullable Integer rippleColor) {
        DrawableBuilder drawableBuilder;
        DrawableBuilder $this$withRipple_u24lambda_u240 = drawableBuilder = this;
        boolean bl = false;
        $this$withRipple_u24lambda_u240.withRipple = true;
        $this$withRipple_u24lambda_u240.rippleColor = rippleColor;
        return drawableBuilder;
    }

    public static /* synthetic */ DrawableBuilder withRipple$default(DrawableBuilder drawableBuilder, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return drawableBuilder.withRipple(n);
    }

    @NotNull
    public final DrawableBuilder withBorderStroke(@ColorInt @Nullable Integer borderStrokeColor, @Px @Nullable Float borderStrikeWidth) {
        DrawableBuilder drawableBuilder;
        DrawableBuilder $this$withBorderStroke_u24lambda_u240 = drawableBuilder = this;
        boolean bl = false;
        $this$withBorderStroke_u24lambda_u240.withBorderStroke = true;
        $this$withBorderStroke_u24lambda_u240.borderStrokeColor = borderStrokeColor;
        $this$withBorderStroke_u24lambda_u240.borderStrokeWidth = borderStrikeWidth;
        return drawableBuilder;
    }

    public static /* synthetic */ DrawableBuilder withBorderStroke$default(DrawableBuilder drawableBuilder, Integer n, Float f, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            f = null;
        }
        return drawableBuilder.withBorderStroke(n, f);
    }

    @NotNull
    public final Drawable get() {
        return this.applyBorderStroke(this.applyRipple((Drawable)this.applyCornerRadius(this.baseDrawable)));
    }

    private final PaintDrawable applyCornerRadius(PaintDrawable $this$applyCornerRadius) {
        PaintDrawable paintDrawable;
        PaintDrawable $this$applyCornerRadius_u24lambda_u240 = paintDrawable = $this$applyCornerRadius;
        boolean bl = false;
        if (this.withCornerRadius) {
            Float f = this.cornerRadius;
            $this$applyCornerRadius_u24lambda_u240.setCornerRadius(f != null ? f.floatValue() : DimensionUtilsKt.getDimension(this.context, R.attr.containerBorderRadius));
        }
        return paintDrawable;
    }

    private final Drawable applyRipple(Drawable $this$applyRipple) {
        if (!this.withRipple) {
            return $this$applyRipple;
        }
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.empty_ripple_background, (Resources.Theme)this.context.getTheme());
        Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.RippleDrawable");
        RippleDrawable ripple = (RippleDrawable)drawable2;
        Integer n = this.rippleColor;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ripple.setColor(ColorStateList.valueOf((int)it));
        }
        ripple.setDrawableByLayerId(16908334, $this$applyRipple);
        ripple.setDrawableByLayerId(0x1020000, $this$applyRipple);
        return (Drawable)ripple;
    }

    private final Drawable applyBorderStroke(Drawable $this$applyBorderStroke) {
        Drawable[] drawableArray;
        if (!this.withBorderStroke) {
            return $this$applyBorderStroke;
        }
        Drawable[] $this$applyBorderStroke_u24lambda_u240 = drawableArray = new PaintDrawable();
        boolean bl = false;
        $this$applyBorderStroke_u24lambda_u240.setShape((Shape)new RectShape());
        if (this.withCornerRadius) {
            Float f = this.cornerRadius;
            $this$applyBorderStroke_u24lambda_u240.setCornerRadius(f != null ? f.floatValue() : DimensionUtilsKt.getDimension(this.context, R.attr.containerBorderRadius));
        }
        Integer n = this.borderStrokeColor;
        $this$applyBorderStroke_u24lambda_u240.getPaint().setColor(n != null ? n : ColorUtilsKt.getThemeColor(this.context, R.attr.colorBorder));
        Float f = this.borderStrokeWidth;
        $this$applyBorderStroke_u24lambda_u240.getPaint().setStrokeWidth(f != null ? f.floatValue() : (float)ViewUtilsKt.convertDpToPx(this.context, 1.0f));
        $this$applyBorderStroke_u24lambda_u240.getPaint().setStyle(Paint.Style.STROKE);
        Drawable[] strokeDrawable = drawableArray;
        drawableArray = new Drawable[]{$this$applyBorderStroke, strokeDrawable};
        return (Drawable)new LayerDrawable(drawableArray);
    }
}

