/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.stepper;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.stepper.IndeterminateStepperView;
import com.telefonica.mistica.stepper.StepView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(attribute="maxSteps", method="setMaxSteps", type=DeterminateStepperView.class), @BindingMethod(attribute="step", method="setStep", type=DeterminateStepperView.class)})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0014H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/telefonica/mistica/stepper/DeterminateStepperView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentStep", "indeterminateStepper", "Lcom/telefonica/mistica/stepper/IndeterminateStepperView;", "isDetermined", "", "maxSteps", "progressBars", "", "steps", "Lcom/telefonica/mistica/stepper/StepView;", "complete", "", "createDeterminedSteps", "container", "Landroidx/constraintlayout/widget/ConstraintLayout;", "createFirstDeterminedStep", "createRemainingDeterminedSteps", "decreaseStepsUntil", "step", "increaseStepsUntil", "reset", "setDeterminedStep", "setIndeterminateStep", "setMaxSteps", "setStep", "setStepSafe", "setUpDeterminedLayout", "setUpDeterminedStepper", "setUpIndeterminateStepper", "Companion", "com.telefonica.mistica"})
public final class DeterminateStepperView
extends FrameLayout {
    private int maxSteps;
    private int currentStep;
    private boolean isDetermined;
    private final List<StepView> steps;
    private final List<IndeterminateStepperView> progressBars;
    private IndeterminateStepperView indeterminateStepper;
    @Deprecated
    public static final int FIRST_STEP = 1;
    @Deprecated
    public static final int MAX_DETERMINED_STEPS = 5;
    @Deprecated
    public static final double MAX_INDETERMINATE_PROGRESS = 100.0;
    @NotNull
    private static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void setMaxSteps(int maxSteps) {
        this.reset();
        if (maxSteps <= 0) {
            return;
        }
        this.maxSteps = maxSteps;
        boolean bl = this.isDetermined = maxSteps <= 5;
        if (this.isDetermined) {
            this.setUpDeterminedStepper();
        } else {
            this.setUpIndeterminateStepper();
        }
    }

    private final void reset() {
        this.removeAllViews();
        this.steps.clear();
        this.progressBars.clear();
        this.currentStep = 0;
    }

    private final void setUpDeterminedStepper() {
        ConstraintLayout container;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.determinate_stepper_layout, (ViewGroup)this, true);
        ConstraintLayout constraintLayout = container = (ConstraintLayout)this.findViewById(R.id.stepper_container);
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"container");
        this.createDeterminedSteps(constraintLayout);
        this.setUpDeterminedLayout(container);
    }

    private final void createDeterminedSteps(ConstraintLayout container) {
        this.createFirstDeterminedStep(container);
        this.createRemainingDeterminedSteps(container);
    }

    private final void createFirstDeterminedStep(ConstraintLayout container) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        StepView stepView = new StepView(context, null, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        StepView $this$apply = stepView;
        boolean bl3 = false;
        $this$apply.setStep(1, true);
        $this$apply.setId(View.generateViewId());
        StepView firstStep = stepView;
        this.steps.add(firstStep);
        container.addView((View)firstStep);
    }

    /*
     * WARNING - void declaration
     */
    private final void createRemainingDeterminedSteps(ConstraintLayout container) {
        int n = 2;
        int n2 = this.maxSteps;
        if (n <= n2) {
            while (true) {
                void i;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                StepView stepView = new StepView(context, null, 0, 6, null);
                boolean bl = false;
                boolean bl2 = false;
                StepView $this$apply = stepView;
                boolean bl3 = false;
                $this$apply.setId(View.generateViewId());
                StepView.setStep$default($this$apply, (int)i, false, 2, null);
                StepView step = stepView;
                this.steps.add(step);
                container.addView((View)step);
                Context context2 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                IndeterminateStepperView indeterminateStepperView = new IndeterminateStepperView(context2, null, 0, 6, null);
                bl2 = false;
                boolean bl4 = false;
                IndeterminateStepperView $this$apply2 = indeterminateStepperView;
                boolean bl5 = false;
                $this$apply2.setId(View.generateViewId());
                $this$apply2.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(0, -2));
                IndeterminateStepperView progressBar = indeterminateStepperView;
                this.progressBars.add(progressBar);
                container.addView((View)progressBar);
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpDeterminedLayout(ConstraintLayout container) {
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone(container);
        constraintSet.connect(((StepView)((Object)CollectionsKt.first(this.steps))).getId(), 6, container.getId(), 6, 0);
        int margin = MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.stepper_step_margin));
        int n = 0;
        int n2 = this.progressBars.size();
        while (n < n2) {
            void i;
            IndeterminateStepperView progressBar = this.progressBars.get((int)i);
            StepView previousStep = this.steps.get((int)i);
            StepView nextStep = this.steps.get((int)(i + true));
            constraintSet.connect(progressBar.getId(), 6, previousStep.getId(), 7, margin);
            constraintSet.connect(progressBar.getId(), 7, nextStep.getId(), 6, margin);
            constraintSet.connect(progressBar.getId(), 3, container.getId(), 3, margin);
            constraintSet.connect(progressBar.getId(), 4, container.getId(), 4, margin);
            constraintSet.connect(previousStep.getId(), 7, progressBar.getId(), 6, 0);
            constraintSet.connect(nextStep.getId(), 6, progressBar.getId(), 7, 0);
            ++i;
        }
        constraintSet.connect(((StepView)((Object)CollectionsKt.last(this.steps))).getId(), 7, container.getId(), 7, 0);
        constraintSet.applyTo(container);
    }

    private final void setUpIndeterminateStepper() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.indeterminateStepper = new IndeterminateStepperView(context, null, 0, 6, null);
        this.setIndeterminateStep(1);
        this.addView((View)this.indeterminateStepper);
    }

    public final void setStep(int step) {
        if (step > this.maxSteps) {
            this.complete();
        } else if (step <= 0) {
            this.setStepSafe(1);
        } else {
            this.setStepSafe(step);
        }
    }

    private final void setStepSafe(int step) {
        if (this.isDetermined) {
            this.setDeterminedStep(step);
        } else {
            this.setIndeterminateStep(step);
        }
    }

    private final void setDeterminedStep(int step) {
        int nextStep = step - 1;
        if (nextStep > this.currentStep) {
            this.increaseStepsUntil(nextStep);
        } else if (nextStep < this.currentStep) {
            this.decreaseStepsUntil(nextStep);
        }
        this.steps.get(nextStep).setSelected();
        this.currentStep = nextStep;
    }

    /*
     * WARNING - void declaration
     */
    private final void increaseStepsUntil(int step) {
        int n = this.currentStep;
        int n2 = step;
        while (n < n2) {
            void i;
            this.steps.get((int)i).setCompleted();
            if (i - true >= 0) {
                this.progressBars.get((int)(i - true)).complete$com_telefonica_mistica();
            }
            ++i;
        }
        if (step - 1 >= 0 && step < this.maxSteps) {
            this.progressBars.get(step - 1).complete$com_telefonica_mistica();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void decreaseStepsUntil(int step) {
        int n = this.currentStep;
        int n2 = step + 1;
        if (n >= n2) {
            while (true) {
                void i;
                this.steps.get((int)i).setUnselected();
                if (i - true >= 0) {
                    this.progressBars.get((int)(i - true)).reset$com_telefonica_mistica();
                }
                if (i == n2) break;
                --i;
            }
        }
    }

    private final void setIndeterminateStep(int step) {
        block0: {
            double progress = 100.0 / (double)(this.maxSteps + 1) * (double)step;
            IndeterminateStepperView indeterminateStepperView = this.indeterminateStepper;
            if (indeterminateStepperView == null) break block0;
            indeterminateStepperView.setProgress(MathKt.roundToInt((double)progress));
        }
    }

    private final void complete() {
        block1: {
            block0: {
                if (!this.isDetermined) break block0;
                this.increaseStepsUntil(this.maxSteps);
                this.currentStep = this.maxSteps - 1;
                break block1;
            }
            IndeterminateStepperView indeterminateStepperView = this.indeterminateStepper;
            if (indeterminateStepperView == null) break block1;
            indeterminateStepperView.complete$com_telefonica_mistica();
        }
    }

    @JvmOverloads
    public DeterminateStepperView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isDetermined = true;
        boolean bl = false;
        this.steps = new ArrayList();
        bl = false;
        this.progressBars = new ArrayList();
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DeterminateStepperView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026          0\n            )");
            TypedArray styledAttrs = typedArray;
            int maxSteps = styledAttrs.getInteger(R.styleable.DeterminateStepperView_maxSteps, -1);
            if (maxSteps >= 0) {
                this.setMaxSteps(maxSteps);
            }
        }
    }

    public /* synthetic */ DeterminateStepperView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public DeterminateStepperView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DeterminateStepperView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/telefonica/mistica/stepper/DeterminateStepperView$Companion;", "", "()V", "FIRST_STEP", "", "MAX_DETERMINED_STEPS", "MAX_INDETERMINATE_PROGRESS", "", "com.telefonica.mistica"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

