/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.button;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.button.MaterialButton;
import com.telefonica.mistica.R;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0003J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020(J\u001e\u0010)\u001a\u00020(2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0012H\u0016J\u000e\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0012J\u000e\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\"J\u0012\u00100\u001a\u00020(2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020(H\u0002J\u000e\u00104\u001a\u00020(2\u0006\u0010/\u001a\u00020\"J\u0010\u00104\u001a\u00020(2\b\b\u0001\u00105\u001a\u00020\tJ\b\u00106\u001a\u00020(H\u0002J\u0006\u00107\u001a\u00020(J\b\u00108\u001a\u00020(H\u0002J\f\u00109\u001a\u00020&*\u00020&H\u0002J\f\u0010:\u001a\u00020(*\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/telefonica/mistica/button/ProgressButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "buttonBackground", "Lcom/google/android/material/button/MaterialButton;", "buttonLoading", "buttonNormal", "currentAnimation", "Landroid/animation/AnimatorSet;", "<set-?>", "", "isLoading", "()Z", "originalTextColors", "Landroid/content/res/ColorStateList;", "progressBar", "Landroid/widget/ProgressBar;", "getCubicBezierInterpolator", "Landroid/view/animation/PathInterpolator;", "getCurrentTextColor", "getCurrentTextColorFadeAnim", "Landroid/animation/ObjectAnimator;", "view", "Landroid/widget/TextView;", "out", "getText", "", "getTranslationYAnim", "Landroid/view/View;", "positions", "", "hideLoading", "", "init", "setEnabled", "enabled", "setIsLoading", "loading", "setLoadingText", "text", "setOnClickListener", "l", "Landroid/view/View$OnClickListener;", "setProgressBarHorizontalPosition", "setText", "textId", "setVisibilityAndColors", "showLoading", "switchState", "reverseIfLoading", "showTextOnly", "Companion", "library_release"})
public final class ProgressButton
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressBar progressBar;
    @NotNull
    private final MaterialButton buttonNormal;
    @NotNull
    private final MaterialButton buttonLoading;
    @NotNull
    private final MaterialButton buttonBackground;
    private ColorStateList originalTextColors;
    private boolean isLoading;
    @Nullable
    private AnimatorSet currentAnimation;
    @Deprecated
    private static final long ANIMATION_DURATION = 300L;
    @Deprecated
    private static final int NO_ID = -1;

    public final boolean isLoading() {
        return this.isLoading;
    }

    public ProgressButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context);
        this.buttonLoading = new MaterialButton(context);
        this.buttonBackground = new MaterialButton(context);
        ProgressButton.init$default(this, null, 0, 3, null);
    }

    public ProgressButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context, attrs);
        this.buttonLoading = new MaterialButton(context, attrs);
        this.buttonBackground = new MaterialButton(context, attrs);
        ProgressButton.init$default(this, attrs, 0, 2, null);
    }

    public ProgressButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context, attrs, defStyleAttr);
        this.buttonLoading = new MaterialButton(context, attrs, defStyleAttr);
        this.buttonBackground = new MaterialButton(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            Resources.Theme theme = this.getContext().getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.ProgressButton, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"theme.obtainStyledAttributes(attrs, R.styleable.ProgressButton, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            try {
                this.isLoading = styledAttrs.getBoolean(R.styleable.ProgressButton_isLoading, false);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        this.setClickable(false);
        this.setPadding(0, 0, 0, 0);
        this.setBackgroundColor(0);
        ColorStateList colorStateList = this.buttonNormal.getTextColors();
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"buttonNormal.textColors");
        this.originalTextColors = colorStateList;
        colorStateList = this.buttonNormal;
        boolean bl = false;
        boolean bl2 = false;
        ColorStateList $this$init_u24lambda_u2d0 = colorStateList;
        boolean bl3 = false;
        $this$init_u24lambda_u2d0.setId(-1);
        $this$init_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.showTextOnly((MaterialButton)$this$init_u24lambda_u2d0);
        colorStateList = this.buttonLoading;
        bl = false;
        bl2 = false;
        ColorStateList $this$init_u24lambda_u2d1 = colorStateList;
        boolean bl4 = false;
        $this$init_u24lambda_u2d1.setId(-1);
        $this$init_u24lambda_u2d1.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.showTextOnly((MaterialButton)$this$init_u24lambda_u2d1);
        $this$init_u24lambda_u2d1.setIcon(ContextCompat.getDrawable((Context)$this$init_u24lambda_u2d1.getContext(), (int)R.drawable.empty_material_button_icon));
        $this$init_u24lambda_u2d1.setText((CharSequence)"");
        colorStateList = this.progressBar;
        bl = false;
        bl2 = false;
        ColorStateList $this$init_u24lambda_u2d3 = colorStateList;
        boolean bl5 = false;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.buttonLoading.getIconSize(), this.buttonLoading.getIconSize());
        boolean bl6 = false;
        boolean bl7 = false;
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        ColorStateList colorStateList2 = $this$init_u24lambda_u2d3;
        boolean bl8 = false;
        $this$init_u24lambda_u2d3_u24lambda_u2d2.gravity = 17;
        Unit unit = Unit.INSTANCE;
        colorStateList2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        $this$init_u24lambda_u2d3.setIndeterminate(true);
        $this$init_u24lambda_u2d3.setIndeterminateTintMode(PorterDuff.Mode.SRC_IN);
        $this$init_u24lambda_u2d3.setVisibility(4);
        colorStateList = this.buttonBackground;
        bl = false;
        bl2 = false;
        ColorStateList $this$init_u24lambda_u2d5 = colorStateList;
        boolean bl9 = false;
        $this$init_u24lambda_u2d5.setId(-1);
        $this$init_u24lambda_u2d5.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        $this$init_u24lambda_u2d5.setIcon(null);
        $this$init_u24lambda_u2d5.setTextColor(0);
        $this$init_u24lambda_u2d5.setVisibility(0);
        $this$init_u24lambda_u2d5.setOnTouchListener((arg_0, arg_1) -> ProgressButton.init$lambda-5$lambda-4(this, arg_0, arg_1));
        this.addView((View)this.buttonBackground);
        this.addView((View)this.buttonNormal);
        this.addView((View)this.buttonLoading);
        this.addView((View)this.progressBar);
        this.setVisibilityAndColors();
    }

    static /* synthetic */ void init$default(ProgressButton progressButton, AttributeSet attributeSet, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            attributeSet = null;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        progressButton.init(attributeSet, n);
    }

    @NotNull
    public final CharSequence getText() {
        CharSequence charSequence = this.buttonBackground.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"buttonBackground.text");
        return charSequence;
    }

    public final void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buttonNormal.setText(text);
        if (!this.isLoading) {
            this.buttonBackground.setText(text);
        }
    }

    public final void setText(@StringRes int textId) {
        String string2 = this.getContext().getString(textId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(textId)");
        this.setText(string2);
    }

    public final void setLoadingText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buttonLoading.setText(text);
        if (this.isLoading) {
            this.buttonBackground.setText(text);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.buttonBackground.setOnClickListener(l);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonBackground.setEnabled(enabled);
        this.buttonNormal.setEnabled(enabled);
        this.buttonLoading.setEnabled(enabled);
        this.progressBar.setEnabled(enabled);
    }

    public final void setIsLoading(boolean loading) {
        if (loading) {
            this.showLoading();
        } else {
            this.hideLoading();
        }
    }

    public final void showLoading() {
        if (!this.isLoading) {
            this.switchState();
        }
    }

    public final void hideLoading() {
        if (this.isLoading) {
            this.switchState();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void switchState() {
        void $this$switchState_u24lambda_u2d10_u24lambda_u2d9;
        Object $this$switchState_u24lambda_u2d10_u24lambda_u2d7;
        void $this$switchState_u24lambda_u2d10;
        AnimatorSet animatorSet = this.currentAnimation;
        if (animatorSet != null) {
            animatorSet.cancel();
        }
        float maxTranslation = this.getResources().getDimensionPixelSize(R.dimen.button_max_animation_translation);
        AnimatorSet animatorSet2 = new AnimatorSet();
        boolean bl = false;
        boolean bl2 = false;
        AnimatorSet animatorSet3 = animatorSet2;
        ProgressButton progressButton = this;
        boolean bl3 = false;
        Animator[] animatorArray = new Animator[4];
        animatorArray[0] = (Animator)this.getCurrentTextColorFadeAnim((TextView)this.buttonNormal, !this.isLoading());
        Object object = new float[]{0.0f, -maxTranslation};
        animatorArray[1] = (Animator)this.getTranslationYAnim((View)this.buttonNormal, this.reverseIfLoading((float[])object));
        object = this.getCurrentTextColorFadeAnim((TextView)this.buttonLoading, this.isLoading());
        boolean bl4 = false;
        boolean bl5 = false;
        Object object2 = object;
        int n = 2;
        Animator[] animatorArray2 = animatorArray;
        void var14_16 = $this$switchState_u24lambda_u2d10;
        boolean bl6 = false;
        $this$switchState_u24lambda_u2d10_u24lambda_u2d7.addUpdateListener(arg_0 -> ProgressButton.switchState$lambda-10$lambda-7$lambda-6(this, arg_0));
        Unit unit = Unit.INSTANCE;
        animatorArray2[n] = (Animator)object;
        object = new float[]{maxTranslation, 0.0f};
        object = this.getTranslationYAnim((View)this.buttonLoading, this.reverseIfLoading((float[])object));
        bl4 = false;
        bl5 = false;
        $this$switchState_u24lambda_u2d10_u24lambda_u2d7 = object;
        n = 3;
        animatorArray2 = animatorArray;
        boolean bl7 = false;
        $this$switchState_u24lambda_u2d10_u24lambda_u2d9.addUpdateListener(arg_0 -> ProgressButton.switchState$lambda-10$lambda-9$lambda-8(this, arg_0));
        unit = Unit.INSTANCE;
        animatorArray2[n] = (Animator)object;
        var14_16.playTogether(animatorArray);
        $this$switchState_u24lambda_u2d10.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
        $this$switchState_u24lambda_u2d10.setDuration(300L);
        $this$switchState_u24lambda_u2d10.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ ProgressButton this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationRepeat(@Nullable Animator animator) {
            }

            public void onAnimationEnd(@Nullable Animator animator) {
                ProgressButton.access$setVisibilityAndColors(this.this$0);
                if (!this.this$0.isLoading()) {
                    ProgressButton.access$getButtonBackground$p(this.this$0).setClickable(true);
                }
            }

            public void onAnimationCancel(@Nullable Animator animator) {
                Animator animator2 = animator;
                if (animator2 != null) {
                    animator2.end();
                }
            }

            public void onAnimationStart(@Nullable Animator animator) {
                CharSequence charSequence = ProgressButton.access$getButtonLoading$p(this.this$0).getText();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    ProgressButton.access$setProgressBarHorizontalPosition(this.this$0);
                }
                ProgressButton.access$setLoading$p(this.this$0, !this.this$0.isLoading());
                ProgressButton.access$getButtonNormal$p(this.this$0).setVisibility(0);
                ProgressButton.access$getButtonLoading$p(this.this$0).setVisibility(0);
                ProgressButton.access$getProgressBar$p(this.this$0).setVisibility(0);
                if (this.this$0.isLoading()) {
                    ProgressButton.access$getButtonBackground$p(this.this$0).setClickable(false);
                }
            }
        });
        Unit unit2 = Unit.INSTANCE;
        progressButton.currentAnimation = animatorSet2;
        animatorSet2 = this.currentAnimation;
        if (animatorSet2 != null) {
            animatorSet2.start();
        }
    }

    private final void setVisibilityAndColors() {
        this.buttonNormal.setVisibility(this.isLoading ? 4 : 0);
        this.buttonLoading.setVisibility(this.isLoading ? 0 : 4);
        this.progressBar.setVisibility(this.isLoading ? 0 : 4);
        this.buttonBackground.setText(this.isLoading ? this.buttonLoading.getText() : this.buttonNormal.getText());
        ColorStateList colorStateList = this.originalTextColors;
        if (colorStateList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            throw null;
        }
        this.buttonNormal.setTextColor(colorStateList);
        colorStateList = this.originalTextColors;
        if (colorStateList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            throw null;
        }
        this.buttonLoading.setTextColor(colorStateList);
        this.progressBar.setTranslationY(0.0f);
        colorStateList = this.originalTextColors;
        if (colorStateList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            throw null;
        }
        this.progressBar.setIndeterminateTintList(colorStateList);
    }

    private final void showTextOnly(MaterialButton $this$showTextOnly) {
        $this$showTextOnly.setBackground(null);
        $this$showTextOnly.setClickable(false);
        $this$showTextOnly.setFocusable(false);
        $this$showTextOnly.setStrokeWidth(0);
        $this$showTextOnly.setRippleColor(ColorStateList.valueOf((int)0));
        $this$showTextOnly.setImportantForAccessibility(2);
    }

    private final void setProgressBarHorizontalPosition() {
        Rect bounds = new Rect();
        this.buttonLoading.getPaint().getTextBounds(((Object)this.buttonLoading.getText()).toString(), 0, this.buttonLoading.getText().length(), bounds);
        float textWidth = (float)bounds.width() + (float)this.buttonLoading.getIconSize() + (float)this.buttonLoading.getIconPadding();
        this.progressBar.setX(((float)this.buttonLoading.getWidth() - textWidth) / (float)2);
    }

    private final ObjectAnimator getCurrentTextColorFadeAnim(TextView view, boolean out) {
        int color = this.getCurrentTextColor();
        int transparentColor = ColorUtils.setAlphaComponent((int)color, (int)0);
        int fromColor = out ? color : transparentColor;
        int toColor = out ? transparentColor : color;
        Object object = new int[]{fromColor, toColor};
        object = ObjectAnimator.ofInt((Object)view, (String)"textColor", (int[])object);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$getCurrentTextColorFadeAnim_u24lambda_u2d11 = object;
        boolean bl3 = false;
        $this$getCurrentTextColorFadeAnim_u24lambda_u2d11.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ofInt(view, \"textColor\", fromColor, toColor)\n            .apply {\n                setEvaluator(ArgbEvaluator())\n            }");
        return object2;
    }

    private final ObjectAnimator getTranslationYAnim(View view, float[] positions) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])Arrays.copyOf(positions, positions.length));
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(view, \"translationY\", *positions)");
        return objectAnimator;
    }

    private final PathInterpolator getCubicBezierInterpolator() {
        return new PathInterpolator(0.77f, 0.0f, 0.175f, 1.0f);
    }

    @ColorInt
    private final int getCurrentTextColor() {
        return this.isLoading ? this.buttonLoading.getCurrentTextColor() : this.buttonNormal.getCurrentTextColor();
    }

    private final float[] reverseIfLoading(float[] $this$reverseIfLoading) {
        return this.isLoading ? ArraysKt.reversedArray((float[])$this$reverseIfLoading) : $this$reverseIfLoading;
    }

    public void _$_clearFindViewByIdCache() {
    }

    private static final boolean init$lambda-5$lambda-4(ProgressButton this$0, View view, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int n = event.getAction();
        switch (n) {
            case 0: {
                this$0.buttonNormal.setPressed(true);
                this$0.buttonLoading.setPressed(true);
                break;
            }
            case 2: {
                boolean outsideBounds = event.getX() < 0.0f || event.getY() < 0.0f || event.getX() > (float)view.getMeasuredWidth() || event.getY() > (float)view.getMeasuredHeight();
                this$0.buttonNormal.setPressed(!outsideBounds);
                this$0.buttonLoading.setPressed(!outsideBounds);
                break;
            }
            case 1: 
            case 3: {
                this$0.buttonNormal.setPressed(false);
                this$0.buttonLoading.setPressed(false);
            }
        }
        return false;
    }

    private static final void switchState$lambda-10$lambda-7$lambda-6(ProgressButton this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.progressBar.setIndeterminateTintList(this$0.buttonLoading.getTextColors());
    }

    private static final void switchState$lambda-10$lambda-9$lambda-8(ProgressButton this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.progressBar.setTranslationY(this$0.buttonLoading.getTranslationY());
    }

    public static final /* synthetic */ void access$setVisibilityAndColors(ProgressButton $this) {
        $this.setVisibilityAndColors();
    }

    public static final /* synthetic */ MaterialButton access$getButtonBackground$p(ProgressButton $this) {
        return $this.buttonBackground;
    }

    public static final /* synthetic */ MaterialButton access$getButtonLoading$p(ProgressButton $this) {
        return $this.buttonLoading;
    }

    public static final /* synthetic */ void access$setProgressBarHorizontalPosition(ProgressButton $this) {
        $this.setProgressBarHorizontalPosition();
    }

    public static final /* synthetic */ void access$setLoading$p(ProgressButton $this, boolean bl) {
        $this.isLoading = bl;
    }

    public static final /* synthetic */ MaterialButton access$getButtonNormal$p(ProgressButton $this) {
        return $this.buttonNormal;
    }

    public static final /* synthetic */ ProgressBar access$getProgressBar$p(ProgressButton $this) {
        return $this.progressBar;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/button/ProgressButton$Companion;", "", "()V", "ANIMATION_DURATION", "", "NO_ID", "", "library_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

