/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.card.mediacard;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.card.CardView;
import com.telefonica.mistica.util.ViewUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=MediaCardView.class, attribute="mediaCardImageDrawable", method="setImageDrawable"), @BindingMethod(type=MediaCardView.class, attribute="cardPretitle", method="setPretitle"), @BindingMethod(type=MediaCardView.class, attribute="cardImageContentDescription", method="setCardImageContentDescription")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\nJ\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0014J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0013\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0017\u0010\u0017\u001a\u00020\u00122\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019J\u0017\u0010\u001e\u001a\u00020\u00122\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/telefonica/mistica/card/mediacard/MediaCardView;", "Lcom/telefonica/mistica/card/CardView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cardImageView", "Landroid/widget/ImageView;", "otherMediaLayout", "Landroid/widget/FrameLayout;", "getCardImageView", "handleAttrsAndInflateLayout", "Landroid/view/View;", "defStyleRes", "removeCardImageContentDescription", "", "setCardImage", "imageDrawable", "Landroid/graphics/drawable/Drawable;", "imageRes", "setCardImageContentDescription", "description", "", "textRes", "(Ljava/lang/Integer;)V", "setOtherMultimedia", "view", "setPretitle", "text", "com.telefonica.mistica"})
public final class MediaCardView
extends CardView {
    private ImageView cardImageView;
    private FrameLayout otherMediaLayout;

    @JvmOverloads
    public MediaCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    public /* synthetic */ MediaCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    @NotNull
    protected View handleAttrsAndInflateLayout(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.media_card_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.media_card_image);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.media_card_image)");
        this.cardImageView = (ImageView)view;
        view = this.findViewById(R.id.media_card_multimedia_container);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.media_card_multimedia_container)");
        this.otherMediaLayout = (FrameLayout)view;
        if (attrs != null) {
            Object object = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MediaCardView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.theme.obtainStyledAttributes(\n                    attrs,\n                    R.styleable.MediaCardView,\n                    defStyleAttr,\n                    0\n                )");
            TypedArray styledAttrs = object;
            this.setPretitle(styledAttrs.getText(R.styleable.MediaCardView_cardPretitle));
            this.setCardImageContentDescription(styledAttrs.getText(R.styleable.MediaCardView_cardImageContentDescription));
            Integer n = styledAttrs.getResourceId(R.styleable.MediaCardView_cardImage, 0);
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Integer n2 = object = it != 0 ? n : null;
            if (object != null) {
                Object object2 = object;
                bl2 = false;
                boolean bl4 = false;
                int it2 = ((Number)object2).intValue();
                boolean bl5 = false;
                n = AppCompatResources.getDrawable((Context)this.getContext(), (int)it2);
                if (n != null) {
                    object2 = n;
                    bl2 = false;
                    bl4 = false;
                    Object it3 = object2;
                    boolean bl6 = false;
                    this.setCardImage((Drawable)it3);
                }
            }
            styledAttrs.recycle();
        }
        Intrinsics.checkNotNullExpressionValue((Object)rootView, (String)"rootView");
        return rootView;
    }

    @NotNull
    public final ImageView getCardImageView() {
        ImageView imageView = this.cardImageView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        return imageView;
    }

    public final void setCardImage(@DrawableRes int imageRes) {
        FrameLayout frameLayout = this.otherMediaLayout;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"otherMediaLayout");
            throw null;
        }
        frameLayout.removeAllViews();
        frameLayout = this.cardImageView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        frameLayout.setImageResource(imageRes);
        frameLayout = this.cardImageView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        ViewUtilsKt.show((View)frameLayout);
    }

    public final void setCardImageContentDescription(@Nullable CharSequence description) {
        ImageView imageView = this.cardImageView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        imageView.setContentDescription(description);
    }

    public final void setCardImageContentDescription(@StringRes @Nullable Integer textRes) {
        Integer n = textRes;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.setCardImageContentDescription(this.getContext().getString(it));
        }
    }

    public final void removeCardImageContentDescription() {
        ImageView imageView = this.cardImageView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        imageView.setContentDescription(null);
    }

    public final void setCardImage(@NotNull Drawable imageDrawable) {
        Intrinsics.checkNotNullParameter((Object)imageDrawable, (String)"imageDrawable");
        FrameLayout frameLayout = this.otherMediaLayout;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"otherMediaLayout");
            throw null;
        }
        frameLayout.removeAllViews();
        frameLayout = this.cardImageView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        frameLayout.setImageDrawable(imageDrawable);
        frameLayout = this.cardImageView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        ViewUtilsKt.show((View)frameLayout);
    }

    public final void setOtherMultimedia(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ImageView imageView = this.cardImageView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardImageView");
            throw null;
        }
        ViewUtilsKt.hide((View)imageView);
        imageView = this.otherMediaLayout;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"otherMediaLayout");
            throw null;
        }
        imageView.addView(view);
    }

    public final void setPretitle(@Nullable CharSequence text) {
        CharSequence charSequence = text;
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence2;
            boolean bl3 = false;
            this.setPretitle(((Object)it).toString());
        }
    }

    public final void setPretitle(@StringRes @Nullable Integer textRes) {
        Integer n = textRes;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            String string2 = this.getContext().getString(it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(it)");
            this.setPretitle(string2);
        }
    }

    @Override
    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public MediaCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MediaCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

