/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.popover;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.telefonica.mistica.R;
import com.telefonica.mistica.feedback.popover.PopOverData;
import com.telefonica.mistica.feedback.popover.PopOverTheme;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00015B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0003J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\u001dH\u0007J\u0006\u0010&\u001a\u00020\u001dJ\b\u0010'\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001aH\u0007J\b\u0010.\u001a\u00020\u001dH\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u00102\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nJ\u001d\u00103\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b4R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/telefonica/mistica/feedback/popover/PopOverView;", "Landroid/widget/RelativeLayout;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dimensionsKnown", "", "listener", "Lcom/telefonica/mistica/feedback/popover/PopOverView$PopOverClickListener;", "popOverBottomTip", "Landroid/view/View;", "popOverCloseButton", "Landroid/widget/ImageView;", "popOverContent", "Landroid/view/ViewGroup;", "popOverData", "Lcom/telefonica/mistica/feedback/popover/PopOverData;", "popOverDescription", "Landroid/widget/TextView;", "popOverImage", "popOverTitle", "popOverTopTip", "targetView", "targetViewRelativeX", "", "targetViewRelativeY", "applyPopOverTipPosition", "", "applyTheme", "theme", "Lcom/telefonica/mistica/feedback/popover/PopOverTheme;", "init", "onClick", "view", "onPreDraw", "remove", "removeWithoutAnimation", "setCloseButton", "setDescription", "setImage", "setMargin", "setMaxWidth", "setPointerCenterX", "pointerCenterX", "setShadow", "setTipMargin", "tipMargin", "setTitle", "setToolTipListener", "setUpToolTip", "setUpToolTip$com_telefonica_mistica", "PopOverClickListener", "com.telefonica.mistica"})
public class PopOverView
extends RelativeLayout
implements ViewTreeObserver.OnPreDrawListener,
View.OnClickListener {
    private ViewGroup popOverContent;
    private View popOverTopTip;
    private TextView popOverTitle;
    private ImageView popOverImage;
    private TextView popOverDescription;
    private View popOverBottomTip;
    private ImageView popOverCloseButton;
    @Nullable
    private PopOverData popOverData;
    private View targetView;
    private boolean dimensionsKnown;
    private int targetViewRelativeY;
    private int targetViewRelativeX;
    @Nullable
    private PopOverClickListener listener;

    public PopOverView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init();
    }

    private final void init() {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.popover_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.popover_content);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_content)");
        this.popOverContent = (ViewGroup)view;
        view = this.findViewById(R.id.popover_pointer_up);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_pointer_up)");
        this.popOverTopTip = view;
        view = this.findViewById(R.id.popover_title);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_title)");
        this.popOverTitle = (TextView)view;
        view = this.findViewById(R.id.popover_image);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_image)");
        this.popOverImage = (ImageView)view;
        view = this.findViewById(R.id.popover_subtitle);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_subtitle)");
        this.popOverDescription = (TextView)view;
        view = this.findViewById(R.id.popover_pointer_down);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.popover_pointer_down)");
        this.popOverBottomTip = view;
        view = this.findViewById(R.id.close_button);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.close_button)");
        this.popOverCloseButton = (ImageView)view;
        this.setOnClickListener(this);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public boolean onPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.dimensionsKnown = true;
        if (this.popOverData != null) {
            this.applyPopOverTipPosition();
        }
        return true;
    }

    public final void setUpToolTip$com_telefonica_mistica(@NotNull PopOverData popOverData, @NotNull View targetView) {
        Intrinsics.checkNotNullParameter((Object)popOverData, (String)"popOverData");
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        this.popOverData = popOverData;
        this.targetView = targetView;
        this.setTitle(popOverData);
        this.setImage(popOverData);
        this.setDescription(popOverData);
        this.setCloseButton();
        this.setMaxWidth(popOverData);
        this.applyTheme(popOverData.getTheme());
        this.setTipMargin(popOverData.getExtraMarginForTip());
        this.setMargin(popOverData);
        this.setContentDescription(popOverData.getDismissButtonContentDescription());
        this.setShadow();
        if (this.dimensionsKnown) {
            this.applyPopOverTipPosition();
        }
    }

    private final void setTipMargin(int tipMargin) {
        if (tipMargin != 0) {
            View view;
            View view2;
            ViewGroup.LayoutParams layoutParams;
            View view3;
            View view4 = this.popOverTopTip;
            if (view4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
                view3 = null;
            } else {
                view3 = view4;
            }
            ViewGroup.LayoutParams layoutParams2 = view3.getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams paramsTop = (RelativeLayout.LayoutParams)layoutParams2;
            paramsTop.setMargins(MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), tipMargin, MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_vertical)));
            layoutParams2 = this.popOverTopTip;
            if (layoutParams2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
                layoutParams = null;
            } else {
                layoutParams = layoutParams2;
            }
            layoutParams.setLayoutParams((ViewGroup.LayoutParams)paramsTop);
            View view5 = this.popOverBottomTip;
            if (view5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
                view2 = null;
            } else {
                view2 = view5;
            }
            view4 = view2.getLayoutParams();
            if (view4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams paramsBottom = (RelativeLayout.LayoutParams)view4;
            paramsBottom.setMargins(MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_vertical)), MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.popover_arrow_margin_horizontal)), tipMargin);
            view4 = this.popOverBottomTip;
            if (view4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
                view = null;
            } else {
                view = view4;
            }
            view.setLayoutParams((ViewGroup.LayoutParams)paramsBottom);
        }
    }

    private final void setMargin(PopOverData popOverData) {
        int margin = popOverData.getMargin();
        if (margin > 0) {
            this.setPadding(margin, 0, margin, 0);
        }
    }

    private final void setCloseButton() {
        ImageView imageView;
        ImageView imageView2;
        ImageView imageView3 = this.popOverCloseButton;
        if (imageView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            imageView2 = null;
        } else {
            imageView2 = imageView3;
        }
        imageView2.setVisibility(0);
        imageView3 = this.popOverCloseButton;
        if (imageView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            imageView = null;
        } else {
            imageView = imageView3;
        }
        imageView.setOnClickListener(arg_0 -> PopOverView.setCloseButton$lambda-0(this, arg_0));
    }

    private final void setTitle(PopOverData popOverData) {
        CharSequence charSequence = popOverData.getTitle();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            CharSequence charSequence2;
            CharSequence charSequence3;
            charSequence = this.popOverTitle;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                charSequence3 = null;
            } else {
                charSequence3 = charSequence;
            }
            charSequence3.setText(popOverData.getTitle());
            charSequence = this.popOverTitle;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                charSequence2 = null;
            } else {
                charSequence2 = charSequence;
            }
            charSequence2.setVisibility(0);
        } else {
            CharSequence charSequence4;
            charSequence = this.popOverTitle;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                charSequence4 = null;
            } else {
                charSequence4 = charSequence;
            }
            charSequence4.setVisibility(8);
        }
    }

    private final void setImage(PopOverData popOverData) {
        if (popOverData.getImageRes() != null) {
            ImageView imageView;
            ImageView imageView2;
            ImageView imageView3 = this.popOverImage;
            if (imageView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView2 = null;
            } else {
                imageView2 = imageView3;
            }
            imageView2.setImageResource(popOverData.getImageRes().intValue());
            imageView3 = this.popOverImage;
            if (imageView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView = null;
            } else {
                imageView = imageView3;
            }
            imageView.setVisibility(0);
        } else {
            ImageView imageView;
            ImageView imageView4 = this.popOverImage;
            if (imageView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverImage");
                imageView = null;
            } else {
                imageView = imageView4;
            }
            imageView.setVisibility(8);
        }
    }

    private final void setDescription(PopOverData popOverData) {
        if (popOverData.getDescription() != null) {
            TextView textView;
            TextView textView2;
            TextView textView3 = this.popOverDescription;
            if (textView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView2 = null;
            } else {
                textView2 = textView3;
            }
            textView2.setText((CharSequence)popOverData.getDescription());
            textView3 = this.popOverDescription;
            if (textView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView = null;
            } else {
                textView = textView3;
            }
            textView.setVisibility(0);
        } else {
            TextView textView;
            TextView textView4 = this.popOverDescription;
            if (textView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverDescription");
                textView = null;
            } else {
                textView = textView4;
            }
            textView.setVisibility(8);
        }
    }

    private final void setMaxWidth(PopOverData popOverData) {
        if (popOverData.getMaxWidth() > 0) {
            TextView textView;
            TextView textView2 = this.popOverTitle;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
                textView = null;
            } else {
                textView = textView2;
            }
            textView.setMaxWidth(popOverData.getMaxWidth());
        }
    }

    private final void setShadow() {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewGroup viewGroup;
            ViewGroup viewGroup2;
            ViewGroup viewGroup3;
            ViewGroup viewGroup4 = this.popOverContent;
            if (viewGroup4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverContent");
                viewGroup3 = null;
            } else {
                viewGroup3 = viewGroup4;
            }
            viewGroup3.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
            viewGroup4 = this.popOverBottomTip;
            if (viewGroup4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
                viewGroup2 = null;
            } else {
                viewGroup2 = viewGroup4;
            }
            viewGroup2.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
            viewGroup4 = this.popOverTopTip;
            if (viewGroup4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
                viewGroup = null;
            } else {
                viewGroup = viewGroup4;
            }
            viewGroup.setElevation(this.getResources().getDimension(R.dimen.popover_elevation));
        }
    }

    private final void applyTheme(PopOverTheme theme) {
        View view;
        View view2;
        View view3;
        View view4;
        View view5 = this.popOverTopTip;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view4 = null;
        } else {
            view4 = view5;
        }
        view4.setBackgroundResource(theme.getTopTip());
        view5 = this.popOverBottomTip;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view3 = null;
        } else {
            view3 = view5;
        }
        view3.setBackgroundResource(theme.getBottomTip());
        view5 = this.popOverTitle;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTitle");
            view2 = null;
        } else {
            view2 = view5;
        }
        view5 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"context");
        view2.setTextColor(ColorUtilsKt.getThemeColor((Context)view5, theme.getTextColor()));
        view5 = this.popOverCloseButton;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverCloseButton");
            view = null;
        } else {
            view = view5;
        }
        view.setImageResource(theme.getCloseButton());
    }

    @SuppressLint(value={"NewApi"})
    private final void applyPopOverTipPosition() {
        long l;
        Object object;
        View view;
        View view2;
        View view3;
        View view4;
        View view5;
        View view6;
        int[] targetViewScreenPosition = new int[2];
        int[] parentViewScreenPosition = new int[2];
        Rect availableVisibleArea = new Rect();
        View view7 = this.targetView;
        if (view7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view6 = null;
        } else {
            view6 = view7;
        }
        view6.getLocationOnScreen(targetViewScreenPosition);
        view7 = this.targetView;
        if (view7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view5 = null;
        } else {
            view5 = view7;
        }
        view5.getWindowVisibleDisplayFrame(availableVisibleArea);
        view7 = this.getParent();
        if (view7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        view7.getLocationOnScreen(parentViewScreenPosition);
        this.targetViewRelativeX = targetViewScreenPosition[0] - parentViewScreenPosition[0];
        this.targetViewRelativeY = targetViewScreenPosition[1] - parentViewScreenPosition[1];
        View view8 = this.targetView;
        if (view8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view4 = null;
        } else {
            view4 = view8;
        }
        int targetViewRelativeCenterX = this.targetViewRelativeX + view4.getWidth() / 2;
        float popOverViewAboveY = this.targetViewRelativeY - this.getHeight();
        View view9 = this.targetView;
        if (view9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
            view3 = null;
        } else {
            view3 = view9;
        }
        float popOverViewBelowY = this.targetViewRelativeY + view3.getHeight();
        float popOverViewY = 0.0f;
        int n = 0;
        int n2 = targetViewRelativeCenterX - this.getWidth() / 2;
        boolean bl = false;
        float popOverViewX = Math.max(n, n2);
        if (popOverViewX + (float)this.getWidth() > (float)availableVisibleArea.right) {
            popOverViewX = availableVisibleArea.right - this.getWidth();
        }
        this.setX(popOverViewX);
        this.setPointerCenterX(targetViewRelativeCenterX);
        boolean showBelow = popOverViewAboveY < 0.0f;
        View view10 = this.popOverTopTip;
        if (view10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view2 = null;
        } else {
            view2 = view10;
        }
        view2.setVisibility(showBelow ? 0 : 8);
        view10 = this.popOverBottomTip;
        if (view10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view = null;
        } else {
            view = view10;
        }
        view.setVisibility(showBelow ? 8 : 0);
        popOverViewY = showBelow ? popOverViewBelowY : popOverViewAboveY;
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        Object object2 = this.popOverData;
        if (object2 == null ? false : ((PopOverData)object2).getAnimationType() == 101) {
            View view11;
            View view12;
            object2 = new float[2];
            object = this.targetView;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view12 = null;
            } else {
                view12 = object;
            }
            object2[0] = (float)(this.targetViewRelativeY + view12.getHeight() / 2 - this.getHeight() / 2);
            object2[1] = popOverViewY;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])object2));
            object2 = new float[2];
            object = this.targetView;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view11 = null;
            } else {
                view11 = object;
            }
            object2[0] = (float)(this.targetViewRelativeX + view11.getWidth() / 2 - this.getWidth() / 2);
            object2[1] = popOverViewX;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_X, (float[])object2));
        } else {
            object2 = this.popOverData;
            if (object2 == null ? false : ((PopOverData)object2).getAnimationType() == 102) {
                object2 = new float[2];
                object2[0] = 0.0f;
                object2[1] = popOverViewY;
                animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])object2));
            }
        }
        object2 = new float[2];
        object2[0] = 0.0f;
        object2[1] = 1.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_X, (float[])object2));
        object2 = new float[2];
        object2[0] = 0.0f;
        object2[1] = 1.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_Y, (float[])object2));
        object2 = new float[2];
        object2[0] = 0.0f;
        object2[1] = 1.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.ALPHA, (float[])object2));
        AnimatorSet animatorSet = new AnimatorSet();
        object = this.popOverData;
        animatorSet.setDuration(object == null ? 0L : (l = ((PopOverData)object).getAnimationDuration()));
        animatorSet.playTogether((Collection)animators);
        animatorSet.start();
    }

    @SuppressLint(value={"NewApi"})
    public final void setPointerCenterX(int pointerCenterX) {
        View view;
        View view2;
        View view3;
        View view4;
        View view5 = this.popOverTopTip;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view4 = null;
        } else {
            view4 = view5;
        }
        int n = view4.getMeasuredWidth();
        View view6 = this.popOverBottomTip;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view3 = null;
        } else {
            view3 = view6;
        }
        int n2 = view3.getMeasuredWidth();
        boolean bl = false;
        int pointerWidth = Math.max(n, n2);
        View view7 = this.popOverTopTip;
        if (view7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverTopTip");
            view2 = null;
        } else {
            view2 = view7;
        }
        view2.setX((float)pointerCenterX - (float)(pointerWidth / 2) - this.getX());
        view7 = this.popOverBottomTip;
        if (view7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popOverBottomTip");
            view = null;
        } else {
            view = view7;
        }
        view.setX((float)pointerCenterX - (float)(pointerWidth / 2) - this.getX());
    }

    public final void setToolTipListener(@NotNull PopOverClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @SuppressLint(value={"NewApi"})
    public final void remove() {
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        Object object = this.popOverData;
        if (object == null ? false : ((PopOverData)object).getAnimationType() == 101) {
            View view;
            View view2;
            object = new float[2];
            object[0] = this.getY();
            View view3 = this.targetView;
            if (view3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view2 = null;
            } else {
                view2 = view3;
            }
            object[1] = (float)(this.targetViewRelativeY + view2.getHeight() / 2 - this.getHeight() / 2);
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])object));
            object = new float[2];
            object[0] = this.getX();
            view3 = this.targetView;
            if (view3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetView");
                view = null;
            } else {
                view = view3;
            }
            object[1] = (float)(this.targetViewRelativeX + view.getWidth() / 2 - this.getWidth() / 2);
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_X, (float[])object));
        } else {
            object = new float[2];
            object[0] = this.getY();
            object[1] = 0.0f;
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.TRANSLATION_Y, (float[])object));
        }
        object = new float[2];
        object[0] = 1.0f;
        object[1] = 0.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_X, (float[])object));
        object = new float[2];
        object[0] = 1.0f;
        object[1] = 0.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_Y, (float[])object));
        object = new float[2];
        object[0] = 1.0f;
        object[1] = 0.0f;
        animators.add(ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.ALPHA, (float[])object));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether((Collection)animators);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ PopOverView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                this.this$0.removeWithoutAnimation();
            }
        });
        animatorSet.start();
    }

    public final void removeWithoutAnimation() {
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        View container = (View)viewParent;
        ViewParent viewParent2 = container.getParent();
        ViewGroup containerParent = viewParent2 instanceof ViewGroup ? (ViewGroup)viewParent2 : null;
        viewParent2 = containerParent;
        if (viewParent2 != null) {
            viewParent2.removeView(container);
        }
    }

    public void onClick(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        PopOverClickListener popOverClickListener = this.listener;
        if (popOverClickListener != null) {
            popOverClickListener.onPopOverViewClicked(this);
        }
    }

    public void _$_clearFindViewByIdCache() {
    }

    private static final void setCloseButton$lambda-0(PopOverView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PopOverClickListener popOverClickListener = this$0.listener;
        if (popOverClickListener != null) {
            popOverClickListener.onCloseClicked(this$0);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/feedback/popover/PopOverView$PopOverClickListener;", "", "onCloseClicked", "", "popOverView", "Lcom/telefonica/mistica/feedback/popover/PopOverView;", "onPopOverViewClicked", "com.telefonica.mistica"})
    public static interface PopOverClickListener {
        public void onPopOverViewClicked(@NotNull PopOverView var1);

        public void onCloseClicked(@NotNull PopOverView var1);
    }
}

