/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.StringRes;
import com.google.android.material.snackbar.Snackbar;
import com.telefonica.mistica.R;
import com.telefonica.mistica.feedback.SnackBarBehaviorConfig;
import com.telefonica.mistica.util.ColorUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0005H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u001c\u0010\u001c\u001a\u00020\u00002\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/telefonica/mistica/feedback/SnackbarBuilder;", "", "view", "Landroid/view/View;", "resId", "", "(Landroid/view/View;I)V", "text", "", "(Landroid/view/View;Ljava/lang/String;)V", "actionListener", "Landroid/view/View$OnClickListener;", "actionText", "callback", "Lcom/google/android/material/snackbar/Snackbar$Callback;", "", "createSnackbar", "Lcom/google/android/material/snackbar/Snackbar;", "getSpannable", "Landroid/text/Spannable;", "colorRes", "setActionTextColor", "", "snackbar", "setBackgroundColor", "setTextStyles", "showCritical", "showInformative", "withAction", "listener", "withCallback", "Companion", "com.telefonica.mistica"})
public class SnackbarBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View view;
    @NotNull
    private final CharSequence text;
    @Nullable
    private String actionText;
    @Nullable
    private View.OnClickListener actionListener;
    @Nullable
    private Snackbar.Callback callback;
    private static final int DURATION_WITH_ACTION = 10000;
    private static final int DURATION_WITHOUT_ACTION = 5000;
    private static final int MAX_TEXT_LINES = 4;

    public SnackbarBuilder(@Nullable View view, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl = false;
        boolean bl2 = false;
        if (view == null) {
            boolean bl3 = false;
            String string2 = "View cannot be null";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.text = text;
        this.view = view;
    }

    public SnackbarBuilder(@NotNull View view, @StringRes int resId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = view.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.resources.getString(resId)");
        this(view, string2);
    }

    @NotNull
    public SnackbarBuilder withAction(@NotNull String text, @Nullable View.OnClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SnackbarBuilder snackbarBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        SnackbarBuilder $this$withAction_u24lambda_u2d1 = snackbarBuilder;
        boolean bl3 = false;
        $this$withAction_u24lambda_u2d1.actionText = text;
        $this$withAction_u24lambda_u2d1.actionListener = listener;
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder withAction(@StringRes int resId, @Nullable View.OnClickListener listener) {
        String string2 = this.view.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.resources.getString(resId)");
        return this.withAction(string2, listener);
    }

    @NotNull
    public SnackbarBuilder withCallback(@NotNull Snackbar.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SnackbarBuilder snackbarBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        SnackbarBuilder $this$withCallback_u24lambda_u2d2 = snackbarBuilder;
        boolean bl3 = false;
        $this$withCallback_u24lambda_u2d2.callback = callback;
        return snackbarBuilder;
    }

    @NotNull
    public Snackbar showInformative() {
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackInfoBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextLinkSnackbar);
        snackbar.show();
        return snackbar;
    }

    @NotNull
    public Snackbar showCritical() {
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackErrorBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextPrimaryInverse);
        snackbar.show();
        return snackbar;
    }

    private final void setActionTextColor(Snackbar snackbar, @AttrRes int colorRes) {
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        snackbar.setActionTextColor(ColorUtilsKt.getThemeColor(context, colorRes));
    }

    private final void setBackgroundColor(Snackbar snackbar, @AttrRes int colorRes) {
        View view = snackbar.getView();
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        view.setBackgroundTintList(ColorStateList.valueOf((int)ColorUtilsKt.getThemeColor(context, colorRes)));
    }

    private final Spannable getSpannable(@AttrRes int colorRes) {
        Spannable spannable = (Spannable)new SpannableString(this.text);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ColorUtilsKt.getThemeColor(context, colorRes));
        spannable.setSpan((Object)foregroundColorSpan, 0, spannable.length(), 33);
        return spannable;
    }

    private final Snackbar createSnackbar(CharSequence text) {
        int duration = -2;
        if (!SnackBarBehaviorConfig.areSticky()) {
            duration = this.actionText != null ? 10000 : 5000;
        }
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)text, (int)duration);
        Intrinsics.checkNotNullExpressionValue((Object)snackbar, (String)"make(view, text, duration)");
        Snackbar snackbar2 = snackbar;
        this.setTextStyles(snackbar2);
        if (this.actionText != null) {
            snackbar2.setAction((CharSequence)this.actionText, this.actionListener);
        }
        if (this.callback != null) {
            snackbar2.setCallback(this.callback);
        }
        return snackbar2;
    }

    private final void setTextStyles(Snackbar snackbar) {
        TextView text = (TextView)snackbar.getView().findViewById(R.id.snackbar_text);
        text.setMaxLines(4);
        text.setTextAppearance(text.getContext(), R.style.AppTheme_TextAppearance_Preset2);
        TextView action = (TextView)snackbar.getView().findViewById(R.id.snackbar_action);
        action.setTextAppearance(action.getContext(), R.style.AppTheme_TextAppearance_Preset3_Medium);
        action.setAllCaps(false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/feedback/SnackbarBuilder$Companion;", "", "()V", "DURATION_WITHOUT_ACTION", "", "DURATION_WITH_ACTION", "MAX_TEXT_LINES", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

