/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.input;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.provider.Settings;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;
import androidx.databinding.adapters.ListenerUtil;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.telefonica.mistica.R;
import com.telefonica.mistica.input.Input;
import com.telefonica.mistica.input.validations.NoValidation;
import com.telefonica.mistica.input.validations.TextInputValidation;
import com.telefonica.mistica.input.validations.TextInputValidationResult;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=TextInput.class, attribute="inputCounterEnabled", method="setCounterEnabled"), @BindingMethod(type=TextInput.class, attribute="inputMaxLength", method="setMaxLength"), @BindingMethod(type=TextInput.class, attribute="inputAutofillEnabled", method="setAutofillEnabled"), @BindingMethod(type=TextInput.class, attribute="inputText", method="setText")})
@InverseBindingMethods(value={@InverseBindingMethod(type=TextInput.class, attribute="inputText", method="getText")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 82\u00020\u0001:\u000289B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\"\u0010 \u001a\u00020!2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0006\u0010\"\u001a\u00020#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0007J\u0010\u00100\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0007H\u0002J\u000e\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0007J\u000e\u00106\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/telefonica/mistica/input/TextInput;", "Lcom/telefonica/mistica/input/Input;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "editTextView", "Lcom/google/android/material/textfield/TextInputEditText;", "value", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "type", "getType$annotations", "()V", "validation", "Lcom/telefonica/mistica/input/validations/TextInputValidation;", "addTextChangedListener", "", "watcher", "Landroid/text/TextWatcher;", "clear", "configureAutoFill", "configureEditTextPaddingTop", "configureErrorResetOnTextChange", "handleAttrsAndInflateLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "isValid", "Lcom/telefonica/mistica/input/validations/TextInputValidationResult;", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "removeTextChangedListener", "setAutofillEnabled", "enabled", "", "setCounterEnabled", "setEnabled", "setMaxLength", "maxLength", "setMaxTextLength", "setOnEditorActionListener", "l", "Landroid/widget/TextView$OnEditorActionListener;", "setTopTextPadding", "padding", "setValidation", "validate", "Companion", "TextInputType", "com.telefonica.mistica"})
public final class TextInput
extends Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int type;
    private TextInputEditText editTextView;
    @NotNull
    private TextInputValidation validation;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_EMAIL = 1;
    public static final int TYPE_PASSWORD = 2;
    public static final int TYPE_TEXT_AREA = 3;
    public static final int TYPE_PHONE = 4;
    public static final int NO_MAX_LENGTH = 0;

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.validation = new NoValidation();
    }

    public /* synthetic */ TextInput(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @Nullable
    public final String getText() {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        return String.valueOf(textInputEditText.getText());
    }

    public final void setText(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.getText())) {
            TextInputEditText textInputEditText;
            TextInputEditText textInputEditText2 = this.editTextView;
            if (textInputEditText2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                textInputEditText = null;
            } else {
                textInputEditText = textInputEditText2;
            }
            textInputEditText.setText((CharSequence)value);
        }
    }

    private static /* synthetic */ void getType$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextInputLayout handleAttrsAndInflateLayout(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int n;
        String initialText = null;
        boolean initialCounterEnabled = false;
        int initialMaxLength = 0;
        boolean initialAutofillEnabled = true;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TextInput, defStyleAttr, defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026defStyleRes\n            )");
            TypedArray styledAttrs = typedArray;
            try {
                this.type = styledAttrs.getInt(R.styleable.TextInput_inputType, 0);
                initialText = styledAttrs.getString(R.styleable.TextInput_inputText);
                initialCounterEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputCounterEnabled, false);
                initialMaxLength = styledAttrs.getInt(R.styleable.TextInput_inputMaxLength, 0);
                initialAutofillEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputAutofillEnabled, true);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        int n2 = this.type;
        switch (n2) {
            case 1: {
                n = R.layout.input_text_email;
                break;
            }
            case 2: {
                n = R.layout.input_text_password;
                break;
            }
            case 3: {
                n = R.layout.input_text_area;
                break;
            }
            case 4: {
                n = R.layout.input_text_phone;
                break;
            }
            default: {
                n = R.layout.input_text;
            }
        }
        int layout2 = n;
        LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this, true);
        View view = this.findViewById(R.id.text_input);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.text_input)");
        this.editTextView = (TextInputEditText)view;
        this.setMaxTextLength(initialMaxLength);
        this.setText(initialText);
        this.configureAutoFill();
        this.setAutofillEnabled(initialAutofillEnabled);
        this.configureErrorResetOnTextChange();
        this.configureEditTextPaddingTop();
        View view2 = this.findViewById(R.id.text_input_layout);
        boolean bl = false;
        boolean bl2 = false;
        TextInputLayout $this$handleAttrsAndInflateLayout_u24lambda_u2d0 = (TextInputLayout)view2;
        boolean bl3 = false;
        $this$handleAttrsAndInflateLayout_u24lambda_u2d0.setCounterEnabled(initialCounterEnabled);
        $this$handleAttrsAndInflateLayout_u24lambda_u2d0.setCounterMaxLength(initialMaxLength);
        view = view2;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById<TextInputLa\u2026nitialMaxLength\n        }");
        return (TextInputLayout)view;
    }

    public final void clear() {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        Editable editable = textInputEditText.getText();
        if (editable != null) {
            editable.clear();
        }
    }

    public final void setCounterEnabled(boolean enabled) {
        this.getLayoutView().setCounterEnabled(enabled);
    }

    public final void setMaxLength(int maxLength) {
        this.getLayoutView().setCounterMaxLength(maxLength);
        this.setMaxTextLength(maxLength);
    }

    public final void setAutofillEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 26) {
            TextInputEditText textInputEditText;
            TextInputEditText textInputEditText2 = this.editTextView;
            if (textInputEditText2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                textInputEditText = null;
            } else {
                textInputEditText = textInputEditText2;
            }
            textInputEditText.setImportantForAutofill(enabled ? 0 : 2);
        }
    }

    public final void addTextChangedListener(@NotNull TextWatcher watcher) {
        TextInputEditText textInputEditText;
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        textInputEditText.addTextChangedListener(watcher);
    }

    public final void removeTextChangedListener(@NotNull TextWatcher watcher) {
        TextInputEditText textInputEditText;
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        textInputEditText.removeTextChangedListener(watcher);
    }

    public final void setTopTextPadding(int padding) {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2;
        TextInputEditText textInputEditText3;
        TextInputEditText textInputEditText4;
        TextInputEditText textInputEditText5 = this.editTextView;
        if (textInputEditText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText4 = null;
        } else {
            textInputEditText4 = textInputEditText5;
        }
        textInputEditText5 = this.editTextView;
        if (textInputEditText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText3 = null;
        } else {
            textInputEditText3 = textInputEditText5;
        }
        int n = textInputEditText3.getPaddingLeft();
        textInputEditText5 = this.editTextView;
        if (textInputEditText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        } else {
            textInputEditText2 = textInputEditText5;
        }
        int n2 = textInputEditText2.getPaddingRight();
        textInputEditText5 = this.editTextView;
        if (textInputEditText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText5;
        }
        textInputEditText4.setPadding(n, padding, n2, textInputEditText.getPaddingBottom());
    }

    public final void setOnEditorActionListener(@NotNull TextView.OnEditorActionListener l) {
        TextInputEditText textInputEditText;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        textInputEditText.setOnEditorActionListener(l);
    }

    public final void setValidation(@NotNull TextInputValidation validation) {
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        this.validation = validation;
    }

    @NotNull
    public final TextInputValidationResult isValid() {
        return this.validation.isValid(this.getText());
    }

    public final void validate() {
        TextInputValidationResult result = this.isValid();
        if (Intrinsics.areEqual((Object)result, (Object)TextInputValidationResult.Success.INSTANCE)) {
            this.setErrorEnabled(false);
        } else if (result instanceof TextInputValidationResult.Invalid) {
            this.setError(((TextInputValidationResult.Invalid)result).getInvalidMessage());
            this.setErrorEnabled(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        TextInputEditText textInputEditText;
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        return textInputEditText.onCreateInputConnection(outAttrs);
    }

    private final void configureAutoFill() {
        if (Build.VERSION.SDK_INT >= 26) {
            String hint;
            String string2;
            int n = this.type;
            switch (n) {
                case 1: {
                    string2 = "emailAddress";
                    break;
                }
                case 2: {
                    string2 = "password";
                    break;
                }
                case 4: {
                    string2 = "phone";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            String string3 = hint = string2;
            if (string3 != null) {
                String[] stringArray;
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                String[] stringArray2 = this.editTextView;
                if (stringArray2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                    stringArray = null;
                } else {
                    stringArray = stringArray2;
                }
                stringArray2 = new String[]{it};
                stringArray.setAutofillHints(stringArray2);
            }
        }
    }

    private final void configureErrorResetOnTextChange() {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        textInputEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ TextInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterTextChanged(@Nullable Editable s) {
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.setErrorEnabled(false);
            }
        });
    }

    private final void configureEditTextPaddingTop() {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2;
        float fontScale = Settings.System.getFloat((ContentResolver)this.getContext().getContentResolver(), (String)"font_scale", (float)1.0f);
        TextInputEditText textInputEditText3 = this.editTextView;
        if (textInputEditText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        } else {
            textInputEditText2 = textInputEditText3;
        }
        View view = (View)textInputEditText2;
        textInputEditText3 = this.editTextView;
        if (textInputEditText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText3;
        }
        ViewUtilsKt.padding$default(view, 0, (int)((float)textInputEditText.getPaddingTop() * fontScale), 0, 0, 13, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaxTextLength(int maxLength) {
        TextInputEditText textInputEditText;
        void $this$filterNotTo$iv$iv;
        TextInputEditText textInputEditText2;
        TextInputEditText textInputEditText3 = this.editTextView;
        if (textInputEditText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        } else {
            textInputEditText2 = textInputEditText3;
        }
        Object object = textInputEditText2.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"editTextView.filters");
        Object[] $this$filterNot$iv = object;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            InputFilter it = (InputFilter)element$iv$iv;
            boolean bl = false;
            if (it instanceof InputFilter.LengthFilter) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        object = maxLength != 0 ? CollectionsKt.plus((Collection)((Collection)it), (Object)new InputFilter.LengthFilter(maxLength)) : it;
        bl = false;
        bl2 = false;
        it = object;
        boolean bl4 = false;
        TextInputEditText textInputEditText4 = this.editTextView;
        if (textInputEditText4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText4;
        }
        Collection $this$toTypedArray$iv = (Collection)it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        InputFilter[] inputFilterArray = thisCollection$iv.toArray(new InputFilter[0]);
        if (inputFilterArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        textInputEditText.setFilters(inputFilterArray);
    }

    @Override
    public void setEnabled(boolean enabled) {
        TextInputEditText textInputEditText;
        super.setEnabled(enabled);
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        } else {
            textInputEditText = textInputEditText2;
        }
        textInputEditText.setEnabled(enabled);
    }

    @Override
    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    @BindingAdapter(value={"inputTextAttrChanged"})
    @JvmStatic
    public static final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener) {
        Companion.setTextWatcher(input, listener);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/input/TextInput$TextInputType;", "", "com.telefonica.mistica"})
    public static @interface TextInputType {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/telefonica/mistica/input/TextInput$Companion;", "", "()V", "NO_MAX_LENGTH", "", "TYPE_EMAIL", "TYPE_PASSWORD", "TYPE_PHONE", "TYPE_TEXT", "TYPE_TEXT_AREA", "setTextWatcher", "", "input", "Lcom/telefonica/mistica/input/TextInput;", "listener", "Landroidx/databinding/InverseBindingListener;", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        @BindingAdapter(value={"inputTextAttrChanged"})
        @JvmStatic
        public final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener) {
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TextWatcher textWatcher2 = new TextWatcher(listener){
                final /* synthetic */ InverseBindingListener $listener;
                {
                    this.$listener = $listener;
                }

                public void afterTextChanged(@Nullable Editable s) {
                    this.$listener.onChange();
                }

                public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                }
            };
            TextWatcher oldTextWatcher = (TextWatcher)ListenerUtil.trackListener((View)((View)input), (Object)textWatcher2, (int)R.id.textWatcher);
            if (oldTextWatcher != null) {
                input.removeTextChangedListener(oldTextWatcher);
            }
            input.addTextChangedListener(textWatcher2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

