/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.tag;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textview.MaterialTextView;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0007J\u001c\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001b*\u00020\u0007H\u0002R\u0014\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/telefonica/mistica/tag/TagView;", "Lcom/google/android/material/textview/MaterialTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentStyle", "getCurrentStyle$annotations", "()V", "setTagIcon", "", "drawable", "Landroid/graphics/drawable/Drawable;", "setTagStyle", "style", "icon", "setText", "text", "", "type", "Landroid/widget/TextView$BufferType;", "captitalizeFirstChar", "", "getStyle", "Lkotlin/Pair;", "Companion", "com.telefonica.mistica"})
public final class TagView
extends MaterialTextView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentStyle;
    public static final int TYPE_PROMO = 0;
    public static final int TYPE_ACTIVE = 1;
    public static final int TYPE_INACTIVE = 2;
    public static final int TYPE_SUCCESS = 3;
    public static final int TYPE_WARNING = 4;
    public static final int TYPE_ERROR = 5;
    public static final int TYPE_INVERSE = 6;

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((Context)new ContextThemeWrapper(context, R.style.AppTheme_Widgets_Tag), attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TagView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026TagView, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            int style2 = styledAttrs.getInt(R.styleable.TagView_tagStyle, this.currentStyle);
            Drawable icon = styledAttrs.getDrawable(R.styleable.TagView_tagIcon);
            this.setTagStyle(style2, icon);
            styledAttrs.recycle();
        }
    }

    public /* synthetic */ TagView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private static /* synthetic */ void getCurrentStyle$annotations() {
    }

    @JvmOverloads
    public final void setTagStyle(int style2, @Nullable Drawable icon) {
        this.currentStyle = style2;
        Pair<Integer, Integer> pair = this.getStyle(style2);
        int tagBackground = ((Number)pair.component1()).intValue();
        int tagTextColor = ((Number)pair.component2()).intValue();
        Drawable drawable2 = this.getBackground();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        drawable2.setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ColorUtilsKt.getThemeColor(context, tagBackground), (BlendModeCompat)BlendModeCompat.SRC_IN));
        context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.setTextColor(ColorUtilsKt.getThemeColor(context, tagTextColor));
        if (icon != null) {
            this.setTagIcon(icon);
        }
    }

    public static /* synthetic */ void setTagStyle$default(TagView tagView, int n, Drawable drawable2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            drawable2 = null;
        }
        tagView.setTagStyle(n, drawable2);
    }

    public final void setTagIcon(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Drawable drawable3 = DrawableCompat.wrap((Drawable)drawable2);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        DrawableCompat.setTint((Drawable)drawable3, (int)ColorUtilsKt.getThemeColor(context, ((Number)this.getStyle(this.currentStyle).getSecond()).intValue()));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int iconSize = ViewUtilsKt.convertDpToPx(context2, 16);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        int fixedMargin = ViewUtilsKt.convertDpToPx(context3, 1.5f);
        drawable2.setBounds(0, fixedMargin, iconSize, iconSize + fixedMargin);
        this.setCompoundDrawablesRelative(drawable2, null, null, null);
        context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        this.setCompoundDrawablePadding(ViewUtilsKt.convertDpToPx(context3, 4));
        context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        this.setPadding(ViewUtilsKt.convertDpToPx(context3, 8), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    public void setText(@Nullable CharSequence text, @Nullable TextView.BufferType type) {
        String string2;
        CharSequence charSequence = text;
        super.setText((CharSequence)(charSequence == null ? null : ((string2 = ((Object)charSequence).toString()) == null ? null : this.captitalizeFirstChar(string2))), type);
    }

    private final Pair<Integer, Integer> getStyle(int $this$getStyle) {
        Pair pair;
        int n = $this$getStyle;
        switch (n) {
            case 0: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundPromo, (Object)R.attr.textTagPromo);
                break;
            }
            case 1: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundActive, (Object)R.attr.textTagActive);
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundInactive, (Object)R.attr.textTagInactive);
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundSuccess, (Object)R.attr.textTagSuccess);
                break;
            }
            case 4: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundWarning, (Object)R.attr.textTagWarning);
                break;
            }
            case 5: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundError, (Object)R.attr.textTagError);
                break;
            }
            case 6: {
                pair = TuplesKt.to((Object)R.attr.colorInverse, (Object)R.attr.textTagActive);
                break;
            }
            default: {
                pair = TuplesKt.to((Object)R.attr.tagBackgroundPromo, (Object)R.attr.textTagPromo);
            }
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final String captitalizeFirstChar(String $this$captitalizeFirstChar) {
        String string2;
        String string3 = $this$captitalizeFirstChar;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        string3 = string5;
        boolean bl2 = false;
        CharSequence charSequence = string3;
        int n = 0;
        if (charSequence.length() > 0) {
            String string6;
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            void var8_11 = it;
            boolean bl4 = false;
            if (Character.isLowerCase((char)var8_11)) {
                var8_11 = it;
                bl4 = false;
                String string7 = String.valueOf((char)var8_11);
                boolean bl5 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toUpperCase(Locale.ROOT);
                string6 = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
            } else {
                string6 = String.valueOf((char)it);
            }
            String string10 = string6;
            StringBuilder stringBuilder2 = stringBuilder.append(string10.toString());
            charSequence = string3;
            n = 1;
            c = '\u0000';
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = ((String)charSequence2).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string11).toString();
        } else {
            string2 = string3;
        }
        return string2;
    }

    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TagView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @JvmOverloads
    public final void setTagStyle(int style2) {
        TagView.setTagStyle$default(this, style2, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/telefonica/mistica/tag/TagView$Companion;", "", "()V", "TYPE_ACTIVE", "", "TYPE_ERROR", "TYPE_INACTIVE", "TYPE_INVERSE", "TYPE_PROMO", "TYPE_SUCCESS", "TYPE_WARNING", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

