/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.input;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.StringRes;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.google.android.material.textfield.TextInputLayout;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=Input.class, attribute="inputHint", method="setHint"), @BindingMethod(type=Input.class, attribute="inputError", method="setError"), @BindingMethod(type=Input.class, attribute="inputHelperText", method="setHelperText"), @BindingMethod(type=Input.class, attribute="inputEnabled", method="setEnabled"), @BindingMethod(type=Input.class, attribute="inputInverse", method="setInverse")})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u001d\u001a\u00020\u001a2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H&J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0017\u0010\u000f\u001a\u00020\u001f2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R(\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/telefonica/mistica/input/Input;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "value", "", "error", "getError", "()Ljava/lang/String;", "setError", "(Ljava/lang/String;)V", "helperText", "getHelperText", "setHelperText", "hint", "getHint", "setHint", "inverse", "", "layoutView", "Lcom/google/android/material/textfield/TextInputLayout;", "getLayoutView", "()Lcom/google/android/material/textfield/TextInputLayout;", "handleAttrsAndInflateLayout", "reconfigureErrorTextColor", "", "setEnabled", "enabled", "textRes", "(Ljava/lang/Integer;)V", "setErrorEnabled", "setInverse", "com.telefonica.mistica"})
public abstract class Input
extends FrameLayout {
    @NotNull
    private final TextInputLayout layoutView;
    private boolean inverse;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public Input(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context, attrs, defStyleAttr, defStyleRes);
        String initialHint = null;
        String initialError = null;
        String initialHelperText = null;
        boolean initialEnabled = true;
        boolean initialInverse = false;
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Input, defStyleAttr, defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026defStyleRes\n            )");
            TypedArray styledAttrs = typedArray;
            try {
                initialHint = styledAttrs.getString(R.styleable.Input_inputHint);
                initialError = styledAttrs.getString(R.styleable.Input_inputError);
                initialHelperText = styledAttrs.getString(R.styleable.Input_inputHelperText);
                initialEnabled = styledAttrs.getBoolean(R.styleable.Input_inputEnabled, true);
                initialInverse = styledAttrs.getBoolean(R.styleable.Input_inputInverse, false);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        this.layoutView = this.handleAttrsAndInflateLayout(attrs, defStyleAttr, defStyleRes);
        this.setEnabled(initialEnabled);
        this.setHint(initialHint);
        this.setError(initialError);
        this.setHelperText(initialHelperText);
        this.setInverse(initialInverse);
    }

    public /* synthetic */ Input(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @Nullable
    public final String getHelperText() {
        CharSequence charSequence = this.layoutView.getHelperText();
        return charSequence != null ? ((Object)charSequence).toString() : null;
    }

    public final void setHelperText(@Nullable String value) {
        this.layoutView.setHelperText((CharSequence)value);
    }

    @Nullable
    public final String getError() {
        CharSequence charSequence = this.layoutView.getError();
        return charSequence != null ? ((Object)charSequence).toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setError(@Nullable String value) {
        CharSequence charSequence;
        TextInputLayout textInputLayout = this.layoutView;
        if (value != null && this.inverse) {
            void $this$_set_error__u24lambda_u2d0;
            SpannableString spannableString;
            SpannableString spannableString2 = spannableString = new SpannableString((CharSequence)value);
            TextInputLayout textInputLayout2 = textInputLayout;
            boolean bl = false;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            $this$_set_error__u24lambda_u2d0.setSpan((Object)new ForegroundColorSpan(ColorUtilsKt.getThemeColor(context, R.attr.colorTextPrimaryInverse)), 0, value.length(), 33);
            textInputLayout = textInputLayout2;
            charSequence = (CharSequence)spannableString;
        } else {
            charSequence = value;
        }
        textInputLayout.setError(charSequence);
    }

    @Nullable
    public final String getHint() {
        CharSequence charSequence = this.layoutView.getHint();
        return charSequence != null ? ((Object)charSequence).toString() : null;
    }

    public final void setHint(@Nullable String value) {
        this.layoutView.setHint((CharSequence)value);
    }

    @NotNull
    protected final TextInputLayout getLayoutView() {
        return this.layoutView;
    }

    /*
     * WARNING - void declaration
     */
    public final void setError(@StringRes @Nullable Integer textRes) {
        String string2;
        Input input = this;
        Integer n = textRes;
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            Input input2 = input;
            boolean bl = false;
            string2 = this.getContext().getString((int)it);
            input = input2;
        } else {
            string2 = null;
        }
        input.setError(string2);
    }

    public final void setErrorEnabled(boolean enabled) {
        this.layoutView.setErrorEnabled(enabled);
    }

    public final void setInverse(boolean inverse) {
        this.inverse = inverse;
        this.layoutView.setHelperTextTextAppearance(inverse ? R.style.AppTheme_Forms_TextInputLayout_Helper_Inverse : R.style.AppTheme_Forms_TextInputLayout_Helper);
        this.reconfigureErrorTextColor();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.layoutView.setEnabled(enabled);
    }

    @NotNull
    public abstract TextInputLayout handleAttrsAndInflateLayout(@Nullable AttributeSet var1, int var2, int var3);

    public static /* synthetic */ TextInputLayout handleAttrsAndInflateLayout$default(Input input, AttributeSet attributeSet, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleAttrsAndInflateLayout");
        }
        if ((n3 & 1) != 0) {
            attributeSet = null;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return input.handleAttrsAndInflateLayout(attributeSet, n, n2);
    }

    private final void reconfigureErrorTextColor() {
        if (this.layoutView.isErrorEnabled()) {
            this.setError(this.getError());
        }
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @JvmOverloads
    public Input(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public Input(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public Input(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }
}

