/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.sheet.children.list.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.telefonica.mistica.R;
import com.telefonica.mistica.sheet.children.list.InformativeIconViewData;
import com.telefonica.mistica.sheet.children.list.ListElementViewData;
import com.telefonica.mistica.sheet.children.list.adapter.InformativeListViewHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/telefonica/mistica/sheet/children/list/adapter/InformativeListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/telefonica/mistica/sheet/children/list/adapter/InformativeListViewHolder;", "items", "", "Lcom/telefonica/mistica/sheet/children/list/ListElementViewData$RowInformativeViewData;", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "com.telefonica.mistica"})
public final class InformativeListAdapter
extends RecyclerView.Adapter<InformativeListViewHolder> {
    @NotNull
    private final List<ListElementViewData.RowInformativeViewData> items;

    public InformativeListAdapter(@NotNull List<ListElementViewData.RowInformativeViewData> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items = items;
    }

    @NotNull
    public final List<ListElementViewData.RowInformativeViewData> getItems() {
        return this.items;
    }

    @NotNull
    public InformativeListViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.sheet_list_row_informative, parent, false);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }
        return new InformativeListViewHolder((ConstraintLayout)view);
    }

    public void onBindViewHolder(@NotNull InformativeListViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        ListElementViewData.RowInformativeViewData item = this.items.get(position);
        holder.getText().setText((CharSequence)item.getTitle());
        if (item.getDescription() != null) {
            holder.getDescription().setText((CharSequence)item.getDescription());
            holder.getDescription().setVisibility(0);
        } else {
            holder.getDescription().setVisibility(8);
        }
        InformativeIconViewData informativeIconViewData = item.getIcon();
        if (Intrinsics.areEqual((Object)informativeIconViewData, (Object)InformativeIconViewData.Bullet.INSTANCE)) {
            holder.getBullet().setVisibility(0);
            holder.getIconDefault().setVisibility(8);
            holder.getIconSmall().setVisibility(8);
        } else if (informativeIconViewData instanceof InformativeIconViewData.Icon) {
            holder.getIconDefault().setImageDrawable(((InformativeIconViewData.Icon)item.getIcon()).getDrawableRes());
            holder.getBullet().setVisibility(8);
            holder.getIconDefault().setVisibility(0);
            holder.getIconSmall().setVisibility(8);
        } else if (informativeIconViewData instanceof InformativeIconViewData.SmallIcon) {
            holder.getIconSmall().setImageDrawable(((InformativeIconViewData.SmallIcon)item.getIcon()).getDrawableRes());
            holder.getBullet().setVisibility(8);
            holder.getIconDefault().setVisibility(8);
            holder.getIconSmall().setVisibility(0);
        }
        if (position == this.items.size() - 1) {
            holder.getBottomExtraSpace().setVisibility(0);
        } else {
            holder.getBottomExtraSpace().setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.items.size();
    }
}

