/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.title;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.title.TitleStyleConfig;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.TextUtilsKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=TitleView.class, attribute="title", method="setTitle"), @BindingMethod(type=TitleView.class, attribute="titleStyle", method="setTitleStyle"), @BindingMethod(type=TitleView.class, attribute="link", method="setLink"), @BindingMethod(type=TitleView.class, attribute="linkOnClick", method="setOnLinkClickedListener")})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0014\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/telefonica/mistica/title/TitleView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "linkTextView", "Landroid/widget/TextView;", "titleTextView", "getLink", "", "getTitle", "setLink", "", "text", "", "setOnLinkClickedListener", "listener", "Lkotlin/Function0;", "setTitle", "setTitleStyle", "style", "Companion", "TitleStyle", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
public final class TitleView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TextView linkTextView;
    @NotNull
    private TextView titleTextView;
    public static final int $stable = 8;
    public static final int TITLE_1 = 0;
    public static final int TITLE_2 = 1;
    @NotNull
    private static final TitleStyleConfig TITLE_1_STYLE_CONFIG = new TitleStyleConfig(R.style.AppTheme_TextAppearance_Preset1, R.attr.colorTextSecondary, true);
    @NotNull
    private static final TitleStyleConfig TITLE_2_STYLE_CONFIG = new TitleStyleConfig(R.style.AppTheme_TextAppearance_Preset5, R.attr.colorTextPrimary, false);

    @JvmOverloads
    public TitleView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.title, (ViewGroup)this, true);
        View view = this.findViewById(R.id.title_text);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.title_text)");
        this.titleTextView = (TextView)view;
        View view2 = this.findViewById(R.id.link_text);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.link_text)");
        this.linkTextView = (TextView)view2;
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TitleView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026      0\n                )");
            TypedArray styledAttrs = typedArray;
            TextUtilsKt.setTextAndVisibility(this.titleTextView, styledAttrs.getText(R.styleable.TitleView_title));
            this.setTitleStyle(styledAttrs.getInt(R.styleable.TitleView_titleStyle, -1));
            TextUtilsKt.setTextAndVisibility(this.linkTextView, styledAttrs.getText(R.styleable.TitleView_link));
            styledAttrs.recycle();
        }
    }

    public /* synthetic */ TitleView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final String getTitle() {
        return ((Object)this.titleTextView.getText()).toString();
    }

    public final void setTitle(@Nullable CharSequence text) {
        TextUtilsKt.setTextAndVisibility(this.titleTextView, text);
    }

    public final void setTitleStyle(int style2) {
        TitleStyleConfig titleStyleConfig;
        switch (style2) {
            case 0: {
                titleStyleConfig = TITLE_1_STYLE_CONFIG;
                break;
            }
            case 1: {
                titleStyleConfig = TITLE_2_STYLE_CONFIG;
                break;
            }
            default: {
                titleStyleConfig = TITLE_1_STYLE_CONFIG;
            }
        }
        TitleStyleConfig styleConfig = titleStyleConfig;
        TextUtilsKt.setTextPreset(this.titleTextView, styleConfig.getPreset());
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.titleTextView.setTextColor(ColorUtilsKt.getThemeColor(context, styleConfig.getColorAttrRes()));
        this.titleTextView.setAllCaps(styleConfig.isAllCaps());
    }

    @NotNull
    public final String getLink() {
        return ((Object)this.linkTextView.getText()).toString();
    }

    public final void setLink(@Nullable CharSequence text) {
        TextUtilsKt.setTextAndVisibility(this.linkTextView, text);
    }

    public final void setOnLinkClickedListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.linkTextView.setOnClickListener(arg_0 -> TitleView.setOnLinkClickedListener$lambda$0(listener, arg_0));
    }

    @JvmOverloads
    public TitleView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TitleView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setOnLinkClickedListener$lambda$0(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/title/TitleView$TitleStyle;", "", "com.telefonica.mistica"})
    public static @interface TitleStyle {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/telefonica/mistica/title/TitleView$Companion;", "", "()V", "TITLE_1", "", "TITLE_1_STYLE_CONFIG", "Lcom/telefonica/mistica/title/TitleStyleConfig;", "TITLE_2", "TITLE_2_STYLE_CONFIG", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

