/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.button;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.button.MaterialButton;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0003J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020(J\u001e\u0010)\u001a\u00020(2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0003J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0012H\u0016J\u000e\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0012J\u000e\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\"J\u0012\u00100\u001a\u00020(2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020(H\u0002J\u000e\u00104\u001a\u00020(2\u0006\u0010/\u001a\u00020\"J\u0010\u00104\u001a\u00020(2\b\b\u0001\u00105\u001a\u00020\tJ\b\u00106\u001a\u00020(H\u0002J\u0006\u00107\u001a\u00020(J\b\u00108\u001a\u00020(H\u0002J\f\u00109\u001a\u00020&*\u00020&H\u0002J\f\u0010:\u001a\u00020(*\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/telefonica/mistica/button/ProgressButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "buttonBackground", "Lcom/google/android/material/button/MaterialButton;", "buttonLoading", "buttonNormal", "currentAnimation", "Landroid/animation/AnimatorSet;", "<set-?>", "", "isLoading", "()Z", "originalTextColors", "Landroid/content/res/ColorStateList;", "progressBar", "Landroid/widget/ProgressBar;", "getCubicBezierInterpolator", "Landroid/view/animation/PathInterpolator;", "getCurrentTextColor", "getCurrentTextColorFadeAnim", "Landroid/animation/ObjectAnimator;", "view", "Landroid/widget/TextView;", "out", "getText", "", "getTranslationYAnim", "Landroid/view/View;", "positions", "", "hideLoading", "", "init", "setEnabled", "enabled", "setIsLoading", "loading", "setLoadingText", "text", "setOnClickListener", "l", "Landroid/view/View$OnClickListener;", "setProgressBarHorizontalPosition", "setText", "textId", "setVisibilityAndColors", "showLoading", "switchState", "reverseIfLoading", "showTextOnly", "Companion", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
public final class ProgressButton
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressBar progressBar;
    @NotNull
    private final MaterialButton buttonNormal;
    @NotNull
    private final MaterialButton buttonLoading;
    @NotNull
    private final MaterialButton buttonBackground;
    private ColorStateList originalTextColors;
    private boolean isLoading;
    @Nullable
    private AnimatorSet currentAnimation;
    public static final int $stable = 8;
    @Deprecated
    private static final long ANIMATION_DURATION = 300L;
    @Deprecated
    private static final int NO_ID = -1;

    public final boolean isLoading() {
        return this.isLoading;
    }

    public ProgressButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context);
        this.buttonLoading = new MaterialButton(context);
        this.buttonBackground = new MaterialButton(context);
        ProgressButton.init$default(this, null, 0, 3, null);
    }

    public ProgressButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context, attrs);
        this.buttonLoading = new MaterialButton(context, attrs);
        this.buttonBackground = new MaterialButton(context, attrs);
        ProgressButton.init$default(this, attrs, 0, 2, null);
    }

    public ProgressButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.progressBar = new ProgressBar(this.getContext());
        this.buttonNormal = new MaterialButton(context, attrs, defStyleAttr);
        this.buttonLoading = new MaterialButton(context, attrs, defStyleAttr);
        this.buttonBackground = new MaterialButton(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void init(AttributeSet attrs, int defStyleAttr) {
        FrameLayout.LayoutParams layoutParams;
        MaterialButton materialButton;
        if (attrs != null) {
            Resources.Theme theme = this.getContext().getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.ProgressButton, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"theme.obtainStyledAttrib\u2026sButton, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            try {
                this.isLoading = styledAttrs.getBoolean(R.styleable.ProgressButton_isLoading, false);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        this.setClickable(false);
        this.setPadding(0, 0, 0, 0);
        this.setBackgroundColor(0);
        ColorStateList colorStateList = this.buttonNormal.getTextColors();
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"buttonNormal.textColors");
        this.originalTextColors = colorStateList;
        MaterialButton $this$init_u24lambda_u240 = materialButton = this.buttonNormal;
        boolean bl = false;
        $this$init_u24lambda_u240.setId(-1);
        $this$init_u24lambda_u240.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.showTextOnly($this$init_u24lambda_u240);
        MaterialButton $this$init_u24lambda_u241 = materialButton = this.buttonLoading;
        boolean bl2 = false;
        $this$init_u24lambda_u241.setId(-1);
        $this$init_u24lambda_u241.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.showTextOnly($this$init_u24lambda_u241);
        $this$init_u24lambda_u241.setIcon(AppCompatResources.getDrawable((Context)$this$init_u24lambda_u241.getContext(), (int)R.drawable.empty_material_button_icon));
        $this$init_u24lambda_u241.setText((CharSequence)"");
        MaterialButton $this$init_u24lambda_u243 = materialButton = this.progressBar;
        boolean bl3 = false;
        FrameLayout.LayoutParams layoutParams2 = layoutParams = new FrameLayout.LayoutParams(this.buttonLoading.getIconSize(), this.buttonLoading.getIconSize());
        MaterialButton materialButton2 = $this$init_u24lambda_u243;
        boolean bl4 = false;
        $this$init_u24lambda_u243_u24lambda_u242.gravity = 17;
        materialButton2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        $this$init_u24lambda_u243.setIndeterminate(true);
        $this$init_u24lambda_u243.setIndeterminateTintMode(PorterDuff.Mode.SRC_IN);
        $this$init_u24lambda_u243.setVisibility(4);
        MaterialButton $this$init_u24lambda_u245 = materialButton = this.buttonBackground;
        boolean bl5 = false;
        $this$init_u24lambda_u245.setId(-1);
        $this$init_u24lambda_u245.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        $this$init_u24lambda_u245.setIcon(null);
        $this$init_u24lambda_u245.setTextColor(0);
        $this$init_u24lambda_u245.setVisibility(0);
        $this$init_u24lambda_u245.setOnTouchListener((arg_0, arg_1) -> ProgressButton.init$lambda$5$lambda$4(this, arg_0, arg_1));
        this.addView((View)this.buttonBackground);
        this.addView((View)this.buttonNormal);
        this.addView((View)this.buttonLoading);
        this.addView((View)this.progressBar);
        this.setVisibilityAndColors();
    }

    static /* synthetic */ void init$default(ProgressButton progressButton, AttributeSet attributeSet, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            attributeSet = null;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        progressButton.init(attributeSet, n);
    }

    @NotNull
    public final CharSequence getText() {
        CharSequence charSequence = this.buttonBackground.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"buttonBackground.text");
        return charSequence;
    }

    public final void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buttonNormal.setText(text);
        if (!this.isLoading) {
            this.buttonBackground.setText(text);
        }
    }

    public final void setText(@StringRes int textId) {
        String string2 = this.getContext().getString(textId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(textId)");
        this.setText(string2);
    }

    public final void setLoadingText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buttonLoading.setText(text);
        if (this.isLoading) {
            this.buttonBackground.setText(text);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.buttonBackground.setOnClickListener(l);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ViewUtilsKt.setAlpha((View)this, enabled);
        this.buttonBackground.setEnabled(enabled);
        this.buttonNormal.setEnabled(enabled);
        this.buttonLoading.setEnabled(enabled);
        this.progressBar.setEnabled(enabled);
    }

    public final void setIsLoading(boolean loading) {
        if (loading) {
            this.showLoading();
        } else {
            this.hideLoading();
        }
    }

    public final void showLoading() {
        if (!this.isLoading) {
            this.switchState();
        }
    }

    public final void hideLoading() {
        if (this.isLoading) {
            this.switchState();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void switchState() {
        block1: {
            void $this$switchState_u24lambda_u2410_u24lambda_u249;
            Object $this$switchState_u24lambda_u2410_u24lambda_u247;
            void $this$switchState_u24lambda_u2410;
            AnimatorSet animatorSet;
            AnimatorSet animatorSet2 = this.currentAnimation;
            if (animatorSet2 != null) {
                animatorSet2.cancel();
            }
            float maxTranslation = this.getResources().getDimensionPixelSize(R.dimen.button_max_animation_translation);
            AnimatorSet animatorSet3 = animatorSet = new AnimatorSet();
            ProgressButton progressButton = this;
            boolean bl = false;
            Animator[] animatorArray = new Animator[4];
            animatorArray[0] = (Animator)this.getCurrentTextColorFadeAnim((TextView)this.buttonNormal, !this.isLoading);
            Object object = new float[]{0.0f, -maxTranslation};
            animatorArray[1] = (Animator)this.getTranslationYAnim((View)this.buttonNormal, this.reverseIfLoading((float[])object));
            Object object2 = object = (Object)this.getCurrentTextColorFadeAnim((TextView)this.buttonLoading, this.isLoading);
            int n = 2;
            Animator[] animatorArray2 = animatorArray;
            void var10_11 = $this$switchState_u24lambda_u2410;
            boolean bl2 = false;
            $this$switchState_u24lambda_u2410_u24lambda_u247.addUpdateListener(arg_0 -> ProgressButton.switchState$lambda$10$lambda$7$lambda$6(this, arg_0));
            Unit unit = Unit.INSTANCE;
            animatorArray2[n] = (Animator)object;
            object = new float[]{maxTranslation, 0.0f};
            $this$switchState_u24lambda_u2410_u24lambda_u247 = object = (Object)this.getTranslationYAnim((View)this.buttonLoading, this.reverseIfLoading((float[])object));
            n = 3;
            animatorArray2 = animatorArray;
            boolean bl3 = false;
            $this$switchState_u24lambda_u2410_u24lambda_u249.addUpdateListener(arg_0 -> ProgressButton.switchState$lambda$10$lambda$9$lambda$8(this, arg_0));
            unit = Unit.INSTANCE;
            animatorArray2[n] = (Animator)object;
            var10_11.playTogether(animatorArray);
            $this$switchState_u24lambda_u2410.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
            $this$switchState_u24lambda_u2410.setDuration(300L);
            $this$switchState_u24lambda_u2410.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ ProgressButton this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    ProgressButton.access$setVisibilityAndColors(this.this$0);
                    if (!this.this$0.isLoading()) {
                        ProgressButton.access$getButtonBackground$p(this.this$0).setClickable(true);
                    }
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    animator.end();
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    CharSequence charSequence = ProgressButton.access$getButtonLoading$p(this.this$0).getText();
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        ProgressButton.access$setProgressBarHorizontalPosition(this.this$0);
                    }
                    ProgressButton.access$setLoading$p(this.this$0, !this.this$0.isLoading());
                    ProgressButton.access$getButtonNormal$p(this.this$0).setVisibility(0);
                    ProgressButton.access$getButtonLoading$p(this.this$0).setVisibility(0);
                    ProgressButton.access$getProgressBar$p(this.this$0).setVisibility(0);
                    if (this.this$0.isLoading()) {
                        ProgressButton.access$getButtonBackground$p(this.this$0).setClickable(false);
                    }
                }
            });
            progressButton.currentAnimation = animatorSet;
            AnimatorSet animatorSet4 = this.currentAnimation;
            if (animatorSet4 == null) break block1;
            animatorSet4.start();
        }
    }

    private final void setVisibilityAndColors() {
        this.buttonNormal.setVisibility(this.isLoading ? 4 : 0);
        this.buttonLoading.setVisibility(this.isLoading ? 0 : 4);
        this.progressBar.setVisibility(this.isLoading ? 0 : 4);
        this.buttonBackground.setText(this.isLoading ? this.buttonLoading.getText() : this.buttonNormal.getText());
        ColorStateList colorStateList = this.originalTextColors;
        if (colorStateList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            colorStateList = null;
        }
        this.buttonNormal.setTextColor(colorStateList);
        ColorStateList colorStateList2 = this.originalTextColors;
        if (colorStateList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            colorStateList2 = null;
        }
        this.buttonLoading.setTextColor(colorStateList2);
        this.progressBar.setTranslationY(0.0f);
        ColorStateList colorStateList3 = this.originalTextColors;
        if (colorStateList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalTextColors");
            colorStateList3 = null;
        }
        this.progressBar.setIndeterminateTintList(colorStateList3);
    }

    private final void showTextOnly(MaterialButton $this$showTextOnly) {
        $this$showTextOnly.setBackground(null);
        $this$showTextOnly.setClickable(false);
        $this$showTextOnly.setFocusable(false);
        $this$showTextOnly.setStrokeWidth(0);
        $this$showTextOnly.setRippleColor(ColorStateList.valueOf((int)0));
        $this$showTextOnly.setImportantForAccessibility(2);
    }

    private final void setProgressBarHorizontalPosition() {
        Rect bounds = new Rect();
        this.buttonLoading.getPaint().getTextBounds(((Object)this.buttonLoading.getText()).toString(), 0, this.buttonLoading.getText().length(), bounds);
        float textWidth = (float)bounds.width() + (float)this.buttonLoading.getIconSize() + (float)this.buttonLoading.getIconPadding();
        this.progressBar.setX(((float)this.buttonLoading.getWidth() - textWidth) / (float)2);
    }

    private final ObjectAnimator getCurrentTextColorFadeAnim(TextView view, boolean out) {
        int color = this.getCurrentTextColor();
        int transparentColor = ColorUtils.setAlphaComponent((int)color, (int)0);
        int fromColor = out ? color : transparentColor;
        int toColor = out ? transparentColor : color;
        Object object = new int[]{fromColor, toColor};
        Object $this$getCurrentTextColorFadeAnim_u24lambda_u2411 = object = (Object)ObjectAnimator.ofInt((Object)view, (String)"textColor", (int[])object);
        boolean bl = false;
        $this$getCurrentTextColorFadeAnim_u24lambda_u2411.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofInt(view, \"textColor\",\u2026valuator())\n            }");
        return object;
    }

    private final ObjectAnimator getTranslationYAnim(View view, float[] positions) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])Arrays.copyOf(positions, positions.length));
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(view, \"translationY\", *positions)");
        return objectAnimator;
    }

    private final PathInterpolator getCubicBezierInterpolator() {
        return new PathInterpolator(0.77f, 0.0f, 0.175f, 1.0f);
    }

    @ColorInt
    private final int getCurrentTextColor() {
        return this.isLoading ? this.buttonLoading.getCurrentTextColor() : this.buttonNormal.getCurrentTextColor();
    }

    private final float[] reverseIfLoading(float[] $this$reverseIfLoading) {
        return this.isLoading ? ArraysKt.reversedArray((float[])$this$reverseIfLoading) : $this$reverseIfLoading;
    }

    private static final boolean init$lambda$5$lambda$4(ProgressButton this$0, View view, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        switch (event.getAction()) {
            case 0: {
                this$0.buttonNormal.setPressed(true);
                this$0.buttonLoading.setPressed(true);
                break;
            }
            case 2: {
                boolean outsideBounds = event.getX() < 0.0f || event.getY() < 0.0f || event.getX() > (float)view.getMeasuredWidth() || event.getY() > (float)view.getMeasuredHeight();
                this$0.buttonNormal.setPressed(!outsideBounds);
                this$0.buttonLoading.setPressed(!outsideBounds);
                break;
            }
            case 1: 
            case 3: {
                this$0.buttonNormal.setPressed(false);
                this$0.buttonLoading.setPressed(false);
            }
        }
        return false;
    }

    private static final void switchState$lambda$10$lambda$7$lambda$6(ProgressButton this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.progressBar.setIndeterminateTintList(this$0.buttonLoading.getTextColors());
    }

    private static final void switchState$lambda$10$lambda$9$lambda$8(ProgressButton this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.progressBar.setTranslationY(this$0.buttonLoading.getTranslationY());
    }

    public static final /* synthetic */ void access$setVisibilityAndColors(ProgressButton $this) {
        $this.setVisibilityAndColors();
    }

    public static final /* synthetic */ MaterialButton access$getButtonBackground$p(ProgressButton $this) {
        return $this.buttonBackground;
    }

    public static final /* synthetic */ MaterialButton access$getButtonLoading$p(ProgressButton $this) {
        return $this.buttonLoading;
    }

    public static final /* synthetic */ void access$setProgressBarHorizontalPosition(ProgressButton $this) {
        $this.setProgressBarHorizontalPosition();
    }

    public static final /* synthetic */ void access$setLoading$p(ProgressButton $this, boolean bl) {
        $this.isLoading = bl;
    }

    public static final /* synthetic */ MaterialButton access$getButtonNormal$p(ProgressButton $this) {
        return $this.buttonNormal;
    }

    public static final /* synthetic */ ProgressBar access$getProgressBar$p(ProgressButton $this) {
        return $this.progressBar;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/button/ProgressButton$Companion;", "", "()V", "ANIMATION_DURATION", "", "NO_ID", "", "com.telefonica.mistica"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

