/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.highlightedcard;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardBackground", method="setCustomBackground"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardInverse", method="setInverse"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardTitle", method="setTitle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardContent", method="setContent"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButtonStyle", method="setButtonStyle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImageStyle", method="setImageStyle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImage", method="setImage"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButton", method="setButtonText"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImageVisibility", method="setImageVisibility"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButtonVisibility", method="setCloseVisibility"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButtonOnClick", method="setButtonOnClick"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButton", method="setCloseButton"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButtonOnClick", method="setCloseButtonOnClick")})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 C2\u00020\u0001:\u0003BCDB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u0006\u0010\"\u001a\u00020\u001eJ\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\b\u0010'\u001a\u00020\u001eH\u0002J\u0006\u0010(\u001a\u00020\u001eJ\u0010\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\fJ\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.J\u0017\u0010,\u001a\u00020\u001e2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020.J\u000e\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\fJ\u000e\u00105\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.J\u0010\u00105\u001a\u00020\u001e2\b\b\u0001\u0010/\u001a\u00020\u0007J\u000e\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208J\u0010\u00106\u001a\u00020\u001e2\b\b\u0001\u00109\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\u001e2\u0006\u00109\u001a\u000208J\u0010\u0010:\u001a\u00020\u001e2\b\b\u0001\u00109\u001a\u00020\u0007J\u000e\u0010;\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0018J\u000e\u0010>\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.J\u0010\u0010>\u001a\u00020\u001e2\b\b\u0001\u0010/\u001a\u00020\u0007J\b\u0010?\u001a\u00020\u0018H\u0002J\b\u0010@\u001a\u00020\u001eH\u0002J\b\u0010A\u001a\u00020\u001eH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "button", "Landroid/widget/Button;", "buttonClickListener", "Landroid/view/View$OnClickListener;", "buttonStyle", "buttonText", "", "closeButton", "Landroid/widget/ImageView;", "closeButtonBackground", "Landroid/view/View;", "container", "contentTextView", "Landroid/widget/TextView;", "hasCustomBackground", "", "image", "imageStyle", "isInverse", "titleTextView", "configureBackground", "", "configureButton", "configureColors", "configureImage", "disableCustomBackground", "getRoundedCornerBitmap", "Landroid/graphics/Bitmap;", "bitmap", "hideImage", "reload", "removeCloseButton", "setButtonOnClick", "onClickListener", "setButtonStyle", "setButtonText", "text", "", "textRes", "(Ljava/lang/Integer;)V", "setCloseButton", "buttonContentDescription", "setCloseButtonOnClick", "onButtonClick", "setContent", "setCustomBackground", "drawable", "Landroid/graphics/drawable/Drawable;", "imageRes", "setImage", "setImageStyle", "setInverse", "inverse", "setTitle", "showCloseButtonBackground", "showFillImage", "showFitImage", "ButtonStyle", "Companion", "ImageStyle", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
public final class HighlightedCardView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView titleTextView;
    @NotNull
    private final TextView contentTextView;
    @NotNull
    private final ImageView image;
    @NotNull
    private final ImageView closeButton;
    @NotNull
    private final View closeButtonBackground;
    @NotNull
    private final ConstraintLayout container;
    @Nullable
    private Button button;
    @Nullable
    private View.OnClickListener buttonClickListener;
    @Nullable
    private String buttonText;
    private boolean isInverse;
    private boolean hasCustomBackground;
    private int buttonStyle;
    private int imageStyle;
    public static final int $stable = 8;
    public static final int BUTTON_STYLE_PRIMARY = 0;
    public static final int BUTTON_STYLE_SECONDARY = 1;
    public static final int BUTTON_STYLE_LINK = 2;
    public static final int BUTTON_STYLE_NO_BUTTON = 3;
    public static final int IMAGE_STYLE_MODE_FIT = 0;
    public static final int IMAGE_STYLE_MODE_FILL = 1;
    public static final int IMAGE_STYLE_NO_IMAGE = 2;

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.buttonStyle = 3;
        this.imageStyle = 2;
        LayoutInflater.from((Context)context).inflate(R.layout.highlighted_card_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.highlighted_card_title);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.highlighted_card_title)");
        this.titleTextView = (TextView)view;
        View view2 = this.findViewById(R.id.highlighted_card_content);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.highlighted_card_content)");
        this.contentTextView = (TextView)view2;
        this.button = (Button)this.findViewById(R.id.highlighted_card_button_primary);
        View view3 = this.findViewById(R.id.highlighted_card_image);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.highlighted_card_image)");
        this.image = (ImageView)view3;
        View view4 = this.findViewById(R.id.highlighted_card_close_button);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.highlighted_card_close_button)");
        this.closeButton = (ImageView)view4;
        View view5 = this.findViewById(R.id.highlighted_card_close_button_background);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.highli\u2026_close_button_background)");
        this.closeButtonBackground = view5;
        View view6 = this.findViewById(R.id.highlighted_card_container);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.highlighted_card_container)");
        this.container = (ConstraintLayout)view6;
        if (attrs != null) {
            Object object;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HighlightedCardView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026      0\n                )");
            TypedArray styledAttrs = typedArray;
            Integer n = styledAttrs.getResourceId(R.styleable.HighlightedCardView_highlightedCardBackground, 0);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Object object2 = object = it != 0 ? n : null;
            if (object != null) {
                int it2 = ((Number)object).intValue();
                boolean bl2 = false;
                n = AppCompatResources.getDrawable((Context)context, (int)it2);
                if (n != null) {
                    Integer it3 = n;
                    boolean bl3 = false;
                    this.setCustomBackground((Drawable)it3);
                }
            }
            this.isInverse = styledAttrs.getBoolean(R.styleable.HighlightedCardView_highlightedCardInverse, false);
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardTitle);
            if (object != null) {
                Object it4 = object;
                boolean bl4 = false;
                this.titleTextView.setText((CharSequence)it4);
            }
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardContent);
            if (object != null) {
                Object it5 = object;
                boolean bl5 = false;
                this.contentTextView.setText((CharSequence)it5);
            }
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardButton);
            if (object != null) {
                Object it6 = object;
                boolean bl6 = false;
                this.buttonText = it6.toString();
            }
            String string2 = this.buttonText;
            if (string2 != null) {
                String it7 = string2;
                boolean bl7 = false;
                Button button = this.button;
                if (button != null) {
                    button.setText((CharSequence)it7);
                }
            }
            this.buttonStyle = styledAttrs.getInt(R.styleable.HighlightedCardView_highlightedCardButtonStyle, 3);
            this.imageStyle = styledAttrs.getInt(R.styleable.HighlightedCardView_highlightedCardImageStyle, 2);
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardCloseButton);
            if (object != null) {
                Object it8 = object;
                boolean bl8 = false;
                this.setCloseButton((CharSequence)it8);
            }
            n = styledAttrs.getResourceId(R.styleable.HighlightedCardView_highlightedCardImage, 0);
            int it9 = ((Number)n).intValue();
            boolean bl9 = false;
            Object object3 = object = it9 != 0 ? n : null;
            if (object != null) {
                int it10 = ((Number)object).intValue();
                boolean bl10 = false;
                n = AppCompatResources.getDrawable((Context)context, (int)it10);
                if (n != null) {
                    Integer it11 = n;
                    boolean bl11 = false;
                    this.setImage((Drawable)it11);
                }
            }
            styledAttrs.recycle();
        }
        this.reload();
    }

    public /* synthetic */ HighlightedCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setButtonOnClick(@Nullable View.OnClickListener onClickListener) {
        block0: {
            this.buttonClickListener = onClickListener;
            Button button = this.button;
            if (button == null) break block0;
            button.setOnClickListener(onClickListener);
        }
    }

    public final void setTitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.titleTextView.setText(text);
    }

    public final void setTitle(@StringRes int textRes) {
        String string2 = this.getContext().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(textRes)");
        this.setTitle(string2);
    }

    public final void setContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.contentTextView.setText(text);
    }

    public final void setContent(@StringRes int textRes) {
        String string2 = this.getContext().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(textRes)");
        this.setContent(string2);
    }

    public final void setButtonText(@Nullable CharSequence text) {
        CharSequence charSequence = text;
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            this.buttonText = ((Object)it).toString();
        }
        this.configureButton();
    }

    public final void setButtonText(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setButtonText(this.getContext().getString(it));
        }
    }

    public final void setButtonStyle(int buttonStyle) {
        this.buttonStyle = buttonStyle;
        this.configureButton();
    }

    public final void setInverse(boolean inverse) {
        this.isInverse = inverse;
        this.reload();
    }

    public final void setImage(@DrawableRes int imageRes) {
        this.image.setImageResource(imageRes);
        this.configureImage();
    }

    public final void setImage(@NotNull Drawable imageRes) {
        Intrinsics.checkNotNullParameter((Object)imageRes, (String)"imageRes");
        this.image.setImageDrawable(imageRes);
        this.configureImage();
    }

    public final void setImageStyle(int imageStyle) {
        this.imageStyle = imageStyle;
        this.configureImage();
    }

    public final void setCustomBackground(@DrawableRes int imageRes) {
        Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageRes);
        Intrinsics.checkNotNull((Object)drawable2);
        this.setCustomBackground(drawable2);
    }

    public final void setCustomBackground(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Resources resources = this.getResources();
        Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"drawable as BitmapDrawable).bitmap");
        BitmapDrawable roundedCornerBitmap = new BitmapDrawable(resources, this.getRoundedCornerBitmap(bitmap));
        this.container.setBackground((Drawable)roundedCornerBitmap);
        this.hasCustomBackground = true;
    }

    public final void disableCustomBackground() {
        this.hasCustomBackground = false;
        this.configureBackground();
    }

    public final void setCloseButton(@NotNull CharSequence buttonContentDescription) {
        Intrinsics.checkNotNullParameter((Object)buttonContentDescription, (String)"buttonContentDescription");
        this.closeButton.setContentDescription(buttonContentDescription);
        ViewUtilsKt.show((View)this.closeButton);
        boolean bl = this.showCloseButtonBackground();
        if (bl) {
            ViewUtilsKt.show(this.closeButtonBackground);
        } else if (!bl) {
            ViewUtilsKt.hide(this.closeButtonBackground);
        }
    }

    private final boolean showCloseButtonBackground() {
        return this.isInverse || this.hasCustomBackground || this.imageStyle == 1;
    }

    public final void setCloseButtonOnClick(@NotNull View.OnClickListener onButtonClick) {
        Intrinsics.checkNotNullParameter((Object)onButtonClick, (String)"onButtonClick");
        this.closeButton.setOnClickListener(onButtonClick);
    }

    public final void removeCloseButton() {
        ViewUtilsKt.hide((View)this.closeButton);
        ViewUtilsKt.hide(this.closeButtonBackground);
    }

    private final void configureColors() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int primaryColor = ColorUtilsKt.getThemeColor(context, this.isInverse ? R.attr.colorTextPrimaryInverse : R.attr.colorTextPrimary);
        this.titleTextView.setTextColor(primaryColor);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int secondaryColor = ColorUtilsKt.getThemeColor(context2, this.isInverse ? R.attr.colorTextSecondaryInverse : R.attr.colorTextSecondary);
        this.contentTextView.setTextColor(secondaryColor);
    }

    private final void configureBackground() {
        if (!this.hasCustomBackground) {
            int backgroundDrawable = this.isInverse ? R.drawable.highlighted_card_background_inverse : R.drawable.highlighted_card_background;
            this.container.setBackground(AppCompatResources.getDrawable((Context)this.getContext(), (int)backgroundDrawable));
        }
    }

    private final void configureImage() {
        switch (this.imageStyle) {
            case 0: {
                this.showFitImage();
                break;
            }
            case 1: {
                this.showFillImage();
                break;
            }
            case 2: {
                this.hideImage();
            }
        }
    }

    private final void showFillImage() {
        this.image.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.image.setVisibility(0);
    }

    private final void showFitImage() {
        this.image.setScaleType(ImageView.ScaleType.FIT_END);
        this.image.setVisibility(0);
    }

    private final void hideImage() {
        this.image.setVisibility(8);
    }

    private final void reload() {
        this.configureButton();
        this.configureBackground();
        this.configureColors();
        this.configureImage();
    }

    private final void configureButton() {
        Button button;
        Button button2;
        switch (this.buttonStyle) {
            case 0: {
                button2 = (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_primary_inverse : R.id.highlighted_card_button_primary);
                break;
            }
            case 1: {
                button2 = (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_secondary_inverse : R.id.highlighted_card_button_secondary);
                break;
            }
            case 2: {
                button2 = (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_link_inverse : R.id.highlighted_card_button_link);
                break;
            }
            default: {
                button2 = null;
            }
        }
        Button button3 = button = button2;
        if (button3 != null) {
            button3.setOnClickListener(this.buttonClickListener);
        }
        Button button4 = button;
        if (button4 != null) {
            button4.setText((CharSequence)this.buttonText);
        }
        if (!Intrinsics.areEqual((Object)this.button, (Object)button)) {
            Button button5 = button;
            if (button5 != null) {
                button5.setVisibility(0);
            }
            Button button6 = this.button;
            if (button6 != null) {
                button6.setVisibility(8);
            }
            this.button = button;
        }
    }

    private final Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int color = ColorUtilsKt.getThemeColor(context, R.attr.colorBorder);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = this.getResources().getDimension(R.dimen.highlighted_card_corner_radius);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$ButtonStyle;", "", "com.telefonica.mistica"})
    public static @interface ButtonStyle {
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$ImageStyle;", "", "com.telefonica.mistica"})
    public static @interface ImageStyle {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$Companion;", "", "()V", "BUTTON_STYLE_LINK", "", "BUTTON_STYLE_NO_BUTTON", "BUTTON_STYLE_PRIMARY", "BUTTON_STYLE_SECONDARY", "IMAGE_STYLE_MODE_FILL", "IMAGE_STYLE_MODE_FIT", "IMAGE_STYLE_NO_IMAGE", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

