/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.screen.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.PathInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.RawRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.telefonica.mistica.R;
import com.telefonica.mistica.button.ProgressButton;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbackType;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbacksKt;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ResUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import com.telefonica.mistica.util.background.GradientBackgroundFactory;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0007\u0018\u0000 b2\u00020\u0001:\u0002bcB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020.H\u0002J\b\u00100\u001a\u00020.H\u0002J\b\u00101\u001a\u00020.H\u0002J\b\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020.H\u0002J&\u00103\u001a\u00020.2\b\b\u0001\u00104\u001a\u00020\t2\b\b\u0001\u00105\u001a\u00020\t2\b\b\u0001\u00106\u001a\u00020\tH\u0002J/\u00107\u001a\u00020.2\n\b\u0001\u00108\u001a\u0004\u0018\u00010\t2\n\b\u0001\u00109\u001a\u0004\u0018\u00010\t2\b\b\u0001\u00106\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020.H\u0002J\b\u0010<\u001a\u00020.H\u0002J\b\u0010=\u001a\u00020.H\u0002J\u0012\u0010>\u001a\u00020 2\b\b\u0001\u0010?\u001a\u00020\tH\u0002J\b\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u0006\u0010F\u001a\u00020\tJ\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J&\u0010J\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\b\u0010K\u001a\u00020 H\u0002J\b\u0010L\u001a\u00020.H\u0014J\b\u0010M\u001a\u00020.H\u0002J\u000e\u0010N\u001a\u00020.2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010O\u001a\u00020.2\b\b\u0001\u0010P\u001a\u00020\tJ\u000e\u0010Q\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010R\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010T\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010U\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010V\u001a\u00020.2\u0006\u0010W\u001a\u00020 J\u000e\u0010X\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010Y\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010Z\u001a\u00020.2\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010[\u001a\u00020.2\u0006\u0010,\u001a\u00020\tJ\u000e\u0010\\\u001a\u00020.2\u0006\u0010]\u001a\u00020\u001aJ\u000e\u0010^\u001a\u00020.2\u0006\u0010!\u001a\u00020 J\u000e\u0010_\u001a\u00020.2\u0006\u0010]\u001a\u00020\u001aJ\u000e\u0010`\u001a\u00020.2\u0006\u0010a\u001a\u00020 R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "buttonsContainer", "Landroid/widget/LinearLayout;", "customAnimation", "Ljava/lang/Integer;", "customContentContainer", "Landroid/widget/FrameLayout;", "customContentLayout", "customIcon", "errorReference", "Landroid/widget/TextView;", "errorReferenceText", "", "firstButton", "Lcom/telefonica/mistica/button/ProgressButton;", "firstButtonClickListener", "Landroid/view/View$OnClickListener;", "firstButtonLoadingText", "firstButtonText", "icon", "Lcom/airbnb/lottie/LottieAnimationView;", "isIconAnimated", "", "isLoading", "secondButton", "Landroid/widget/Button;", "secondButtonAsLink", "secondButtonClickListener", "secondButtonText", "shouldAnimateOnAttachedToWindow", "subtitle", "subtitleText", "title", "titleText", "type", "animateViews", "", "animateViewsOnFirstLayout", "configureBackground", "configureButtons", "configureCustomContentView", "configureIcon", "animationAttr", "imageAttr", "colorAttr", "configureIconAsResource", "animationResource", "imageResource", "(Ljava/lang/Integer;Ljava/lang/Integer;I)V", "configureTexts", "configureView", "executeHapticFeedback", "getBooleanThemeRes", "attributeRes", "getCubicBezierInterpolator", "Landroid/view/animation/PathInterpolator;", "getFadeInAnim", "Landroid/animation/ObjectAnimator;", "view", "Landroid/view/View;", "getFeedbackType", "getFirstButtonText", "", "getTranslationYAnim", "init", "isInversePresentation", "onAttachedToWindow", "performHapticFeedback", "setCustomAnimation", "setCustomContentLayout", "layout", "setCustomIcon", "setFeedbackErrorReference", "text", "setFeedbackFirstButtonLoadingText", "setFeedbackFirstButtonText", "setFeedbackSecondButtonAsLink", "asLink", "setFeedbackSecondButtonText", "setFeedbackSubtitle", "setFeedbackTitle", "setFeedbackType", "setFirstButtonOnClick", "clickListener", "setIsLoading", "setSecondButtonOnClick", "setShouldAnimateOnAttached", "animate", "Companion", "FeedbackType", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFeedbackScreenView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedbackScreenView.kt\ncom/telefonica/mistica/feedback/screen/view/FeedbackScreenView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1#2:472\n*E\n"})
public final class FeedbackScreenView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private LottieAnimationView icon;
    private TextView title;
    private TextView subtitle;
    private TextView errorReference;
    private FrameLayout customContentContainer;
    private LinearLayout buttonsContainer;
    private ProgressButton firstButton;
    private Button secondButton;
    private int type;
    @NotNull
    private CharSequence titleText;
    @NotNull
    private CharSequence subtitleText;
    @NotNull
    private CharSequence errorReferenceText;
    private boolean isLoading;
    @LayoutRes
    @Nullable
    private Integer customContentLayout;
    @NotNull
    private CharSequence firstButtonText;
    @NotNull
    private CharSequence firstButtonLoadingText;
    @NotNull
    private CharSequence secondButtonText;
    private boolean secondButtonAsLink;
    private boolean isIconAnimated;
    private boolean shouldAnimateOnAttachedToWindow;
    @Nullable
    private View.OnClickListener firstButtonClickListener;
    @Nullable
    private View.OnClickListener secondButtonClickListener;
    @RawRes
    @Nullable
    private Integer customAnimation;
    @DrawableRes
    @Nullable
    private Integer customIcon;
    public static final int $stable = 8;
    public static final int TYPE_SUCCESS = 0;
    public static final int TYPE_ERROR = 1;
    public static final int TYPE_INFO = 2;
    public static final long TEXTS_ANIMATION_DURATION = 800L;
    public static final long TEXTS_ANIMATION_DELAY = 200L;
    public static final long HAPTIC_FEEDBACK_DEFAULT_DELAY = 450L;
    public static final long HAPTIC_FEEDBACK_ERROR_DELAY = 500L;

    public FeedbackScreenView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        FeedbackScreenView.init$default(this, context, null, 0, 6, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        FeedbackScreenView.init$default(this, context, attrs, 0, 4, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.errorReferenceText = "";
        this.firstButtonText = "";
        this.firstButtonLoadingText = "";
        this.secondButtonText = "";
        this.shouldAnimateOnAttachedToWindow = true;
        this.init(context, attrs, defStyleAttr);
    }

    public final void setFeedbackType(int type) {
        this.type = type;
        this.configureView();
    }

    public final int getFeedbackType() {
        return this.type;
    }

    public final void setFeedbackTitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.titleText = text;
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            textView = null;
        }
        textView.setText(text);
    }

    public final void setFeedbackSubtitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.subtitleText = text;
        TextView textView = this.subtitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
            textView = null;
        }
        textView.setText(text);
    }

    public final void setFeedbackErrorReference(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.errorReferenceText = text;
        TextView textView = this.errorReference;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
            textView = null;
        }
        textView.setText(text);
        TextView textView2 = this.errorReference;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
            textView2 = null;
        }
        textView2.setVisibility(!StringsKt.isBlank((CharSequence)text) && this.type == 1 ? 0 : 8);
    }

    public final void setCustomContentLayout(@LayoutRes int layout2) {
        this.customContentLayout = layout2;
        this.configureCustomContentView();
    }

    public final void setShouldAnimateOnAttached(boolean animate) {
        this.shouldAnimateOnAttachedToWindow = animate;
    }

    public final void setFeedbackFirstButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.firstButtonText = text;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setText(text);
        ProgressButton progressButton2 = this.firstButton;
        if (progressButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton2 = null;
        }
        progressButton2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackFirstButtonLoadingText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.firstButtonLoadingText = text;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setLoadingText(text);
    }

    public final void setFeedbackSecondButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.secondButtonText = text;
        Button button = this.secondButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
            button = null;
        }
        button.setText(text);
        Button button2 = this.secondButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
            button2 = null;
        }
        button2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackSecondButtonAsLink(boolean asLink) {
        this.secondButtonAsLink = asLink;
        this.configureButtons();
    }

    public final void setFirstButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.firstButtonClickListener = clickListener;
        if (this.firstButton != null) {
            ProgressButton progressButton = this.firstButton;
            if (progressButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
                progressButton = null;
            }
            progressButton.setOnClickListener(clickListener);
        }
    }

    public final void setSecondButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.secondButtonClickListener = clickListener;
        if (this.secondButton != null) {
            Button button = this.secondButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
                button = null;
            }
            button.setOnClickListener(clickListener);
        }
    }

    @NotNull
    public final String getFirstButtonText() {
        return ((Object)this.firstButtonText).toString();
    }

    public final void setIsLoading(boolean isLoading) {
        boolean wasLoading = this.isLoading;
        this.isLoading = isLoading;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            progressButton = null;
        }
        progressButton.setIsLoading(isLoading);
        if (wasLoading && !isLoading) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.playAnimation();
            this.executeHapticFeedback();
        }
    }

    public final void setCustomIcon(int customIcon) {
        this.customIcon = customIcon;
    }

    public final void setCustomAnimation(int customAnimation) {
        this.customAnimation = customAnimation;
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.screen_feedback, (ViewGroup)this, true);
        if (attrs != null) {
            int it;
            CharSequence it2;
            Resources.Theme theme = context.getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.FeedbackScreen, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"theme.obtainStyledAttrib\u2026kScreen, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            this.type = styledAttrs.getInteger(R.styleable.FeedbackScreen_feedbackType, 2);
            CharSequence charSequence = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackTitle);
            if (charSequence != null) {
                it2 = charSequence;
                boolean bl = false;
                this.titleText = it2;
            }
            Object object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSubtitle);
            if (object != null) {
                it2 = object;
                boolean bl = false;
                this.subtitleText = it2;
            }
            CharSequence charSequence2 = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackErrorReference);
            if (charSequence2 != null) {
                it2 = charSequence2;
                boolean bl = false;
                this.errorReferenceText = it2;
            }
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_feedbackCustomContentLayout, 0);
            int n = ((Number)object).intValue();
            FeedbackScreenView feedbackScreenView = this;
            boolean bl = false;
            boolean bl2 = it != 0;
            feedbackScreenView.customContentLayout = bl2 ? object : null;
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackFirstButtonText);
            if (object != null) {
                Object it3 = object;
                boolean bl3 = false;
                this.firstButtonText = it3;
            }
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackFirstButtonLoadingText);
            if (object != null) {
                Object it4 = object;
                boolean bl4 = false;
                this.firstButtonLoadingText = it4;
            }
            object = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSecondButtonText);
            if (object != null) {
                Object it5 = object;
                boolean bl5 = false;
                this.secondButtonText = it5;
            }
            this.secondButtonAsLink = styledAttrs.getBoolean(R.styleable.FeedbackScreen_feedbackSecondButtonAsLink, false);
            this.shouldAnimateOnAttachedToWindow = styledAttrs.getBoolean(R.styleable.FeedbackScreen_shouldAnimateOnAttached, true);
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_customAnimation, 0);
            it = ((Number)object).intValue();
            boolean bl6 = false;
            Object it22 = it != 0 ? object : null;
            boolean bl7 = false;
            this.customAnimation = it22;
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_customIcon, 0);
            it = ((Number)object).intValue();
            boolean bl8 = false;
            Object it3 = it != 0 ? object : null;
            boolean bl9 = false;
            this.customIcon = it3;
            styledAttrs.recycle();
        }
        View view = this.findViewById(R.id.icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.icon)");
        this.icon = (LottieAnimationView)view;
        View view2 = this.findViewById(R.id.title);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.title)");
        this.title = (TextView)view2;
        View view3 = this.findViewById(R.id.subtitle);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.subtitle)");
        this.subtitle = (TextView)view3;
        View view4 = this.findViewById(R.id.error_reference);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.error_reference)");
        this.errorReference = (TextView)view4;
        View view5 = this.findViewById(R.id.custom_content);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.custom_content)");
        this.customContentContainer = (FrameLayout)view5;
        View view6 = this.findViewById(R.id.buttons_container);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.buttons_container)");
        this.buttonsContainer = (LinearLayout)view6;
        int buttonsLayout = this.isInversePresentation() ? R.layout.screen_feedback_buttons_inverse : R.layout.screen_feedback_buttons;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        LinearLayout linearLayout = this.buttonsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
            linearLayout = null;
        }
        View buttonsView = layoutInflater.inflate(buttonsLayout, (ViewGroup)linearLayout, true);
        View view7 = buttonsView.findViewById(R.id.first_button);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"buttonsView.findViewById(R.id.first_button)");
        this.firstButton = (ProgressButton)view7;
        View view8 = buttonsView.findViewById(this.secondButtonAsLink ? R.id.link_button : R.id.second_button);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"buttonsView.findViewById\u2026 else R.id.second_button)");
        this.secondButton = (Button)view8;
    }

    static /* synthetic */ void init$default(FeedbackScreenView feedbackScreenView, Context context, AttributeSet attributeSet, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        feedbackScreenView.init(context, attributeSet, n);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.configureView();
        this.animateViewsOnFirstLayout();
    }

    private final void configureView() {
        this.configureBackground();
        this.configureIcon();
        this.configureTexts();
        this.configureCustomContentView();
        this.configureButtons();
    }

    private final void configureBackground() {
        Drawable drawable2;
        if (this.type == 0) {
            if (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessWithGradient)) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                drawable2 = GradientBackgroundFactory.getBackground(context);
            } else if (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessInverse)) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackgroundBrand));
            } else {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackground));
            }
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackground));
        }
        Drawable it = drawable2;
        boolean bl = false;
        this.setBackground(it);
    }

    private final void configureIcon() {
        switch (this.type) {
            case 0: {
                this.configureIcon(R.attr.feedbackScreenSuccessAnimation, R.attr.feedbackScreenSuccessIcon, R.attr.colorInverse);
                break;
            }
            case 1: {
                this.configureIcon(R.attr.feedbackScreenErrorAnimation, R.attr.feedbackScreenErrorIcon, R.attr.colorError);
                break;
            }
            case 2: {
                Integer n;
                Integer n2 = this.customAnimation;
                if (n2 == null) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    n2 = ResUtilsKt.getThemeRes(context, R.attr.feedbackScreenInfoAnimation, false);
                }
                if ((n = this.customIcon) == null) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    n = ResUtilsKt.getThemeRes(context, R.attr.feedbackScreenInfoIcon, false);
                }
                this.configureIconAsResource(n2, n, R.attr.colorBrand);
            }
        }
    }

    private final void configureIcon(@AttrRes int animationAttr, @AttrRes int imageAttr, @AttrRes int colorAttr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Integer animationResource = ResUtilsKt.getThemeRes(context, animationAttr, false);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        Integer imageResource = ResUtilsKt.getThemeRes(context2, imageAttr, false);
        this.configureIconAsResource(animationResource, imageResource, colorAttr);
    }

    private final void configureIconAsResource(@RawRes Integer animationResource, @DrawableRes Integer imageResource, @AttrRes int colorAttr) {
        if (animationResource != null) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setAnimation(animationResource.intValue());
            LottieAnimationView lottieAnimationView2 = this.icon;
            if (lottieAnimationView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView2 = null;
            }
            String[] stringArray = new String[]{"**"};
            lottieAnimationView2.addValueCallback(new KeyPath(stringArray), (Object)LottieProperty.COLOR_FILTER, arg_0 -> FeedbackScreenView.configureIconAsResource$lambda$12(this, colorAttr, arg_0));
            LottieAnimationView lottieAnimationView3 = this.icon;
            if (lottieAnimationView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView3 = null;
            }
            lottieAnimationView3.setVisibility(0);
        } else if (imageResource != null) {
            Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageResource);
            Intrinsics.checkNotNull((Object)drawable2);
            Drawable unwrappedDrawable = drawable2;
            Drawable drawable3 = DrawableCompat.wrap((Drawable)unwrappedDrawable);
            Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"wrap(unwrappedDrawable)");
            Drawable drawable4 = drawable3;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            DrawableCompat.setTint((Drawable)drawable4, (int)ColorUtilsKt.getThemeColor(context, colorAttr));
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setImageDrawable(drawable4);
            LottieAnimationView lottieAnimationView4 = this.icon;
            if (lottieAnimationView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView4 = null;
            }
            lottieAnimationView4.setVisibility(0);
        } else {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.setVisibility(8);
        }
        this.isIconAnimated = animationResource != null;
        LottieAnimationView lottieAnimationView = this.icon;
        if (lottieAnimationView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            lottieAnimationView = null;
        }
        lottieAnimationView.addOnLayoutChangeListener((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> FeedbackScreenView.configureIconAsResource$lambda$13(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8));
    }

    private final void configureTexts() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int titleTextColor = ColorUtilsKt.getThemeColor(context, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextPrimary);
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            textView = null;
        }
        textView.setTextColor(titleTextColor);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int subtitleTextColor = ColorUtilsKt.getThemeColor(context2, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextSecondary);
        TextView textView2 = this.subtitle;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
            textView2 = null;
        }
        textView2.setTextColor(subtitleTextColor);
        this.setFeedbackTitle(this.titleText);
        this.setFeedbackSubtitle(this.subtitleText);
        this.setFeedbackErrorReference(this.errorReferenceText);
    }

    private final void configureCustomContentView() {
        block3: {
            FrameLayout frameLayout = this.customContentContainer;
            if (frameLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout = null;
            }
            frameLayout.removeAllViews();
            Integer n = this.customContentLayout;
            if (n == null) break block3;
            int it = ((Number)n).intValue();
            boolean bl = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            FrameLayout frameLayout2 = this.customContentContainer;
            if (frameLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout2 = null;
            }
            layoutInflater.inflate(it, (ViewGroup)frameLayout2, false);
            FrameLayout frameLayout3 = this.customContentContainer;
            if (frameLayout3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout3 = null;
            }
            frameLayout3.setVisibility(0);
        }
    }

    private final void configureButtons() {
        block4: {
            ProgressButton progressButton;
            View.OnClickListener it;
            LinearLayout linearLayout = this.buttonsContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
                linearLayout = null;
            }
            linearLayout.removeAllViews();
            int layout2 = this.isInversePresentation() ? R.layout.screen_feedback_buttons_inverse : R.layout.screen_feedback_buttons;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            LinearLayout linearLayout2 = this.buttonsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
                linearLayout2 = null;
            }
            layoutInflater.inflate(layout2, (ViewGroup)linearLayout2, true);
            View view = this.findViewById(R.id.first_button);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.first_button)");
            this.firstButton = (ProgressButton)view;
            this.setFeedbackFirstButtonText(this.firstButtonText);
            this.setFeedbackFirstButtonLoadingText(this.firstButtonLoadingText);
            View.OnClickListener onClickListener = this.firstButtonClickListener;
            if (onClickListener != null) {
                it = onClickListener;
                boolean bl = false;
                this.setFirstButtonOnClick(it);
            }
            if ((progressButton = this.firstButton) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
                progressButton = null;
            }
            progressButton.setIsLoading(this.isLoading);
            View view2 = this.findViewById(this.secondButtonAsLink ? R.id.link_button : R.id.second_button);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(if (secondB\u2026 else R.id.second_button)");
            this.secondButton = (Button)view2;
            this.setFeedbackSecondButtonText(this.secondButtonText);
            View.OnClickListener onClickListener2 = this.secondButtonClickListener;
            if (onClickListener2 == null) break block4;
            it = onClickListener2;
            boolean bl = false;
            this.setSecondButtonOnClick(it);
        }
    }

    private final void animateViewsOnFirstLayout() {
        if (this.shouldAnimateOnAttachedToWindow) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
                final /* synthetic */ FeedbackScreenView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onGlobalLayout() {
                    this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    this.this$0.animateViews();
                }
            });
        }
    }

    public final void animateViews() {
        if (this.isIconAnimated) {
            AnimatorSet animatorSet;
            AnimatorSet $this$animateViews_u24lambda_u2417 = animatorSet = new AnimatorSet();
            boolean bl = false;
            Animator[] animatorArray = new Animator[8];
            TextView textView = this.title;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                textView = null;
            }
            animatorArray[0] = this.getFadeInAnim((View)textView);
            TextView textView2 = this.subtitle;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                textView2 = null;
            }
            animatorArray[1] = this.getFadeInAnim((View)textView2);
            FrameLayout frameLayout = this.customContentContainer;
            if (frameLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout = null;
            }
            animatorArray[2] = this.getFadeInAnim((View)frameLayout);
            TextView textView3 = this.errorReference;
            if (textView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                textView3 = null;
            }
            animatorArray[3] = this.getFadeInAnim((View)textView3);
            TextView textView4 = this.title;
            if (textView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                textView4 = null;
            }
            animatorArray[4] = this.getTranslationYAnim((View)textView4);
            TextView textView5 = this.subtitle;
            if (textView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                textView5 = null;
            }
            animatorArray[5] = this.getTranslationYAnim((View)textView5);
            FrameLayout frameLayout2 = this.customContentContainer;
            if (frameLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout2 = null;
            }
            animatorArray[6] = this.getTranslationYAnim((View)frameLayout2);
            TextView textView6 = this.errorReference;
            if (textView6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                textView6 = null;
            }
            animatorArray[7] = this.getTranslationYAnim((View)textView6);
            $this$animateViews_u24lambda_u2417.playTogether(animatorArray);
            $this$animateViews_u24lambda_u2417.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
            $this$animateViews_u24lambda_u2417.setDuration(800L);
            $this$animateViews_u24lambda_u2417.setStartDelay(200L);
            AnimatorSet animation = animatorSet;
            TextView textView7 = this.title;
            if (textView7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"title");
                textView7 = null;
            }
            textView7.setAlpha(0.0f);
            TextView textView8 = this.subtitle;
            if (textView8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
                textView8 = null;
            }
            textView8.setAlpha(0.0f);
            TextView textView9 = this.errorReference;
            if (textView9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"errorReference");
                textView9 = null;
            }
            textView9.setAlpha(0.0f);
            FrameLayout frameLayout3 = this.customContentContainer;
            if (frameLayout3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
                frameLayout3 = null;
            }
            frameLayout3.setAlpha(0.0f);
            animation.start();
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
                lottieAnimationView = null;
            }
            lottieAnimationView.playAnimation();
            this.executeHapticFeedback();
        }
    }

    private final void executeHapticFeedback() {
        this.postDelayed(() -> FeedbackScreenView.executeHapticFeedback$lambda$18(this), this.type == 1 ? 500L : 450L);
    }

    private final ObjectAnimator getTranslationYAnim(View view) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        float pixels = ViewUtilsKt.convertDpToPx(context, 20);
        float[] fArray = new float[]{pixels, 0.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])fArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(view, \"translationY\", pixels, 0F)");
        return objectAnimator;
    }

    private final ObjectAnimator getFadeInAnim(View view) {
        float[] fArray = new float[]{0.0f, 1.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])fArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ofFloat(view, \"alpha\", 0F, 1F)");
        return objectAnimator;
    }

    private final PathInterpolator getCubicBezierInterpolator() {
        return new PathInterpolator(0.215f, 0.61f, 0.355f, 1.0f);
    }

    private final void performHapticFeedback() {
        switch (this.type) {
            case 0: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.SUCCESS);
                break;
            }
            case 1: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.ERROR);
            }
        }
    }

    private final boolean isInversePresentation() {
        return this.type == 0 && (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessWithGradient) || this.getBooleanThemeRes(R.attr.feedbackScreenSuccessInverse));
    }

    private final boolean getBooleanThemeRes(@AttrRes int attributeRes) {
        boolean bl;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Integer n = ResUtilsKt.getThemeRes$default(context, attributeRes, false, 2, null);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final ColorFilter configureIconAsResource$lambda$12(FeedbackScreenView this$0, int $colorAttr, LottieFrameInfo it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return (ColorFilter)new PorterDuffColorFilter(ColorUtilsKt.getThemeColor(context, $colorAttr), PorterDuff.Mode.SRC_ATOP);
    }

    private static final void configureIconAsResource$lambda$13(FeedbackScreenView this$0, View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        LottieAnimationView lottieAnimationView;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        LottieAnimationView lottieAnimationView2 = this$0.icon;
        if (lottieAnimationView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            lottieAnimationView2 = null;
        }
        if ((lottieAnimationView = this$0.icon) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            lottieAnimationView = null;
        }
        float f = lottieAnimationView.getWidth();
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        lottieAnimationView2.setTranslationX(-(f - (float)ViewUtilsKt.convertDpToPx(context, 64)) / (float)2);
    }

    private static final void executeHapticFeedback$lambda$18(FeedbackScreenView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.performHapticFeedback();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$Companion;", "", "()V", "HAPTIC_FEEDBACK_DEFAULT_DELAY", "", "HAPTIC_FEEDBACK_ERROR_DELAY", "TEXTS_ANIMATION_DELAY", "TEXTS_ANIMATION_DURATION", "TYPE_ERROR", "", "TYPE_INFO", "TYPE_SUCCESS", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$FeedbackType;", "", "com.telefonica.mistica"})
    public static @interface FeedbackType {
    }
}

