/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.sheet;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.telefonica.mistica.R;
import com.telefonica.mistica.sheet.Children;
import com.telefonica.mistica.sheet.InternalOnSheetTapped;
import com.telefonica.mistica.sheet.SheetKt;
import com.telefonica.mistica.sheet.SheetModel;
import com.telefonica.mistica.sheet.onSheetTapped;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\fJ(\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/telefonica/mistica/sheet/SheetView;", "Lcom/google/android/material/bottomsheet/BottomSheetDialog;", "context", "Landroid/content/Context;", "sheetModel", "Lcom/telefonica/mistica/sheet/SheetModel;", "onSheetTapped", "Lcom/telefonica/mistica/sheet/onSheetTapped;", "onDismiss", "Lkotlin/Function0;", "", "onCancel", "(Landroid/content/Context;Lcom/telefonica/mistica/sheet/SheetModel;Lcom/telefonica/mistica/sheet/onSheetTapped;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "fillContent", "root", "Landroid/view/View;", "onSheetTappedWrapped", "Lcom/telefonica/mistica/sheet/InternalOnSheetTapped;", "fillData", "fillHeader", "setUpBehavior", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sheet.kt\ncom/telefonica/mistica/sheet/SheetView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1855#2,2:222\n*S KotlinDebug\n*F\n+ 1 Sheet.kt\ncom/telefonica/mistica/sheet/SheetView\n*L\n81#1:222,2\n*E\n"})
public class SheetView
extends BottomSheetDialog {
    @NotNull
    private final onSheetTapped onSheetTapped;
    @NotNull
    private final Function0<Unit> onDismiss;
    @NotNull
    private final Function0<Unit> onCancel;
    public static final int $stable = 8;

    public SheetView(@NotNull Context context, @NotNull SheetModel sheetModel, @NotNull onSheetTapped onSheetTapped2, @NotNull Function0<Unit> onDismiss2, @NotNull Function0<Unit> onCancel2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sheetModel, (String)"sheetModel");
        Intrinsics.checkNotNullParameter((Object)onSheetTapped2, (String)"onSheetTapped");
        Intrinsics.checkNotNullParameter(onDismiss2, (String)"onDismiss");
        Intrinsics.checkNotNullParameter(onCancel2, (String)"onCancel");
        super(context, R.style.SheetDialogTheme);
        this.onSheetTapped = onSheetTapped2;
        this.onDismiss = onDismiss2;
        this.onCancel = onCancel2;
        InternalOnSheetTapped onSheetTappedWrapped2 = new InternalOnSheetTapped(this){
            final /* synthetic */ SheetView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTapped(@NotNull String childrenId, @NotNull String itemId) {
                Intrinsics.checkNotNullParameter((Object)childrenId, (String)"childrenId");
                Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
                SheetView.access$getOnSheetTapped$p(this.this$0).onTapped(this.this$0, childrenId, itemId);
            }
        };
        View root = View.inflate((Context)this.getContext(), (int)R.layout.sheet_layout, null);
        this.setContentView(root);
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        this.setUpBehavior(root);
        this.fillData(root, sheetModel, context, onSheetTappedWrapped2);
    }

    public /* synthetic */ SheetView(Context context, SheetModel sheetModel, onSheetTapped onSheetTapped2, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function02 = 2.INSTANCE;
        }
        this(context, sheetModel, onSheetTapped2, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    private final void fillData(View root, SheetModel sheetModel, Context context, InternalOnSheetTapped onSheetTappedWrapped2) {
        this.fillHeader(root, sheetModel);
        this.fillContent(root, sheetModel, context, onSheetTappedWrapped2);
    }

    private final void fillHeader(View root, SheetModel sheetModel) {
        TextView title = (TextView)root.findViewById(R.id.title);
        TextView subtitle = (TextView)root.findViewById(R.id.subtitle);
        TextView description = (TextView)root.findViewById(R.id.description);
        Space titleSpace = (Space)root.findViewById(R.id.title_space);
        String titleText = sheetModel.getHeader().getTitle();
        String subtitleText = sheetModel.getHeader().getSubtitle();
        String descriptionText = sheetModel.getHeader().getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
        SheetKt.access$setTextOrHide(title, titleText);
        Intrinsics.checkNotNullExpressionValue((Object)titleSpace, (String)"titleSpace");
        SheetKt.access$setSpaceOrGone(titleSpace, titleText);
        Intrinsics.checkNotNullExpressionValue((Object)subtitle, (String)"subtitle");
        SheetKt.access$setTextOrHide(subtitle, subtitleText);
        Intrinsics.checkNotNullExpressionValue((Object)description, (String)"description");
        SheetKt.access$setTextOrHide(description, descriptionText);
    }

    private final void fillContent(View root, SheetModel sheetModel, Context context, InternalOnSheetTapped onSheetTappedWrapped2) {
        LinearLayout container = (LinearLayout)root.findViewById(R.id.container);
        List<Children> children = sheetModel.getContent();
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Children it = (Children)element$iv;
            boolean bl = false;
            container.addView(SheetKt.access$toView(it, context, onSheetTappedWrapped2));
        }
    }

    private final void setUpBehavior(View root) {
        ViewParent viewParent = root.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        ViewGroup.LayoutParams layoutParams = ((View)viewParent).getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.coordinatorlayout.widget.CoordinatorLayout.LayoutParams");
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)layoutParams;
        CoordinatorLayout.Behavior behavior = params.getBehavior();
        if (behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(this){
                final /* synthetic */ SheetView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onStateChanged(@NotNull View bottomSheet, int newState) {
                    Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                    if (newState == 5) {
                        this.this$0.dismiss();
                    }
                }

                public void onSlide(@NotNull View bottomSheet, float slideOffset) {
                    Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                }
            });
            Resources resources = this.getContext().getResources();
            if (resources != null && (resources = resources.getDisplayMetrics()) != null) {
                int height = resources.heightPixels;
                boolean bl = false;
                ((BottomSheetBehavior)behavior).setMaxHeight((int)((double)height * 0.7));
            }
        }
        this.setCanceledOnTouchOutside(true);
        this.setOnDismissListener(arg_0 -> SheetView.setUpBehavior$lambda$2(this, arg_0));
        this.setOnCancelListener(arg_0 -> SheetView.setUpBehavior$lambda$3(this, arg_0));
    }

    private static final void setUpBehavior$lambda$2(SheetView this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onDismiss.invoke();
    }

    private static final void setUpBehavior$lambda$3(SheetView this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onCancel.invoke();
    }

    public static final /* synthetic */ onSheetTapped access$getOnSheetTapped$p(SheetView $this) {
        return $this.onSheetTapped;
    }
}

