/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.tag;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textview.MaterialTextView;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0007J\u001c\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0019*\u00020\u0007H\u0002R\u0014\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/telefonica/mistica/tag/TagView;", "Lcom/google/android/material/textview/MaterialTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentStyle", "getCurrentStyle$annotations", "()V", "setTagIcon", "", "drawable", "Landroid/graphics/drawable/Drawable;", "setTagStyle", "style", "icon", "setText", "text", "", "type", "Landroid/widget/TextView$BufferType;", "getStyle", "Lkotlin/Pair;", "Companion", "com.telefonica.mistica"})
@StabilityInferred(parameters=0)
public final class TagView
extends MaterialTextView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentStyle;
    public static final int $stable = 8;
    public static final int TYPE_PROMO = 0;
    public static final int TYPE_ACTIVE = 1;
    public static final int TYPE_INACTIVE = 2;
    public static final int TYPE_SUCCESS = 3;
    public static final int TYPE_WARNING = 4;
    public static final int TYPE_ERROR = 5;
    public static final int TYPE_INVERSE = 6;

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((Context)new ContextThemeWrapper(context, R.style.AppTheme_Widgets_Tag), attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TagView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026TagView, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            int style2 = styledAttrs.getInt(R.styleable.TagView_tagStyle, this.currentStyle);
            Drawable icon = styledAttrs.getDrawable(R.styleable.TagView_tagIcon);
            this.setTagStyle(style2, icon);
            styledAttrs.recycle();
        }
    }

    public /* synthetic */ TagView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private static /* synthetic */ void getCurrentStyle$annotations() {
    }

    @JvmOverloads
    public final void setTagStyle(int style2, @Nullable Drawable icon) {
        this.currentStyle = style2;
        Pair<Integer, Integer> pair = this.getStyle(style2);
        int tagBackground = ((Number)pair.component1()).intValue();
        int tagTextColor = ((Number)pair.component2()).intValue();
        Drawable drawable2 = this.getBackground();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        drawable2.setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ColorUtilsKt.getThemeColor(context, tagBackground), (BlendModeCompat)BlendModeCompat.SRC_IN));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setTextColor(ColorUtilsKt.getThemeColor(context2, tagTextColor));
        if (icon != null) {
            this.setTagIcon(icon);
        }
    }

    public static /* synthetic */ void setTagStyle$default(TagView tagView, int n, Drawable drawable2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            drawable2 = null;
        }
        tagView.setTagStyle(n, drawable2);
    }

    public final void setTagIcon(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Drawable drawable3 = DrawableCompat.wrap((Drawable)drawable2);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        DrawableCompat.setTint((Drawable)drawable3, (int)ColorUtilsKt.getThemeColor(context, ((Number)this.getStyle(this.currentStyle).getSecond()).intValue()));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int iconSize = ViewUtilsKt.convertDpToPx(context2, 16);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        int fixedMargin = ViewUtilsKt.convertDpToPx(context3, 1.5f);
        drawable2.setBounds(0, fixedMargin, iconSize, iconSize + fixedMargin);
        this.setCompoundDrawablesRelative(drawable2, null, null, null);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
        this.setCompoundDrawablePadding(ViewUtilsKt.convertDpToPx(context4, 4));
        Context context5 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"context");
        this.setPadding(ViewUtilsKt.convertDpToPx(context5, 8), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    public void setText(@Nullable CharSequence text, @Nullable TextView.BufferType type) {
        CharSequence charSequence = text;
        super.setText((CharSequence)(charSequence != null ? ((Object)charSequence).toString() : null), type);
    }

    private final Pair<Integer, Integer> getStyle(int $this$getStyle) {
        Pair pair;
        switch ($this$getStyle) {
            case 0: {
                pair = TuplesKt.to((Object)R.attr.colorPromoLow, (Object)R.attr.colorPromoHigh);
                break;
            }
            case 1: {
                pair = TuplesKt.to((Object)R.attr.colorBrandLow, (Object)R.attr.colorBrand);
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)R.attr.colorNeutralLow, (Object)R.attr.colorNeutralMedium);
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)R.attr.colorSuccessLow, (Object)R.attr.colorSuccessHigh);
                break;
            }
            case 4: {
                pair = TuplesKt.to((Object)R.attr.colorWarningLow, (Object)R.attr.colorWarningHigh);
                break;
            }
            case 5: {
                pair = TuplesKt.to((Object)R.attr.colorErrorLow, (Object)R.attr.colorErrorHigh);
                break;
            }
            case 6: {
                pair = TuplesKt.to((Object)R.attr.colorInverse, (Object)R.attr.colorBrand);
                break;
            }
            default: {
                pair = TuplesKt.to((Object)R.attr.colorPromoLow, (Object)R.attr.colorPromoHigh);
            }
        }
        return pair;
    }

    @JvmOverloads
    public TagView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TagView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @JvmOverloads
    public final void setTagStyle(int style2) {
        TagView.setTagStyle$default(this, style2, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/telefonica/mistica/tag/TagView$Companion;", "", "()V", "TYPE_ACTIVE", "", "TYPE_ERROR", "TYPE_INACTIVE", "TYPE_INVERSE", "TYPE_PROMO", "TYPE_SUCCESS", "TYPE_WARNING", "com.telefonica.mistica"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

