/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.AccessPointRule;
import telegram4j.tl.IpPort;
import telegram4j.tl.api.TlObject;

public final class ImmutableAccessPointRule
implements AccessPointRule {
    private final int identifier;
    private final String phonePrefixRules;
    private final int dcId;
    private final List<IpPort> ips;

    private ImmutableAccessPointRule(String phonePrefixRules, int dcId) {
        this.phonePrefixRules = Objects.requireNonNull(phonePrefixRules, "phonePrefixRules");
        this.dcId = dcId;
        this.ips = Collections.emptyList();
        this.identifier = AccessPointRule.super.identifier();
    }

    private ImmutableAccessPointRule(Builder builder) {
        this.phonePrefixRules = builder.phonePrefixRules;
        this.dcId = builder.dcId;
        this.ips = ImmutableAccessPointRule.createUnmodifiableList(true, builder.ips);
        this.identifier = builder.identifierIsSet() ? builder.identifier : AccessPointRule.super.identifier();
    }

    private ImmutableAccessPointRule(int identifier, String phonePrefixRules, int dcId, List<IpPort> ips) {
        this.identifier = identifier;
        this.phonePrefixRules = phonePrefixRules;
        this.dcId = dcId;
        this.ips = ips;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phonePrefixRules() {
        return this.phonePrefixRules;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public List<IpPort> ips() {
        return this.ips;
    }

    public final ImmutableAccessPointRule withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAccessPointRule(value, this.phonePrefixRules, this.dcId, this.ips);
    }

    public final ImmutableAccessPointRule withPhonePrefixRules(String value) {
        String newValue = Objects.requireNonNull(value, "phonePrefixRules");
        if (this.phonePrefixRules.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessPointRule(this.identifier, newValue, this.dcId, this.ips);
    }

    public final ImmutableAccessPointRule withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableAccessPointRule(this.identifier, this.phonePrefixRules, value, this.ips);
    }

    public final ImmutableAccessPointRule withIps(IpPort ... elements) {
        List<IpPort> newValue = ImmutableAccessPointRule.createUnmodifiableList(false, ImmutableAccessPointRule.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAccessPointRule(this.identifier, this.phonePrefixRules, this.dcId, newValue);
    }

    public final ImmutableAccessPointRule withIps(Iterable<? extends IpPort> elements) {
        if (this.ips == elements) {
            return this;
        }
        List<IpPort> newValue = ImmutableAccessPointRule.createUnmodifiableList(false, ImmutableAccessPointRule.createSafeList(elements, true, false));
        return new ImmutableAccessPointRule(this.identifier, this.phonePrefixRules, this.dcId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessPointRule && this.equalTo(0, (ImmutableAccessPointRule)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessPointRule another) {
        return this.identifier == another.identifier && this.phonePrefixRules.equals(another.phonePrefixRules) && this.dcId == another.dcId && this.ips.equals(another.ips);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phonePrefixRules.hashCode();
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.ips.hashCode();
        return h;
    }

    public String toString() {
        return "AccessPointRule{identifier=" + this.identifier + ", phonePrefixRules=" + this.phonePrefixRules + ", dcId=" + this.dcId + ", ips=" + this.ips + "}";
    }

    public static ImmutableAccessPointRule of(String phonePrefixRules, int dcId) {
        return new ImmutableAccessPointRule(phonePrefixRules, dcId);
    }

    public static ImmutableAccessPointRule copyOf(AccessPointRule instance) {
        if (instance instanceof ImmutableAccessPointRule) {
            return (ImmutableAccessPointRule)instance;
        }
        return ImmutableAccessPointRule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_PREFIX_RULES = 1L;
        private static final long INIT_BIT_DC_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phonePrefixRules;
        private int dcId;
        private List<IpPort> ips = new ArrayList<IpPort>();

        private Builder() {
        }

        public final Builder from(AccessPointRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AccessPointRule instance;
            long bits = 0L;
            if (object instanceof AccessPointRule) {
                instance = (AccessPointRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phonePrefixRules(instance.phonePrefixRules());
                this.dcId(instance.dcId());
                this.addAllIps(instance.ips());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phonePrefixRules(String phonePrefixRules) {
            this.phonePrefixRules = Objects.requireNonNull(phonePrefixRules, "phonePrefixRules");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addIp(IpPort element) {
            this.ips.add(Objects.requireNonNull(element, "ips element"));
            return this;
        }

        public final Builder addIps(IpPort ... elements) {
            for (IpPort element : elements) {
                this.ips.add(Objects.requireNonNull(element, "ips element"));
            }
            return this;
        }

        public final Builder ips(Iterable<? extends IpPort> elements) {
            this.ips.clear();
            return this.addAllIps(elements);
        }

        public final Builder addAllIps(Iterable<? extends IpPort> elements) {
            for (IpPort ipPort : elements) {
                this.ips.add(Objects.requireNonNull(ipPort, "ips element"));
            }
            return this;
        }

        public ImmutableAccessPointRule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccessPointRule(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phonePrefixRules");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build AccessPointRule, some of required attributes are not set " + attributes;
        }
    }
}

