/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AccountDaysTTL;
import telegram4j.tl.api.TlObject;

public final class ImmutableAccountDaysTTL
implements AccountDaysTTL {
    private final int identifier;
    private final int days;

    private ImmutableAccountDaysTTL(int days) {
        this.days = days;
        this.identifier = AccountDaysTTL.super.identifier();
    }

    private ImmutableAccountDaysTTL(Builder builder) {
        this.days = builder.days;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AccountDaysTTL.super.identifier();
    }

    private ImmutableAccountDaysTTL(int identifier, int days) {
        this.identifier = identifier;
        this.days = days;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int days() {
        return this.days;
    }

    public final ImmutableAccountDaysTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAccountDaysTTL(value, this.days);
    }

    public final ImmutableAccountDaysTTL withDays(int value) {
        if (this.days == value) {
            return this;
        }
        return new ImmutableAccountDaysTTL(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountDaysTTL && this.equalTo(0, (ImmutableAccountDaysTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountDaysTTL another) {
        return this.identifier == another.identifier && this.days == another.days;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.days;
        return h;
    }

    public String toString() {
        return "AccountDaysTTL{identifier=" + this.identifier + ", days=" + this.days + "}";
    }

    public static ImmutableAccountDaysTTL of(int days) {
        return new ImmutableAccountDaysTTL(days);
    }

    public static ImmutableAccountDaysTTL copyOf(AccountDaysTTL instance) {
        if (instance instanceof ImmutableAccountDaysTTL) {
            return (ImmutableAccountDaysTTL)instance;
        }
        return ImmutableAccountDaysTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DAYS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int days;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AccountDaysTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AccountDaysTTL) {
                instance = (AccountDaysTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.days(instance.days());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder days(int days) {
            this.days = days;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAccountDaysTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountDaysTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("days");
            }
            return "Cannot build AccountDaysTTL, some of required attributes are not set " + attributes;
        }
    }
}

