/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.AttachMenuBot;
import telegram4j.tl.AttachMenuBotIcon;
import telegram4j.tl.AttachMenuPeerType;
import telegram4j.tl.api.TlObject;

public final class ImmutableAttachMenuBot
implements AttachMenuBot {
    private final int identifier;
    private final int flags;
    private final boolean inactive;
    private final boolean hasSettings;
    private final long botId;
    private final String shortName;
    private final List<AttachMenuPeerType> peerTypes;
    private final List<AttachMenuBotIcon> icons;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAttachMenuBot(long botId, String shortName) {
        this.botId = botId;
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.peerTypes = Collections.emptyList();
        this.icons = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inactive = this.initShim.inactive();
        this.hasSettings = this.initShim.hasSettings();
        this.initShim = null;
    }

    private ImmutableAttachMenuBot(Builder builder) {
        this.botId = builder.botId;
        this.shortName = builder.shortName;
        this.peerTypes = ImmutableAttachMenuBot.createUnmodifiableList(true, builder.peerTypes);
        this.icons = ImmutableAttachMenuBot.createUnmodifiableList(true, builder.icons);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inactiveIsSet()) {
            this.initShim.inactive(builder.inactive);
        }
        if (builder.hasSettingsIsSet()) {
            this.initShim.hasSettings(builder.hasSettings);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inactive = this.initShim.inactive();
        this.hasSettings = this.initShim.hasSettings();
        this.initShim = null;
    }

    private ImmutableAttachMenuBot(int identifier, int flags, boolean inactive, boolean hasSettings, long botId, String shortName, List<AttachMenuPeerType> peerTypes, List<AttachMenuBotIcon> icons) {
        this.identifier = identifier;
        this.flags = flags;
        this.inactive = inactive;
        this.hasSettings = hasSettings;
        this.botId = botId;
        this.shortName = shortName;
        this.peerTypes = peerTypes;
        this.icons = icons;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AttachMenuBot.super.identifier();
    }

    private int flagsInitialize() {
        return AttachMenuBot.super.flags();
    }

    private boolean inactiveInitialize() {
        return AttachMenuBot.super.inactive();
    }

    private boolean hasSettingsInitialize() {
        return AttachMenuBot.super.hasSettings();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inactive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inactive() : this.inactive;
    }

    @Override
    public boolean hasSettings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasSettings() : this.hasSettings;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public List<AttachMenuPeerType> peerTypes() {
        return this.peerTypes;
    }

    @Override
    public List<AttachMenuBotIcon> icons() {
        return this.icons;
    }

    public final ImmutableAttachMenuBot withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAttachMenuBot(value, this.flags, this.inactive, this.hasSettings, this.botId, this.shortName, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAttachMenuBot(this.identifier, value, this.inactive, this.hasSettings, this.botId, this.shortName, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withInactive(boolean value) {
        if (this.inactive == value) {
            return this;
        }
        return new ImmutableAttachMenuBot(this.identifier, this.flags, value, this.hasSettings, this.botId, this.shortName, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withHasSettings(boolean value) {
        if (this.hasSettings == value) {
            return this;
        }
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, value, this.botId, this.shortName, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, value, this.shortName, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, this.botId, newValue, this.peerTypes, this.icons);
    }

    public final ImmutableAttachMenuBot withPeerTypes(AttachMenuPeerType ... elements) {
        List<AttachMenuPeerType> newValue = ImmutableAttachMenuBot.createUnmodifiableList(false, ImmutableAttachMenuBot.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, this.botId, this.shortName, newValue, this.icons);
    }

    public final ImmutableAttachMenuBot withPeerTypes(Iterable<? extends AttachMenuPeerType> elements) {
        if (this.peerTypes == elements) {
            return this;
        }
        List<AttachMenuPeerType> newValue = ImmutableAttachMenuBot.createUnmodifiableList(false, ImmutableAttachMenuBot.createSafeList(elements, true, false));
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, this.botId, this.shortName, newValue, this.icons);
    }

    public final ImmutableAttachMenuBot withIcons(AttachMenuBotIcon ... elements) {
        List<AttachMenuBotIcon> newValue = ImmutableAttachMenuBot.createUnmodifiableList(false, ImmutableAttachMenuBot.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, this.botId, this.shortName, this.peerTypes, newValue);
    }

    public final ImmutableAttachMenuBot withIcons(Iterable<? extends AttachMenuBotIcon> elements) {
        if (this.icons == elements) {
            return this;
        }
        List<AttachMenuBotIcon> newValue = ImmutableAttachMenuBot.createUnmodifiableList(false, ImmutableAttachMenuBot.createSafeList(elements, true, false));
        return new ImmutableAttachMenuBot(this.identifier, this.flags, this.inactive, this.hasSettings, this.botId, this.shortName, this.peerTypes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttachMenuBot && this.equalTo(0, (ImmutableAttachMenuBot)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttachMenuBot another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inactive == another.inactive && this.hasSettings == another.hasSettings && this.botId == another.botId && this.shortName.equals(another.shortName) && this.peerTypes.equals(another.peerTypes) && this.icons.equals(another.icons);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inactive);
        h += (h << 5) + Boolean.hashCode(this.hasSettings);
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.shortName.hashCode();
        h += (h << 5) + this.peerTypes.hashCode();
        h += (h << 5) + this.icons.hashCode();
        return h;
    }

    public String toString() {
        return "AttachMenuBot{identifier=" + this.identifier + ", flags=" + this.flags + ", inactive=" + this.inactive + ", hasSettings=" + this.hasSettings + ", botId=" + this.botId + ", shortName=" + this.shortName + ", peerTypes=" + this.peerTypes + ", icons=" + this.icons + "}";
    }

    public static ImmutableAttachMenuBot of(long botId, String shortName) {
        return new ImmutableAttachMenuBot(botId, shortName);
    }

    public static ImmutableAttachMenuBot copyOf(AttachMenuBot instance) {
        if (instance instanceof ImmutableAttachMenuBot) {
            return (ImmutableAttachMenuBot)instance;
        }
        return ImmutableAttachMenuBot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_ID = 1L;
        private static final long INIT_BIT_SHORT_NAME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INACTIVE = 4L;
        private static final long OPT_BIT_HAS_SETTINGS = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inactive;
        private boolean hasSettings;
        private long botId;
        private String shortName;
        private List<AttachMenuPeerType> peerTypes = new ArrayList<AttachMenuPeerType>();
        private List<AttachMenuBotIcon> icons = new ArrayList<AttachMenuBotIcon>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AttachMenuBot instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AttachMenuBot) {
                instance = (AttachMenuBot)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.inactive(instance.inactive());
                this.flags(instance.flags());
                this.hasSettings(instance.hasSettings());
                this.addAllPeerTypes(instance.peerTypes());
                this.botId(instance.botId());
                this.shortName(instance.shortName());
                this.addAllIcons(instance.icons());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inactive(boolean inactive) {
            this.inactive = inactive;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hasSettings(boolean hasSettings) {
            this.hasSettings = hasSettings;
            this.optBits |= 8L;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPeerType(AttachMenuPeerType element) {
            this.peerTypes.add(Objects.requireNonNull(element, "peerTypes element"));
            return this;
        }

        public final Builder addPeerTypes(AttachMenuPeerType ... elements) {
            for (AttachMenuPeerType element : elements) {
                this.peerTypes.add(Objects.requireNonNull(element, "peerTypes element"));
            }
            return this;
        }

        public final Builder peerTypes(Iterable<? extends AttachMenuPeerType> elements) {
            this.peerTypes.clear();
            return this.addAllPeerTypes(elements);
        }

        public final Builder addAllPeerTypes(Iterable<? extends AttachMenuPeerType> elements) {
            for (AttachMenuPeerType attachMenuPeerType : elements) {
                this.peerTypes.add(Objects.requireNonNull(attachMenuPeerType, "peerTypes element"));
            }
            return this;
        }

        public final Builder addIcon(AttachMenuBotIcon element) {
            this.icons.add(Objects.requireNonNull(element, "icons element"));
            return this;
        }

        public final Builder addIcons(AttachMenuBotIcon ... elements) {
            for (AttachMenuBotIcon element : elements) {
                this.icons.add(Objects.requireNonNull(element, "icons element"));
            }
            return this;
        }

        public final Builder icons(Iterable<? extends AttachMenuBotIcon> elements) {
            this.icons.clear();
            return this.addAllIcons(elements);
        }

        public final Builder addAllIcons(Iterable<? extends AttachMenuBotIcon> elements) {
            for (AttachMenuBotIcon attachMenuBotIcon : elements) {
                this.icons.add(Objects.requireNonNull(attachMenuBotIcon, "icons element"));
            }
            return this;
        }

        public ImmutableAttachMenuBot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttachMenuBot(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inactiveIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hasSettingsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("shortName");
            }
            return "Cannot build AttachMenuBot, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inactiveBuildStage = 0;
        private boolean inactive;
        private byte hasSettingsBuildStage = 0;
        private boolean hasSettings;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAttachMenuBot.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAttachMenuBot.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inactive() {
            if (this.inactiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inactiveBuildStage == 0) {
                this.inactiveBuildStage = (byte)-1;
                this.inactive = ImmutableAttachMenuBot.this.inactiveInitialize();
                this.inactiveBuildStage = 1;
            }
            return this.inactive;
        }

        void inactive(boolean inactive) {
            this.inactive = inactive;
            this.inactiveBuildStage = 1;
        }

        boolean hasSettings() {
            if (this.hasSettingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasSettingsBuildStage == 0) {
                this.hasSettingsBuildStage = (byte)-1;
                this.hasSettings = ImmutableAttachMenuBot.this.hasSettingsInitialize();
                this.hasSettingsBuildStage = 1;
            }
            return this.hasSettings;
        }

        void hasSettings(boolean hasSettings) {
            this.hasSettings = hasSettings;
            this.hasSettingsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inactiveBuildStage == -1) {
                attributes.add("inactive");
            }
            if (this.hasSettingsBuildStage == -1) {
                attributes.add("hasSettings");
            }
            return "Cannot build AttachMenuBot, attribute initializers form cycle " + attributes;
        }
    }
}

