/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.AttachMenuBotIcon;
import telegram4j.tl.AttachMenuBotIconColor;
import telegram4j.tl.Document;
import telegram4j.tl.api.TlObject;

public final class ImmutableAttachMenuBotIcon
implements AttachMenuBotIcon {
    private final int identifier;
    private final int flags;
    private final String name;
    private final Document icon;
    @Nullable
    private final List<AttachMenuBotIconColor> colors;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAttachMenuBotIcon(String name, Document icon) {
        this.name = Objects.requireNonNull(name, "name");
        this.icon = Objects.requireNonNull(icon, "icon");
        this.colors = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAttachMenuBotIcon(Builder builder) {
        this.name = builder.name;
        this.icon = builder.icon;
        List<AttachMenuBotIconColor> list = this.colors = builder.colors == null ? null : ImmutableAttachMenuBotIcon.createUnmodifiableList(true, builder.colors);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAttachMenuBotIcon(int identifier, int flags, String name, Document icon, @Nullable List<AttachMenuBotIconColor> colors) {
        this.identifier = identifier;
        this.flags = flags;
        this.name = name;
        this.icon = icon;
        this.colors = colors;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AttachMenuBotIcon.super.identifier();
    }

    private int flagsInitialize() {
        return AttachMenuBotIcon.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Document icon() {
        return this.icon;
    }

    @Override
    @Nullable
    public List<AttachMenuBotIconColor> colors() {
        return this.colors;
    }

    public final ImmutableAttachMenuBotIcon withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAttachMenuBotIcon(value, this.flags, this.name, this.icon, this.colors);
    }

    public final ImmutableAttachMenuBotIcon withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAttachMenuBotIcon(this.identifier, value, this.name, this.icon, this.colors);
    }

    public final ImmutableAttachMenuBotIcon withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachMenuBotIcon(this.identifier, this.flags, newValue, this.icon, this.colors);
    }

    public final ImmutableAttachMenuBotIcon withIcon(Document value) {
        if (this.icon == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "icon");
        return new ImmutableAttachMenuBotIcon(this.identifier, this.flags, this.name, newValue, this.colors);
    }

    public final ImmutableAttachMenuBotIcon withColors(AttachMenuBotIconColor ... elements) {
        if (elements == null) {
            return new ImmutableAttachMenuBotIcon(this.identifier, this.flags, this.name, this.icon, null);
        }
        List<AttachMenuBotIconColor> newValue = Arrays.asList(elements) == null ? null : ImmutableAttachMenuBotIcon.createUnmodifiableList(false, ImmutableAttachMenuBotIcon.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAttachMenuBotIcon(this.identifier, this.flags, this.name, this.icon, newValue);
    }

    public final ImmutableAttachMenuBotIcon withColors(@Nullable Iterable<? extends AttachMenuBotIconColor> elements) {
        if (this.colors == elements) {
            return this;
        }
        List<AttachMenuBotIconColor> newValue = elements == null ? null : ImmutableAttachMenuBotIcon.createUnmodifiableList(false, ImmutableAttachMenuBotIcon.createSafeList(elements, true, false));
        return new ImmutableAttachMenuBotIcon(this.identifier, this.flags, this.name, this.icon, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttachMenuBotIcon && this.equalTo(0, (ImmutableAttachMenuBotIcon)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttachMenuBotIcon another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.name.equals(another.name) && this.icon.equals(another.icon) && Objects.equals(this.colors, another.colors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.icon.hashCode();
        h += (h << 5) + Objects.hashCode(this.colors);
        return h;
    }

    public String toString() {
        return "AttachMenuBotIcon{identifier=" + this.identifier + ", flags=" + this.flags + ", name=" + this.name + ", icon=" + this.icon + ", colors=" + this.colors + "}";
    }

    public static ImmutableAttachMenuBotIcon of(String name, Document icon) {
        return new ImmutableAttachMenuBotIcon(name, icon);
    }

    public static ImmutableAttachMenuBotIcon copyOf(AttachMenuBotIcon instance) {
        if (instance instanceof ImmutableAttachMenuBotIcon) {
            return (ImmutableAttachMenuBotIcon)instance;
        }
        return ImmutableAttachMenuBotIcon.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ICON = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private String name;
        private Document icon;
        private List<AttachMenuBotIconColor> colors = null;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AttachMenuBotIcon instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AttachMenuBotIcon) {
                List<AttachMenuBotIconColor> colorsValue;
                instance = (AttachMenuBotIcon)object;
                this.flags(instance.flags());
                this.name(instance.name());
                this.icon(instance.icon());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((colorsValue = instance.colors()) != null) {
                    this.addAllColors(colorsValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder icon(Document icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addColor(AttachMenuBotIconColor element) {
            if (this.colors == null) {
                this.colors = new ArrayList<AttachMenuBotIconColor>();
            }
            this.colors.add(Objects.requireNonNull(element, "colors element"));
            return this;
        }

        public final Builder addColors(AttachMenuBotIconColor ... elements) {
            if (this.colors == null) {
                this.colors = new ArrayList<AttachMenuBotIconColor>();
            }
            for (AttachMenuBotIconColor element : elements) {
                this.colors.add(Objects.requireNonNull(element, "colors element"));
            }
            return this;
        }

        public final Builder colors(@Nullable Iterable<? extends AttachMenuBotIconColor> elements) {
            if (elements == null) {
                this.colors = null;
                return this;
            }
            this.colors = new ArrayList<AttachMenuBotIconColor>();
            return this.addAllColors(elements);
        }

        public final Builder addAllColors(Iterable<? extends AttachMenuBotIconColor> elements) {
            Objects.requireNonNull(elements, "colors element");
            if (this.colors == null) {
                this.colors = new ArrayList<AttachMenuBotIconColor>();
            }
            for (AttachMenuBotIconColor attachMenuBotIconColor : elements) {
                this.colors.add(Objects.requireNonNull(attachMenuBotIconColor, "colors element"));
            }
            return this;
        }

        public ImmutableAttachMenuBotIcon build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttachMenuBotIcon(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("icon");
            }
            return "Cannot build AttachMenuBotIcon, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAttachMenuBotIcon.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAttachMenuBotIcon.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build AttachMenuBotIcon, attribute initializers form cycle " + attributes;
        }
    }
}

