/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AttachMenuBotIconColor;
import telegram4j.tl.api.TlObject;

public final class ImmutableAttachMenuBotIconColor
implements AttachMenuBotIconColor {
    private final int identifier;
    private final String name;
    private final int color;

    private ImmutableAttachMenuBotIconColor(String name, int color) {
        this.name = Objects.requireNonNull(name, "name");
        this.color = color;
        this.identifier = AttachMenuBotIconColor.super.identifier();
    }

    private ImmutableAttachMenuBotIconColor(Builder builder) {
        this.name = builder.name;
        this.color = builder.color;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AttachMenuBotIconColor.super.identifier();
    }

    private ImmutableAttachMenuBotIconColor(int identifier, String name, int color) {
        this.identifier = identifier;
        this.name = name;
        this.color = color;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int color() {
        return this.color;
    }

    public final ImmutableAttachMenuBotIconColor withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAttachMenuBotIconColor(value, this.name, this.color);
    }

    public final ImmutableAttachMenuBotIconColor withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachMenuBotIconColor(this.identifier, newValue, this.color);
    }

    public final ImmutableAttachMenuBotIconColor withColor(int value) {
        if (this.color == value) {
            return this;
        }
        return new ImmutableAttachMenuBotIconColor(this.identifier, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttachMenuBotIconColor && this.equalTo(0, (ImmutableAttachMenuBotIconColor)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttachMenuBotIconColor another) {
        return this.identifier == another.identifier && this.name.equals(another.name) && this.color == another.color;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.color;
        return h;
    }

    public String toString() {
        return "AttachMenuBotIconColor{identifier=" + this.identifier + ", name=" + this.name + ", color=" + this.color + "}";
    }

    public static ImmutableAttachMenuBotIconColor of(String name, int color) {
        return new ImmutableAttachMenuBotIconColor(name, color);
    }

    public static ImmutableAttachMenuBotIconColor copyOf(AttachMenuBotIconColor instance) {
        if (instance instanceof ImmutableAttachMenuBotIconColor) {
            return (ImmutableAttachMenuBotIconColor)instance;
        }
        return ImmutableAttachMenuBotIconColor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COLOR = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String name;
        private int color;

        private Builder() {
        }

        public final Builder from(AttachMenuBotIconColor instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AttachMenuBotIconColor instance;
            long bits = 0L;
            if (object instanceof AttachMenuBotIconColor) {
                instance = (AttachMenuBotIconColor)object;
                this.color(instance.color());
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder color(int color) {
            this.color = color;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAttachMenuBotIconColor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttachMenuBotIconColor(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("color");
            }
            return "Cannot build AttachMenuBotIconColor, some of required attributes are not set " + attributes;
        }
    }
}

