/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Authorization;
import telegram4j.tl.api.TlObject;

public final class ImmutableAuthorization
implements Authorization {
    private final int identifier;
    private final int flags;
    private final boolean current;
    private final boolean officialApp;
    private final boolean passwordPending;
    private final boolean encryptedRequestsDisabled;
    private final boolean callRequestsDisabled;
    private final long hash;
    private final String deviceModel;
    private final String platform;
    private final String systemVersion;
    private final int apiId;
    private final String appName;
    private final String appVersion;
    private final int dateCreated;
    private final int dateActive;
    private final String ip;
    private final String country;
    private final String region;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAuthorization(long hash, String deviceModel, String platform, String systemVersion, int apiId, String appName, String appVersion, int dateCreated, int dateActive, String ip, String country, String region) {
        this.hash = hash;
        this.deviceModel = Objects.requireNonNull(deviceModel, "deviceModel");
        this.platform = Objects.requireNonNull(platform, "platform");
        this.systemVersion = Objects.requireNonNull(systemVersion, "systemVersion");
        this.apiId = apiId;
        this.appName = Objects.requireNonNull(appName, "appName");
        this.appVersion = Objects.requireNonNull(appVersion, "appVersion");
        this.dateCreated = dateCreated;
        this.dateActive = dateActive;
        this.ip = Objects.requireNonNull(ip, "ip");
        this.country = Objects.requireNonNull(country, "country");
        this.region = Objects.requireNonNull(region, "region");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.current = this.initShim.current();
        this.officialApp = this.initShim.officialApp();
        this.passwordPending = this.initShim.passwordPending();
        this.encryptedRequestsDisabled = this.initShim.encryptedRequestsDisabled();
        this.callRequestsDisabled = this.initShim.callRequestsDisabled();
        this.initShim = null;
    }

    private ImmutableAuthorization(Builder builder) {
        this.hash = builder.hash;
        this.deviceModel = builder.deviceModel;
        this.platform = builder.platform;
        this.systemVersion = builder.systemVersion;
        this.apiId = builder.apiId;
        this.appName = builder.appName;
        this.appVersion = builder.appVersion;
        this.dateCreated = builder.dateCreated;
        this.dateActive = builder.dateActive;
        this.ip = builder.ip;
        this.country = builder.country;
        this.region = builder.region;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.currentIsSet()) {
            this.initShim.current(builder.current);
        }
        if (builder.officialAppIsSet()) {
            this.initShim.officialApp(builder.officialApp);
        }
        if (builder.passwordPendingIsSet()) {
            this.initShim.passwordPending(builder.passwordPending);
        }
        if (builder.encryptedRequestsDisabledIsSet()) {
            this.initShim.encryptedRequestsDisabled(builder.encryptedRequestsDisabled);
        }
        if (builder.callRequestsDisabledIsSet()) {
            this.initShim.callRequestsDisabled(builder.callRequestsDisabled);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.current = this.initShim.current();
        this.officialApp = this.initShim.officialApp();
        this.passwordPending = this.initShim.passwordPending();
        this.encryptedRequestsDisabled = this.initShim.encryptedRequestsDisabled();
        this.callRequestsDisabled = this.initShim.callRequestsDisabled();
        this.initShim = null;
    }

    private ImmutableAuthorization(int identifier, int flags, boolean current, boolean officialApp, boolean passwordPending, boolean encryptedRequestsDisabled, boolean callRequestsDisabled, long hash, String deviceModel, String platform, String systemVersion, int apiId, String appName, String appVersion, int dateCreated, int dateActive, String ip, String country, String region) {
        this.identifier = identifier;
        this.flags = flags;
        this.current = current;
        this.officialApp = officialApp;
        this.passwordPending = passwordPending;
        this.encryptedRequestsDisabled = encryptedRequestsDisabled;
        this.callRequestsDisabled = callRequestsDisabled;
        this.hash = hash;
        this.deviceModel = deviceModel;
        this.platform = platform;
        this.systemVersion = systemVersion;
        this.apiId = apiId;
        this.appName = appName;
        this.appVersion = appVersion;
        this.dateCreated = dateCreated;
        this.dateActive = dateActive;
        this.ip = ip;
        this.country = country;
        this.region = region;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Authorization.super.identifier();
    }

    private int flagsInitialize() {
        return Authorization.super.flags();
    }

    private boolean currentInitialize() {
        return Authorization.super.current();
    }

    private boolean officialAppInitialize() {
        return Authorization.super.officialApp();
    }

    private boolean passwordPendingInitialize() {
        return Authorization.super.passwordPending();
    }

    private boolean encryptedRequestsDisabledInitialize() {
        return Authorization.super.encryptedRequestsDisabled();
    }

    private boolean callRequestsDisabledInitialize() {
        return Authorization.super.callRequestsDisabled();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean current() {
        InitShim shim = this.initShim;
        return shim != null ? shim.current() : this.current;
    }

    @Override
    public boolean officialApp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.officialApp() : this.officialApp;
    }

    @Override
    public boolean passwordPending() {
        InitShim shim = this.initShim;
        return shim != null ? shim.passwordPending() : this.passwordPending;
    }

    @Override
    public boolean encryptedRequestsDisabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encryptedRequestsDisabled() : this.encryptedRequestsDisabled;
    }

    @Override
    public boolean callRequestsDisabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callRequestsDisabled() : this.callRequestsDisabled;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public String deviceModel() {
        return this.deviceModel;
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public String systemVersion() {
        return this.systemVersion;
    }

    @Override
    public int apiId() {
        return this.apiId;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public String appVersion() {
        return this.appVersion;
    }

    @Override
    public int dateCreated() {
        return this.dateCreated;
    }

    @Override
    public int dateActive() {
        return this.dateActive;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public String country() {
        return this.country;
    }

    @Override
    public String region() {
        return this.region;
    }

    public final ImmutableAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAuthorization(value, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, value, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withCurrent(boolean value) {
        if (this.current == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, value, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withOfficialApp(boolean value) {
        if (this.officialApp == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, value, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withPasswordPending(boolean value) {
        if (this.passwordPending == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, value, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withEncryptedRequestsDisabled(boolean value) {
        if (this.encryptedRequestsDisabled == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, value, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withCallRequestsDisabled(boolean value) {
        if (this.callRequestsDisabled == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, value, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, value, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withDeviceModel(String value) {
        String newValue = Objects.requireNonNull(value, "deviceModel");
        if (this.deviceModel.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, newValue, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withPlatform(String value) {
        String newValue = Objects.requireNonNull(value, "platform");
        if (this.platform.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, newValue, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withSystemVersion(String value) {
        String newValue = Objects.requireNonNull(value, "systemVersion");
        if (this.systemVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, newValue, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withApiId(int value) {
        if (this.apiId == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, value, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withAppName(String value) {
        String newValue = Objects.requireNonNull(value, "appName");
        if (this.appName.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, newValue, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withAppVersion(String value) {
        String newValue = Objects.requireNonNull(value, "appVersion");
        if (this.appVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, newValue, this.dateCreated, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withDateCreated(int value) {
        if (this.dateCreated == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, value, this.dateActive, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withDateActive(int value) {
        if (this.dateActive == value) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, value, this.ip, this.country, this.region);
    }

    public final ImmutableAuthorization withIp(String value) {
        String newValue = Objects.requireNonNull(value, "ip");
        if (this.ip.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, newValue, this.country, this.region);
    }

    public final ImmutableAuthorization withCountry(String value) {
        String newValue = Objects.requireNonNull(value, "country");
        if (this.country.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, newValue, this.region);
    }

    public final ImmutableAuthorization withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorization(this.identifier, this.flags, this.current, this.officialApp, this.passwordPending, this.encryptedRequestsDisabled, this.callRequestsDisabled, this.hash, this.deviceModel, this.platform, this.systemVersion, this.apiId, this.appName, this.appVersion, this.dateCreated, this.dateActive, this.ip, this.country, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorization && this.equalTo(0, (ImmutableAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorization another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.current == another.current && this.officialApp == another.officialApp && this.passwordPending == another.passwordPending && this.encryptedRequestsDisabled == another.encryptedRequestsDisabled && this.callRequestsDisabled == another.callRequestsDisabled && this.hash == another.hash && this.deviceModel.equals(another.deviceModel) && this.platform.equals(another.platform) && this.systemVersion.equals(another.systemVersion) && this.apiId == another.apiId && this.appName.equals(another.appName) && this.appVersion.equals(another.appVersion) && this.dateCreated == another.dateCreated && this.dateActive == another.dateActive && this.ip.equals(another.ip) && this.country.equals(another.country) && this.region.equals(another.region);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.current);
        h += (h << 5) + Boolean.hashCode(this.officialApp);
        h += (h << 5) + Boolean.hashCode(this.passwordPending);
        h += (h << 5) + Boolean.hashCode(this.encryptedRequestsDisabled);
        h += (h << 5) + Boolean.hashCode(this.callRequestsDisabled);
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.deviceModel.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.systemVersion.hashCode();
        h += (h << 5) + this.apiId;
        h += (h << 5) + this.appName.hashCode();
        h += (h << 5) + this.appVersion.hashCode();
        h += (h << 5) + this.dateCreated;
        h += (h << 5) + this.dateActive;
        h += (h << 5) + this.ip.hashCode();
        h += (h << 5) + this.country.hashCode();
        h += (h << 5) + this.region.hashCode();
        return h;
    }

    public String toString() {
        return "Authorization{identifier=" + this.identifier + ", flags=" + this.flags + ", current=" + this.current + ", officialApp=" + this.officialApp + ", passwordPending=" + this.passwordPending + ", encryptedRequestsDisabled=" + this.encryptedRequestsDisabled + ", callRequestsDisabled=" + this.callRequestsDisabled + ", hash=" + this.hash + ", deviceModel=" + this.deviceModel + ", platform=" + this.platform + ", systemVersion=" + this.systemVersion + ", apiId=" + this.apiId + ", appName=" + this.appName + ", appVersion=" + this.appVersion + ", dateCreated=" + this.dateCreated + ", dateActive=" + this.dateActive + ", ip=" + this.ip + ", country=" + this.country + ", region=" + this.region + "}";
    }

    public static ImmutableAuthorization of(long hash, String deviceModel, String platform, String systemVersion, int apiId, String appName, String appVersion, int dateCreated, int dateActive, String ip, String country, String region) {
        return new ImmutableAuthorization(hash, deviceModel, platform, systemVersion, apiId, appName, appVersion, dateCreated, dateActive, ip, country, region);
    }

    public static ImmutableAuthorization copyOf(Authorization instance) {
        if (instance instanceof ImmutableAuthorization) {
            return (ImmutableAuthorization)instance;
        }
        return ImmutableAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_DEVICE_MODEL = 2L;
        private static final long INIT_BIT_PLATFORM = 4L;
        private static final long INIT_BIT_SYSTEM_VERSION = 8L;
        private static final long INIT_BIT_API_ID = 16L;
        private static final long INIT_BIT_APP_NAME = 32L;
        private static final long INIT_BIT_APP_VERSION = 64L;
        private static final long INIT_BIT_DATE_CREATED = 128L;
        private static final long INIT_BIT_DATE_ACTIVE = 256L;
        private static final long INIT_BIT_IP = 512L;
        private static final long INIT_BIT_COUNTRY = 1024L;
        private static final long INIT_BIT_REGION = 2048L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CURRENT = 4L;
        private static final long OPT_BIT_OFFICIAL_APP = 8L;
        private static final long OPT_BIT_PASSWORD_PENDING = 16L;
        private static final long OPT_BIT_ENCRYPTED_REQUESTS_DISABLED = 32L;
        private static final long OPT_BIT_CALL_REQUESTS_DISABLED = 64L;
        private long initBits = 4095L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean current;
        private boolean officialApp;
        private boolean passwordPending;
        private boolean encryptedRequestsDisabled;
        private boolean callRequestsDisabled;
        private long hash;
        private String deviceModel;
        private String platform;
        private String systemVersion;
        private int apiId;
        private String appName;
        private String appVersion;
        private int dateCreated;
        private int dateActive;
        private String ip;
        private String country;
        private String region;

        private Builder() {
        }

        public final Builder from(Authorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Authorization instance;
            long bits = 0L;
            if (object instanceof Authorization) {
                instance = (Authorization)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.country(instance.country());
                this.appVersion(instance.appVersion());
                this.dateActive(instance.dateActive());
                this.appName(instance.appName());
                this.ip(instance.ip());
                this.flags(instance.flags());
                this.passwordPending(instance.passwordPending());
                this.systemVersion(instance.systemVersion());
                this.platform(instance.platform());
                this.current(instance.current());
                this.encryptedRequestsDisabled(instance.encryptedRequestsDisabled());
                this.dateCreated(instance.dateCreated());
                this.callRequestsDisabled(instance.callRequestsDisabled());
                this.deviceModel(instance.deviceModel());
                this.officialApp(instance.officialApp());
                this.region(instance.region());
                this.hash(instance.hash());
                this.apiId(instance.apiId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder current(boolean current) {
            this.current = current;
            this.optBits |= 4L;
            return this;
        }

        public final Builder officialApp(boolean officialApp) {
            this.officialApp = officialApp;
            this.optBits |= 8L;
            return this;
        }

        public final Builder passwordPending(boolean passwordPending) {
            this.passwordPending = passwordPending;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder encryptedRequestsDisabled(boolean encryptedRequestsDisabled) {
            this.encryptedRequestsDisabled = encryptedRequestsDisabled;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder callRequestsDisabled(boolean callRequestsDisabled) {
            this.callRequestsDisabled = callRequestsDisabled;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder deviceModel(String deviceModel) {
            this.deviceModel = Objects.requireNonNull(deviceModel, "deviceModel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder platform(String platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder systemVersion(String systemVersion) {
            this.systemVersion = Objects.requireNonNull(systemVersion, "systemVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder apiId(int apiId) {
            this.apiId = apiId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder appName(String appName) {
            this.appName = Objects.requireNonNull(appName, "appName");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder appVersion(String appVersion) {
            this.appVersion = Objects.requireNonNull(appVersion, "appVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder dateCreated(int dateCreated) {
            this.dateCreated = dateCreated;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder dateActive(int dateActive) {
            this.dateActive = dateActive;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder ip(String ip) {
            this.ip = Objects.requireNonNull(ip, "ip");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder country(String country) {
            this.country = Objects.requireNonNull(country, "country");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public ImmutableAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean currentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean officialAppIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean passwordPendingIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean encryptedRequestsDisabledIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean callRequestsDisabledIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deviceModel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("systemVersion");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("apiId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("appName");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("appVersion");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("dateCreated");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("dateActive");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("ip");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("country");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("region");
            }
            return "Cannot build Authorization, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte currentBuildStage = 0;
        private boolean current;
        private byte officialAppBuildStage = 0;
        private boolean officialApp;
        private byte passwordPendingBuildStage = 0;
        private boolean passwordPending;
        private byte encryptedRequestsDisabledBuildStage = 0;
        private boolean encryptedRequestsDisabled;
        private byte callRequestsDisabledBuildStage = 0;
        private boolean callRequestsDisabled;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAuthorization.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAuthorization.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean current() {
            if (this.currentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.currentBuildStage == 0) {
                this.currentBuildStage = (byte)-1;
                this.current = ImmutableAuthorization.this.currentInitialize();
                this.currentBuildStage = 1;
            }
            return this.current;
        }

        void current(boolean current) {
            this.current = current;
            this.currentBuildStage = 1;
        }

        boolean officialApp() {
            if (this.officialAppBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.officialAppBuildStage == 0) {
                this.officialAppBuildStage = (byte)-1;
                this.officialApp = ImmutableAuthorization.this.officialAppInitialize();
                this.officialAppBuildStage = 1;
            }
            return this.officialApp;
        }

        void officialApp(boolean officialApp) {
            this.officialApp = officialApp;
            this.officialAppBuildStage = 1;
        }

        boolean passwordPending() {
            if (this.passwordPendingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passwordPendingBuildStage == 0) {
                this.passwordPendingBuildStage = (byte)-1;
                this.passwordPending = ImmutableAuthorization.this.passwordPendingInitialize();
                this.passwordPendingBuildStage = 1;
            }
            return this.passwordPending;
        }

        void passwordPending(boolean passwordPending) {
            this.passwordPending = passwordPending;
            this.passwordPendingBuildStage = 1;
        }

        boolean encryptedRequestsDisabled() {
            if (this.encryptedRequestsDisabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encryptedRequestsDisabledBuildStage == 0) {
                this.encryptedRequestsDisabledBuildStage = (byte)-1;
                this.encryptedRequestsDisabled = ImmutableAuthorization.this.encryptedRequestsDisabledInitialize();
                this.encryptedRequestsDisabledBuildStage = 1;
            }
            return this.encryptedRequestsDisabled;
        }

        void encryptedRequestsDisabled(boolean encryptedRequestsDisabled) {
            this.encryptedRequestsDisabled = encryptedRequestsDisabled;
            this.encryptedRequestsDisabledBuildStage = 1;
        }

        boolean callRequestsDisabled() {
            if (this.callRequestsDisabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callRequestsDisabledBuildStage == 0) {
                this.callRequestsDisabledBuildStage = (byte)-1;
                this.callRequestsDisabled = ImmutableAuthorization.this.callRequestsDisabledInitialize();
                this.callRequestsDisabledBuildStage = 1;
            }
            return this.callRequestsDisabled;
        }

        void callRequestsDisabled(boolean callRequestsDisabled) {
            this.callRequestsDisabled = callRequestsDisabled;
            this.callRequestsDisabledBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.currentBuildStage == -1) {
                attributes.add("current");
            }
            if (this.officialAppBuildStage == -1) {
                attributes.add("officialApp");
            }
            if (this.passwordPendingBuildStage == -1) {
                attributes.add("passwordPending");
            }
            if (this.encryptedRequestsDisabledBuildStage == -1) {
                attributes.add("encryptedRequestsDisabled");
            }
            if (this.callRequestsDisabledBuildStage == -1) {
                attributes.add("callRequestsDisabled");
            }
            return "Cannot build Authorization, attribute initializers form cycle " + attributes;
        }
    }
}

