/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AutoDownloadSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableAutoDownloadSettings
implements AutoDownloadSettings {
    private final int identifier;
    private final int flags;
    private final boolean disabled;
    private final boolean videoPreloadLarge;
    private final boolean audioPreloadNext;
    private final boolean phonecallsLessData;
    private final int photoSizeMax;
    private final long videoSizeMax;
    private final long fileSizeMax;
    private final int videoUploadMaxbitrate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAutoDownloadSettings(int photoSizeMax, long videoSizeMax, long fileSizeMax, int videoUploadMaxbitrate) {
        this.photoSizeMax = photoSizeMax;
        this.videoSizeMax = videoSizeMax;
        this.fileSizeMax = fileSizeMax;
        this.videoUploadMaxbitrate = videoUploadMaxbitrate;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.disabled = this.initShim.disabled();
        this.videoPreloadLarge = this.initShim.videoPreloadLarge();
        this.audioPreloadNext = this.initShim.audioPreloadNext();
        this.phonecallsLessData = this.initShim.phonecallsLessData();
        this.initShim = null;
    }

    private ImmutableAutoDownloadSettings(Builder builder) {
        this.photoSizeMax = builder.photoSizeMax;
        this.videoSizeMax = builder.videoSizeMax;
        this.fileSizeMax = builder.fileSizeMax;
        this.videoUploadMaxbitrate = builder.videoUploadMaxbitrate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.disabledIsSet()) {
            this.initShim.disabled(builder.disabled);
        }
        if (builder.videoPreloadLargeIsSet()) {
            this.initShim.videoPreloadLarge(builder.videoPreloadLarge);
        }
        if (builder.audioPreloadNextIsSet()) {
            this.initShim.audioPreloadNext(builder.audioPreloadNext);
        }
        if (builder.phonecallsLessDataIsSet()) {
            this.initShim.phonecallsLessData(builder.phonecallsLessData);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.disabled = this.initShim.disabled();
        this.videoPreloadLarge = this.initShim.videoPreloadLarge();
        this.audioPreloadNext = this.initShim.audioPreloadNext();
        this.phonecallsLessData = this.initShim.phonecallsLessData();
        this.initShim = null;
    }

    private ImmutableAutoDownloadSettings(int identifier, int flags, boolean disabled, boolean videoPreloadLarge, boolean audioPreloadNext, boolean phonecallsLessData, int photoSizeMax, long videoSizeMax, long fileSizeMax, int videoUploadMaxbitrate) {
        this.identifier = identifier;
        this.flags = flags;
        this.disabled = disabled;
        this.videoPreloadLarge = videoPreloadLarge;
        this.audioPreloadNext = audioPreloadNext;
        this.phonecallsLessData = phonecallsLessData;
        this.photoSizeMax = photoSizeMax;
        this.videoSizeMax = videoSizeMax;
        this.fileSizeMax = fileSizeMax;
        this.videoUploadMaxbitrate = videoUploadMaxbitrate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AutoDownloadSettings.super.identifier();
    }

    private int flagsInitialize() {
        return AutoDownloadSettings.super.flags();
    }

    private boolean disabledInitialize() {
        return AutoDownloadSettings.super.disabled();
    }

    private boolean videoPreloadLargeInitialize() {
        return AutoDownloadSettings.super.videoPreloadLarge();
    }

    private boolean audioPreloadNextInitialize() {
        return AutoDownloadSettings.super.audioPreloadNext();
    }

    private boolean phonecallsLessDataInitialize() {
        return AutoDownloadSettings.super.phonecallsLessData();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean disabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.disabled() : this.disabled;
    }

    @Override
    public boolean videoPreloadLarge() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videoPreloadLarge() : this.videoPreloadLarge;
    }

    @Override
    public boolean audioPreloadNext() {
        InitShim shim = this.initShim;
        return shim != null ? shim.audioPreloadNext() : this.audioPreloadNext;
    }

    @Override
    public boolean phonecallsLessData() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phonecallsLessData() : this.phonecallsLessData;
    }

    @Override
    public int photoSizeMax() {
        return this.photoSizeMax;
    }

    @Override
    public long videoSizeMax() {
        return this.videoSizeMax;
    }

    @Override
    public long fileSizeMax() {
        return this.fileSizeMax;
    }

    @Override
    public int videoUploadMaxbitrate() {
        return this.videoUploadMaxbitrate;
    }

    public final ImmutableAutoDownloadSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(value, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, value, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withDisabled(boolean value) {
        if (this.disabled == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, value, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withVideoPreloadLarge(boolean value) {
        if (this.videoPreloadLarge == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, value, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withAudioPreloadNext(boolean value) {
        if (this.audioPreloadNext == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, value, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withPhonecallsLessData(boolean value) {
        if (this.phonecallsLessData == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, value, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withPhotoSizeMax(int value) {
        if (this.photoSizeMax == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, value, this.videoSizeMax, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withVideoSizeMax(long value) {
        if (this.videoSizeMax == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, value, this.fileSizeMax, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withFileSizeMax(long value) {
        if (this.fileSizeMax == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, value, this.videoUploadMaxbitrate);
    }

    public final ImmutableAutoDownloadSettings withVideoUploadMaxbitrate(int value) {
        if (this.videoUploadMaxbitrate == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(this.identifier, this.flags, this.disabled, this.videoPreloadLarge, this.audioPreloadNext, this.phonecallsLessData, this.photoSizeMax, this.videoSizeMax, this.fileSizeMax, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAutoDownloadSettings && this.equalTo(0, (ImmutableAutoDownloadSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableAutoDownloadSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.disabled == another.disabled && this.videoPreloadLarge == another.videoPreloadLarge && this.audioPreloadNext == another.audioPreloadNext && this.phonecallsLessData == another.phonecallsLessData && this.photoSizeMax == another.photoSizeMax && this.videoSizeMax == another.videoSizeMax && this.fileSizeMax == another.fileSizeMax && this.videoUploadMaxbitrate == another.videoUploadMaxbitrate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.disabled);
        h += (h << 5) + Boolean.hashCode(this.videoPreloadLarge);
        h += (h << 5) + Boolean.hashCode(this.audioPreloadNext);
        h += (h << 5) + Boolean.hashCode(this.phonecallsLessData);
        h += (h << 5) + this.photoSizeMax;
        h += (h << 5) + Long.hashCode(this.videoSizeMax);
        h += (h << 5) + Long.hashCode(this.fileSizeMax);
        h += (h << 5) + this.videoUploadMaxbitrate;
        return h;
    }

    public String toString() {
        return "AutoDownloadSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", disabled=" + this.disabled + ", videoPreloadLarge=" + this.videoPreloadLarge + ", audioPreloadNext=" + this.audioPreloadNext + ", phonecallsLessData=" + this.phonecallsLessData + ", photoSizeMax=" + this.photoSizeMax + ", videoSizeMax=" + this.videoSizeMax + ", fileSizeMax=" + this.fileSizeMax + ", videoUploadMaxbitrate=" + this.videoUploadMaxbitrate + "}";
    }

    public static ImmutableAutoDownloadSettings of(int photoSizeMax, long videoSizeMax, long fileSizeMax, int videoUploadMaxbitrate) {
        return new ImmutableAutoDownloadSettings(photoSizeMax, videoSizeMax, fileSizeMax, videoUploadMaxbitrate);
    }

    public static ImmutableAutoDownloadSettings copyOf(AutoDownloadSettings instance) {
        if (instance instanceof ImmutableAutoDownloadSettings) {
            return (ImmutableAutoDownloadSettings)instance;
        }
        return ImmutableAutoDownloadSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHOTO_SIZE_MAX = 1L;
        private static final long INIT_BIT_VIDEO_SIZE_MAX = 2L;
        private static final long INIT_BIT_FILE_SIZE_MAX = 4L;
        private static final long INIT_BIT_VIDEO_UPLOAD_MAXBITRATE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_DISABLED = 4L;
        private static final long OPT_BIT_VIDEO_PRELOAD_LARGE = 8L;
        private static final long OPT_BIT_AUDIO_PRELOAD_NEXT = 16L;
        private static final long OPT_BIT_PHONECALLS_LESS_DATA = 32L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean disabled;
        private boolean videoPreloadLarge;
        private boolean audioPreloadNext;
        private boolean phonecallsLessData;
        private int photoSizeMax;
        private long videoSizeMax;
        private long fileSizeMax;
        private int videoUploadMaxbitrate;

        private Builder() {
        }

        public final Builder from(AutoDownloadSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AutoDownloadSettings instance;
            long bits = 0L;
            if (object instanceof AutoDownloadSettings) {
                instance = (AutoDownloadSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.videoSizeMax(instance.videoSizeMax());
                this.videoPreloadLarge(instance.videoPreloadLarge());
                this.phonecallsLessData(instance.phonecallsLessData());
                this.photoSizeMax(instance.photoSizeMax());
                this.videoUploadMaxbitrate(instance.videoUploadMaxbitrate());
                this.flags(instance.flags());
                this.audioPreloadNext(instance.audioPreloadNext());
                this.disabled(instance.disabled());
                this.fileSizeMax(instance.fileSizeMax());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder disabled(boolean disabled) {
            this.disabled = disabled;
            this.optBits |= 4L;
            return this;
        }

        public final Builder videoPreloadLarge(boolean videoPreloadLarge) {
            this.videoPreloadLarge = videoPreloadLarge;
            this.optBits |= 8L;
            return this;
        }

        public final Builder audioPreloadNext(boolean audioPreloadNext) {
            this.audioPreloadNext = audioPreloadNext;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder phonecallsLessData(boolean phonecallsLessData) {
            this.phonecallsLessData = phonecallsLessData;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder photoSizeMax(int photoSizeMax) {
            this.photoSizeMax = photoSizeMax;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder videoSizeMax(long videoSizeMax) {
            this.videoSizeMax = videoSizeMax;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fileSizeMax(long fileSizeMax) {
            this.fileSizeMax = fileSizeMax;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder videoUploadMaxbitrate(int videoUploadMaxbitrate) {
            this.videoUploadMaxbitrate = videoUploadMaxbitrate;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAutoDownloadSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAutoDownloadSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean disabledIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean videoPreloadLargeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean audioPreloadNextIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean phonecallsLessDataIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("photoSizeMax");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("videoSizeMax");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fileSizeMax");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("videoUploadMaxbitrate");
            }
            return "Cannot build AutoDownloadSettings, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte disabledBuildStage = 0;
        private boolean disabled;
        private byte videoPreloadLargeBuildStage = 0;
        private boolean videoPreloadLarge;
        private byte audioPreloadNextBuildStage = 0;
        private boolean audioPreloadNext;
        private byte phonecallsLessDataBuildStage = 0;
        private boolean phonecallsLessData;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAutoDownloadSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAutoDownloadSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean disabled() {
            if (this.disabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disabledBuildStage == 0) {
                this.disabledBuildStage = (byte)-1;
                this.disabled = ImmutableAutoDownloadSettings.this.disabledInitialize();
                this.disabledBuildStage = 1;
            }
            return this.disabled;
        }

        void disabled(boolean disabled) {
            this.disabled = disabled;
            this.disabledBuildStage = 1;
        }

        boolean videoPreloadLarge() {
            if (this.videoPreloadLargeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoPreloadLargeBuildStage == 0) {
                this.videoPreloadLargeBuildStage = (byte)-1;
                this.videoPreloadLarge = ImmutableAutoDownloadSettings.this.videoPreloadLargeInitialize();
                this.videoPreloadLargeBuildStage = 1;
            }
            return this.videoPreloadLarge;
        }

        void videoPreloadLarge(boolean videoPreloadLarge) {
            this.videoPreloadLarge = videoPreloadLarge;
            this.videoPreloadLargeBuildStage = 1;
        }

        boolean audioPreloadNext() {
            if (this.audioPreloadNextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.audioPreloadNextBuildStage == 0) {
                this.audioPreloadNextBuildStage = (byte)-1;
                this.audioPreloadNext = ImmutableAutoDownloadSettings.this.audioPreloadNextInitialize();
                this.audioPreloadNextBuildStage = 1;
            }
            return this.audioPreloadNext;
        }

        void audioPreloadNext(boolean audioPreloadNext) {
            this.audioPreloadNext = audioPreloadNext;
            this.audioPreloadNextBuildStage = 1;
        }

        boolean phonecallsLessData() {
            if (this.phonecallsLessDataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phonecallsLessDataBuildStage == 0) {
                this.phonecallsLessDataBuildStage = (byte)-1;
                this.phonecallsLessData = ImmutableAutoDownloadSettings.this.phonecallsLessDataInitialize();
                this.phonecallsLessDataBuildStage = 1;
            }
            return this.phonecallsLessData;
        }

        void phonecallsLessData(boolean phonecallsLessData) {
            this.phonecallsLessData = phonecallsLessData;
            this.phonecallsLessDataBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.disabledBuildStage == -1) {
                attributes.add("disabled");
            }
            if (this.videoPreloadLargeBuildStage == -1) {
                attributes.add("videoPreloadLarge");
            }
            if (this.audioPreloadNextBuildStage == -1) {
                attributes.add("audioPreloadNext");
            }
            if (this.phonecallsLessDataBuildStage == -1) {
                attributes.add("phonecallsLessData");
            }
            return "Cannot build AutoDownloadSettings, attribute initializers form cycle " + attributes;
        }
    }
}

