/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.AvailableReaction;
import telegram4j.tl.Document;
import telegram4j.tl.api.TlObject;

public final class ImmutableAvailableReaction
implements AvailableReaction {
    private final int identifier;
    private final int flags;
    private final boolean inactive;
    private final boolean premium;
    private final String reaction;
    private final String title;
    private final Document staticIcon;
    private final Document appearAnimation;
    private final Document selectAnimation;
    private final Document activateAnimation;
    private final Document effectAnimation;
    @Nullable
    private final Document aroundAnimation;
    @Nullable
    private final Document centerIcon;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAvailableReaction(String reaction, String title, Document staticIcon, Document appearAnimation, Document selectAnimation, Document activateAnimation, Document effectAnimation) {
        this.reaction = Objects.requireNonNull(reaction, "reaction");
        this.title = Objects.requireNonNull(title, "title");
        this.staticIcon = Objects.requireNonNull(staticIcon, "staticIcon");
        this.appearAnimation = Objects.requireNonNull(appearAnimation, "appearAnimation");
        this.selectAnimation = Objects.requireNonNull(selectAnimation, "selectAnimation");
        this.activateAnimation = Objects.requireNonNull(activateAnimation, "activateAnimation");
        this.effectAnimation = Objects.requireNonNull(effectAnimation, "effectAnimation");
        this.aroundAnimation = null;
        this.centerIcon = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inactive = this.initShim.inactive();
        this.premium = this.initShim.premium();
        this.initShim = null;
    }

    private ImmutableAvailableReaction(Builder builder) {
        this.reaction = builder.reaction;
        this.title = builder.title;
        this.staticIcon = builder.staticIcon;
        this.appearAnimation = builder.appearAnimation;
        this.selectAnimation = builder.selectAnimation;
        this.activateAnimation = builder.activateAnimation;
        this.effectAnimation = builder.effectAnimation;
        this.aroundAnimation = builder.aroundAnimation;
        this.centerIcon = builder.centerIcon;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inactiveIsSet()) {
            this.initShim.inactive(builder.inactive);
        }
        if (builder.premiumIsSet()) {
            this.initShim.premium(builder.premium);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inactive = this.initShim.inactive();
        this.premium = this.initShim.premium();
        this.initShim = null;
    }

    private ImmutableAvailableReaction(int identifier, int flags, boolean inactive, boolean premium, String reaction, String title, Document staticIcon, Document appearAnimation, Document selectAnimation, Document activateAnimation, Document effectAnimation, @Nullable Document aroundAnimation, @Nullable Document centerIcon) {
        this.identifier = identifier;
        this.flags = flags;
        this.inactive = inactive;
        this.premium = premium;
        this.reaction = reaction;
        this.title = title;
        this.staticIcon = staticIcon;
        this.appearAnimation = appearAnimation;
        this.selectAnimation = selectAnimation;
        this.activateAnimation = activateAnimation;
        this.effectAnimation = effectAnimation;
        this.aroundAnimation = aroundAnimation;
        this.centerIcon = centerIcon;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AvailableReaction.super.identifier();
    }

    private int flagsInitialize() {
        return AvailableReaction.super.flags();
    }

    private boolean inactiveInitialize() {
        return AvailableReaction.super.inactive();
    }

    private boolean premiumInitialize() {
        return AvailableReaction.super.premium();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inactive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inactive() : this.inactive;
    }

    @Override
    public boolean premium() {
        InitShim shim = this.initShim;
        return shim != null ? shim.premium() : this.premium;
    }

    @Override
    public String reaction() {
        return this.reaction;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public Document staticIcon() {
        return this.staticIcon;
    }

    @Override
    public Document appearAnimation() {
        return this.appearAnimation;
    }

    @Override
    public Document selectAnimation() {
        return this.selectAnimation;
    }

    @Override
    public Document activateAnimation() {
        return this.activateAnimation;
    }

    @Override
    public Document effectAnimation() {
        return this.effectAnimation;
    }

    @Override
    @Nullable
    public Document aroundAnimation() {
        return this.aroundAnimation;
    }

    @Override
    @Nullable
    public Document centerIcon() {
        return this.centerIcon;
    }

    public final ImmutableAvailableReaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAvailableReaction(value, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, value, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withInactive(boolean value) {
        if (this.inactive == value) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, value, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withPremium(boolean value) {
        if (this.premium == value) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, value, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withReaction(String value) {
        String newValue = Objects.requireNonNull(value, "reaction");
        if (this.reaction.equals(newValue)) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, newValue, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, newValue, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withStaticIcon(Document value) {
        if (this.staticIcon == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "staticIcon");
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, newValue, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withAppearAnimation(Document value) {
        if (this.appearAnimation == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "appearAnimation");
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, newValue, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withSelectAnimation(Document value) {
        if (this.selectAnimation == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "selectAnimation");
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, newValue, this.activateAnimation, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withActivateAnimation(Document value) {
        if (this.activateAnimation == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "activateAnimation");
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, newValue, this.effectAnimation, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withEffectAnimation(Document value) {
        if (this.effectAnimation == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "effectAnimation");
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, newValue, this.aroundAnimation, this.centerIcon);
    }

    public final ImmutableAvailableReaction withAroundAnimation(@Nullable Document value) {
        if (this.aroundAnimation == value) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, value, this.centerIcon);
    }

    public final ImmutableAvailableReaction withCenterIcon(@Nullable Document value) {
        if (this.centerIcon == value) {
            return this;
        }
        return new ImmutableAvailableReaction(this.identifier, this.flags, this.inactive, this.premium, this.reaction, this.title, this.staticIcon, this.appearAnimation, this.selectAnimation, this.activateAnimation, this.effectAnimation, this.aroundAnimation, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAvailableReaction && this.equalTo(0, (ImmutableAvailableReaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableAvailableReaction another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inactive == another.inactive && this.premium == another.premium && this.reaction.equals(another.reaction) && this.title.equals(another.title) && this.staticIcon.equals(another.staticIcon) && this.appearAnimation.equals(another.appearAnimation) && this.selectAnimation.equals(another.selectAnimation) && this.activateAnimation.equals(another.activateAnimation) && this.effectAnimation.equals(another.effectAnimation) && Objects.equals(this.aroundAnimation, another.aroundAnimation) && Objects.equals(this.centerIcon, another.centerIcon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inactive);
        h += (h << 5) + Boolean.hashCode(this.premium);
        h += (h << 5) + this.reaction.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.staticIcon.hashCode();
        h += (h << 5) + this.appearAnimation.hashCode();
        h += (h << 5) + this.selectAnimation.hashCode();
        h += (h << 5) + this.activateAnimation.hashCode();
        h += (h << 5) + this.effectAnimation.hashCode();
        h += (h << 5) + Objects.hashCode(this.aroundAnimation);
        h += (h << 5) + Objects.hashCode(this.centerIcon);
        return h;
    }

    public String toString() {
        return "AvailableReaction{identifier=" + this.identifier + ", flags=" + this.flags + ", inactive=" + this.inactive + ", premium=" + this.premium + ", reaction=" + this.reaction + ", title=" + this.title + ", staticIcon=" + this.staticIcon + ", appearAnimation=" + this.appearAnimation + ", selectAnimation=" + this.selectAnimation + ", activateAnimation=" + this.activateAnimation + ", effectAnimation=" + this.effectAnimation + ", aroundAnimation=" + this.aroundAnimation + ", centerIcon=" + this.centerIcon + "}";
    }

    public static ImmutableAvailableReaction of(String reaction, String title, Document staticIcon, Document appearAnimation, Document selectAnimation, Document activateAnimation, Document effectAnimation) {
        return new ImmutableAvailableReaction(reaction, title, staticIcon, appearAnimation, selectAnimation, activateAnimation, effectAnimation);
    }

    public static ImmutableAvailableReaction copyOf(AvailableReaction instance) {
        if (instance instanceof ImmutableAvailableReaction) {
            return (ImmutableAvailableReaction)instance;
        }
        return ImmutableAvailableReaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REACTION = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_STATIC_ICON = 4L;
        private static final long INIT_BIT_APPEAR_ANIMATION = 8L;
        private static final long INIT_BIT_SELECT_ANIMATION = 16L;
        private static final long INIT_BIT_ACTIVATE_ANIMATION = 32L;
        private static final long INIT_BIT_EFFECT_ANIMATION = 64L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INACTIVE = 4L;
        private static final long OPT_BIT_PREMIUM = 8L;
        private long initBits = 127L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inactive;
        private boolean premium;
        private String reaction;
        private String title;
        private Document staticIcon;
        private Document appearAnimation;
        private Document selectAnimation;
        private Document activateAnimation;
        private Document effectAnimation;
        private Document aroundAnimation;
        private Document centerIcon;

        private Builder() {
        }

        public final Builder from(AvailableReaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AvailableReaction instance;
            long bits = 0L;
            if (object instanceof AvailableReaction) {
                instance = (AvailableReaction)object;
                this.staticIcon(instance.staticIcon());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.appearAnimation(instance.appearAnimation());
                this.reaction(instance.reaction());
                this.activateAnimation(instance.activateAnimation());
                this.flags(instance.flags());
                this.selectAnimation(instance.selectAnimation());
                this.title(instance.title());
                Document aroundAnimationValue = instance.aroundAnimation();
                if (aroundAnimationValue != null) {
                    this.aroundAnimation(aroundAnimationValue);
                }
                this.inactive(instance.inactive());
                this.premium(instance.premium());
                Document centerIconValue = instance.centerIcon();
                if (centerIconValue != null) {
                    this.centerIcon(centerIconValue);
                }
                this.effectAnimation(instance.effectAnimation());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inactive(boolean inactive) {
            this.inactive = inactive;
            this.optBits |= 4L;
            return this;
        }

        public final Builder premium(boolean premium) {
            this.premium = premium;
            this.optBits |= 8L;
            return this;
        }

        public final Builder reaction(String reaction) {
            this.reaction = Objects.requireNonNull(reaction, "reaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder staticIcon(Document staticIcon) {
            this.staticIcon = Objects.requireNonNull(staticIcon, "staticIcon");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder appearAnimation(Document appearAnimation) {
            this.appearAnimation = Objects.requireNonNull(appearAnimation, "appearAnimation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder selectAnimation(Document selectAnimation) {
            this.selectAnimation = Objects.requireNonNull(selectAnimation, "selectAnimation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder activateAnimation(Document activateAnimation) {
            this.activateAnimation = Objects.requireNonNull(activateAnimation, "activateAnimation");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder effectAnimation(Document effectAnimation) {
            this.effectAnimation = Objects.requireNonNull(effectAnimation, "effectAnimation");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder aroundAnimation(@Nullable Document aroundAnimation) {
            this.aroundAnimation = aroundAnimation;
            return this;
        }

        public final Builder centerIcon(@Nullable Document centerIcon) {
            this.centerIcon = centerIcon;
            return this;
        }

        public ImmutableAvailableReaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAvailableReaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inactiveIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean premiumIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("staticIcon");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("appearAnimation");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("selectAnimation");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("activateAnimation");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("effectAnimation");
            }
            return "Cannot build AvailableReaction, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inactiveBuildStage = 0;
        private boolean inactive;
        private byte premiumBuildStage = 0;
        private boolean premium;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAvailableReaction.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAvailableReaction.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inactive() {
            if (this.inactiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inactiveBuildStage == 0) {
                this.inactiveBuildStage = (byte)-1;
                this.inactive = ImmutableAvailableReaction.this.inactiveInitialize();
                this.inactiveBuildStage = 1;
            }
            return this.inactive;
        }

        void inactive(boolean inactive) {
            this.inactive = inactive;
            this.inactiveBuildStage = 1;
        }

        boolean premium() {
            if (this.premiumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.premiumBuildStage == 0) {
                this.premiumBuildStage = (byte)-1;
                this.premium = ImmutableAvailableReaction.this.premiumInitialize();
                this.premiumBuildStage = 1;
            }
            return this.premium;
        }

        void premium(boolean premium) {
            this.premium = premium;
            this.premiumBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inactiveBuildStage == -1) {
                attributes.add("inactive");
            }
            if (this.premiumBuildStage == -1) {
                attributes.add("premium");
            }
            return "Cannot build AvailableReaction, attribute initializers form cycle " + attributes;
        }
    }
}

