/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BankCardOpenUrl;
import telegram4j.tl.api.TlObject;

public final class ImmutableBankCardOpenUrl
implements BankCardOpenUrl {
    private final int identifier;
    private final String url;
    private final String name;

    private ImmutableBankCardOpenUrl(String url, String name) {
        this.url = Objects.requireNonNull(url, "url");
        this.name = Objects.requireNonNull(name, "name");
        this.identifier = BankCardOpenUrl.super.identifier();
    }

    private ImmutableBankCardOpenUrl(Builder builder) {
        this.url = builder.url;
        this.name = builder.name;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BankCardOpenUrl.super.identifier();
    }

    private ImmutableBankCardOpenUrl(int identifier, String url, String name) {
        this.identifier = identifier;
        this.url = url;
        this.name = name;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutableBankCardOpenUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBankCardOpenUrl(value, this.url, this.name);
    }

    public final ImmutableBankCardOpenUrl withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableBankCardOpenUrl(this.identifier, newValue, this.name);
    }

    public final ImmutableBankCardOpenUrl withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableBankCardOpenUrl(this.identifier, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBankCardOpenUrl && this.equalTo(0, (ImmutableBankCardOpenUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableBankCardOpenUrl another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "BankCardOpenUrl{identifier=" + this.identifier + ", url=" + this.url + ", name=" + this.name + "}";
    }

    public static ImmutableBankCardOpenUrl of(String url, String name) {
        return new ImmutableBankCardOpenUrl(url, name);
    }

    public static ImmutableBankCardOpenUrl copyOf(BankCardOpenUrl instance) {
        if (instance instanceof ImmutableBankCardOpenUrl) {
            return (ImmutableBankCardOpenUrl)instance;
        }
        return ImmutableBankCardOpenUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private String name;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BankCardOpenUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BankCardOpenUrl) {
                instance = (BankCardOpenUrl)object;
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBankCardOpenUrl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBankCardOpenUrl(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build BankCardOpenUrl, some of required attributes are not set " + attributes;
        }
    }
}

