/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.AttachMenuBot;
import telegram4j.tl.AttachMenuBots;
import telegram4j.tl.BaseAttachMenuBots;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseAttachMenuBots
implements BaseAttachMenuBots {
    private final int identifier;
    private final long hash;
    private final List<AttachMenuBot> bots;
    private final List<User> users;

    private ImmutableBaseAttachMenuBots(long hash) {
        this.hash = hash;
        this.bots = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = BaseAttachMenuBots.super.identifier();
    }

    private ImmutableBaseAttachMenuBots(Builder builder) {
        this.hash = builder.hash;
        this.bots = ImmutableBaseAttachMenuBots.createUnmodifiableList(true, builder.bots);
        this.users = ImmutableBaseAttachMenuBots.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseAttachMenuBots.super.identifier();
    }

    private ImmutableBaseAttachMenuBots(int identifier, long hash, List<AttachMenuBot> bots, List<User> users) {
        this.identifier = identifier;
        this.hash = hash;
        this.bots = bots;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<AttachMenuBot> bots() {
        return this.bots;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseAttachMenuBots withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseAttachMenuBots(value, this.hash, this.bots, this.users);
    }

    public final ImmutableBaseAttachMenuBots withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseAttachMenuBots(this.identifier, value, this.bots, this.users);
    }

    public final ImmutableBaseAttachMenuBots withBots(AttachMenuBot ... elements) {
        List<AttachMenuBot> newValue = ImmutableBaseAttachMenuBots.createUnmodifiableList(false, ImmutableBaseAttachMenuBots.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseAttachMenuBots(this.identifier, this.hash, newValue, this.users);
    }

    public final ImmutableBaseAttachMenuBots withBots(Iterable<? extends AttachMenuBot> elements) {
        if (this.bots == elements) {
            return this;
        }
        List<AttachMenuBot> newValue = ImmutableBaseAttachMenuBots.createUnmodifiableList(false, ImmutableBaseAttachMenuBots.createSafeList(elements, true, false));
        return new ImmutableBaseAttachMenuBots(this.identifier, this.hash, newValue, this.users);
    }

    public final ImmutableBaseAttachMenuBots withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseAttachMenuBots.createUnmodifiableList(false, ImmutableBaseAttachMenuBots.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseAttachMenuBots(this.identifier, this.hash, this.bots, newValue);
    }

    public final ImmutableBaseAttachMenuBots withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseAttachMenuBots.createUnmodifiableList(false, ImmutableBaseAttachMenuBots.createSafeList(elements, true, false));
        return new ImmutableBaseAttachMenuBots(this.identifier, this.hash, this.bots, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseAttachMenuBots && this.equalTo(0, (ImmutableBaseAttachMenuBots)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseAttachMenuBots another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.bots.equals(another.bots) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.bots.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseAttachMenuBots{identifier=" + this.identifier + ", hash=" + this.hash + ", bots=" + this.bots + ", users=" + this.users + "}";
    }

    public static ImmutableBaseAttachMenuBots of(long hash) {
        return new ImmutableBaseAttachMenuBots(hash);
    }

    public static ImmutableBaseAttachMenuBots copyOf(BaseAttachMenuBots instance) {
        if (instance instanceof ImmutableBaseAttachMenuBots) {
            return (ImmutableBaseAttachMenuBots)instance;
        }
        return ImmutableBaseAttachMenuBots.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<AttachMenuBot> bots = new ArrayList<AttachMenuBot>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(BaseAttachMenuBots instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AttachMenuBots instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AttachMenuBots instance;
            long bits = 0L;
            if (object instanceof BaseAttachMenuBots) {
                instance = (BaseAttachMenuBots)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllBots(instance.bots());
                this.hash(instance.hash());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AttachMenuBots) {
                instance = (AttachMenuBots)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBot(AttachMenuBot element) {
            this.bots.add(Objects.requireNonNull(element, "bots element"));
            return this;
        }

        public final Builder addBots(AttachMenuBot ... elements) {
            for (AttachMenuBot element : elements) {
                this.bots.add(Objects.requireNonNull(element, "bots element"));
            }
            return this;
        }

        public final Builder bots(Iterable<? extends AttachMenuBot> elements) {
            this.bots.clear();
            return this.addAllBots(elements);
        }

        public final Builder addAllBots(Iterable<? extends AttachMenuBot> elements) {
            for (AttachMenuBot attachMenuBot : elements) {
                this.bots.add(Objects.requireNonNull(attachMenuBot, "bots element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseAttachMenuBots build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseAttachMenuBots(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseAttachMenuBots, some of required attributes are not set " + attributes;
        }
    }
}

