/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseChannelLocation;
import telegram4j.tl.ChannelLocation;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChannelLocation
implements BaseChannelLocation {
    private final int identifier;
    private final GeoPoint geoPoint;
    private final String address;

    private ImmutableBaseChannelLocation(GeoPoint geoPoint, String address) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.address = Objects.requireNonNull(address, "address");
        this.identifier = BaseChannelLocation.super.identifier();
    }

    private ImmutableBaseChannelLocation(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.address = builder.address;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseChannelLocation.super.identifier();
    }

    private ImmutableBaseChannelLocation(int identifier, GeoPoint geoPoint, String address) {
        this.identifier = identifier;
        this.geoPoint = geoPoint;
        this.address = address;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public GeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public String address() {
        return this.address;
    }

    public final ImmutableBaseChannelLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChannelLocation(value, this.geoPoint, this.address);
    }

    public final ImmutableBaseChannelLocation withGeoPoint(GeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        GeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableBaseChannelLocation(this.identifier, newValue, this.address);
    }

    public final ImmutableBaseChannelLocation withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseChannelLocation(this.identifier, this.geoPoint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChannelLocation && this.equalTo(0, (ImmutableBaseChannelLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChannelLocation another) {
        return this.identifier == another.identifier && this.geoPoint.equals(another.geoPoint) && this.address.equals(another.address);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + this.address.hashCode();
        return h;
    }

    public String toString() {
        return "BaseChannelLocation{identifier=" + this.identifier + ", geoPoint=" + this.geoPoint + ", address=" + this.address + "}";
    }

    public static ImmutableBaseChannelLocation of(GeoPoint geoPoint, String address) {
        return new ImmutableBaseChannelLocation(geoPoint, address);
    }

    public static ImmutableBaseChannelLocation copyOf(BaseChannelLocation instance) {
        if (instance instanceof ImmutableBaseChannelLocation) {
            return (ImmutableBaseChannelLocation)instance;
        }
        return ImmutableBaseChannelLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private GeoPoint geoPoint;
        private String address;

        private Builder() {
        }

        public final Builder from(ChannelLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChannelLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelLocation instance;
            long bits = 0L;
            if (object instanceof ChannelLocation) {
                instance = (ChannelLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChannelLocation) {
                instance = (BaseChannelLocation)object;
                this.geoPoint(instance.geoPoint());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.address(instance.address());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geoPoint(GeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseChannelLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChannelLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build BaseChannelLocation, some of required attributes are not set " + attributes;
        }
    }
}

