/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BaseChannelMessagesFilter;
import telegram4j.tl.ChannelMessagesFilter;
import telegram4j.tl.MessageRange;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChannelMessagesFilter
implements BaseChannelMessagesFilter {
    private final int identifier;
    private final int flags;
    private final boolean excludeNewMessages;
    private final List<MessageRange> ranges;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseChannelMessagesFilter(Builder builder) {
        this.ranges = ImmutableBaseChannelMessagesFilter.createUnmodifiableList(true, builder.ranges);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.excludeNewMessagesIsSet()) {
            this.initShim.excludeNewMessages(builder.excludeNewMessages);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.excludeNewMessages = this.initShim.excludeNewMessages();
        this.initShim = null;
    }

    private ImmutableBaseChannelMessagesFilter(int identifier, int flags, boolean excludeNewMessages, List<MessageRange> ranges) {
        this.identifier = identifier;
        this.flags = flags;
        this.excludeNewMessages = excludeNewMessages;
        this.ranges = ranges;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseChannelMessagesFilter.super.identifier();
    }

    private int flagsInitialize() {
        return BaseChannelMessagesFilter.super.flags();
    }

    private boolean excludeNewMessagesInitialize() {
        return BaseChannelMessagesFilter.super.excludeNewMessages();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean excludeNewMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludeNewMessages() : this.excludeNewMessages;
    }

    @Override
    public List<MessageRange> ranges() {
        return this.ranges;
    }

    public final ImmutableBaseChannelMessagesFilter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChannelMessagesFilter(value, this.flags, this.excludeNewMessages, this.ranges);
    }

    public final ImmutableBaseChannelMessagesFilter withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseChannelMessagesFilter(this.identifier, value, this.excludeNewMessages, this.ranges);
    }

    public final ImmutableBaseChannelMessagesFilter withExcludeNewMessages(boolean value) {
        if (this.excludeNewMessages == value) {
            return this;
        }
        return new ImmutableBaseChannelMessagesFilter(this.identifier, this.flags, value, this.ranges);
    }

    public final ImmutableBaseChannelMessagesFilter withRanges(MessageRange ... elements) {
        List<MessageRange> newValue = ImmutableBaseChannelMessagesFilter.createUnmodifiableList(false, ImmutableBaseChannelMessagesFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelMessagesFilter(this.identifier, this.flags, this.excludeNewMessages, newValue);
    }

    public final ImmutableBaseChannelMessagesFilter withRanges(Iterable<? extends MessageRange> elements) {
        if (this.ranges == elements) {
            return this;
        }
        List<MessageRange> newValue = ImmutableBaseChannelMessagesFilter.createUnmodifiableList(false, ImmutableBaseChannelMessagesFilter.createSafeList(elements, true, false));
        return new ImmutableBaseChannelMessagesFilter(this.identifier, this.flags, this.excludeNewMessages, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChannelMessagesFilter && this.equalTo(0, (ImmutableBaseChannelMessagesFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChannelMessagesFilter another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.excludeNewMessages == another.excludeNewMessages && this.ranges.equals(another.ranges);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.excludeNewMessages);
        h += (h << 5) + this.ranges.hashCode();
        return h;
    }

    public String toString() {
        return "BaseChannelMessagesFilter{identifier=" + this.identifier + ", flags=" + this.flags + ", excludeNewMessages=" + this.excludeNewMessages + ", ranges=" + this.ranges + "}";
    }

    public static ImmutableBaseChannelMessagesFilter copyOf(BaseChannelMessagesFilter instance) {
        if (instance instanceof ImmutableBaseChannelMessagesFilter) {
            return (ImmutableBaseChannelMessagesFilter)instance;
        }
        return ImmutableBaseChannelMessagesFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_EXCLUDE_NEW_MESSAGES = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean excludeNewMessages;
        private List<MessageRange> ranges = new ArrayList<MessageRange>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChannelMessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelMessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChannelMessagesFilter) {
                instance = (BaseChannelMessagesFilter)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.excludeNewMessages(instance.excludeNewMessages());
                this.addAllRanges(instance.ranges());
            }
            if (object instanceof ChannelMessagesFilter) {
                instance = (ChannelMessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder excludeNewMessages(boolean excludeNewMessages) {
            this.excludeNewMessages = excludeNewMessages;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRange(MessageRange element) {
            this.ranges.add(Objects.requireNonNull(element, "ranges element"));
            return this;
        }

        public final Builder addRanges(MessageRange ... elements) {
            for (MessageRange element : elements) {
                this.ranges.add(Objects.requireNonNull(element, "ranges element"));
            }
            return this;
        }

        public final Builder ranges(Iterable<? extends MessageRange> elements) {
            this.ranges.clear();
            return this.addAllRanges(elements);
        }

        public final Builder addAllRanges(Iterable<? extends MessageRange> elements) {
            for (MessageRange messageRange : elements) {
                this.ranges.add(Objects.requireNonNull(messageRange, "ranges element"));
            }
            return this;
        }

        public ImmutableBaseChannelMessagesFilter build() {
            return new ImmutableBaseChannelMessagesFilter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean excludeNewMessagesIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte excludeNewMessagesBuildStage = 0;
        private boolean excludeNewMessages;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseChannelMessagesFilter.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseChannelMessagesFilter.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean excludeNewMessages() {
            if (this.excludeNewMessagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludeNewMessagesBuildStage == 0) {
                this.excludeNewMessagesBuildStage = (byte)-1;
                this.excludeNewMessages = ImmutableBaseChannelMessagesFilter.this.excludeNewMessagesInitialize();
                this.excludeNewMessagesBuildStage = 1;
            }
            return this.excludeNewMessages;
        }

        void excludeNewMessages(boolean excludeNewMessages) {
            this.excludeNewMessages = excludeNewMessages;
            this.excludeNewMessagesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.excludeNewMessagesBuildStage == -1) {
                attributes.add("excludeNewMessages");
            }
            return "Cannot build BaseChannelMessagesFilter, attribute initializers form cycle " + attributes;
        }
    }
}

