/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseChannelParticipant;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChannelParticipant
implements BaseChannelParticipant {
    private final int identifier;
    private final long userId;
    private final int date;

    private ImmutableBaseChannelParticipant(long userId, int date) {
        this.userId = userId;
        this.date = date;
        this.identifier = BaseChannelParticipant.super.identifier();
    }

    private ImmutableBaseChannelParticipant(Builder builder) {
        this.userId = builder.userId;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseChannelParticipant.super.identifier();
    }

    private ImmutableBaseChannelParticipant(int identifier, long userId, int date) {
        this.identifier = identifier;
        this.userId = userId;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableBaseChannelParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChannelParticipant(value, this.userId, this.date);
    }

    public final ImmutableBaseChannelParticipant withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableBaseChannelParticipant(this.identifier, value, this.date);
    }

    public final ImmutableBaseChannelParticipant withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseChannelParticipant(this.identifier, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChannelParticipant && this.equalTo(0, (ImmutableBaseChannelParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChannelParticipant another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "BaseChannelParticipant{identifier=" + this.identifier + ", userId=" + this.userId + ", date=" + this.date + "}";
    }

    public static ImmutableBaseChannelParticipant of(long userId, int date) {
        return new ImmutableBaseChannelParticipant(userId, date);
    }

    public static ImmutableBaseChannelParticipant copyOf(BaseChannelParticipant instance) {
        if (instance instanceof ImmutableBaseChannelParticipant) {
            return (ImmutableBaseChannelParticipant)instance;
        }
        return ImmutableBaseChannelParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private int date;

        private Builder() {
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChannelParticipant) {
                instance = (BaseChannelParticipant)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseChannelParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChannelParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseChannelParticipant, some of required attributes are not set " + attributes;
        }
    }
}

