/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseChat;
import telegram4j.tl.Chat;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.ChatPhoto;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChat
implements BaseChat {
    private final int identifier;
    private final int flags;
    private final boolean creator;
    private final boolean left;
    private final boolean deactivated;
    private final boolean callActive;
    private final boolean callNotEmpty;
    private final boolean noforwards;
    private final long id;
    private final String title;
    private final ChatPhoto photo;
    private final int participantsCount;
    private final int date;
    private final int version;
    @Nullable
    private final InputChannel migratedTo;
    @Nullable
    private final ChatAdminRights adminRights;
    @Nullable
    private final ChatBannedRights defaultBannedRights;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseChat(long id, String title, ChatPhoto photo, int participantsCount, int date, int version) {
        this.id = id;
        this.title = Objects.requireNonNull(title, "title");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.participantsCount = participantsCount;
        this.date = date;
        this.version = version;
        this.migratedTo = null;
        this.adminRights = null;
        this.defaultBannedRights = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.left = this.initShim.left();
        this.deactivated = this.initShim.deactivated();
        this.callActive = this.initShim.callActive();
        this.callNotEmpty = this.initShim.callNotEmpty();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableBaseChat(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.photo = builder.photo;
        this.participantsCount = builder.participantsCount;
        this.date = builder.date;
        this.version = builder.version;
        this.migratedTo = builder.migratedTo;
        this.adminRights = builder.adminRights;
        this.defaultBannedRights = builder.defaultBannedRights;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.creatorIsSet()) {
            this.initShim.creator(builder.creator);
        }
        if (builder.leftIsSet()) {
            this.initShim.left(builder.left);
        }
        if (builder.deactivatedIsSet()) {
            this.initShim.deactivated(builder.deactivated);
        }
        if (builder.callActiveIsSet()) {
            this.initShim.callActive(builder.callActive);
        }
        if (builder.callNotEmptyIsSet()) {
            this.initShim.callNotEmpty(builder.callNotEmpty);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.left = this.initShim.left();
        this.deactivated = this.initShim.deactivated();
        this.callActive = this.initShim.callActive();
        this.callNotEmpty = this.initShim.callNotEmpty();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableBaseChat(int identifier, int flags, boolean creator, boolean left, boolean deactivated, boolean callActive, boolean callNotEmpty, boolean noforwards, long id, String title, ChatPhoto photo, int participantsCount, int date, int version, @Nullable InputChannel migratedTo, @Nullable ChatAdminRights adminRights, @Nullable ChatBannedRights defaultBannedRights) {
        this.identifier = identifier;
        this.flags = flags;
        this.creator = creator;
        this.left = left;
        this.deactivated = deactivated;
        this.callActive = callActive;
        this.callNotEmpty = callNotEmpty;
        this.noforwards = noforwards;
        this.id = id;
        this.title = title;
        this.photo = photo;
        this.participantsCount = participantsCount;
        this.date = date;
        this.version = version;
        this.migratedTo = migratedTo;
        this.adminRights = adminRights;
        this.defaultBannedRights = defaultBannedRights;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseChat.super.identifier();
    }

    private int flagsInitialize() {
        return BaseChat.super.flags();
    }

    private boolean creatorInitialize() {
        return BaseChat.super.creator();
    }

    private boolean leftInitialize() {
        return BaseChat.super.left();
    }

    private boolean deactivatedInitialize() {
        return BaseChat.super.deactivated();
    }

    private boolean callActiveInitialize() {
        return BaseChat.super.callActive();
    }

    private boolean callNotEmptyInitialize() {
        return BaseChat.super.callNotEmpty();
    }

    private boolean noforwardsInitialize() {
        return BaseChat.super.noforwards();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean creator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creator() : this.creator;
    }

    @Override
    public boolean left() {
        InitShim shim = this.initShim;
        return shim != null ? shim.left() : this.left;
    }

    @Override
    public boolean deactivated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deactivated() : this.deactivated;
    }

    @Override
    public boolean callActive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callActive() : this.callActive;
    }

    @Override
    public boolean callNotEmpty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callNotEmpty() : this.callNotEmpty;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public ChatPhoto photo() {
        return this.photo;
    }

    @Override
    public int participantsCount() {
        return this.participantsCount;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    @Nullable
    public InputChannel migratedTo() {
        return this.migratedTo;
    }

    @Override
    @Nullable
    public ChatAdminRights adminRights() {
        return this.adminRights;
    }

    @Override
    @Nullable
    public ChatBannedRights defaultBannedRights() {
        return this.defaultBannedRights;
    }

    public final ImmutableBaseChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChat(value, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, value, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withCreator(boolean value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, value, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withLeft(boolean value) {
        if (this.left == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, value, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withDeactivated(boolean value) {
        if (this.deactivated == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, value, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withCallActive(boolean value) {
        if (this.callActive == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, value, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withCallNotEmpty(boolean value) {
        if (this.callNotEmpty == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, value, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, value, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, value, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, newValue, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withPhoto(ChatPhoto value) {
        if (this.photo == value) {
            return this;
        }
        ChatPhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, newValue, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withParticipantsCount(int value) {
        if (this.participantsCount == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, value, this.date, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, value, this.version, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, value, this.migratedTo, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withMigratedTo(@Nullable InputChannel value) {
        if (this.migratedTo == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, value, this.adminRights, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withAdminRights(@Nullable ChatAdminRights value) {
        if (this.adminRights == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, value, this.defaultBannedRights);
    }

    public final ImmutableBaseChat withDefaultBannedRights(@Nullable ChatBannedRights value) {
        if (this.defaultBannedRights == value) {
            return this;
        }
        return new ImmutableBaseChat(this.identifier, this.flags, this.creator, this.left, this.deactivated, this.callActive, this.callNotEmpty, this.noforwards, this.id, this.title, this.photo, this.participantsCount, this.date, this.version, this.migratedTo, this.adminRights, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChat && this.equalTo(0, (ImmutableBaseChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChat another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.creator == another.creator && this.left == another.left && this.deactivated == another.deactivated && this.callActive == another.callActive && this.callNotEmpty == another.callNotEmpty && this.noforwards == another.noforwards && this.id == another.id && this.title.equals(another.title) && this.photo.equals(another.photo) && this.participantsCount == another.participantsCount && this.date == another.date && this.version == another.version && Objects.equals(this.migratedTo, another.migratedTo) && Objects.equals(this.adminRights, another.adminRights) && Objects.equals(this.defaultBannedRights, another.defaultBannedRights);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.creator);
        h += (h << 5) + Boolean.hashCode(this.left);
        h += (h << 5) + Boolean.hashCode(this.deactivated);
        h += (h << 5) + Boolean.hashCode(this.callActive);
        h += (h << 5) + Boolean.hashCode(this.callNotEmpty);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + this.participantsCount;
        h += (h << 5) + this.date;
        h += (h << 5) + this.version;
        h += (h << 5) + Objects.hashCode(this.migratedTo);
        h += (h << 5) + Objects.hashCode(this.adminRights);
        h += (h << 5) + Objects.hashCode(this.defaultBannedRights);
        return h;
    }

    public String toString() {
        return "BaseChat{identifier=" + this.identifier + ", flags=" + this.flags + ", creator=" + this.creator + ", left=" + this.left + ", deactivated=" + this.deactivated + ", callActive=" + this.callActive + ", callNotEmpty=" + this.callNotEmpty + ", noforwards=" + this.noforwards + ", id=" + this.id + ", title=" + this.title + ", photo=" + this.photo + ", participantsCount=" + this.participantsCount + ", date=" + this.date + ", version=" + this.version + ", migratedTo=" + this.migratedTo + ", adminRights=" + this.adminRights + ", defaultBannedRights=" + this.defaultBannedRights + "}";
    }

    public static ImmutableBaseChat of(long id, String title, ChatPhoto photo, int participantsCount, int date, int version) {
        return new ImmutableBaseChat(id, title, photo, participantsCount, date, version);
    }

    public static ImmutableBaseChat copyOf(BaseChat instance) {
        if (instance instanceof ImmutableBaseChat) {
            return (ImmutableBaseChat)instance;
        }
        return ImmutableBaseChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_PHOTO = 4L;
        private static final long INIT_BIT_PARTICIPANTS_COUNT = 8L;
        private static final long INIT_BIT_DATE = 16L;
        private static final long INIT_BIT_VERSION = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CREATOR = 4L;
        private static final long OPT_BIT_LEFT = 8L;
        private static final long OPT_BIT_DEACTIVATED = 16L;
        private static final long OPT_BIT_CALL_ACTIVE = 32L;
        private static final long OPT_BIT_CALL_NOT_EMPTY = 64L;
        private static final long OPT_BIT_NOFORWARDS = 128L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean creator;
        private boolean left;
        private boolean deactivated;
        private boolean callActive;
        private boolean callNotEmpty;
        private boolean noforwards;
        private long id;
        private String title;
        private ChatPhoto photo;
        private int participantsCount;
        private int date;
        private int version;
        private InputChannel migratedTo;
        private ChatAdminRights adminRights;
        private ChatBannedRights defaultBannedRights;

        private Builder() {
        }

        public final Builder from(BaseChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Chat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Chat instance;
            long bits = 0L;
            if (object instanceof BaseChat) {
                instance = (BaseChat)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participantsCount(instance.participantsCount());
                this.creator(instance.creator());
                this.noforwards(instance.noforwards());
                this.flags(instance.flags());
                this.photo(instance.photo());
                ChatBannedRights defaultBannedRightsValue = instance.defaultBannedRights();
                if (defaultBannedRightsValue != null) {
                    this.defaultBannedRights(defaultBannedRightsValue);
                }
                this.title(instance.title());
                this.callActive(instance.callActive());
                this.version(instance.version());
                this.deactivated(instance.deactivated());
                this.callNotEmpty(instance.callNotEmpty());
                ChatAdminRights adminRightsValue = instance.adminRights();
                if (adminRightsValue != null) {
                    this.adminRights(adminRightsValue);
                }
                this.left(instance.left());
                InputChannel migratedToValue = instance.migratedTo();
                if (migratedToValue != null) {
                    this.migratedTo(migratedToValue);
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Chat) {
                instance = (Chat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder creator(boolean creator) {
            this.creator = creator;
            this.optBits |= 4L;
            return this;
        }

        public final Builder left(boolean left) {
            this.left = left;
            this.optBits |= 8L;
            return this;
        }

        public final Builder deactivated(boolean deactivated) {
            this.deactivated = deactivated;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder callActive(boolean callActive) {
            this.callActive = callActive;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder callNotEmpty(boolean callNotEmpty) {
            this.callNotEmpty = callNotEmpty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(ChatPhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder participantsCount(int participantsCount) {
            this.participantsCount = participantsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder migratedTo(@Nullable InputChannel migratedTo) {
            this.migratedTo = migratedTo;
            return this;
        }

        public final Builder adminRights(@Nullable ChatAdminRights adminRights) {
            this.adminRights = adminRights;
            return this;
        }

        public final Builder defaultBannedRights(@Nullable ChatBannedRights defaultBannedRights) {
            this.defaultBannedRights = defaultBannedRights;
            return this;
        }

        public ImmutableBaseChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean creatorIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean leftIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean deactivatedIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean callActiveIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean callNotEmptyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("photo");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("participantsCount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build BaseChat, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte creatorBuildStage = 0;
        private boolean creator;
        private byte leftBuildStage = 0;
        private boolean left;
        private byte deactivatedBuildStage = 0;
        private boolean deactivated;
        private byte callActiveBuildStage = 0;
        private boolean callActive;
        private byte callNotEmptyBuildStage = 0;
        private boolean callNotEmpty;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseChat.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseChat.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean creator() {
            if (this.creatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creatorBuildStage == 0) {
                this.creatorBuildStage = (byte)-1;
                this.creator = ImmutableBaseChat.this.creatorInitialize();
                this.creatorBuildStage = 1;
            }
            return this.creator;
        }

        void creator(boolean creator) {
            this.creator = creator;
            this.creatorBuildStage = 1;
        }

        boolean left() {
            if (this.leftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leftBuildStage == 0) {
                this.leftBuildStage = (byte)-1;
                this.left = ImmutableBaseChat.this.leftInitialize();
                this.leftBuildStage = 1;
            }
            return this.left;
        }

        void left(boolean left) {
            this.left = left;
            this.leftBuildStage = 1;
        }

        boolean deactivated() {
            if (this.deactivatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deactivatedBuildStage == 0) {
                this.deactivatedBuildStage = (byte)-1;
                this.deactivated = ImmutableBaseChat.this.deactivatedInitialize();
                this.deactivatedBuildStage = 1;
            }
            return this.deactivated;
        }

        void deactivated(boolean deactivated) {
            this.deactivated = deactivated;
            this.deactivatedBuildStage = 1;
        }

        boolean callActive() {
            if (this.callActiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callActiveBuildStage == 0) {
                this.callActiveBuildStage = (byte)-1;
                this.callActive = ImmutableBaseChat.this.callActiveInitialize();
                this.callActiveBuildStage = 1;
            }
            return this.callActive;
        }

        void callActive(boolean callActive) {
            this.callActive = callActive;
            this.callActiveBuildStage = 1;
        }

        boolean callNotEmpty() {
            if (this.callNotEmptyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callNotEmptyBuildStage == 0) {
                this.callNotEmptyBuildStage = (byte)-1;
                this.callNotEmpty = ImmutableBaseChat.this.callNotEmptyInitialize();
                this.callNotEmptyBuildStage = 1;
            }
            return this.callNotEmpty;
        }

        void callNotEmpty(boolean callNotEmpty) {
            this.callNotEmpty = callNotEmpty;
            this.callNotEmptyBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableBaseChat.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.creatorBuildStage == -1) {
                attributes.add("creator");
            }
            if (this.leftBuildStage == -1) {
                attributes.add("left");
            }
            if (this.deactivatedBuildStage == -1) {
                attributes.add("deactivated");
            }
            if (this.callActiveBuildStage == -1) {
                attributes.add("callActive");
            }
            if (this.callNotEmptyBuildStage == -1) {
                attributes.add("callNotEmpty");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            return "Cannot build BaseChat, attribute initializers form cycle " + attributes;
        }
    }
}

