/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseChatFull;
import telegram4j.tl.BotInfo;
import telegram4j.tl.ChatFull;
import telegram4j.tl.ChatParticipants;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChatFull
implements BaseChatFull {
    private final int identifier;
    private final int flags;
    private final boolean canSetUsername;
    private final boolean hasScheduled;
    private final long id;
    private final String about;
    private final ChatParticipants participants;
    @Nullable
    private final Photo chatPhoto;
    private final PeerNotifySettings notifySettings;
    @Nullable
    private final ExportedChatInvite exportedInvite;
    @Nullable
    private final List<BotInfo> botInfo;
    @Nullable
    private final Integer pinnedMsgId;
    @Nullable
    private final Integer folderId;
    @Nullable
    private final InputGroupCall call;
    @Nullable
    private final Integer ttlPeriod;
    @Nullable
    private final Peer groupcallDefaultJoinAs;
    @Nullable
    private final String themeEmoticon;
    @Nullable
    private final Integer requestsPending;
    @Nullable
    private final List<Long> recentRequesters;
    @Nullable
    private final List<String> availableReactions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseChatFull(long id, String about, ChatParticipants participants, PeerNotifySettings notifySettings) {
        this.id = id;
        this.about = Objects.requireNonNull(about, "about");
        this.participants = Objects.requireNonNull(participants, "participants");
        this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
        this.chatPhoto = null;
        this.exportedInvite = null;
        this.botInfo = null;
        this.pinnedMsgId = null;
        this.folderId = null;
        this.call = null;
        this.ttlPeriod = null;
        this.groupcallDefaultJoinAs = null;
        this.themeEmoticon = null;
        this.requestsPending = null;
        this.recentRequesters = null;
        this.availableReactions = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSetUsername = this.initShim.canSetUsername();
        this.hasScheduled = this.initShim.hasScheduled();
        this.initShim = null;
    }

    private ImmutableBaseChatFull(Builder builder) {
        this.id = builder.id;
        this.about = builder.about;
        this.participants = builder.participants;
        this.chatPhoto = builder.chatPhoto;
        this.notifySettings = builder.notifySettings;
        this.exportedInvite = builder.exportedInvite;
        this.botInfo = builder.botInfo == null ? null : ImmutableBaseChatFull.createUnmodifiableList(true, builder.botInfo);
        this.pinnedMsgId = builder.pinnedMsgId;
        this.folderId = builder.folderId;
        this.call = builder.call;
        this.ttlPeriod = builder.ttlPeriod;
        this.groupcallDefaultJoinAs = builder.groupcallDefaultJoinAs;
        this.themeEmoticon = builder.themeEmoticon;
        this.requestsPending = builder.requestsPending;
        this.recentRequesters = builder.recentRequesters == null ? null : ImmutableBaseChatFull.createUnmodifiableList(true, builder.recentRequesters);
        List<String> list = this.availableReactions = builder.availableReactions == null ? null : ImmutableBaseChatFull.createUnmodifiableList(true, builder.availableReactions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canSetUsernameIsSet()) {
            this.initShim.canSetUsername(builder.canSetUsername);
        }
        if (builder.hasScheduledIsSet()) {
            this.initShim.hasScheduled(builder.hasScheduled);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSetUsername = this.initShim.canSetUsername();
        this.hasScheduled = this.initShim.hasScheduled();
        this.initShim = null;
    }

    private ImmutableBaseChatFull(int identifier, int flags, boolean canSetUsername, boolean hasScheduled, long id, String about, ChatParticipants participants, @Nullable Photo chatPhoto, PeerNotifySettings notifySettings, @Nullable ExportedChatInvite exportedInvite, @Nullable List<BotInfo> botInfo, @Nullable Integer pinnedMsgId, @Nullable Integer folderId, @Nullable InputGroupCall call, @Nullable Integer ttlPeriod, @Nullable Peer groupcallDefaultJoinAs, @Nullable String themeEmoticon, @Nullable Integer requestsPending, @Nullable List<Long> recentRequesters, @Nullable List<String> availableReactions) {
        this.identifier = identifier;
        this.flags = flags;
        this.canSetUsername = canSetUsername;
        this.hasScheduled = hasScheduled;
        this.id = id;
        this.about = about;
        this.participants = participants;
        this.chatPhoto = chatPhoto;
        this.notifySettings = notifySettings;
        this.exportedInvite = exportedInvite;
        this.botInfo = botInfo;
        this.pinnedMsgId = pinnedMsgId;
        this.folderId = folderId;
        this.call = call;
        this.ttlPeriod = ttlPeriod;
        this.groupcallDefaultJoinAs = groupcallDefaultJoinAs;
        this.themeEmoticon = themeEmoticon;
        this.requestsPending = requestsPending;
        this.recentRequesters = recentRequesters;
        this.availableReactions = availableReactions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseChatFull.super.identifier();
    }

    private int flagsInitialize() {
        return BaseChatFull.super.flags();
    }

    private boolean canSetUsernameInitialize() {
        return BaseChatFull.super.canSetUsername();
    }

    private boolean hasScheduledInitialize() {
        return BaseChatFull.super.hasScheduled();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canSetUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSetUsername() : this.canSetUsername;
    }

    @Override
    public boolean hasScheduled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasScheduled() : this.hasScheduled;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String about() {
        return this.about;
    }

    @Override
    public ChatParticipants participants() {
        return this.participants;
    }

    @Override
    @Nullable
    public Photo chatPhoto() {
        return this.chatPhoto;
    }

    @Override
    public PeerNotifySettings notifySettings() {
        return this.notifySettings;
    }

    @Override
    @Nullable
    public ExportedChatInvite exportedInvite() {
        return this.exportedInvite;
    }

    @Override
    @Nullable
    public List<BotInfo> botInfo() {
        return this.botInfo;
    }

    @Override
    @Nullable
    public Integer pinnedMsgId() {
        return this.pinnedMsgId;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    @Nullable
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    @Override
    @Nullable
    public Peer groupcallDefaultJoinAs() {
        return this.groupcallDefaultJoinAs;
    }

    @Override
    @Nullable
    public String themeEmoticon() {
        return this.themeEmoticon;
    }

    @Override
    @Nullable
    public Integer requestsPending() {
        return this.requestsPending;
    }

    @Override
    @Nullable
    public List<Long> recentRequesters() {
        return this.recentRequesters;
    }

    @Override
    @Nullable
    public List<String> availableReactions() {
        return this.availableReactions;
    }

    public final ImmutableBaseChatFull withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChatFull(value, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, value, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withCanSetUsername(boolean value) {
        if (this.canSetUsername == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, value, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withHasScheduled(boolean value) {
        if (this.hasScheduled == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, value, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, value, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withAbout(String value) {
        String newValue = Objects.requireNonNull(value, "about");
        if (this.about.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, newValue, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withParticipants(ChatParticipants value) {
        if (this.participants == value) {
            return this;
        }
        ChatParticipants newValue = Objects.requireNonNull(value, "participants");
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, newValue, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withChatPhoto(@Nullable Photo value) {
        if (this.chatPhoto == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, value, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withNotifySettings(PeerNotifySettings value) {
        if (this.notifySettings == value) {
            return this;
        }
        PeerNotifySettings newValue = Objects.requireNonNull(value, "notifySettings");
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, newValue, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withExportedInvite(@Nullable ExportedChatInvite value) {
        if (this.exportedInvite == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, value, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withBotInfo(BotInfo ... elements) {
        if (elements == null) {
            return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, null, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
        }
        List<BotInfo> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseChatFull.createUnmodifiableList(false, ImmutableBaseChatFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, newValue, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withBotInfo(@Nullable Iterable<? extends BotInfo> elements) {
        if (this.botInfo == elements) {
            return this;
        }
        List<BotInfo> newValue = elements == null ? null : ImmutableBaseChatFull.createUnmodifiableList(false, ImmutableBaseChatFull.createSafeList(elements, true, false));
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, newValue, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withPinnedMsgId(@Nullable Integer value) {
        if (Objects.equals(this.pinnedMsgId, value)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, value, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, value, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withCall(@Nullable InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, value, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, value, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withGroupcallDefaultJoinAs(@Nullable Peer value) {
        if (this.groupcallDefaultJoinAs == value) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, value, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withThemeEmoticon(@Nullable String value) {
        if (Objects.equals(this.themeEmoticon, value)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, value, this.requestsPending, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withRequestsPending(@Nullable Integer value) {
        if (Objects.equals(this.requestsPending, value)) {
            return this;
        }
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, value, this.recentRequesters, this.availableReactions);
    }

    public final ImmutableBaseChatFull withRecentRequesters(long ... elements) {
        if (elements == null) {
            return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, null, this.availableReactions);
        }
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableBaseChatFull.createUnmodifiableList(false, wrappedList);
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, newValue, this.availableReactions);
    }

    public final ImmutableBaseChatFull withRecentRequesters(@Nullable Iterable<Long> elements) {
        if (this.recentRequesters == elements) {
            return this;
        }
        List<Long> newValue = elements == null ? null : ImmutableBaseChatFull.createUnmodifiableList(false, ImmutableBaseChatFull.createSafeList(elements, true, false));
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, newValue, this.availableReactions);
    }

    public final ImmutableBaseChatFull withAvailableReactions(String ... elements) {
        if (elements == null) {
            return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseChatFull.createUnmodifiableList(false, ImmutableBaseChatFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, newValue);
    }

    public final ImmutableBaseChatFull withAvailableReactions(@Nullable Iterable<String> elements) {
        if (this.availableReactions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableBaseChatFull.createUnmodifiableList(false, ImmutableBaseChatFull.createSafeList(elements, true, false));
        return new ImmutableBaseChatFull(this.identifier, this.flags, this.canSetUsername, this.hasScheduled, this.id, this.about, this.participants, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.pinnedMsgId, this.folderId, this.call, this.ttlPeriod, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChatFull && this.equalTo(0, (ImmutableBaseChatFull)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChatFull another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canSetUsername == another.canSetUsername && this.hasScheduled == another.hasScheduled && this.id == another.id && this.about.equals(another.about) && this.participants.equals(another.participants) && Objects.equals(this.chatPhoto, another.chatPhoto) && this.notifySettings.equals(another.notifySettings) && Objects.equals(this.exportedInvite, another.exportedInvite) && Objects.equals(this.botInfo, another.botInfo) && Objects.equals(this.pinnedMsgId, another.pinnedMsgId) && Objects.equals(this.folderId, another.folderId) && Objects.equals(this.call, another.call) && Objects.equals(this.ttlPeriod, another.ttlPeriod) && Objects.equals(this.groupcallDefaultJoinAs, another.groupcallDefaultJoinAs) && Objects.equals(this.themeEmoticon, another.themeEmoticon) && Objects.equals(this.requestsPending, another.requestsPending) && Objects.equals(this.recentRequesters, another.recentRequesters) && Objects.equals(this.availableReactions, another.availableReactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canSetUsername);
        h += (h << 5) + Boolean.hashCode(this.hasScheduled);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.about.hashCode();
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + Objects.hashCode(this.chatPhoto);
        h += (h << 5) + this.notifySettings.hashCode();
        h += (h << 5) + Objects.hashCode(this.exportedInvite);
        h += (h << 5) + Objects.hashCode(this.botInfo);
        h += (h << 5) + Objects.hashCode(this.pinnedMsgId);
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + Objects.hashCode(this.call);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        h += (h << 5) + Objects.hashCode(this.groupcallDefaultJoinAs);
        h += (h << 5) + Objects.hashCode(this.themeEmoticon);
        h += (h << 5) + Objects.hashCode(this.requestsPending);
        h += (h << 5) + Objects.hashCode(this.recentRequesters);
        h += (h << 5) + Objects.hashCode(this.availableReactions);
        return h;
    }

    public String toString() {
        return "BaseChatFull{identifier=" + this.identifier + ", flags=" + this.flags + ", canSetUsername=" + this.canSetUsername + ", hasScheduled=" + this.hasScheduled + ", id=" + this.id + ", about=" + this.about + ", participants=" + this.participants + ", chatPhoto=" + this.chatPhoto + ", notifySettings=" + this.notifySettings + ", exportedInvite=" + this.exportedInvite + ", botInfo=" + this.botInfo + ", pinnedMsgId=" + this.pinnedMsgId + ", folderId=" + this.folderId + ", call=" + this.call + ", ttlPeriod=" + this.ttlPeriod + ", groupcallDefaultJoinAs=" + this.groupcallDefaultJoinAs + ", themeEmoticon=" + this.themeEmoticon + ", requestsPending=" + this.requestsPending + ", recentRequesters=" + this.recentRequesters + ", availableReactions=" + this.availableReactions + "}";
    }

    public static ImmutableBaseChatFull of(long id, String about, ChatParticipants participants, PeerNotifySettings notifySettings) {
        return new ImmutableBaseChatFull(id, about, participants, notifySettings);
    }

    public static ImmutableBaseChatFull copyOf(BaseChatFull instance) {
        if (instance instanceof ImmutableBaseChatFull) {
            return (ImmutableBaseChatFull)instance;
        }
        return ImmutableBaseChatFull.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ABOUT = 2L;
        private static final long INIT_BIT_PARTICIPANTS = 4L;
        private static final long INIT_BIT_NOTIFY_SETTINGS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_SET_USERNAME = 4L;
        private static final long OPT_BIT_HAS_SCHEDULED = 8L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canSetUsername;
        private boolean hasScheduled;
        private long id;
        private String about;
        private ChatParticipants participants;
        private Photo chatPhoto;
        private PeerNotifySettings notifySettings;
        private ExportedChatInvite exportedInvite;
        private List<BotInfo> botInfo = null;
        private Integer pinnedMsgId;
        private Integer folderId;
        private InputGroupCall call;
        private Integer ttlPeriod;
        private Peer groupcallDefaultJoinAs;
        private String themeEmoticon;
        private Integer requestsPending;
        private List<Long> recentRequesters = null;
        private List<String> availableReactions = null;

        private Builder() {
        }

        public final Builder from(BaseChatFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatFull instance;
            long bits = 0L;
            if (object instanceof BaseChatFull) {
                List<BotInfo> botInfoValue;
                Photo chatPhotoValue;
                instance = (BaseChatFull)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((chatPhotoValue = instance.chatPhoto()) != null) {
                    this.chatPhoto(chatPhotoValue);
                }
                if ((bits & 2L) == 0L) {
                    Peer groupcallDefaultJoinAsValue = instance.groupcallDefaultJoinAs();
                    if (groupcallDefaultJoinAsValue != null) {
                        this.groupcallDefaultJoinAs(groupcallDefaultJoinAsValue);
                    }
                    bits |= 2L;
                }
                if ((botInfoValue = instance.botInfo()) != null) {
                    this.addAllBotInfo(botInfoValue);
                }
                if ((bits & 4L) == 0L) {
                    Integer pinnedMsgIdValue = instance.pinnedMsgId();
                    if (pinnedMsgIdValue != null) {
                        this.pinnedMsgId(pinnedMsgIdValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<String> availableReactionsValue = instance.availableReactions();
                    if (availableReactionsValue != null) {
                        this.addAllAvailableReactions(availableReactionsValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.about(instance.about());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    List<Long> recentRequestersValue = instance.recentRequesters();
                    if (recentRequestersValue != null) {
                        this.addAllRecentRequesters(recentRequestersValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.canSetUsername(instance.canSetUsername());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.notifySettings(instance.notifySettings());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    Integer folderIdValue = instance.folderId();
                    if (folderIdValue != null) {
                        this.folderId(folderIdValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    InputGroupCall callValue = instance.call();
                    if (callValue != null) {
                        this.call(callValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    String themeEmoticonValue = instance.themeEmoticon();
                    if (themeEmoticonValue != null) {
                        this.themeEmoticon(themeEmoticonValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    Integer requestsPendingValue = instance.requestsPending();
                    if (requestsPendingValue != null) {
                        this.requestsPending(requestsPendingValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.hasScheduled(instance.hasScheduled());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    ExportedChatInvite exportedInviteValue = instance.exportedInvite();
                    if (exportedInviteValue != null) {
                        this.exportedInvite(exportedInviteValue);
                    }
                    bits |= 0x10000L;
                }
                this.participants(instance.participants());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatFull) {
                instance = (ChatFull)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Peer groupcallDefaultJoinAsValue = instance.groupcallDefaultJoinAs();
                    if (groupcallDefaultJoinAsValue != null) {
                        this.groupcallDefaultJoinAs(groupcallDefaultJoinAsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Integer pinnedMsgIdValue = instance.pinnedMsgId();
                    if (pinnedMsgIdValue != null) {
                        this.pinnedMsgId(pinnedMsgIdValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<String> availableReactionsValue = instance.availableReactions();
                    if (availableReactionsValue != null) {
                        this.addAllAvailableReactions(availableReactionsValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.about(instance.about());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    List<Long> recentRequestersValue = instance.recentRequesters();
                    if (recentRequestersValue != null) {
                        this.addAllRecentRequesters(recentRequestersValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.canSetUsername(instance.canSetUsername());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.notifySettings(instance.notifySettings());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    Integer folderIdValue = instance.folderId();
                    if (folderIdValue != null) {
                        this.folderId(folderIdValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    InputGroupCall callValue = instance.call();
                    if (callValue != null) {
                        this.call(callValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    String themeEmoticonValue = instance.themeEmoticon();
                    if (themeEmoticonValue != null) {
                        this.themeEmoticon(themeEmoticonValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    Integer requestsPendingValue = instance.requestsPending();
                    if (requestsPendingValue != null) {
                        this.requestsPending(requestsPendingValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.hasScheduled(instance.hasScheduled());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    ExportedChatInvite exportedInviteValue = instance.exportedInvite();
                    if (exportedInviteValue != null) {
                        this.exportedInvite(exportedInviteValue);
                    }
                    bits |= 0x10000L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canSetUsername(boolean canSetUsername) {
            this.canSetUsername = canSetUsername;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.optBits |= 8L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder about(String about) {
            this.about = Objects.requireNonNull(about, "about");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder participants(ChatParticipants participants) {
            this.participants = Objects.requireNonNull(participants, "participants");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder chatPhoto(@Nullable Photo chatPhoto) {
            this.chatPhoto = chatPhoto;
            return this;
        }

        public final Builder notifySettings(PeerNotifySettings notifySettings) {
            this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder exportedInvite(@Nullable ExportedChatInvite exportedInvite) {
            this.exportedInvite = exportedInvite;
            return this;
        }

        public final Builder addBotInfo(BotInfo element) {
            if (this.botInfo == null) {
                this.botInfo = new ArrayList<BotInfo>();
            }
            this.botInfo.add(Objects.requireNonNull(element, "botInfo element"));
            return this;
        }

        public final Builder addBotInfo(BotInfo ... elements) {
            if (this.botInfo == null) {
                this.botInfo = new ArrayList<BotInfo>();
            }
            for (BotInfo element : elements) {
                this.botInfo.add(Objects.requireNonNull(element, "botInfo element"));
            }
            return this;
        }

        public final Builder botInfo(@Nullable Iterable<? extends BotInfo> elements) {
            if (elements == null) {
                this.botInfo = null;
                return this;
            }
            this.botInfo = new ArrayList<BotInfo>();
            return this.addAllBotInfo(elements);
        }

        public final Builder addAllBotInfo(Iterable<? extends BotInfo> elements) {
            Objects.requireNonNull(elements, "botInfo element");
            if (this.botInfo == null) {
                this.botInfo = new ArrayList<BotInfo>();
            }
            for (BotInfo botInfo : elements) {
                this.botInfo.add(Objects.requireNonNull(botInfo, "botInfo element"));
            }
            return this;
        }

        public final Builder pinnedMsgId(@Nullable Integer pinnedMsgId) {
            this.pinnedMsgId = pinnedMsgId;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder call(@Nullable InputGroupCall call) {
            this.call = call;
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public final Builder groupcallDefaultJoinAs(@Nullable Peer groupcallDefaultJoinAs) {
            this.groupcallDefaultJoinAs = groupcallDefaultJoinAs;
            return this;
        }

        public final Builder themeEmoticon(@Nullable String themeEmoticon) {
            this.themeEmoticon = themeEmoticon;
            return this;
        }

        public final Builder requestsPending(@Nullable Integer requestsPending) {
            this.requestsPending = requestsPending;
            return this;
        }

        public final Builder addRecentRequester(long element) {
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            this.recentRequesters.add(element);
            return this;
        }

        public final Builder addRecentRequesters(long ... elements) {
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.recentRequesters.add(element);
            }
            return this;
        }

        public final Builder recentRequesters(@Nullable Iterable<Long> elements) {
            if (elements == null) {
                this.recentRequesters = null;
                return this;
            }
            this.recentRequesters = new ArrayList<Long>();
            return this.addAllRecentRequesters(elements);
        }

        public final Builder addAllRecentRequesters(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "recentRequesters element");
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            for (Long element : elements) {
                this.recentRequesters.add(Objects.requireNonNull(element, "recentRequesters element"));
            }
            return this;
        }

        public final Builder addAvailableReaction(String element) {
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            return this;
        }

        public final Builder addAvailableReactions(String ... elements) {
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public final Builder availableReactions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.availableReactions = null;
                return this;
            }
            this.availableReactions = new ArrayList<String>();
            return this.addAllAvailableReactions(elements);
        }

        public final Builder addAllAvailableReactions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "availableReactions element");
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public ImmutableBaseChatFull build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChatFull(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canSetUsernameIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hasScheduledIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("about");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("participants");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("notifySettings");
            }
            return "Cannot build BaseChatFull, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canSetUsernameBuildStage = 0;
        private boolean canSetUsername;
        private byte hasScheduledBuildStage = 0;
        private boolean hasScheduled;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseChatFull.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseChatFull.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canSetUsername() {
            if (this.canSetUsernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSetUsernameBuildStage == 0) {
                this.canSetUsernameBuildStage = (byte)-1;
                this.canSetUsername = ImmutableBaseChatFull.this.canSetUsernameInitialize();
                this.canSetUsernameBuildStage = 1;
            }
            return this.canSetUsername;
        }

        void canSetUsername(boolean canSetUsername) {
            this.canSetUsername = canSetUsername;
            this.canSetUsernameBuildStage = 1;
        }

        boolean hasScheduled() {
            if (this.hasScheduledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasScheduledBuildStage == 0) {
                this.hasScheduledBuildStage = (byte)-1;
                this.hasScheduled = ImmutableBaseChatFull.this.hasScheduledInitialize();
                this.hasScheduledBuildStage = 1;
            }
            return this.hasScheduled;
        }

        void hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.hasScheduledBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canSetUsernameBuildStage == -1) {
                attributes.add("canSetUsername");
            }
            if (this.hasScheduledBuildStage == -1) {
                attributes.add("hasScheduled");
            }
            return "Cannot build BaseChatFull, attribute initializers form cycle " + attributes;
        }
    }
}

