/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseChatInvite;
import telegram4j.tl.ChatInvite;
import telegram4j.tl.Photo;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChatInvite
implements BaseChatInvite {
    private final int identifier;
    private final int flags;
    private final boolean channel;
    private final boolean broadcast;
    private final boolean isPublic;
    private final boolean megagroup;
    private final boolean requestNeeded;
    private final String title;
    @Nullable
    private final String about;
    private final Photo photo;
    private final int participantsCount;
    @Nullable
    private final List<User> participants;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseChatInvite(String title, Photo photo, int participantsCount) {
        this.title = Objects.requireNonNull(title, "title");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.participantsCount = participantsCount;
        this.about = null;
        this.participants = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.channel = this.initShim.channel();
        this.broadcast = this.initShim.broadcast();
        this.isPublic = this.initShim.isPublic();
        this.megagroup = this.initShim.megagroup();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableBaseChatInvite(Builder builder) {
        this.title = builder.title;
        this.about = builder.about;
        this.photo = builder.photo;
        this.participantsCount = builder.participantsCount;
        List<User> list = this.participants = builder.participants == null ? null : ImmutableBaseChatInvite.createUnmodifiableList(true, builder.participants);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.channelIsSet()) {
            this.initShim.channel(builder.channel);
        }
        if (builder.broadcastIsSet()) {
            this.initShim.broadcast(builder.broadcast);
        }
        if (builder.isPublicIsSet()) {
            this.initShim.isPublic(builder.isPublic);
        }
        if (builder.megagroupIsSet()) {
            this.initShim.megagroup(builder.megagroup);
        }
        if (builder.requestNeededIsSet()) {
            this.initShim.requestNeeded(builder.requestNeeded);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.channel = this.initShim.channel();
        this.broadcast = this.initShim.broadcast();
        this.isPublic = this.initShim.isPublic();
        this.megagroup = this.initShim.megagroup();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableBaseChatInvite(int identifier, int flags, boolean channel, boolean broadcast, boolean isPublic, boolean megagroup, boolean requestNeeded, String title, @Nullable String about, Photo photo, int participantsCount, @Nullable List<User> participants) {
        this.identifier = identifier;
        this.flags = flags;
        this.channel = channel;
        this.broadcast = broadcast;
        this.isPublic = isPublic;
        this.megagroup = megagroup;
        this.requestNeeded = requestNeeded;
        this.title = title;
        this.about = about;
        this.photo = photo;
        this.participantsCount = participantsCount;
        this.participants = participants;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseChatInvite.super.identifier();
    }

    private int flagsInitialize() {
        return BaseChatInvite.super.flags();
    }

    private boolean channelInitialize() {
        return BaseChatInvite.super.channel();
    }

    private boolean broadcastInitialize() {
        return BaseChatInvite.super.broadcast();
    }

    private boolean isPublicInitialize() {
        return BaseChatInvite.super.isPublic();
    }

    private boolean megagroupInitialize() {
        return BaseChatInvite.super.megagroup();
    }

    private boolean requestNeededInitialize() {
        return BaseChatInvite.super.requestNeeded();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean channel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.channel() : this.channel;
    }

    @Override
    public boolean broadcast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.broadcast() : this.broadcast;
    }

    @Override
    public boolean isPublic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublic() : this.isPublic;
    }

    @Override
    public boolean megagroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.megagroup() : this.megagroup;
    }

    @Override
    public boolean requestNeeded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestNeeded() : this.requestNeeded;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String about() {
        return this.about;
    }

    @Override
    public Photo photo() {
        return this.photo;
    }

    @Override
    public int participantsCount() {
        return this.participantsCount;
    }

    @Override
    @Nullable
    public List<User> participants() {
        return this.participants;
    }

    public final ImmutableBaseChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(value, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, value, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withChannel(boolean value) {
        if (this.channel == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, value, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withBroadcast(boolean value) {
        if (this.broadcast == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, value, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withIsPublic(boolean value) {
        if (this.isPublic == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, value, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withMegagroup(boolean value) {
        if (this.megagroup == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, value, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withRequestNeeded(boolean value) {
        if (this.requestNeeded == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, value, this.title, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, newValue, this.about, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withAbout(@Nullable String value) {
        if (Objects.equals(this.about, value)) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, value, this.photo, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withPhoto(Photo value) {
        if (this.photo == value) {
            return this;
        }
        Photo newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, newValue, this.participantsCount, this.participants);
    }

    public final ImmutableBaseChatInvite withParticipantsCount(int value) {
        if (this.participantsCount == value) {
            return this;
        }
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, value, this.participants);
    }

    public final ImmutableBaseChatInvite withParticipants(User ... elements) {
        if (elements == null) {
            return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, null);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseChatInvite.createUnmodifiableList(false, ImmutableBaseChatInvite.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, newValue);
    }

    public final ImmutableBaseChatInvite withParticipants(@Nullable Iterable<? extends User> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutableBaseChatInvite.createUnmodifiableList(false, ImmutableBaseChatInvite.createSafeList(elements, true, false));
        return new ImmutableBaseChatInvite(this.identifier, this.flags, this.channel, this.broadcast, this.isPublic, this.megagroup, this.requestNeeded, this.title, this.about, this.photo, this.participantsCount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChatInvite && this.equalTo(0, (ImmutableBaseChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChatInvite another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channel == another.channel && this.broadcast == another.broadcast && this.isPublic == another.isPublic && this.megagroup == another.megagroup && this.requestNeeded == another.requestNeeded && this.title.equals(another.title) && Objects.equals(this.about, another.about) && this.photo.equals(another.photo) && this.participantsCount == another.participantsCount && Objects.equals(this.participants, another.participants);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.channel);
        h += (h << 5) + Boolean.hashCode(this.broadcast);
        h += (h << 5) + Boolean.hashCode(this.isPublic);
        h += (h << 5) + Boolean.hashCode(this.megagroup);
        h += (h << 5) + Boolean.hashCode(this.requestNeeded);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.about);
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + this.participantsCount;
        h += (h << 5) + Objects.hashCode(this.participants);
        return h;
    }

    public String toString() {
        return "BaseChatInvite{identifier=" + this.identifier + ", flags=" + this.flags + ", channel=" + this.channel + ", broadcast=" + this.broadcast + ", isPublic=" + this.isPublic + ", megagroup=" + this.megagroup + ", requestNeeded=" + this.requestNeeded + ", title=" + this.title + ", about=" + this.about + ", photo=" + this.photo + ", participantsCount=" + this.participantsCount + ", participants=" + this.participants + "}";
    }

    public static ImmutableBaseChatInvite of(String title, Photo photo, int participantsCount) {
        return new ImmutableBaseChatInvite(title, photo, participantsCount);
    }

    public static ImmutableBaseChatInvite copyOf(BaseChatInvite instance) {
        if (instance instanceof ImmutableBaseChatInvite) {
            return (ImmutableBaseChatInvite)instance;
        }
        return ImmutableBaseChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_PHOTO = 2L;
        private static final long INIT_BIT_PARTICIPANTS_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CHANNEL = 4L;
        private static final long OPT_BIT_BROADCAST = 8L;
        private static final long OPT_BIT_IS_PUBLIC = 16L;
        private static final long OPT_BIT_MEGAGROUP = 32L;
        private static final long OPT_BIT_REQUEST_NEEDED = 64L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean channel;
        private boolean broadcast;
        private boolean isPublic;
        private boolean megagroup;
        private boolean requestNeeded;
        private String title;
        private String about;
        private Photo photo;
        private int participantsCount;
        private List<User> participants = null;

        private Builder() {
        }

        public final Builder from(ChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatInvite instance;
            long bits = 0L;
            if (object instanceof ChatInvite) {
                instance = (ChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChatInvite) {
                instance = (BaseChatInvite)object;
                this.broadcast(instance.broadcast());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestNeeded(instance.requestNeeded());
                this.participantsCount(instance.participantsCount());
                this.flags(instance.flags());
                this.channel(instance.channel());
                String aboutValue = instance.about();
                if (aboutValue != null) {
                    this.about(aboutValue);
                }
                this.isPublic(instance.isPublic());
                this.photo(instance.photo());
                this.title(instance.title());
                this.megagroup(instance.megagroup());
                List<User> participantsValue = instance.participants();
                if (participantsValue != null) {
                    this.addAllParticipants(participantsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channel(boolean channel) {
            this.channel = channel;
            this.optBits |= 4L;
            return this;
        }

        public final Builder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.optBits |= 8L;
            return this;
        }

        public final Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder about(@Nullable String about) {
            this.about = about;
            return this;
        }

        public final Builder photo(Photo photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder participantsCount(int participantsCount) {
            this.participantsCount = participantsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addParticipant(User element) {
            if (this.participants == null) {
                this.participants = new ArrayList<User>();
            }
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(User ... elements) {
            if (this.participants == null) {
                this.participants = new ArrayList<User>();
            }
            for (User element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.participants = null;
                return this;
            }
            this.participants = new ArrayList<User>();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "participants element");
            if (this.participants == null) {
                this.participants = new ArrayList<User>();
            }
            for (User user : elements) {
                this.participants.add(Objects.requireNonNull(user, "participants element"));
            }
            return this;
        }

        public ImmutableBaseChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean channelIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean broadcastIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean isPublicIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean megagroupIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean requestNeededIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("photo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("participantsCount");
            }
            return "Cannot build BaseChatInvite, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte channelBuildStage = 0;
        private boolean channel;
        private byte broadcastBuildStage = 0;
        private boolean broadcast;
        private byte isPublicBuildStage = 0;
        private boolean isPublic;
        private byte megagroupBuildStage = 0;
        private boolean megagroup;
        private byte requestNeededBuildStage = 0;
        private boolean requestNeeded;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseChatInvite.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseChatInvite.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean channel() {
            if (this.channelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.channelBuildStage == 0) {
                this.channelBuildStage = (byte)-1;
                this.channel = ImmutableBaseChatInvite.this.channelInitialize();
                this.channelBuildStage = 1;
            }
            return this.channel;
        }

        void channel(boolean channel) {
            this.channel = channel;
            this.channelBuildStage = 1;
        }

        boolean broadcast() {
            if (this.broadcastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.broadcastBuildStage == 0) {
                this.broadcastBuildStage = (byte)-1;
                this.broadcast = ImmutableBaseChatInvite.this.broadcastInitialize();
                this.broadcastBuildStage = 1;
            }
            return this.broadcast;
        }

        void broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.broadcastBuildStage = 1;
        }

        boolean isPublic() {
            if (this.isPublicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPublicBuildStage == 0) {
                this.isPublicBuildStage = (byte)-1;
                this.isPublic = ImmutableBaseChatInvite.this.isPublicInitialize();
                this.isPublicBuildStage = 1;
            }
            return this.isPublic;
        }

        void isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicBuildStage = 1;
        }

        boolean megagroup() {
            if (this.megagroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.megagroupBuildStage == 0) {
                this.megagroupBuildStage = (byte)-1;
                this.megagroup = ImmutableBaseChatInvite.this.megagroupInitialize();
                this.megagroupBuildStage = 1;
            }
            return this.megagroup;
        }

        void megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.megagroupBuildStage = 1;
        }

        boolean requestNeeded() {
            if (this.requestNeededBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestNeededBuildStage == 0) {
                this.requestNeededBuildStage = (byte)-1;
                this.requestNeeded = ImmutableBaseChatInvite.this.requestNeededInitialize();
                this.requestNeededBuildStage = 1;
            }
            return this.requestNeeded;
        }

        void requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.requestNeededBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.channelBuildStage == -1) {
                attributes.add("channel");
            }
            if (this.broadcastBuildStage == -1) {
                attributes.add("broadcast");
            }
            if (this.isPublicBuildStage == -1) {
                attributes.add("isPublic");
            }
            if (this.megagroupBuildStage == -1) {
                attributes.add("megagroup");
            }
            if (this.requestNeededBuildStage == -1) {
                attributes.add("requestNeeded");
            }
            return "Cannot build BaseChatInvite, attribute initializers form cycle " + attributes;
        }
    }
}

