/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BaseChatParticipants;
import telegram4j.tl.ChatParticipant;
import telegram4j.tl.ChatParticipants;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseChatParticipants
implements BaseChatParticipants {
    private final int identifier;
    private final long chatId;
    private final List<ChatParticipant> participants;
    private final int version;

    private ImmutableBaseChatParticipants(long chatId, int version) {
        this.chatId = chatId;
        this.version = version;
        this.participants = Collections.emptyList();
        this.identifier = BaseChatParticipants.super.identifier();
    }

    private ImmutableBaseChatParticipants(Builder builder) {
        this.chatId = builder.chatId;
        this.participants = ImmutableBaseChatParticipants.createUnmodifiableList(true, builder.participants);
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseChatParticipants.super.identifier();
    }

    private ImmutableBaseChatParticipants(int identifier, long chatId, List<ChatParticipant> participants, int version) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.participants = participants;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public List<ChatParticipant> participants() {
        return this.participants;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableBaseChatParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChatParticipants(value, this.chatId, this.participants, this.version);
    }

    public final ImmutableBaseChatParticipants withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableBaseChatParticipants(this.identifier, value, this.participants, this.version);
    }

    public final ImmutableBaseChatParticipants withParticipants(ChatParticipant ... elements) {
        List<ChatParticipant> newValue = ImmutableBaseChatParticipants.createUnmodifiableList(false, ImmutableBaseChatParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChatParticipants(this.identifier, this.chatId, newValue, this.version);
    }

    public final ImmutableBaseChatParticipants withParticipants(Iterable<? extends ChatParticipant> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<ChatParticipant> newValue = ImmutableBaseChatParticipants.createUnmodifiableList(false, ImmutableBaseChatParticipants.createSafeList(elements, true, false));
        return new ImmutableBaseChatParticipants(this.identifier, this.chatId, newValue, this.version);
    }

    public final ImmutableBaseChatParticipants withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableBaseChatParticipants(this.identifier, this.chatId, this.participants, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChatParticipants && this.equalTo(0, (ImmutableBaseChatParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChatParticipants another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.participants.equals(another.participants) && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "BaseChatParticipants{identifier=" + this.identifier + ", chatId=" + this.chatId + ", participants=" + this.participants + ", version=" + this.version + "}";
    }

    public static ImmutableBaseChatParticipants of(long chatId, int version) {
        return new ImmutableBaseChatParticipants(chatId, version);
    }

    public static ImmutableBaseChatParticipants copyOf(BaseChatParticipants instance) {
        if (instance instanceof ImmutableBaseChatParticipants) {
            return (ImmutableBaseChatParticipants)instance;
        }
        return ImmutableBaseChatParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long chatId;
        private List<ChatParticipant> participants = new ArrayList<ChatParticipant>();
        private int version;

        private Builder() {
        }

        public final Builder from(ChatParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChatParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatParticipants instance;
            long bits = 0L;
            if (object instanceof ChatParticipants) {
                instance = (ChatParticipants)object;
                if ((bits & 2L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChatParticipants) {
                instance = (BaseChatParticipants)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 2L;
                }
                this.version(instance.version());
                this.addAllParticipants(instance.participants());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParticipant(ChatParticipant element) {
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(ChatParticipant ... elements) {
            for (ChatParticipant element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(Iterable<? extends ChatParticipant> elements) {
            this.participants.clear();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends ChatParticipant> elements) {
            for (ChatParticipant chatParticipant : elements) {
                this.participants.add(Objects.requireNonNull(chatParticipant, "participants element"));
            }
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseChatParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChatParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build BaseChatParticipants, some of required attributes are not set " + attributes;
        }
    }
}

