/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseDialog;
import telegram4j.tl.Dialog;
import telegram4j.tl.DraftMessage;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseDialog
implements BaseDialog {
    private final int identifier;
    private final int flags;
    private final boolean pinned;
    private final boolean unreadMark;
    private final Peer peer;
    private final int topMessage;
    private final int readInboxMaxId;
    private final int readOutboxMaxId;
    private final int unreadCount;
    private final int unreadMentionsCount;
    private final int unreadReactionsCount;
    private final PeerNotifySettings notifySettings;
    @Nullable
    private final Integer pts;
    @Nullable
    private final DraftMessage draft;
    @Nullable
    private final Integer folderId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseDialog(Peer peer, int topMessage, int readInboxMaxId, int readOutboxMaxId, int unreadCount, int unreadMentionsCount, int unreadReactionsCount, PeerNotifySettings notifySettings) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.topMessage = topMessage;
        this.readInboxMaxId = readInboxMaxId;
        this.readOutboxMaxId = readOutboxMaxId;
        this.unreadCount = unreadCount;
        this.unreadMentionsCount = unreadMentionsCount;
        this.unreadReactionsCount = unreadReactionsCount;
        this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
        this.pts = null;
        this.draft = null;
        this.folderId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.unreadMark = this.initShim.unreadMark();
        this.initShim = null;
    }

    private ImmutableBaseDialog(Builder builder) {
        this.peer = builder.peer;
        this.topMessage = builder.topMessage;
        this.readInboxMaxId = builder.readInboxMaxId;
        this.readOutboxMaxId = builder.readOutboxMaxId;
        this.unreadCount = builder.unreadCount;
        this.unreadMentionsCount = builder.unreadMentionsCount;
        this.unreadReactionsCount = builder.unreadReactionsCount;
        this.notifySettings = builder.notifySettings;
        this.pts = builder.pts;
        this.draft = builder.draft;
        this.folderId = builder.folderId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pinnedIsSet()) {
            this.initShim.pinned(builder.pinned);
        }
        if (builder.unreadMarkIsSet()) {
            this.initShim.unreadMark(builder.unreadMark);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.unreadMark = this.initShim.unreadMark();
        this.initShim = null;
    }

    private ImmutableBaseDialog(int identifier, int flags, boolean pinned, boolean unreadMark, Peer peer, int topMessage, int readInboxMaxId, int readOutboxMaxId, int unreadCount, int unreadMentionsCount, int unreadReactionsCount, PeerNotifySettings notifySettings, @Nullable Integer pts, @Nullable DraftMessage draft, @Nullable Integer folderId) {
        this.identifier = identifier;
        this.flags = flags;
        this.pinned = pinned;
        this.unreadMark = unreadMark;
        this.peer = peer;
        this.topMessage = topMessage;
        this.readInboxMaxId = readInboxMaxId;
        this.readOutboxMaxId = readOutboxMaxId;
        this.unreadCount = unreadCount;
        this.unreadMentionsCount = unreadMentionsCount;
        this.unreadReactionsCount = unreadReactionsCount;
        this.notifySettings = notifySettings;
        this.pts = pts;
        this.draft = draft;
        this.folderId = folderId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseDialog.super.identifier();
    }

    private int flagsInitialize() {
        return BaseDialog.super.flags();
    }

    private boolean pinnedInitialize() {
        return BaseDialog.super.pinned();
    }

    private boolean unreadMarkInitialize() {
        return BaseDialog.super.unreadMark();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinned() : this.pinned;
    }

    @Override
    public boolean unreadMark() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unreadMark() : this.unreadMark;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int topMessage() {
        return this.topMessage;
    }

    @Override
    public int readInboxMaxId() {
        return this.readInboxMaxId;
    }

    @Override
    public int readOutboxMaxId() {
        return this.readOutboxMaxId;
    }

    @Override
    public int unreadCount() {
        return this.unreadCount;
    }

    @Override
    public int unreadMentionsCount() {
        return this.unreadMentionsCount;
    }

    @Override
    public int unreadReactionsCount() {
        return this.unreadReactionsCount;
    }

    @Override
    public PeerNotifySettings notifySettings() {
        return this.notifySettings;
    }

    @Override
    @Nullable
    public Integer pts() {
        return this.pts;
    }

    @Override
    @Nullable
    public DraftMessage draft() {
        return this.draft;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    public final ImmutableBaseDialog withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDialog(value, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, value, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, value, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withUnreadMark(boolean value) {
        if (this.unreadMark == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, value, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, newValue, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withTopMessage(int value) {
        if (this.topMessage == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, value, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withReadInboxMaxId(int value) {
        if (this.readInboxMaxId == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, value, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withReadOutboxMaxId(int value) {
        if (this.readOutboxMaxId == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, value, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withUnreadCount(int value) {
        if (this.unreadCount == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, value, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withUnreadMentionsCount(int value) {
        if (this.unreadMentionsCount == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, value, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withUnreadReactionsCount(int value) {
        if (this.unreadReactionsCount == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, value, this.notifySettings, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withNotifySettings(PeerNotifySettings value) {
        if (this.notifySettings == value) {
            return this;
        }
        PeerNotifySettings newValue = Objects.requireNonNull(value, "notifySettings");
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, newValue, this.pts, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withPts(@Nullable Integer value) {
        if (Objects.equals(this.pts, value)) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, value, this.draft, this.folderId);
    }

    public final ImmutableBaseDialog withDraft(@Nullable DraftMessage value) {
        if (this.draft == value) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, value, this.folderId);
    }

    public final ImmutableBaseDialog withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableBaseDialog(this.identifier, this.flags, this.pinned, this.unreadMark, this.peer, this.topMessage, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.unreadMentionsCount, this.unreadReactionsCount, this.notifySettings, this.pts, this.draft, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDialog && this.equalTo(0, (ImmutableBaseDialog)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDialog another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pinned == another.pinned && this.unreadMark == another.unreadMark && this.peer.equals(another.peer) && this.topMessage == another.topMessage && this.readInboxMaxId == another.readInboxMaxId && this.readOutboxMaxId == another.readOutboxMaxId && this.unreadCount == another.unreadCount && this.unreadMentionsCount == another.unreadMentionsCount && this.unreadReactionsCount == another.unreadReactionsCount && this.notifySettings.equals(another.notifySettings) && Objects.equals(this.pts, another.pts) && Objects.equals(this.draft, another.draft) && Objects.equals(this.folderId, another.folderId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + Boolean.hashCode(this.unreadMark);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.topMessage;
        h += (h << 5) + this.readInboxMaxId;
        h += (h << 5) + this.readOutboxMaxId;
        h += (h << 5) + this.unreadCount;
        h += (h << 5) + this.unreadMentionsCount;
        h += (h << 5) + this.unreadReactionsCount;
        h += (h << 5) + this.notifySettings.hashCode();
        h += (h << 5) + Objects.hashCode(this.pts);
        h += (h << 5) + Objects.hashCode(this.draft);
        h += (h << 5) + Objects.hashCode(this.folderId);
        return h;
    }

    public String toString() {
        return "BaseDialog{identifier=" + this.identifier + ", flags=" + this.flags + ", pinned=" + this.pinned + ", unreadMark=" + this.unreadMark + ", peer=" + this.peer + ", topMessage=" + this.topMessage + ", readInboxMaxId=" + this.readInboxMaxId + ", readOutboxMaxId=" + this.readOutboxMaxId + ", unreadCount=" + this.unreadCount + ", unreadMentionsCount=" + this.unreadMentionsCount + ", unreadReactionsCount=" + this.unreadReactionsCount + ", notifySettings=" + this.notifySettings + ", pts=" + this.pts + ", draft=" + this.draft + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableBaseDialog of(Peer peer, int topMessage, int readInboxMaxId, int readOutboxMaxId, int unreadCount, int unreadMentionsCount, int unreadReactionsCount, PeerNotifySettings notifySettings) {
        return new ImmutableBaseDialog(peer, topMessage, readInboxMaxId, readOutboxMaxId, unreadCount, unreadMentionsCount, unreadReactionsCount, notifySettings);
    }

    public static ImmutableBaseDialog copyOf(BaseDialog instance) {
        if (instance instanceof ImmutableBaseDialog) {
            return (ImmutableBaseDialog)instance;
        }
        return ImmutableBaseDialog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_TOP_MESSAGE = 2L;
        private static final long INIT_BIT_READ_INBOX_MAX_ID = 4L;
        private static final long INIT_BIT_READ_OUTBOX_MAX_ID = 8L;
        private static final long INIT_BIT_UNREAD_COUNT = 16L;
        private static final long INIT_BIT_UNREAD_MENTIONS_COUNT = 32L;
        private static final long INIT_BIT_UNREAD_REACTIONS_COUNT = 64L;
        private static final long INIT_BIT_NOTIFY_SETTINGS = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PINNED = 4L;
        private static final long OPT_BIT_UNREAD_MARK = 8L;
        private long initBits = 255L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pinned;
        private boolean unreadMark;
        private Peer peer;
        private int topMessage;
        private int readInboxMaxId;
        private int readOutboxMaxId;
        private int unreadCount;
        private int unreadMentionsCount;
        private int unreadReactionsCount;
        private PeerNotifySettings notifySettings;
        private Integer pts;
        private DraftMessage draft;
        private Integer folderId;

        private Builder() {
        }

        public final Builder from(Dialog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseDialog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Dialog instance;
            long bits = 0L;
            if (object instanceof Dialog) {
                instance = (Dialog)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.topMessage(instance.topMessage());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 0x10L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseDialog) {
                DraftMessage draftValue;
                Integer folderIdValue;
                instance = (BaseDialog)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                this.unreadMark(instance.unreadMark());
                this.readInboxMaxId(instance.readInboxMaxId());
                this.unreadMentionsCount(instance.unreadMentionsCount());
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.topMessage(instance.topMessage());
                    bits |= 8L;
                }
                this.unreadCount(instance.unreadCount());
                this.notifySettings(instance.notifySettings());
                Integer ptsValue = instance.pts();
                if (ptsValue != null) {
                    this.pts(ptsValue);
                }
                if ((folderIdValue = instance.folderId()) != null) {
                    this.folderId(folderIdValue);
                }
                this.readOutboxMaxId(instance.readOutboxMaxId());
                if ((bits & 0x10L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 0x10L;
                }
                if ((draftValue = instance.draft()) != null) {
                    this.draft(draftValue);
                }
                this.unreadReactionsCount(instance.unreadReactionsCount());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.optBits |= 4L;
            return this;
        }

        public final Builder unreadMark(boolean unreadMark) {
            this.unreadMark = unreadMark;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topMessage(int topMessage) {
            this.topMessage = topMessage;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder readInboxMaxId(int readInboxMaxId) {
            this.readInboxMaxId = readInboxMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder readOutboxMaxId(int readOutboxMaxId) {
            this.readOutboxMaxId = readOutboxMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder unreadCount(int unreadCount) {
            this.unreadCount = unreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder unreadMentionsCount(int unreadMentionsCount) {
            this.unreadMentionsCount = unreadMentionsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder unreadReactionsCount(int unreadReactionsCount) {
            this.unreadReactionsCount = unreadReactionsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder notifySettings(PeerNotifySettings notifySettings) {
            this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder pts(@Nullable Integer pts) {
            this.pts = pts;
            return this;
        }

        public final Builder draft(@Nullable DraftMessage draft) {
            this.draft = draft;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public ImmutableBaseDialog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDialog(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pinnedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean unreadMarkIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("topMessage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readInboxMaxId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("readOutboxMaxId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("unreadCount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("unreadMentionsCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("unreadReactionsCount");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("notifySettings");
            }
            return "Cannot build BaseDialog, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pinnedBuildStage = 0;
        private boolean pinned;
        private byte unreadMarkBuildStage = 0;
        private boolean unreadMark;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseDialog.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseDialog.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pinned() {
            if (this.pinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinnedBuildStage == 0) {
                this.pinnedBuildStage = (byte)-1;
                this.pinned = ImmutableBaseDialog.this.pinnedInitialize();
                this.pinnedBuildStage = 1;
            }
            return this.pinned;
        }

        void pinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedBuildStage = 1;
        }

        boolean unreadMark() {
            if (this.unreadMarkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unreadMarkBuildStage == 0) {
                this.unreadMarkBuildStage = (byte)-1;
                this.unreadMark = ImmutableBaseDialog.this.unreadMarkInitialize();
                this.unreadMarkBuildStage = 1;
            }
            return this.unreadMark;
        }

        void unreadMark(boolean unreadMark) {
            this.unreadMark = unreadMark;
            this.unreadMarkBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pinnedBuildStage == -1) {
                attributes.add("pinned");
            }
            if (this.unreadMarkBuildStage == -1) {
                attributes.add("unreadMark");
            }
            return "Cannot build BaseDialog, attribute initializers form cycle " + attributes;
        }
    }
}

