/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseDialogFilter;
import telegram4j.tl.DialogFilter;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseDialogFilter
implements BaseDialogFilter {
    private final int identifier;
    private final int flags;
    private final boolean contacts;
    private final boolean nonContacts;
    private final boolean groups;
    private final boolean broadcasts;
    private final boolean bots;
    private final boolean excludeMuted;
    private final boolean excludeRead;
    private final boolean excludeArchived;
    private final int id;
    private final String title;
    @Nullable
    private final String emoticon;
    private final List<InputPeer> pinnedPeers;
    private final List<InputPeer> includePeers;
    private final List<InputPeer> excludePeers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseDialogFilter(int id, String title) {
        this.id = id;
        this.title = Objects.requireNonNull(title, "title");
        this.emoticon = null;
        this.pinnedPeers = Collections.emptyList();
        this.includePeers = Collections.emptyList();
        this.excludePeers = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.contacts = this.initShim.contacts();
        this.nonContacts = this.initShim.nonContacts();
        this.groups = this.initShim.groups();
        this.broadcasts = this.initShim.broadcasts();
        this.bots = this.initShim.bots();
        this.excludeMuted = this.initShim.excludeMuted();
        this.excludeRead = this.initShim.excludeRead();
        this.excludeArchived = this.initShim.excludeArchived();
        this.initShim = null;
    }

    private ImmutableBaseDialogFilter(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.emoticon = builder.emoticon;
        this.pinnedPeers = ImmutableBaseDialogFilter.createUnmodifiableList(true, builder.pinnedPeers);
        this.includePeers = ImmutableBaseDialogFilter.createUnmodifiableList(true, builder.includePeers);
        this.excludePeers = ImmutableBaseDialogFilter.createUnmodifiableList(true, builder.excludePeers);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.contactsIsSet()) {
            this.initShim.contacts(builder.contacts);
        }
        if (builder.nonContactsIsSet()) {
            this.initShim.nonContacts(builder.nonContacts);
        }
        if (builder.groupsIsSet()) {
            this.initShim.groups(builder.groups);
        }
        if (builder.broadcastsIsSet()) {
            this.initShim.broadcasts(builder.broadcasts);
        }
        if (builder.botsIsSet()) {
            this.initShim.bots(builder.bots);
        }
        if (builder.excludeMutedIsSet()) {
            this.initShim.excludeMuted(builder.excludeMuted);
        }
        if (builder.excludeReadIsSet()) {
            this.initShim.excludeRead(builder.excludeRead);
        }
        if (builder.excludeArchivedIsSet()) {
            this.initShim.excludeArchived(builder.excludeArchived);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.contacts = this.initShim.contacts();
        this.nonContacts = this.initShim.nonContacts();
        this.groups = this.initShim.groups();
        this.broadcasts = this.initShim.broadcasts();
        this.bots = this.initShim.bots();
        this.excludeMuted = this.initShim.excludeMuted();
        this.excludeRead = this.initShim.excludeRead();
        this.excludeArchived = this.initShim.excludeArchived();
        this.initShim = null;
    }

    private ImmutableBaseDialogFilter(int identifier, int flags, boolean contacts, boolean nonContacts, boolean groups, boolean broadcasts, boolean bots, boolean excludeMuted, boolean excludeRead, boolean excludeArchived, int id, String title, @Nullable String emoticon, List<InputPeer> pinnedPeers, List<InputPeer> includePeers, List<InputPeer> excludePeers) {
        this.identifier = identifier;
        this.flags = flags;
        this.contacts = contacts;
        this.nonContacts = nonContacts;
        this.groups = groups;
        this.broadcasts = broadcasts;
        this.bots = bots;
        this.excludeMuted = excludeMuted;
        this.excludeRead = excludeRead;
        this.excludeArchived = excludeArchived;
        this.id = id;
        this.title = title;
        this.emoticon = emoticon;
        this.pinnedPeers = pinnedPeers;
        this.includePeers = includePeers;
        this.excludePeers = excludePeers;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseDialogFilter.super.identifier();
    }

    private int flagsInitialize() {
        return BaseDialogFilter.super.flags();
    }

    private boolean contactsInitialize() {
        return BaseDialogFilter.super.contacts();
    }

    private boolean nonContactsInitialize() {
        return BaseDialogFilter.super.nonContacts();
    }

    private boolean groupsInitialize() {
        return BaseDialogFilter.super.groups();
    }

    private boolean broadcastsInitialize() {
        return BaseDialogFilter.super.broadcasts();
    }

    private boolean botsInitialize() {
        return BaseDialogFilter.super.bots();
    }

    private boolean excludeMutedInitialize() {
        return BaseDialogFilter.super.excludeMuted();
    }

    private boolean excludeReadInitialize() {
        return BaseDialogFilter.super.excludeRead();
    }

    private boolean excludeArchivedInitialize() {
        return BaseDialogFilter.super.excludeArchived();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean contacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contacts() : this.contacts;
    }

    @Override
    public boolean nonContacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nonContacts() : this.nonContacts;
    }

    @Override
    public boolean groups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groups() : this.groups;
    }

    @Override
    public boolean broadcasts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.broadcasts() : this.broadcasts;
    }

    @Override
    public boolean bots() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bots() : this.bots;
    }

    @Override
    public boolean excludeMuted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludeMuted() : this.excludeMuted;
    }

    @Override
    public boolean excludeRead() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludeRead() : this.excludeRead;
    }

    @Override
    public boolean excludeArchived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludeArchived() : this.excludeArchived;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String emoticon() {
        return this.emoticon;
    }

    @Override
    public List<InputPeer> pinnedPeers() {
        return this.pinnedPeers;
    }

    @Override
    public List<InputPeer> includePeers() {
        return this.includePeers;
    }

    @Override
    public List<InputPeer> excludePeers() {
        return this.excludePeers;
    }

    public final ImmutableBaseDialogFilter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(value, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, value, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withContacts(boolean value) {
        if (this.contacts == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, value, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withNonContacts(boolean value) {
        if (this.nonContacts == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, value, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withGroups(boolean value) {
        if (this.groups == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, value, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withBroadcasts(boolean value) {
        if (this.broadcasts == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, value, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withBots(boolean value) {
        if (this.bots == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, value, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withExcludeMuted(boolean value) {
        if (this.excludeMuted == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, value, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withExcludeRead(boolean value) {
        if (this.excludeRead == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, value, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withExcludeArchived(boolean value) {
        if (this.excludeArchived == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, value, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, value, this.title, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, newValue, this.emoticon, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withEmoticon(@Nullable String value) {
        if (Objects.equals(this.emoticon, value)) {
            return this;
        }
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, value, this.pinnedPeers, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withPinnedPeers(InputPeer ... elements) {
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, newValue, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withPinnedPeers(Iterable<? extends InputPeer> elements) {
        if (this.pinnedPeers == elements) {
            return this;
        }
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(elements, true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, newValue, this.includePeers, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withIncludePeers(InputPeer ... elements) {
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, newValue, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withIncludePeers(Iterable<? extends InputPeer> elements) {
        if (this.includePeers == elements) {
            return this;
        }
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(elements, true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, newValue, this.excludePeers);
    }

    public final ImmutableBaseDialogFilter withExcludePeers(InputPeer ... elements) {
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, newValue);
    }

    public final ImmutableBaseDialogFilter withExcludePeers(Iterable<? extends InputPeer> elements) {
        if (this.excludePeers == elements) {
            return this;
        }
        List<InputPeer> newValue = ImmutableBaseDialogFilter.createUnmodifiableList(false, ImmutableBaseDialogFilter.createSafeList(elements, true, false));
        return new ImmutableBaseDialogFilter(this.identifier, this.flags, this.contacts, this.nonContacts, this.groups, this.broadcasts, this.bots, this.excludeMuted, this.excludeRead, this.excludeArchived, this.id, this.title, this.emoticon, this.pinnedPeers, this.includePeers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDialogFilter && this.equalTo(0, (ImmutableBaseDialogFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDialogFilter another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.contacts == another.contacts && this.nonContacts == another.nonContacts && this.groups == another.groups && this.broadcasts == another.broadcasts && this.bots == another.bots && this.excludeMuted == another.excludeMuted && this.excludeRead == another.excludeRead && this.excludeArchived == another.excludeArchived && this.id == another.id && this.title.equals(another.title) && Objects.equals(this.emoticon, another.emoticon) && this.pinnedPeers.equals(another.pinnedPeers) && this.includePeers.equals(another.includePeers) && this.excludePeers.equals(another.excludePeers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.contacts);
        h += (h << 5) + Boolean.hashCode(this.nonContacts);
        h += (h << 5) + Boolean.hashCode(this.groups);
        h += (h << 5) + Boolean.hashCode(this.broadcasts);
        h += (h << 5) + Boolean.hashCode(this.bots);
        h += (h << 5) + Boolean.hashCode(this.excludeMuted);
        h += (h << 5) + Boolean.hashCode(this.excludeRead);
        h += (h << 5) + Boolean.hashCode(this.excludeArchived);
        h += (h << 5) + this.id;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.emoticon);
        h += (h << 5) + this.pinnedPeers.hashCode();
        h += (h << 5) + this.includePeers.hashCode();
        h += (h << 5) + this.excludePeers.hashCode();
        return h;
    }

    public String toString() {
        return "BaseDialogFilter{identifier=" + this.identifier + ", flags=" + this.flags + ", contacts=" + this.contacts + ", nonContacts=" + this.nonContacts + ", groups=" + this.groups + ", broadcasts=" + this.broadcasts + ", bots=" + this.bots + ", excludeMuted=" + this.excludeMuted + ", excludeRead=" + this.excludeRead + ", excludeArchived=" + this.excludeArchived + ", id=" + this.id + ", title=" + this.title + ", emoticon=" + this.emoticon + ", pinnedPeers=" + this.pinnedPeers + ", includePeers=" + this.includePeers + ", excludePeers=" + this.excludePeers + "}";
    }

    public static ImmutableBaseDialogFilter of(int id, String title) {
        return new ImmutableBaseDialogFilter(id, title);
    }

    public static ImmutableBaseDialogFilter copyOf(BaseDialogFilter instance) {
        if (instance instanceof ImmutableBaseDialogFilter) {
            return (ImmutableBaseDialogFilter)instance;
        }
        return ImmutableBaseDialogFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CONTACTS = 4L;
        private static final long OPT_BIT_NON_CONTACTS = 8L;
        private static final long OPT_BIT_GROUPS = 16L;
        private static final long OPT_BIT_BROADCASTS = 32L;
        private static final long OPT_BIT_BOTS = 64L;
        private static final long OPT_BIT_EXCLUDE_MUTED = 128L;
        private static final long OPT_BIT_EXCLUDE_READ = 256L;
        private static final long OPT_BIT_EXCLUDE_ARCHIVED = 512L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean contacts;
        private boolean nonContacts;
        private boolean groups;
        private boolean broadcasts;
        private boolean bots;
        private boolean excludeMuted;
        private boolean excludeRead;
        private boolean excludeArchived;
        private int id;
        private String title;
        private String emoticon;
        private List<InputPeer> pinnedPeers = new ArrayList<InputPeer>();
        private List<InputPeer> includePeers = new ArrayList<InputPeer>();
        private List<InputPeer> excludePeers = new ArrayList<InputPeer>();

        private Builder() {
        }

        public final Builder from(BaseDialogFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DialogFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialogFilter instance;
            long bits = 0L;
            if (object instanceof BaseDialogFilter) {
                instance = (BaseDialogFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.excludeRead(instance.excludeRead());
                this.bots(instance.bots());
                this.excludeMuted(instance.excludeMuted());
                this.flags(instance.flags());
                this.groups(instance.groups());
                this.broadcasts(instance.broadcasts());
                this.nonContacts(instance.nonContacts());
                this.title(instance.title());
                this.addAllExcludePeers(instance.excludePeers());
                this.addAllIncludePeers(instance.includePeers());
                this.excludeArchived(instance.excludeArchived());
                this.id(instance.id());
                String emoticonValue = instance.emoticon();
                if (emoticonValue != null) {
                    this.emoticon(emoticonValue);
                }
                this.contacts(instance.contacts());
                this.addAllPinnedPeers(instance.pinnedPeers());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DialogFilter) {
                instance = (DialogFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder contacts(boolean contacts) {
            this.contacts = contacts;
            this.optBits |= 4L;
            return this;
        }

        public final Builder nonContacts(boolean nonContacts) {
            this.nonContacts = nonContacts;
            this.optBits |= 8L;
            return this;
        }

        public final Builder groups(boolean groups) {
            this.groups = groups;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder broadcasts(boolean broadcasts) {
            this.broadcasts = broadcasts;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder bots(boolean bots) {
            this.bots = bots;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder excludeMuted(boolean excludeMuted) {
            this.excludeMuted = excludeMuted;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder excludeRead(boolean excludeRead) {
            this.excludeRead = excludeRead;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder excludeArchived(boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder emoticon(@Nullable String emoticon) {
            this.emoticon = emoticon;
            return this;
        }

        public final Builder addPinnedPeer(InputPeer element) {
            this.pinnedPeers.add(Objects.requireNonNull(element, "pinnedPeers element"));
            return this;
        }

        public final Builder addPinnedPeers(InputPeer ... elements) {
            for (InputPeer element : elements) {
                this.pinnedPeers.add(Objects.requireNonNull(element, "pinnedPeers element"));
            }
            return this;
        }

        public final Builder pinnedPeers(Iterable<? extends InputPeer> elements) {
            this.pinnedPeers.clear();
            return this.addAllPinnedPeers(elements);
        }

        public final Builder addAllPinnedPeers(Iterable<? extends InputPeer> elements) {
            for (InputPeer inputPeer : elements) {
                this.pinnedPeers.add(Objects.requireNonNull(inputPeer, "pinnedPeers element"));
            }
            return this;
        }

        public final Builder addIncludePeer(InputPeer element) {
            this.includePeers.add(Objects.requireNonNull(element, "includePeers element"));
            return this;
        }

        public final Builder addIncludePeers(InputPeer ... elements) {
            for (InputPeer element : elements) {
                this.includePeers.add(Objects.requireNonNull(element, "includePeers element"));
            }
            return this;
        }

        public final Builder includePeers(Iterable<? extends InputPeer> elements) {
            this.includePeers.clear();
            return this.addAllIncludePeers(elements);
        }

        public final Builder addAllIncludePeers(Iterable<? extends InputPeer> elements) {
            for (InputPeer inputPeer : elements) {
                this.includePeers.add(Objects.requireNonNull(inputPeer, "includePeers element"));
            }
            return this;
        }

        public final Builder addExcludePeer(InputPeer element) {
            this.excludePeers.add(Objects.requireNonNull(element, "excludePeers element"));
            return this;
        }

        public final Builder addExcludePeers(InputPeer ... elements) {
            for (InputPeer element : elements) {
                this.excludePeers.add(Objects.requireNonNull(element, "excludePeers element"));
            }
            return this;
        }

        public final Builder excludePeers(Iterable<? extends InputPeer> elements) {
            this.excludePeers.clear();
            return this.addAllExcludePeers(elements);
        }

        public final Builder addAllExcludePeers(Iterable<? extends InputPeer> elements) {
            for (InputPeer inputPeer : elements) {
                this.excludePeers.add(Objects.requireNonNull(inputPeer, "excludePeers element"));
            }
            return this;
        }

        public ImmutableBaseDialogFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDialogFilter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean contactsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nonContactsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean groupsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean broadcastsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean botsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean excludeMutedIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean excludeReadIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean excludeArchivedIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build BaseDialogFilter, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte contactsBuildStage = 0;
        private boolean contacts;
        private byte nonContactsBuildStage = 0;
        private boolean nonContacts;
        private byte groupsBuildStage = 0;
        private boolean groups;
        private byte broadcastsBuildStage = 0;
        private boolean broadcasts;
        private byte botsBuildStage = 0;
        private boolean bots;
        private byte excludeMutedBuildStage = 0;
        private boolean excludeMuted;
        private byte excludeReadBuildStage = 0;
        private boolean excludeRead;
        private byte excludeArchivedBuildStage = 0;
        private boolean excludeArchived;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseDialogFilter.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseDialogFilter.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean contacts() {
            if (this.contactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contactsBuildStage == 0) {
                this.contactsBuildStage = (byte)-1;
                this.contacts = ImmutableBaseDialogFilter.this.contactsInitialize();
                this.contactsBuildStage = 1;
            }
            return this.contacts;
        }

        void contacts(boolean contacts) {
            this.contacts = contacts;
            this.contactsBuildStage = 1;
        }

        boolean nonContacts() {
            if (this.nonContactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nonContactsBuildStage == 0) {
                this.nonContactsBuildStage = (byte)-1;
                this.nonContacts = ImmutableBaseDialogFilter.this.nonContactsInitialize();
                this.nonContactsBuildStage = 1;
            }
            return this.nonContacts;
        }

        void nonContacts(boolean nonContacts) {
            this.nonContacts = nonContacts;
            this.nonContactsBuildStage = 1;
        }

        boolean groups() {
            if (this.groupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupsBuildStage == 0) {
                this.groupsBuildStage = (byte)-1;
                this.groups = ImmutableBaseDialogFilter.this.groupsInitialize();
                this.groupsBuildStage = 1;
            }
            return this.groups;
        }

        void groups(boolean groups) {
            this.groups = groups;
            this.groupsBuildStage = 1;
        }

        boolean broadcasts() {
            if (this.broadcastsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.broadcastsBuildStage == 0) {
                this.broadcastsBuildStage = (byte)-1;
                this.broadcasts = ImmutableBaseDialogFilter.this.broadcastsInitialize();
                this.broadcastsBuildStage = 1;
            }
            return this.broadcasts;
        }

        void broadcasts(boolean broadcasts) {
            this.broadcasts = broadcasts;
            this.broadcastsBuildStage = 1;
        }

        boolean bots() {
            if (this.botsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botsBuildStage == 0) {
                this.botsBuildStage = (byte)-1;
                this.bots = ImmutableBaseDialogFilter.this.botsInitialize();
                this.botsBuildStage = 1;
            }
            return this.bots;
        }

        void bots(boolean bots) {
            this.bots = bots;
            this.botsBuildStage = 1;
        }

        boolean excludeMuted() {
            if (this.excludeMutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludeMutedBuildStage == 0) {
                this.excludeMutedBuildStage = (byte)-1;
                this.excludeMuted = ImmutableBaseDialogFilter.this.excludeMutedInitialize();
                this.excludeMutedBuildStage = 1;
            }
            return this.excludeMuted;
        }

        void excludeMuted(boolean excludeMuted) {
            this.excludeMuted = excludeMuted;
            this.excludeMutedBuildStage = 1;
        }

        boolean excludeRead() {
            if (this.excludeReadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludeReadBuildStage == 0) {
                this.excludeReadBuildStage = (byte)-1;
                this.excludeRead = ImmutableBaseDialogFilter.this.excludeReadInitialize();
                this.excludeReadBuildStage = 1;
            }
            return this.excludeRead;
        }

        void excludeRead(boolean excludeRead) {
            this.excludeRead = excludeRead;
            this.excludeReadBuildStage = 1;
        }

        boolean excludeArchived() {
            if (this.excludeArchivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludeArchivedBuildStage == 0) {
                this.excludeArchivedBuildStage = (byte)-1;
                this.excludeArchived = ImmutableBaseDialogFilter.this.excludeArchivedInitialize();
                this.excludeArchivedBuildStage = 1;
            }
            return this.excludeArchived;
        }

        void excludeArchived(boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
            this.excludeArchivedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.contactsBuildStage == -1) {
                attributes.add("contacts");
            }
            if (this.nonContactsBuildStage == -1) {
                attributes.add("nonContacts");
            }
            if (this.groupsBuildStage == -1) {
                attributes.add("groups");
            }
            if (this.broadcastsBuildStage == -1) {
                attributes.add("broadcasts");
            }
            if (this.botsBuildStage == -1) {
                attributes.add("bots");
            }
            if (this.excludeMutedBuildStage == -1) {
                attributes.add("excludeMuted");
            }
            if (this.excludeReadBuildStage == -1) {
                attributes.add("excludeRead");
            }
            if (this.excludeArchivedBuildStage == -1) {
                attributes.add("excludeArchived");
            }
            return "Cannot build BaseDialogFilter, attribute initializers form cycle " + attributes;
        }
    }
}

