/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseDialogPeer;
import telegram4j.tl.DialogPeer;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseDialogPeer
implements BaseDialogPeer {
    private final int identifier;
    private final Peer peer;

    private ImmutableBaseDialogPeer(Peer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = BaseDialogPeer.super.identifier();
    }

    private ImmutableBaseDialogPeer(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseDialogPeer.super.identifier();
    }

    private ImmutableBaseDialogPeer(int identifier, Peer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    public final ImmutableBaseDialogPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDialogPeer(value, this.peer);
    }

    public final ImmutableBaseDialogPeer withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBaseDialogPeer(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDialogPeer && this.equalTo(0, (ImmutableBaseDialogPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDialogPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "BaseDialogPeer{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableBaseDialogPeer of(Peer peer) {
        return new ImmutableBaseDialogPeer(peer);
    }

    public static ImmutableBaseDialogPeer copyOf(BaseDialogPeer instance) {
        if (instance instanceof ImmutableBaseDialogPeer) {
            return (ImmutableBaseDialogPeer)instance;
        }
        return ImmutableBaseDialogPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Peer peer;

        private Builder() {
        }

        public final Builder from(BaseDialogPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DialogPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialogPeer instance;
            long bits = 0L;
            if (object instanceof BaseDialogPeer) {
                instance = (BaseDialogPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof DialogPeer) {
                instance = (DialogPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseDialogPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDialogPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build BaseDialogPeer, some of required attributes are not set " + attributes;
        }
    }
}

