/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseDocument;
import telegram4j.tl.BaseDocumentFields;
import telegram4j.tl.Document;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.VideoSize;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseDocument
implements BaseDocument {
    private final int identifier;
    private final int flags;
    private final long id;
    private final long accessHash;
    private final ByteBuf fileReference;
    private final int date;
    private final String mimeType;
    private final long size;
    @Nullable
    private final List<PhotoSize> thumbs;
    @Nullable
    private final List<VideoSize> videoThumbs;
    private final int dcId;
    private final List<DocumentAttribute> attributes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseDocument(long id, long accessHash, int date, String mimeType, long size, int dcId) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.size = size;
        this.dcId = dcId;
        this.fileReference = null;
        this.thumbs = null;
        this.videoThumbs = null;
        this.attributes = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseDocument(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.fileReference = builder.fileReference_build();
        this.date = builder.date;
        this.mimeType = builder.mimeType;
        this.size = builder.size;
        this.thumbs = builder.thumbs == null ? null : ImmutableBaseDocument.createUnmodifiableList(true, builder.thumbs);
        this.videoThumbs = builder.videoThumbs == null ? null : ImmutableBaseDocument.createUnmodifiableList(true, builder.videoThumbs);
        this.dcId = builder.dcId;
        this.attributes = ImmutableBaseDocument.createUnmodifiableList(true, builder.attributes);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseDocument(int identifier, int flags, long id, long accessHash, ByteBuf fileReference, int date, String mimeType, long size, @Nullable List<PhotoSize> thumbs, @Nullable List<VideoSize> videoThumbs, int dcId, List<DocumentAttribute> attributes) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = fileReference;
        this.date = date;
        this.mimeType = mimeType;
        this.size = size;
        this.thumbs = thumbs;
        this.videoThumbs = videoThumbs;
        this.dcId = dcId;
        this.attributes = attributes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseDocument.super.identifier();
    }

    private int flagsInitialize() {
        return BaseDocument.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @Nullable
    public List<PhotoSize> thumbs() {
        return this.thumbs;
    }

    @Override
    @Nullable
    public List<VideoSize> videoThumbs() {
        return this.videoThumbs;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    public final ImmutableBaseDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDocument(value, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, value, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, value, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, value, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public ImmutableBaseDocument withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, newValue, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, value, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, newValue, this.size, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, value, this.thumbs, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withThumbs(PhotoSize ... elements) {
        if (elements == null) {
            return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, null, this.videoThumbs, this.dcId, this.attributes);
        }
        List<PhotoSize> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, newValue, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withThumbs(@Nullable Iterable<? extends PhotoSize> elements) {
        if (this.thumbs == elements) {
            return this;
        }
        List<PhotoSize> newValue = elements == null ? null : ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(elements, true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, newValue, this.videoThumbs, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withVideoThumbs(VideoSize ... elements) {
        if (elements == null) {
            return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, null, this.dcId, this.attributes);
        }
        List<VideoSize> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, newValue, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withVideoThumbs(@Nullable Iterable<? extends VideoSize> elements) {
        if (this.videoThumbs == elements) {
            return this;
        }
        List<VideoSize> newValue = elements == null ? null : ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(elements, true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, newValue, this.dcId, this.attributes);
    }

    public final ImmutableBaseDocument withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, value, this.attributes);
    }

    public final ImmutableBaseDocument withAttributes(DocumentAttribute ... elements) {
        List<DocumentAttribute> newValue = ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, newValue);
    }

    public final ImmutableBaseDocument withAttributes(Iterable<? extends DocumentAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<DocumentAttribute> newValue = ImmutableBaseDocument.createUnmodifiableList(false, ImmutableBaseDocument.createSafeList(elements, true, false));
        return new ImmutableBaseDocument(this.identifier, this.flags, this.id, this.accessHash, this.fileReference, this.date, this.mimeType, this.size, this.thumbs, this.videoThumbs, this.dcId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDocument && this.equalTo(0, (ImmutableBaseDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDocument another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id == another.id && this.accessHash == another.accessHash && this.fileReference().equals((Object)another.fileReference()) && this.date == another.date && this.mimeType.equals(another.mimeType) && this.size == another.size && Objects.equals(this.thumbs, another.thumbs) && Objects.equals(this.videoThumbs, another.videoThumbs) && this.dcId == another.dcId && this.attributes.equals(another.attributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.fileReference().hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + this.mimeType.hashCode();
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + Objects.hashCode(this.thumbs);
        h += (h << 5) + Objects.hashCode(this.videoThumbs);
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.attributes.hashCode();
        return h;
    }

    public String toString() {
        return "BaseDocument{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", accessHash=" + this.accessHash + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + ", date=" + this.date + ", mimeType=" + this.mimeType + ", size=" + this.size + ", thumbs=" + this.thumbs + ", videoThumbs=" + this.videoThumbs + ", dcId=" + this.dcId + ", attributes=" + this.attributes + "}";
    }

    public static ImmutableBaseDocument of(long id, long accessHash, int date, String mimeType, long size, int dcId) {
        return new ImmutableBaseDocument(id, accessHash, date, mimeType, size, dcId);
    }

    public static ImmutableBaseDocument copyOf(BaseDocument instance) {
        if (instance instanceof ImmutableBaseDocument) {
            return (ImmutableBaseDocument)instance;
        }
        return ImmutableBaseDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_MIME_TYPE = 8L;
        private static final long INIT_BIT_SIZE = 16L;
        private static final long INIT_BIT_DC_ID = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 63L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private int flags;
        private long id;
        private long accessHash;
        private int date;
        private String mimeType;
        private long size;
        private List<PhotoSize> thumbs = null;
        private List<VideoSize> videoThumbs = null;
        private int dcId;
        private List<DocumentAttribute> attributes = new ArrayList<DocumentAttribute>();

        private Builder() {
        }

        public final Builder from(BaseDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Document instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseDocumentFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof BaseDocument) {
                List<VideoSize> videoThumbsValue;
                instance = (BaseDocument)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.size(instance.size());
                this.dcId(instance.dcId());
                this.flags(instance.flags());
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.addAllAttributes(instance.attributes());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.mimeType(instance.mimeType());
                    bits |= 8L;
                }
                this.fileReference(instance.fileReference());
                List<PhotoSize> thumbsValue = instance.thumbs();
                if (thumbsValue != null) {
                    this.addAllThumbs(thumbsValue);
                }
                if ((videoThumbsValue = instance.videoThumbs()) != null) {
                    this.addAllVideoThumbs(videoThumbsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Document) {
                instance = (Document)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
            if (object instanceof BaseDocumentFields) {
                instance = (BaseDocumentFields)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllAttributes(instance.attributes());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.mimeType(instance.mimeType());
                    bits |= 8L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder size(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addThumb(PhotoSize element) {
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            this.thumbs.add(Objects.requireNonNull(element, "thumbs element"));
            return this;
        }

        public final Builder addThumbs(PhotoSize ... elements) {
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            for (PhotoSize element : elements) {
                this.thumbs.add(Objects.requireNonNull(element, "thumbs element"));
            }
            return this;
        }

        public final Builder thumbs(@Nullable Iterable<? extends PhotoSize> elements) {
            if (elements == null) {
                this.thumbs = null;
                return this;
            }
            this.thumbs = new ArrayList<PhotoSize>();
            return this.addAllThumbs(elements);
        }

        public final Builder addAllThumbs(Iterable<? extends PhotoSize> elements) {
            Objects.requireNonNull(elements, "thumbs element");
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            for (PhotoSize photoSize : elements) {
                this.thumbs.add(Objects.requireNonNull(photoSize, "thumbs element"));
            }
            return this;
        }

        public final Builder addVideoThumb(VideoSize element) {
            if (this.videoThumbs == null) {
                this.videoThumbs = new ArrayList<VideoSize>();
            }
            this.videoThumbs.add(Objects.requireNonNull(element, "videoThumbs element"));
            return this;
        }

        public final Builder addVideoThumbs(VideoSize ... elements) {
            if (this.videoThumbs == null) {
                this.videoThumbs = new ArrayList<VideoSize>();
            }
            for (VideoSize element : elements) {
                this.videoThumbs.add(Objects.requireNonNull(element, "videoThumbs element"));
            }
            return this;
        }

        public final Builder videoThumbs(@Nullable Iterable<? extends VideoSize> elements) {
            if (elements == null) {
                this.videoThumbs = null;
                return this;
            }
            this.videoThumbs = new ArrayList<VideoSize>();
            return this.addAllVideoThumbs(elements);
        }

        public final Builder addAllVideoThumbs(Iterable<? extends VideoSize> elements) {
            Objects.requireNonNull(elements, "videoThumbs element");
            if (this.videoThumbs == null) {
                this.videoThumbs = new ArrayList<VideoSize>();
            }
            for (VideoSize videoSize : elements) {
                this.videoThumbs.add(Objects.requireNonNull(videoSize, "videoThumbs element"));
            }
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addAttribute(DocumentAttribute element) {
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(DocumentAttribute ... elements) {
            for (DocumentAttribute element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder attributes(Iterable<? extends DocumentAttribute> elements) {
            this.attributes.clear();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<? extends DocumentAttribute> elements) {
            for (DocumentAttribute documentAttribute : elements) {
                this.attributes.add(Objects.requireNonNull(documentAttribute, "attributes element"));
            }
            return this;
        }

        public ImmutableBaseDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDocument(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mimeType");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build BaseDocument, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseDocument.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseDocument.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseDocument, attribute initializers form cycle " + attributes;
        }
    }
}

