/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseDraftMessage;
import telegram4j.tl.DraftMessage;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseDraftMessage
implements BaseDraftMessage {
    private final int identifier;
    private final int flags;
    private final boolean noWebpage;
    @Nullable
    private final Integer replyToMsgId;
    private final String message;
    @Nullable
    private final List<MessageEntity> entities;
    private final int date;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseDraftMessage(String message, int date) {
        this.message = Objects.requireNonNull(message, "message");
        this.date = date;
        this.replyToMsgId = null;
        this.entities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableBaseDraftMessage(Builder builder) {
        this.replyToMsgId = builder.replyToMsgId;
        this.message = builder.message;
        this.entities = builder.entities == null ? null : ImmutableBaseDraftMessage.createUnmodifiableList(true, builder.entities);
        this.date = builder.date;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noWebpageIsSet()) {
            this.initShim.noWebpage(builder.noWebpage);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableBaseDraftMessage(int identifier, int flags, boolean noWebpage, @Nullable Integer replyToMsgId, String message, @Nullable List<MessageEntity> entities, int date) {
        this.identifier = identifier;
        this.flags = flags;
        this.noWebpage = noWebpage;
        this.replyToMsgId = replyToMsgId;
        this.message = message;
        this.entities = entities;
        this.date = date;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseDraftMessage.super.identifier();
    }

    private int flagsInitialize() {
        return BaseDraftMessage.super.flags();
    }

    private boolean noWebpageInitialize() {
        return BaseDraftMessage.super.noWebpage();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noWebpage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noWebpage() : this.noWebpage;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableBaseDraftMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDraftMessage(value, this.flags, this.noWebpage, this.replyToMsgId, this.message, this.entities, this.date);
    }

    public final ImmutableBaseDraftMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseDraftMessage(this.identifier, value, this.noWebpage, this.replyToMsgId, this.message, this.entities, this.date);
    }

    public final ImmutableBaseDraftMessage withNoWebpage(boolean value) {
        if (this.noWebpage == value) {
            return this;
        }
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, value, this.replyToMsgId, this.message, this.entities, this.date);
    }

    public final ImmutableBaseDraftMessage withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, value, this.message, this.entities, this.date);
    }

    public final ImmutableBaseDraftMessage withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, this.replyToMsgId, newValue, this.entities, this.date);
    }

    public final ImmutableBaseDraftMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, this.replyToMsgId, this.message, null, this.date);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseDraftMessage.createUnmodifiableList(false, ImmutableBaseDraftMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, this.replyToMsgId, this.message, newValue, this.date);
    }

    public final ImmutableBaseDraftMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableBaseDraftMessage.createUnmodifiableList(false, ImmutableBaseDraftMessage.createSafeList(elements, true, false));
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, this.replyToMsgId, this.message, newValue, this.date);
    }

    public final ImmutableBaseDraftMessage withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseDraftMessage(this.identifier, this.flags, this.noWebpage, this.replyToMsgId, this.message, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDraftMessage && this.equalTo(0, (ImmutableBaseDraftMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDraftMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noWebpage == another.noWebpage && Objects.equals(this.replyToMsgId, another.replyToMsgId) && this.message.equals(another.message) && Objects.equals(this.entities, another.entities) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noWebpage);
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "BaseDraftMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", noWebpage=" + this.noWebpage + ", replyToMsgId=" + this.replyToMsgId + ", message=" + this.message + ", entities=" + this.entities + ", date=" + this.date + "}";
    }

    public static ImmutableBaseDraftMessage of(String message, int date) {
        return new ImmutableBaseDraftMessage(message, date);
    }

    public static ImmutableBaseDraftMessage copyOf(BaseDraftMessage instance) {
        if (instance instanceof ImmutableBaseDraftMessage) {
            return (ImmutableBaseDraftMessage)instance;
        }
        return ImmutableBaseDraftMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_WEBPAGE = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean noWebpage;
        private Integer replyToMsgId;
        private String message;
        private List<MessageEntity> entities = null;
        private int date;

        private Builder() {
        }

        public final Builder from(DraftMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseDraftMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DraftMessage instance;
            long bits = 0L;
            if (object instanceof DraftMessage) {
                instance = (DraftMessage)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseDraftMessage) {
                List<MessageEntity> entitiesValue;
                instance = (BaseDraftMessage)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                this.noWebpage(instance.noWebpage());
                Integer replyToMsgIdValue = instance.replyToMsgId();
                if (replyToMsgIdValue != null) {
                    this.replyToMsgId(replyToMsgIdValue);
                }
                this.message(instance.message());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseDraftMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDraftMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noWebpageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseDraftMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noWebpageBuildStage = 0;
        private boolean noWebpage;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseDraftMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseDraftMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noWebpage() {
            if (this.noWebpageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noWebpageBuildStage == 0) {
                this.noWebpageBuildStage = (byte)-1;
                this.noWebpage = ImmutableBaseDraftMessage.this.noWebpageInitialize();
                this.noWebpageBuildStage = 1;
            }
            return this.noWebpage;
        }

        void noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.noWebpageBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noWebpageBuildStage == -1) {
                attributes.add("noWebpage");
            }
            return "Cannot build BaseDraftMessage, attribute initializers form cycle " + attributes;
        }
    }
}

