/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseEncryptedChat;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseEncryptedChat
implements BaseEncryptedChat {
    private final int identifier;
    private final int id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;
    private final ByteBuf gAOrB;
    private final long keyFingerprint;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseEncryptedChat(int id, long accessHash, int date, long adminId, long participantId, long keyFingerprint) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.keyFingerprint = keyFingerprint;
        this.gAOrB = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseEncryptedChat(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.gAOrB = builder.gAOrB_build();
        this.keyFingerprint = builder.keyFingerprint;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseEncryptedChat(int identifier, int id, long accessHash, int date, long adminId, long participantId, ByteBuf gAOrB, long keyFingerprint) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.gAOrB = gAOrB;
        this.keyFingerprint = keyFingerprint;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseEncryptedChat.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    @Override
    public ByteBuf gAOrB() {
        return this.gAOrB.duplicate();
    }

    @Override
    public long keyFingerprint() {
        return this.keyFingerprint;
    }

    public final ImmutableBaseEncryptedChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(value, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, value, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, value, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, this.accessHash, value, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, this.accessHash, this.date, value, this.participantId, this.gAOrB, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, this.accessHash, this.date, this.adminId, value, this.gAOrB, this.keyFingerprint);
    }

    public ImmutableBaseEncryptedChat withGAOrB(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gAOrB == newValue) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, this.accessHash, this.date, this.adminId, this.participantId, newValue, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedChat withKeyFingerprint(long value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableBaseEncryptedChat(this.identifier, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseEncryptedChat && this.equalTo(0, (ImmutableBaseEncryptedChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseEncryptedChat another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId && this.gAOrB().equals((Object)another.gAOrB()) && this.keyFingerprint == another.keyFingerprint;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        h += (h << 5) + this.gAOrB().hashCode();
        h += (h << 5) + Long.hashCode(this.keyFingerprint);
        return h;
    }

    public String toString() {
        return "BaseEncryptedChat{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + ", gAOrB=" + ByteBufUtil.hexDump((ByteBuf)this.gAOrB) + ", keyFingerprint=" + this.keyFingerprint + "}";
    }

    public static ImmutableBaseEncryptedChat of(int id, long accessHash, int date, long adminId, long participantId, long keyFingerprint) {
        return new ImmutableBaseEncryptedChat(id, accessHash, date, adminId, participantId, keyFingerprint);
    }

    public static ImmutableBaseEncryptedChat copyOf(BaseEncryptedChat instance) {
        if (instance instanceof ImmutableBaseEncryptedChat) {
            return (ImmutableBaseEncryptedChat)instance;
        }
        return ImmutableBaseEncryptedChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private ByteBuf gAOrB_value = null;
        private int identifier;
        private int id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;
        private long keyFingerprint;

        private Builder() {
        }

        public final Builder from(EncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseEncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedChat instance;
            long bits = 0L;
            if (object instanceof EncryptedChat) {
                instance = (EncryptedChat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseEncryptedChat) {
                instance = (BaseEncryptedChat)object;
                this.date(instance.date());
                this.participantId(instance.participantId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.keyFingerprint(instance.keyFingerprint());
                this.adminId(instance.adminId());
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.gAOrB(instance.gAOrB());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder gAOrB(ByteBuf value) {
            this.gAOrB_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder keyFingerprint(long keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableBaseEncryptedChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseEncryptedChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("keyFingerprint");
            }
            return "Cannot build BaseEncryptedChat, some of required attributes are not set " + attributes;
        }

        private ByteBuf gAOrB_build() {
            return Objects.requireNonNull(this.gAOrB_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseEncryptedChat.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseEncryptedChat, attribute initializers form cycle " + attributes;
        }
    }
}

