/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseEncryptedFile;
import telegram4j.tl.EncryptedFile;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseEncryptedFile
implements BaseEncryptedFile {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final long size;
    private final int dcId;
    private final int keyFingerprint;

    private ImmutableBaseEncryptedFile(long id, long accessHash, long size, int dcId, int keyFingerprint) {
        this.id = id;
        this.accessHash = accessHash;
        this.size = size;
        this.dcId = dcId;
        this.keyFingerprint = keyFingerprint;
        this.identifier = BaseEncryptedFile.super.identifier();
    }

    private ImmutableBaseEncryptedFile(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.size = builder.size;
        this.dcId = builder.dcId;
        this.keyFingerprint = builder.keyFingerprint;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseEncryptedFile.super.identifier();
    }

    private ImmutableBaseEncryptedFile(int identifier, long id, long accessHash, long size, int dcId, int keyFingerprint) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.size = size;
        this.dcId = dcId;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public int keyFingerprint() {
        return this.keyFingerprint;
    }

    public final ImmutableBaseEncryptedFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(value, this.id, this.accessHash, this.size, this.dcId, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedFile withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(this.identifier, value, this.accessHash, this.size, this.dcId, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedFile withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(this.identifier, this.id, value, this.size, this.dcId, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedFile withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(this.identifier, this.id, this.accessHash, value, this.dcId, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedFile withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(this.identifier, this.id, this.accessHash, this.size, value, this.keyFingerprint);
    }

    public final ImmutableBaseEncryptedFile withKeyFingerprint(int value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableBaseEncryptedFile(this.identifier, this.id, this.accessHash, this.size, this.dcId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseEncryptedFile && this.equalTo(0, (ImmutableBaseEncryptedFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseEncryptedFile another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.size == another.size && this.dcId == another.dcId && this.keyFingerprint == another.keyFingerprint;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.keyFingerprint;
        return h;
    }

    public String toString() {
        return "BaseEncryptedFile{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", size=" + this.size + ", dcId=" + this.dcId + ", keyFingerprint=" + this.keyFingerprint + "}";
    }

    public static ImmutableBaseEncryptedFile of(long id, long accessHash, long size, int dcId, int keyFingerprint) {
        return new ImmutableBaseEncryptedFile(id, accessHash, size, dcId, keyFingerprint);
    }

    public static ImmutableBaseEncryptedFile copyOf(BaseEncryptedFile instance) {
        if (instance instanceof ImmutableBaseEncryptedFile) {
            return (ImmutableBaseEncryptedFile)instance;
        }
        return ImmutableBaseEncryptedFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private static final long INIT_BIT_DC_ID = 8L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private long id;
        private long accessHash;
        private long size;
        private int dcId;
        private int keyFingerprint;

        private Builder() {
        }

        public final Builder from(BaseEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedFile instance;
            long bits = 0L;
            if (object instanceof BaseEncryptedFile) {
                instance = (BaseEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.size(instance.size());
                this.dcId(instance.dcId());
                this.keyFingerprint(instance.keyFingerprint());
            }
            if (object instanceof EncryptedFile) {
                instance = (EncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder size(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder keyFingerprint(int keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableBaseEncryptedFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseEncryptedFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dcId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("keyFingerprint");
            }
            return "Cannot build BaseEncryptedFile, some of required attributes are not set " + attributes;
        }
    }
}

