/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseGeoPoint;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseGeoPoint
implements BaseGeoPoint {
    private final int identifier;
    private final int flags;
    private final double longitude;
    private final double lat;
    private final long accessHash;
    @Nullable
    private final Integer accuracyRadius;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseGeoPoint(double longitude, double lat, long accessHash) {
        this.longitude = longitude;
        this.lat = lat;
        this.accessHash = accessHash;
        this.accuracyRadius = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseGeoPoint(Builder builder) {
        this.longitude = builder.longitude;
        this.lat = builder.lat;
        this.accessHash = builder.accessHash;
        this.accuracyRadius = builder.accuracyRadius;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseGeoPoint(int identifier, int flags, double longitude, double lat, long accessHash, @Nullable Integer accuracyRadius) {
        this.identifier = identifier;
        this.flags = flags;
        this.longitude = longitude;
        this.lat = lat;
        this.accessHash = accessHash;
        this.accuracyRadius = accuracyRadius;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseGeoPoint.super.identifier();
    }

    private int flagsInitialize() {
        return BaseGeoPoint.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public double longitude() {
        return this.longitude;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    @Nullable
    public Integer accuracyRadius() {
        return this.accuracyRadius;
    }

    public final ImmutableBaseGeoPoint withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseGeoPoint(value, this.flags, this.longitude, this.lat, this.accessHash, this.accuracyRadius);
    }

    public final ImmutableBaseGeoPoint withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseGeoPoint(this.identifier, value, this.longitude, this.lat, this.accessHash, this.accuracyRadius);
    }

    public final ImmutableBaseGeoPoint withLongitude(double value) {
        if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBaseGeoPoint(this.identifier, this.flags, value, this.lat, this.accessHash, this.accuracyRadius);
    }

    public final ImmutableBaseGeoPoint withLat(double value) {
        if (Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBaseGeoPoint(this.identifier, this.flags, this.longitude, value, this.accessHash, this.accuracyRadius);
    }

    public final ImmutableBaseGeoPoint withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseGeoPoint(this.identifier, this.flags, this.longitude, this.lat, value, this.accuracyRadius);
    }

    public final ImmutableBaseGeoPoint withAccuracyRadius(@Nullable Integer value) {
        if (Objects.equals(this.accuracyRadius, value)) {
            return this;
        }
        return new ImmutableBaseGeoPoint(this.identifier, this.flags, this.longitude, this.lat, this.accessHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseGeoPoint && this.equalTo(0, (ImmutableBaseGeoPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseGeoPoint another) {
        return this.identifier == another.identifier && this.flags == another.flags && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(another.longitude) && Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(another.lat) && this.accessHash == another.accessHash && Objects.equals(this.accuracyRadius, another.accuracyRadius);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Double.hashCode(this.longitude);
        h += (h << 5) + Double.hashCode(this.lat);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + Objects.hashCode(this.accuracyRadius);
        return h;
    }

    public String toString() {
        return "BaseGeoPoint{identifier=" + this.identifier + ", flags=" + this.flags + ", longitude=" + this.longitude + ", lat=" + this.lat + ", accessHash=" + this.accessHash + ", accuracyRadius=" + this.accuracyRadius + "}";
    }

    public static ImmutableBaseGeoPoint of(double longitude, double lat, long accessHash) {
        return new ImmutableBaseGeoPoint(longitude, lat, accessHash);
    }

    public static ImmutableBaseGeoPoint copyOf(BaseGeoPoint instance) {
        if (instance instanceof ImmutableBaseGeoPoint) {
            return (ImmutableBaseGeoPoint)instance;
        }
        return ImmutableBaseGeoPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LONGITUDE = 1L;
        private static final long INIT_BIT_LAT = 2L;
        private static final long INIT_BIT_ACCESS_HASH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private double longitude;
        private double lat;
        private long accessHash;
        private Integer accuracyRadius;

        private Builder() {
        }

        public final Builder from(GeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseGeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoPoint instance;
            long bits = 0L;
            if (object instanceof GeoPoint) {
                instance = (GeoPoint)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseGeoPoint) {
                Integer accuracyRadiusValue;
                instance = (BaseGeoPoint)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((accuracyRadiusValue = instance.accuracyRadius()) != null) {
                    this.accuracyRadius(accuracyRadiusValue);
                }
                this.accessHash(instance.accessHash());
                this.lat(instance.lat());
                this.longitude(instance.longitude());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder longitude(double longitude) {
            this.longitude = longitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lat(double lat) {
            this.lat = lat;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder accuracyRadius(@Nullable Integer accuracyRadius) {
            this.accuracyRadius = accuracyRadius;
            return this;
        }

        public ImmutableBaseGeoPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseGeoPoint(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lat");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseGeoPoint, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseGeoPoint.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseGeoPoint.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseGeoPoint, attribute initializers form cycle " + attributes;
        }
    }
}

