/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseGroupCall;
import telegram4j.tl.GroupCall;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseGroupCall
implements BaseGroupCall {
    private final int identifier;
    private final int flags;
    private final boolean joinMuted;
    private final boolean canChangeJoinMuted;
    private final boolean joinDateAsc;
    private final boolean scheduleStartSubscribed;
    private final boolean canStartVideo;
    private final boolean recordVideoActive;
    private final boolean rtmpStream;
    private final boolean listenersHidden;
    private final long id;
    private final long accessHash;
    private final int participantsCount;
    @Nullable
    private final String title;
    @Nullable
    private final Integer streamDcId;
    @Nullable
    private final Integer recordStartDate;
    @Nullable
    private final Integer scheduleDate;
    @Nullable
    private final Integer unmutedVideoCount;
    private final int unmutedVideoLimit;
    private final int version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseGroupCall(long id, long accessHash, int participantsCount, int unmutedVideoLimit, int version) {
        this.id = id;
        this.accessHash = accessHash;
        this.participantsCount = participantsCount;
        this.unmutedVideoLimit = unmutedVideoLimit;
        this.version = version;
        this.title = null;
        this.streamDcId = null;
        this.recordStartDate = null;
        this.scheduleDate = null;
        this.unmutedVideoCount = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.joinMuted = this.initShim.joinMuted();
        this.canChangeJoinMuted = this.initShim.canChangeJoinMuted();
        this.joinDateAsc = this.initShim.joinDateAsc();
        this.scheduleStartSubscribed = this.initShim.scheduleStartSubscribed();
        this.canStartVideo = this.initShim.canStartVideo();
        this.recordVideoActive = this.initShim.recordVideoActive();
        this.rtmpStream = this.initShim.rtmpStream();
        this.listenersHidden = this.initShim.listenersHidden();
        this.initShim = null;
    }

    private ImmutableBaseGroupCall(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.participantsCount = builder.participantsCount;
        this.title = builder.title;
        this.streamDcId = builder.streamDcId;
        this.recordStartDate = builder.recordStartDate;
        this.scheduleDate = builder.scheduleDate;
        this.unmutedVideoCount = builder.unmutedVideoCount;
        this.unmutedVideoLimit = builder.unmutedVideoLimit;
        this.version = builder.version;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.joinMutedIsSet()) {
            this.initShim.joinMuted(builder.joinMuted);
        }
        if (builder.canChangeJoinMutedIsSet()) {
            this.initShim.canChangeJoinMuted(builder.canChangeJoinMuted);
        }
        if (builder.joinDateAscIsSet()) {
            this.initShim.joinDateAsc(builder.joinDateAsc);
        }
        if (builder.scheduleStartSubscribedIsSet()) {
            this.initShim.scheduleStartSubscribed(builder.scheduleStartSubscribed);
        }
        if (builder.canStartVideoIsSet()) {
            this.initShim.canStartVideo(builder.canStartVideo);
        }
        if (builder.recordVideoActiveIsSet()) {
            this.initShim.recordVideoActive(builder.recordVideoActive);
        }
        if (builder.rtmpStreamIsSet()) {
            this.initShim.rtmpStream(builder.rtmpStream);
        }
        if (builder.listenersHiddenIsSet()) {
            this.initShim.listenersHidden(builder.listenersHidden);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.joinMuted = this.initShim.joinMuted();
        this.canChangeJoinMuted = this.initShim.canChangeJoinMuted();
        this.joinDateAsc = this.initShim.joinDateAsc();
        this.scheduleStartSubscribed = this.initShim.scheduleStartSubscribed();
        this.canStartVideo = this.initShim.canStartVideo();
        this.recordVideoActive = this.initShim.recordVideoActive();
        this.rtmpStream = this.initShim.rtmpStream();
        this.listenersHidden = this.initShim.listenersHidden();
        this.initShim = null;
    }

    private ImmutableBaseGroupCall(int identifier, int flags, boolean joinMuted, boolean canChangeJoinMuted, boolean joinDateAsc, boolean scheduleStartSubscribed, boolean canStartVideo, boolean recordVideoActive, boolean rtmpStream, boolean listenersHidden, long id, long accessHash, int participantsCount, @Nullable String title, @Nullable Integer streamDcId, @Nullable Integer recordStartDate, @Nullable Integer scheduleDate, @Nullable Integer unmutedVideoCount, int unmutedVideoLimit, int version) {
        this.identifier = identifier;
        this.flags = flags;
        this.joinMuted = joinMuted;
        this.canChangeJoinMuted = canChangeJoinMuted;
        this.joinDateAsc = joinDateAsc;
        this.scheduleStartSubscribed = scheduleStartSubscribed;
        this.canStartVideo = canStartVideo;
        this.recordVideoActive = recordVideoActive;
        this.rtmpStream = rtmpStream;
        this.listenersHidden = listenersHidden;
        this.id = id;
        this.accessHash = accessHash;
        this.participantsCount = participantsCount;
        this.title = title;
        this.streamDcId = streamDcId;
        this.recordStartDate = recordStartDate;
        this.scheduleDate = scheduleDate;
        this.unmutedVideoCount = unmutedVideoCount;
        this.unmutedVideoLimit = unmutedVideoLimit;
        this.version = version;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseGroupCall.super.identifier();
    }

    private int flagsInitialize() {
        return BaseGroupCall.super.flags();
    }

    private boolean joinMutedInitialize() {
        return BaseGroupCall.super.joinMuted();
    }

    private boolean canChangeJoinMutedInitialize() {
        return BaseGroupCall.super.canChangeJoinMuted();
    }

    private boolean joinDateAscInitialize() {
        return BaseGroupCall.super.joinDateAsc();
    }

    private boolean scheduleStartSubscribedInitialize() {
        return BaseGroupCall.super.scheduleStartSubscribed();
    }

    private boolean canStartVideoInitialize() {
        return BaseGroupCall.super.canStartVideo();
    }

    private boolean recordVideoActiveInitialize() {
        return BaseGroupCall.super.recordVideoActive();
    }

    private boolean rtmpStreamInitialize() {
        return BaseGroupCall.super.rtmpStream();
    }

    private boolean listenersHiddenInitialize() {
        return BaseGroupCall.super.listenersHidden();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean joinMuted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.joinMuted() : this.joinMuted;
    }

    @Override
    public boolean canChangeJoinMuted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canChangeJoinMuted() : this.canChangeJoinMuted;
    }

    @Override
    public boolean joinDateAsc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.joinDateAsc() : this.joinDateAsc;
    }

    @Override
    public boolean scheduleStartSubscribed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scheduleStartSubscribed() : this.scheduleStartSubscribed;
    }

    @Override
    public boolean canStartVideo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canStartVideo() : this.canStartVideo;
    }

    @Override
    public boolean recordVideoActive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recordVideoActive() : this.recordVideoActive;
    }

    @Override
    public boolean rtmpStream() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rtmpStream() : this.rtmpStream;
    }

    @Override
    public boolean listenersHidden() {
        InitShim shim = this.initShim;
        return shim != null ? shim.listenersHidden() : this.listenersHidden;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int participantsCount() {
        return this.participantsCount;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public Integer streamDcId() {
        return this.streamDcId;
    }

    @Override
    @Nullable
    public Integer recordStartDate() {
        return this.recordStartDate;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Nullable
    public Integer unmutedVideoCount() {
        return this.unmutedVideoCount;
    }

    @Override
    public int unmutedVideoLimit() {
        return this.unmutedVideoLimit;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableBaseGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(value, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, value, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withJoinMuted(boolean value) {
        if (this.joinMuted == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, value, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withCanChangeJoinMuted(boolean value) {
        if (this.canChangeJoinMuted == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, value, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withJoinDateAsc(boolean value) {
        if (this.joinDateAsc == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, value, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withScheduleStartSubscribed(boolean value) {
        if (this.scheduleStartSubscribed == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, value, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withCanStartVideo(boolean value) {
        if (this.canStartVideo == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, value, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withRecordVideoActive(boolean value) {
        if (this.recordVideoActive == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, value, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withRtmpStream(boolean value) {
        if (this.rtmpStream == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, value, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withListenersHidden(boolean value) {
        if (this.listenersHidden == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, value, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, value, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, value, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withParticipantsCount(int value) {
        if (this.participantsCount == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, value, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, value, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withStreamDcId(@Nullable Integer value) {
        if (Objects.equals(this.streamDcId, value)) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, value, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withRecordStartDate(@Nullable Integer value) {
        if (Objects.equals(this.recordStartDate, value)) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, value, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, value, this.unmutedVideoCount, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withUnmutedVideoCount(@Nullable Integer value) {
        if (Objects.equals(this.unmutedVideoCount, value)) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, value, this.unmutedVideoLimit, this.version);
    }

    public final ImmutableBaseGroupCall withUnmutedVideoLimit(int value) {
        if (this.unmutedVideoLimit == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, value, this.version);
    }

    public final ImmutableBaseGroupCall withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableBaseGroupCall(this.identifier, this.flags, this.joinMuted, this.canChangeJoinMuted, this.joinDateAsc, this.scheduleStartSubscribed, this.canStartVideo, this.recordVideoActive, this.rtmpStream, this.listenersHidden, this.id, this.accessHash, this.participantsCount, this.title, this.streamDcId, this.recordStartDate, this.scheduleDate, this.unmutedVideoCount, this.unmutedVideoLimit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseGroupCall && this.equalTo(0, (ImmutableBaseGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseGroupCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.joinMuted == another.joinMuted && this.canChangeJoinMuted == another.canChangeJoinMuted && this.joinDateAsc == another.joinDateAsc && this.scheduleStartSubscribed == another.scheduleStartSubscribed && this.canStartVideo == another.canStartVideo && this.recordVideoActive == another.recordVideoActive && this.rtmpStream == another.rtmpStream && this.listenersHidden == another.listenersHidden && this.id == another.id && this.accessHash == another.accessHash && this.participantsCount == another.participantsCount && Objects.equals(this.title, another.title) && Objects.equals(this.streamDcId, another.streamDcId) && Objects.equals(this.recordStartDate, another.recordStartDate) && Objects.equals(this.scheduleDate, another.scheduleDate) && Objects.equals(this.unmutedVideoCount, another.unmutedVideoCount) && this.unmutedVideoLimit == another.unmutedVideoLimit && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.joinMuted);
        h += (h << 5) + Boolean.hashCode(this.canChangeJoinMuted);
        h += (h << 5) + Boolean.hashCode(this.joinDateAsc);
        h += (h << 5) + Boolean.hashCode(this.scheduleStartSubscribed);
        h += (h << 5) + Boolean.hashCode(this.canStartVideo);
        h += (h << 5) + Boolean.hashCode(this.recordVideoActive);
        h += (h << 5) + Boolean.hashCode(this.rtmpStream);
        h += (h << 5) + Boolean.hashCode(this.listenersHidden);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.participantsCount;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.streamDcId);
        h += (h << 5) + Objects.hashCode(this.recordStartDate);
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        h += (h << 5) + Objects.hashCode(this.unmutedVideoCount);
        h += (h << 5) + this.unmutedVideoLimit;
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "BaseGroupCall{identifier=" + this.identifier + ", flags=" + this.flags + ", joinMuted=" + this.joinMuted + ", canChangeJoinMuted=" + this.canChangeJoinMuted + ", joinDateAsc=" + this.joinDateAsc + ", scheduleStartSubscribed=" + this.scheduleStartSubscribed + ", canStartVideo=" + this.canStartVideo + ", recordVideoActive=" + this.recordVideoActive + ", rtmpStream=" + this.rtmpStream + ", listenersHidden=" + this.listenersHidden + ", id=" + this.id + ", accessHash=" + this.accessHash + ", participantsCount=" + this.participantsCount + ", title=" + this.title + ", streamDcId=" + this.streamDcId + ", recordStartDate=" + this.recordStartDate + ", scheduleDate=" + this.scheduleDate + ", unmutedVideoCount=" + this.unmutedVideoCount + ", unmutedVideoLimit=" + this.unmutedVideoLimit + ", version=" + this.version + "}";
    }

    public static ImmutableBaseGroupCall of(long id, long accessHash, int participantsCount, int unmutedVideoLimit, int version) {
        return new ImmutableBaseGroupCall(id, accessHash, participantsCount, unmutedVideoLimit, version);
    }

    public static ImmutableBaseGroupCall copyOf(BaseGroupCall instance) {
        if (instance instanceof ImmutableBaseGroupCall) {
            return (ImmutableBaseGroupCall)instance;
        }
        return ImmutableBaseGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_PARTICIPANTS_COUNT = 4L;
        private static final long INIT_BIT_UNMUTED_VIDEO_LIMIT = 8L;
        private static final long INIT_BIT_VERSION = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_JOIN_MUTED = 4L;
        private static final long OPT_BIT_CAN_CHANGE_JOIN_MUTED = 8L;
        private static final long OPT_BIT_JOIN_DATE_ASC = 16L;
        private static final long OPT_BIT_SCHEDULE_START_SUBSCRIBED = 32L;
        private static final long OPT_BIT_CAN_START_VIDEO = 64L;
        private static final long OPT_BIT_RECORD_VIDEO_ACTIVE = 128L;
        private static final long OPT_BIT_RTMP_STREAM = 256L;
        private static final long OPT_BIT_LISTENERS_HIDDEN = 512L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean joinMuted;
        private boolean canChangeJoinMuted;
        private boolean joinDateAsc;
        private boolean scheduleStartSubscribed;
        private boolean canStartVideo;
        private boolean recordVideoActive;
        private boolean rtmpStream;
        private boolean listenersHidden;
        private long id;
        private long accessHash;
        private int participantsCount;
        private String title;
        private Integer streamDcId;
        private Integer recordStartDate;
        private Integer scheduleDate;
        private Integer unmutedVideoCount;
        private int unmutedVideoLimit;
        private int version;

        private Builder() {
        }

        public final Builder from(GroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCall instance;
            long bits = 0L;
            if (object instanceof GroupCall) {
                instance = (GroupCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseGroupCall) {
                Integer unmutedVideoCountValue;
                Integer streamDcIdValue;
                instance = (BaseGroupCall)object;
                this.canStartVideo(instance.canStartVideo());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participantsCount(instance.participantsCount());
                this.unmutedVideoLimit(instance.unmutedVideoLimit());
                this.joinDateAsc(instance.joinDateAsc());
                this.flags(instance.flags());
                this.scheduleStartSubscribed(instance.scheduleStartSubscribed());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
                this.version(instance.version());
                this.joinMuted(instance.joinMuted());
                this.rtmpStream(instance.rtmpStream());
                Integer recordStartDateValue = instance.recordStartDate();
                if (recordStartDateValue != null) {
                    this.recordStartDate(recordStartDateValue);
                }
                this.recordVideoActive(instance.recordVideoActive());
                this.canChangeJoinMuted(instance.canChangeJoinMuted());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                if ((bits & 2L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 2L;
                }
                this.listenersHidden(instance.listenersHidden());
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
                if ((streamDcIdValue = instance.streamDcId()) != null) {
                    this.streamDcId(streamDcIdValue);
                }
                if ((unmutedVideoCountValue = instance.unmutedVideoCount()) != null) {
                    this.unmutedVideoCount(unmutedVideoCountValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder joinMuted(boolean joinMuted) {
            this.joinMuted = joinMuted;
            this.optBits |= 4L;
            return this;
        }

        public final Builder canChangeJoinMuted(boolean canChangeJoinMuted) {
            this.canChangeJoinMuted = canChangeJoinMuted;
            this.optBits |= 8L;
            return this;
        }

        public final Builder joinDateAsc(boolean joinDateAsc) {
            this.joinDateAsc = joinDateAsc;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder scheduleStartSubscribed(boolean scheduleStartSubscribed) {
            this.scheduleStartSubscribed = scheduleStartSubscribed;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder canStartVideo(boolean canStartVideo) {
            this.canStartVideo = canStartVideo;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder recordVideoActive(boolean recordVideoActive) {
            this.recordVideoActive = recordVideoActive;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder rtmpStream(boolean rtmpStream) {
            this.rtmpStream = rtmpStream;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder listenersHidden(boolean listenersHidden) {
            this.listenersHidden = listenersHidden;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder participantsCount(int participantsCount) {
            this.participantsCount = participantsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder streamDcId(@Nullable Integer streamDcId) {
            this.streamDcId = streamDcId;
            return this;
        }

        public final Builder recordStartDate(@Nullable Integer recordStartDate) {
            this.recordStartDate = recordStartDate;
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public final Builder unmutedVideoCount(@Nullable Integer unmutedVideoCount) {
            this.unmutedVideoCount = unmutedVideoCount;
            return this;
        }

        public final Builder unmutedVideoLimit(int unmutedVideoLimit) {
            this.unmutedVideoLimit = unmutedVideoLimit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableBaseGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean joinMutedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean canChangeJoinMutedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean joinDateAscIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean scheduleStartSubscribedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean canStartVideoIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean recordVideoActiveIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean rtmpStreamIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean listenersHiddenIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("participantsCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("unmutedVideoLimit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build BaseGroupCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte joinMutedBuildStage = 0;
        private boolean joinMuted;
        private byte canChangeJoinMutedBuildStage = 0;
        private boolean canChangeJoinMuted;
        private byte joinDateAscBuildStage = 0;
        private boolean joinDateAsc;
        private byte scheduleStartSubscribedBuildStage = 0;
        private boolean scheduleStartSubscribed;
        private byte canStartVideoBuildStage = 0;
        private boolean canStartVideo;
        private byte recordVideoActiveBuildStage = 0;
        private boolean recordVideoActive;
        private byte rtmpStreamBuildStage = 0;
        private boolean rtmpStream;
        private byte listenersHiddenBuildStage = 0;
        private boolean listenersHidden;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseGroupCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseGroupCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean joinMuted() {
            if (this.joinMutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinMutedBuildStage == 0) {
                this.joinMutedBuildStage = (byte)-1;
                this.joinMuted = ImmutableBaseGroupCall.this.joinMutedInitialize();
                this.joinMutedBuildStage = 1;
            }
            return this.joinMuted;
        }

        void joinMuted(boolean joinMuted) {
            this.joinMuted = joinMuted;
            this.joinMutedBuildStage = 1;
        }

        boolean canChangeJoinMuted() {
            if (this.canChangeJoinMutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canChangeJoinMutedBuildStage == 0) {
                this.canChangeJoinMutedBuildStage = (byte)-1;
                this.canChangeJoinMuted = ImmutableBaseGroupCall.this.canChangeJoinMutedInitialize();
                this.canChangeJoinMutedBuildStage = 1;
            }
            return this.canChangeJoinMuted;
        }

        void canChangeJoinMuted(boolean canChangeJoinMuted) {
            this.canChangeJoinMuted = canChangeJoinMuted;
            this.canChangeJoinMutedBuildStage = 1;
        }

        boolean joinDateAsc() {
            if (this.joinDateAscBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinDateAscBuildStage == 0) {
                this.joinDateAscBuildStage = (byte)-1;
                this.joinDateAsc = ImmutableBaseGroupCall.this.joinDateAscInitialize();
                this.joinDateAscBuildStage = 1;
            }
            return this.joinDateAsc;
        }

        void joinDateAsc(boolean joinDateAsc) {
            this.joinDateAsc = joinDateAsc;
            this.joinDateAscBuildStage = 1;
        }

        boolean scheduleStartSubscribed() {
            if (this.scheduleStartSubscribedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scheduleStartSubscribedBuildStage == 0) {
                this.scheduleStartSubscribedBuildStage = (byte)-1;
                this.scheduleStartSubscribed = ImmutableBaseGroupCall.this.scheduleStartSubscribedInitialize();
                this.scheduleStartSubscribedBuildStage = 1;
            }
            return this.scheduleStartSubscribed;
        }

        void scheduleStartSubscribed(boolean scheduleStartSubscribed) {
            this.scheduleStartSubscribed = scheduleStartSubscribed;
            this.scheduleStartSubscribedBuildStage = 1;
        }

        boolean canStartVideo() {
            if (this.canStartVideoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canStartVideoBuildStage == 0) {
                this.canStartVideoBuildStage = (byte)-1;
                this.canStartVideo = ImmutableBaseGroupCall.this.canStartVideoInitialize();
                this.canStartVideoBuildStage = 1;
            }
            return this.canStartVideo;
        }

        void canStartVideo(boolean canStartVideo) {
            this.canStartVideo = canStartVideo;
            this.canStartVideoBuildStage = 1;
        }

        boolean recordVideoActive() {
            if (this.recordVideoActiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recordVideoActiveBuildStage == 0) {
                this.recordVideoActiveBuildStage = (byte)-1;
                this.recordVideoActive = ImmutableBaseGroupCall.this.recordVideoActiveInitialize();
                this.recordVideoActiveBuildStage = 1;
            }
            return this.recordVideoActive;
        }

        void recordVideoActive(boolean recordVideoActive) {
            this.recordVideoActive = recordVideoActive;
            this.recordVideoActiveBuildStage = 1;
        }

        boolean rtmpStream() {
            if (this.rtmpStreamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rtmpStreamBuildStage == 0) {
                this.rtmpStreamBuildStage = (byte)-1;
                this.rtmpStream = ImmutableBaseGroupCall.this.rtmpStreamInitialize();
                this.rtmpStreamBuildStage = 1;
            }
            return this.rtmpStream;
        }

        void rtmpStream(boolean rtmpStream) {
            this.rtmpStream = rtmpStream;
            this.rtmpStreamBuildStage = 1;
        }

        boolean listenersHidden() {
            if (this.listenersHiddenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.listenersHiddenBuildStage == 0) {
                this.listenersHiddenBuildStage = (byte)-1;
                this.listenersHidden = ImmutableBaseGroupCall.this.listenersHiddenInitialize();
                this.listenersHiddenBuildStage = 1;
            }
            return this.listenersHidden;
        }

        void listenersHidden(boolean listenersHidden) {
            this.listenersHidden = listenersHidden;
            this.listenersHiddenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.joinMutedBuildStage == -1) {
                attributes.add("joinMuted");
            }
            if (this.canChangeJoinMutedBuildStage == -1) {
                attributes.add("canChangeJoinMuted");
            }
            if (this.joinDateAscBuildStage == -1) {
                attributes.add("joinDateAsc");
            }
            if (this.scheduleStartSubscribedBuildStage == -1) {
                attributes.add("scheduleStartSubscribed");
            }
            if (this.canStartVideoBuildStage == -1) {
                attributes.add("canStartVideo");
            }
            if (this.recordVideoActiveBuildStage == -1) {
                attributes.add("recordVideoActive");
            }
            if (this.rtmpStreamBuildStage == -1) {
                attributes.add("rtmpStream");
            }
            if (this.listenersHiddenBuildStage == -1) {
                attributes.add("listenersHidden");
            }
            return "Cannot build BaseGroupCall, attribute initializers form cycle " + attributes;
        }
    }
}

