/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputBotInlineMessageID;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputBotInlineMessageID
implements BaseInputBotInlineMessageID {
    private final int identifier;
    private final int dcId;
    private final long id;
    private final long accessHash;

    private ImmutableBaseInputBotInlineMessageID(int dcId, long id, long accessHash) {
        this.dcId = dcId;
        this.id = id;
        this.accessHash = accessHash;
        this.identifier = BaseInputBotInlineMessageID.super.identifier();
    }

    private ImmutableBaseInputBotInlineMessageID(Builder builder) {
        this.dcId = builder.dcId;
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputBotInlineMessageID.super.identifier();
    }

    private ImmutableBaseInputBotInlineMessageID(int identifier, int dcId, long id, long accessHash) {
        this.identifier = identifier;
        this.dcId = dcId;
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableBaseInputBotInlineMessageID withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineMessageID(value, this.dcId, this.id, this.accessHash);
    }

    public final ImmutableBaseInputBotInlineMessageID withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineMessageID(this.identifier, value, this.id, this.accessHash);
    }

    public final ImmutableBaseInputBotInlineMessageID withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineMessageID(this.identifier, this.dcId, value, this.accessHash);
    }

    public final ImmutableBaseInputBotInlineMessageID withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineMessageID(this.identifier, this.dcId, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputBotInlineMessageID && this.equalTo(0, (ImmutableBaseInputBotInlineMessageID)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputBotInlineMessageID another) {
        return this.identifier == another.identifier && this.dcId == another.dcId && this.id == another.id && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "BaseInputBotInlineMessageID{identifier=" + this.identifier + ", dcId=" + this.dcId + ", id=" + this.id + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableBaseInputBotInlineMessageID of(int dcId, long id, long accessHash) {
        return new ImmutableBaseInputBotInlineMessageID(dcId, id, accessHash);
    }

    public static ImmutableBaseInputBotInlineMessageID copyOf(BaseInputBotInlineMessageID instance) {
        if (instance instanceof ImmutableBaseInputBotInlineMessageID) {
            return (ImmutableBaseInputBotInlineMessageID)instance;
        }
        return ImmutableBaseInputBotInlineMessageID.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_ACCESS_HASH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int dcId;
        private long id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(InputBotInlineMessageID instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputBotInlineMessageID instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputBotInlineMessageID instance;
            long bits = 0L;
            if (object instanceof InputBotInlineMessageID) {
                instance = (InputBotInlineMessageID)object;
                if ((bits & 2L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputBotInlineMessageID) {
                instance = (BaseInputBotInlineMessageID)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 4L;
                }
                this.id(instance.id());
                if ((bits & 2L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBaseInputBotInlineMessageID build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputBotInlineMessageID(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputBotInlineMessageID, some of required attributes are not set " + attributes;
        }
    }
}

