/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseInputBotInlineResult;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineResult;
import telegram4j.tl.InputWebDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputBotInlineResult
implements BaseInputBotInlineResult {
    private final int identifier;
    private final int flags;
    private final String id;
    private final String type;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String url;
    @Nullable
    private final InputWebDocument thumb;
    @Nullable
    private final InputWebDocument content;
    private final InputBotInlineMessage sendMessage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputBotInlineResult(String id, String type, InputBotInlineMessage sendMessage) {
        this.id = Objects.requireNonNull(id, "id");
        this.type = Objects.requireNonNull(type, "type");
        this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
        this.title = null;
        this.description = null;
        this.url = null;
        this.thumb = null;
        this.content = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseInputBotInlineResult(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.title = builder.title;
        this.description = builder.description;
        this.url = builder.url;
        this.thumb = builder.thumb;
        this.content = builder.content;
        this.sendMessage = builder.sendMessage;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseInputBotInlineResult(int identifier, int flags, String id, String type, @Nullable String title, @Nullable String description, @Nullable String url, @Nullable InputWebDocument thumb, @Nullable InputWebDocument content, InputBotInlineMessage sendMessage) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.type = type;
        this.title = title;
        this.description = description;
        this.url = url;
        this.thumb = thumb;
        this.content = content;
        this.sendMessage = sendMessage;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputBotInlineResult.super.identifier();
    }

    private int flagsInitialize() {
        return BaseInputBotInlineResult.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public InputWebDocument thumb() {
        return this.thumb;
    }

    @Override
    @Nullable
    public InputWebDocument content() {
        return this.content;
    }

    @Override
    public InputBotInlineMessage sendMessage() {
        return this.sendMessage;
    }

    public final ImmutableBaseInputBotInlineResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(value, this.flags, this.id, this.type, this.title, this.description, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, value, this.id, this.type, this.title, this.description, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, newValue, this.type, this.title, this.description, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, newValue, this.title, this.description, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, value, this.description, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, this.title, value, this.url, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, this.title, this.description, value, this.thumb, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withThumb(@Nullable InputWebDocument value) {
        if (this.thumb == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, this.title, this.description, this.url, value, this.content, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withContent(@Nullable InputWebDocument value) {
        if (this.content == value) {
            return this;
        }
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, this.title, this.description, this.url, this.thumb, value, this.sendMessage);
    }

    public final ImmutableBaseInputBotInlineResult withSendMessage(InputBotInlineMessage value) {
        if (this.sendMessage == value) {
            return this;
        }
        InputBotInlineMessage newValue = Objects.requireNonNull(value, "sendMessage");
        return new ImmutableBaseInputBotInlineResult(this.identifier, this.flags, this.id, this.type, this.title, this.description, this.url, this.thumb, this.content, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputBotInlineResult && this.equalTo(0, (ImmutableBaseInputBotInlineResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputBotInlineResult another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id.equals(another.id) && this.type.equals(another.type) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.url, another.url) && Objects.equals(this.thumb, another.thumb) && Objects.equals(this.content, another.content) && this.sendMessage.equals(another.sendMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.thumb);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + this.sendMessage.hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputBotInlineResult{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", type=" + this.type + ", title=" + this.title + ", description=" + this.description + ", url=" + this.url + ", thumb=" + this.thumb + ", content=" + this.content + ", sendMessage=" + this.sendMessage + "}";
    }

    public static ImmutableBaseInputBotInlineResult of(String id, String type, InputBotInlineMessage sendMessage) {
        return new ImmutableBaseInputBotInlineResult(id, type, sendMessage);
    }

    public static ImmutableBaseInputBotInlineResult copyOf(BaseInputBotInlineResult instance) {
        if (instance instanceof ImmutableBaseInputBotInlineResult) {
            return (ImmutableBaseInputBotInlineResult)instance;
        }
        return ImmutableBaseInputBotInlineResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_SEND_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private String id;
        private String type;
        private String title;
        private String description;
        private String url;
        private InputWebDocument thumb;
        private InputWebDocument content;
        private InputBotInlineMessage sendMessage;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputBotInlineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputBotInlineResult) {
                InputWebDocument contentValue;
                String urlValue;
                InputWebDocument thumbValue;
                instance = (BaseInputBotInlineResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((thumbValue = instance.thumb()) != null) {
                    this.thumb(thumbValue);
                }
                this.flags(instance.flags());
                String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
                this.type(instance.type());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((contentValue = instance.content()) != null) {
                    this.content(contentValue);
                }
            }
            if (object instanceof InputBotInlineResult) {
                instance = (InputBotInlineResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder thumb(@Nullable InputWebDocument thumb) {
            this.thumb = thumb;
            return this;
        }

        public final Builder content(@Nullable InputWebDocument content) {
            this.content = content;
            return this;
        }

        public final Builder sendMessage(InputBotInlineMessage sendMessage) {
            this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBaseInputBotInlineResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputBotInlineResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sendMessage");
            }
            return "Cannot build BaseInputBotInlineResult, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputBotInlineResult.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseInputBotInlineResult.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseInputBotInlineResult, attribute initializers form cycle " + attributes;
        }
    }
}

