/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputChannel;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputChannel
implements BaseInputChannel {
    private final int identifier;
    private final long channelId;
    private final long accessHash;

    private ImmutableBaseInputChannel(long channelId, long accessHash) {
        this.channelId = channelId;
        this.accessHash = accessHash;
        this.identifier = BaseInputChannel.super.identifier();
    }

    private ImmutableBaseInputChannel(Builder builder) {
        this.channelId = builder.channelId;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputChannel.super.identifier();
    }

    private ImmutableBaseInputChannel(int identifier, long channelId, long accessHash) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableBaseInputChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputChannel(value, this.channelId, this.accessHash);
    }

    public final ImmutableBaseInputChannel withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableBaseInputChannel(this.identifier, value, this.accessHash);
    }

    public final ImmutableBaseInputChannel withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputChannel(this.identifier, this.channelId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputChannel && this.equalTo(0, (ImmutableBaseInputChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputChannel another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "BaseInputChannel{identifier=" + this.identifier + ", channelId=" + this.channelId + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableBaseInputChannel of(long channelId, long accessHash) {
        return new ImmutableBaseInputChannel(channelId, accessHash);
    }

    public static ImmutableBaseInputChannel copyOf(BaseInputChannel instance) {
        if (instance instanceof ImmutableBaseInputChannel) {
            return (ImmutableBaseInputChannel)instance;
        }
        return ImmutableBaseInputChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long channelId;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChannel) {
                instance = (InputChannel)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputChannel) {
                instance = (BaseInputChannel)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.channelId(instance.channelId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseInputChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputChannel, some of required attributes are not set " + attributes;
        }
    }
}

